/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network.request;

import android.content.Context;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.citrus.sdk.Callback;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.HttpMethod;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.CustomJsonRequest;
import com.citrus.sdk.network.request.CustomStringRequest;
import com.citrus.sdk.network.request.GsonRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.network.request.VolleyNetworkManager;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONObject;

public class ApiExecutor {
    private static final String TAG = ApiExecutor.class.getSimpleName();
    private static final String CANCEL_TAG = "com.sdk.citrus.volley.TAG";
    private static ApiExecutor instance;
    private VolleyNetworkManager volleyNetworkManager;

    private ApiExecutor(Context context) {
        this.volleyNetworkManager = VolleyNetworkManager.getInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiExecutor getInstance(Context context) {
        if (instance != null) return instance;
        Class<ApiExecutor> clazz = ApiExecutor.class;
        synchronized (ApiExecutor.class) {
            if (instance != null) return instance;
            instance = new ApiExecutor(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void executeJsonApi(Context context, final BaseClient baseClient, final ApiRequest request, final Callback callback) {
        Log.v((String)TAG, (String)(TAG + ".executeJsonApi(): request = " + request + ", baseApi = " + baseClient));
        int method = ApiExecutor.getVolleyMethod(request.getHttpMethod());
        String URL2 = ApiExecutor.getUrl(baseClient, request);
        JSONObject body = null;
        RequestBody requestBody = request.getRequestBody();
        if (requestBody != null && requestBody.getRequestBodyType() == RequestBodyType.JSON) {
            body = (JSONObject)request.getRequestBody().getBody();
        }
        Log.v((String)TAG, (String)(TAG + ".executeJsonApi(): body = " + body));
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(method, URL2, body, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.v((String)TAG, (String)(TAG + ".executeJsonApi().onResponse(): response = " + response));
                baseClient.sendResponse(callback, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)(TAG + ".executeJsonApi().onErrorResponse(): error = " + error));
                baseClient.sendError(callback, error);
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String, String> headers = request.getHeaders();
                Log.d((String)TAG, (String)(TAG + ".executeJsonApi().getHeaders(): headers = " + headers));
                if (headers == null || headers.isEmpty()) {
                    return super.getHeaders();
                }
                return headers;
            }
        };
        jsonObjectRequest.setTag((Object)CANCEL_TAG);
        this.setDefaultRetryPolicy((Request<?>)jsonObjectRequest);
        this.volleyNetworkManager.addToRequestQueue(jsonObjectRequest);
    }

    public void executeCustomJsonApi(final BaseClient baseClient, ApiRequest request, final Callback<JSONObject> callback) {
        Log.v((String)TAG, (String)TAG);
        Log.v((String)TAG, (String)(TAG + ".executeCustomJsonApi(): request = " + request + ", baseApi = " + baseClient));
        int method = ApiExecutor.getVolleyMethod(request.getHttpMethod());
        String URL2 = ApiExecutor.getUrl(baseClient, request);
        String body = ApiExecutor.getVolleyBodyStr(request);
        CustomJsonRequest customRequest = new CustomJsonRequest(method, URL2, request.getParams(), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.v((String)TAG, (String)(TAG + ".executeCustomJsonApi().onResponse(): response = " + response));
                baseClient.sendResponse(callback, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)(TAG + ".executeCustomJsonApi().onErrorResponse(): error = " + error));
                baseClient.sendError(callback, error);
            }
        }, body, request.getHeaders(), request.getBodyContentType());
        customRequest.setTag(CANCEL_TAG);
        this.setDefaultRetryPolicy(customRequest);
        this.volleyNetworkManager.addToRequestQueue(customRequest);
    }

    public void executeStringApi(final BaseClient baseClient, ApiRequest request, final Callback callback) {
        Log.v((String)TAG, (String)TAG);
        Log.v((String)TAG, (String)(TAG + ".executeStringApi(): request = " + request + ", baseApi = " + baseClient));
        int method = ApiExecutor.getVolleyMethod(request.getHttpMethod());
        String URL2 = ApiExecutor.getUrl(baseClient, request);
        byte[] body = ApiExecutor.getVolleyBody(request);
        CustomStringRequest stringRequest = new CustomStringRequest(method, URL2, new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.v((String)TAG, (String)(TAG + ".executeStringApi().onResponse(): response = " + response));
                baseClient.sendResponse(callback, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)(TAG + ".executeStringApi().onErrorResponse(): error = " + error));
                baseClient.sendError(callback, error);
            }
        }, request.getParams(), body, request.getHeaders(), request.getBodyContentType());
        stringRequest.setTag(CANCEL_TAG);
        this.setDefaultRetryPolicy((Request<?>)stringRequest);
        this.volleyNetworkManager.addToRequestQueue(stringRequest);
    }

    public void executeCustomObjectApi(BaseClient baseClient, ApiRequest request, Callback callback) {
        Log.v((String)TAG, (String)TAG);
        Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi(): request = " + request + ", baseApi = " + baseClient));
        this.executeCustomObjectApi(baseClient, request, null, callback);
    }

    public void executeCustomObjectApi(final BaseClient baseClient, ApiRequest request, Type type, final Callback callback) {
        Log.v((String)TAG, (String)TAG);
        Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi(): request = " + request + ", type = " + type + ", baseApi = " + baseClient));
        int method = ApiExecutor.getVolleyMethod(request.getHttpMethod());
        String URL2 = ApiExecutor.getUrl(baseClient, request);
        String body = ApiExecutor.getVolleyBodyStr(request);
        GsonRequest gsonRequest = type == null ? new GsonRequest(URL2, request.getClazz(), method, request.getHeaders(), request.getParams(), request.getBodyContentType(), new Response.Listener(){

            public void onResponse(Object response) {
                Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): response = " + response));
                if (response != null) {
                    Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): response class = " + response.getClass().getName()));
                }
                baseClient.sendResponse(callback, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): error = " + error));
                baseClient.sendError(callback, error);
            }
        }, body) : new GsonRequest(URL2, type, method, request.getHeaders(), request.getParams(), request.getBodyContentType(), new Response.Listener(){

            public void onResponse(Object response) {
                Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): response = " + response));
                if (response != null) {
                    Log.v((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): response class = " + response.getClass().getName()));
                }
                baseClient.sendResponse(callback, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)(TAG + ".executeCustomObjectApi().onResponse(): error = " + error));
                baseClient.sendError(callback, error);
            }
        }, body);
        gsonRequest.setTag(CANCEL_TAG);
        this.setDefaultRetryPolicy(gsonRequest);
        this.volleyNetworkManager.addToRequestQueue(gsonRequest);
    }

    public void cancelAllApiRequests() {
        this.volleyNetworkManager.cancelRequests(CANCEL_TAG);
    }

    private static String getUrl(BaseClient baseClient, ApiRequest request) {
        String relativeUrl = request.getRelativeUrl();
        if (relativeUrl == null || relativeUrl.isEmpty()) {
            return baseClient.getBaseUrl();
        }
        return baseClient.getBaseUrl() + relativeUrl;
    }

    private static int getVolleyMethod(HttpMethod httpMethod) {
        int method;
        switch (httpMethod) {
            default: {
                method = 0;
                break;
            }
            case POST: {
                method = 1;
                break;
            }
            case PUT: {
                method = 2;
                break;
            }
            case DELETE: {
                method = 3;
            }
        }
        return method;
    }

    private static byte[] getVolleyBody(ApiRequest request) {
        String body = ApiExecutor.getVolleyBodyStr(request);
        return body == null ? null : body.getBytes();
    }

    private static String getVolleyBodyStr(ApiRequest request) {
        String body = null;
        RequestBody requestBody = request.getRequestBody();
        if (requestBody != null) {
            switch (requestBody.getRequestBodyType()) {
                case JSON: {
                    JSONObject jsonBody = (JSONObject)requestBody.getBody();
                    body = jsonBody.toString();
                    break;
                }
                case STRING: {
                    body = (String)requestBody.getBody();
                }
            }
        }
        return body;
    }

    private Request<?> setDefaultRetryPolicy(Request<?> request) {
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(12500, 1, 1.0f));
        return request;
    }
}

