/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.util.Log;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.PgClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.walletpg.WalletConsumerProfile;
import com.citrus.sdk.walletpg.WalletPGPaymentResponse;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class WalletPgClient
extends BaseClient {
    private static final String TAG = WalletPgClient.class.getSimpleName();
    private static WalletPgClient instance = null;
    final ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WalletPgClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<PgClient> clazz = PgClient.class;
        synchronized (PgClient.class) {
            if (instance != null) return instance;
            instance = new WalletPgClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private WalletPgClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(this.mContext);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getWalletPGBaseUrl();
    }

    public void makeWalletPGPayment(AccessToken accessToken, String walletPGPaymentJSON, final Callback<WalletPGPaymentResponse> callback) {
        if (this.validate() && accessToken != null && accessToken.getHeaderAccessToken() != null) {
            ApiRequest walletPgChargeApi = this.getWalletPgChargeApi(accessToken.getHeaderAccessToken(), walletPGPaymentJSON);
            this.executor.executeCustomJsonApi(this, walletPgChargeApi, new Callback<JSONObject>(){

                @Override
                public void success(JSONObject jsonObject) {
                    if (jsonObject != null) {
                        WalletPGPaymentResponse walletPGPaymentResponse = WalletPGPaymentResponse.fromJSON(jsonObject.toString());
                        WalletPgClient.this.sendResponse(callback, walletPGPaymentResponse);
                    } else {
                        WalletPgClient.this.sendError(callback, new CitrusError("Unable to process wallet charge", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    WalletPgClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getWalletPgChargeApi(String headerAccessToken, String body) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, body);
        ApiRequest walletPgChargeApi = new ApiRequest.Builder(Api.WALLET_PG_CHARGE).authorizationToken(headerAccessToken).requestBody(requestBody).build();
        return walletPgChargeApi;
    }

    public void fetchConsumerProfile(Amount amount, AccessToken accessToken, final Callback<WalletConsumerProfile> callback) {
        if (this.validate() && accessToken != null && accessToken.getHeaderAccessToken() != null) {
            ApiRequest fetchConsumerProfileApi = this.getFetchConsumerProfileApi(accessToken.getHeaderAccessToken(), String.valueOf(amount.getValueAsDouble()), amount.getCurrency());
            this.executor.executeCustomJsonApi(this, fetchConsumerProfileApi, new Callback<JSONObject>(){

                @Override
                public void success(JSONObject jsonObject) {
                    Log.i((String)TAG, (String)(TAG + ".executeCustomJsonApi().success(): jsonObject = " + jsonObject));
                    try {
                        WalletConsumerProfile walletConsumerProfile = WalletConsumerProfile.fromJSON(jsonObject.toString());
                        if (walletConsumerProfile != null) {
                            WalletPgClient.this.sendResponse(callback, walletConsumerProfile);
                        } else {
                            WalletPgClient.this.sendError(callback, new CitrusError("Unable to fetch wallet", CitrusResponse.Status.FAILED));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        WalletPgClient.this.sendError(callback, new CitrusError("Unable to fetch wallet", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    Log.e((String)TAG, (String)(TAG + ".executeCustomJsonApi().error(): error = " + error));
                    WalletPgClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getFetchConsumerProfileApi(String headerAccessToken, String amount, String currency) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("amount", amount);
        params.put("currency", currency);
        ApiRequest fetchConsumerProfileApi = new ApiRequest.Builder(Api.WALLET_PG_FETCH_CONSUMER_PROFILE).authorizationToken(headerAccessToken).params(params).build();
        return fetchConsumerProfileApi;
    }
}

