/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.citrus.cash.PersistentConfig;
import com.citrus.citrususer.RandomPassword;
import com.citrus.mobile.OAuth2GrantType;
import com.citrus.mobile.OauthToken;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Constants;
import com.citrus.sdk.Environment;
import com.citrus.sdk.UMCallback;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.LinkUserVerifyEOTPUpdateMobile;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.UserBind;
import com.citrus.sdk.classes.VerifyMobileResponse;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.orhanobut.logger.Logger;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class UmClient
extends BaseClient {
    private static final String TAG = UmClient.class.getSimpleName();
    private static UmClient instance = null;
    private AccessToken signUpToken = null;
    private CitrusUser citrusUser = null;
    private ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UmClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<UmClient> clazz = UmClient.class;
        synchronized (UmClient.class) {
            if (instance != null) return instance;
            instance = new UmClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private UmClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(context);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getBaseUrl();
    }

    public synchronized void getSignUpToken(final Callback<AccessToken> callback) {
        if (this.validate()) {
            if (this.signUpToken == null) {
                ApiRequest accessTokenApi = this.getSignUpTokenApi(this.tokenUtils.getSignupId(), this.tokenUtils.getSignupSecret(), OAuth2GrantType.implicit.toString());
                this.executor.executeCustomObjectApi(this, accessTokenApi, new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        if (accessToken != null) {
                            UmClient.this.signUpToken = accessToken;
                            UmClient.this.sendResponse(callback, accessToken);
                        } else {
                            UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        UmClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendResponse(callback, this.signUpToken);
            }
        }
    }

    private ApiRequest getSignUpTokenApi(String clientId, String clientSecret, String grantType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", grantType);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.GET_SIGNUP_TOKEN).params(params).build();
        return apiRequest;
    }

    public void getUserNameToken(String userName, final Callback<AccessToken> callback) {
        if (this.validate()) {
            ApiRequest userNameTokenApi = this.getUserNameTokenApi(this.tokenUtils.getSigninId(), this.tokenUtils.getSigninSecret(), userName, OAuth2GrantType.username.toString());
            this.executor.executeCustomObjectApi(this, userNameTokenApi, new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    if (accessToken != null) {
                        UmClient.this.tokenUtils.saveToken(Constants.TokenType.SIGNIN_TOKEN, accessToken);
                        UmClient.this.sendResponse(callback, accessToken);
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getUserNameTokenApi(String clientId, String clientSecret, String username, String grantType) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", grantType);
        params.put("username", username);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.GET_SIGNUP_TOKEN).params(params).build();
        return apiRequest;
    }

    public void getPrepaidToken(String email, String password, Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidToken(final email , password, callback"));
        this.getPrepaidToken(email, password, OAuth2GrantType.password, callback);
    }

    public void getPrepaidToken(String email, String password, OAuth2GrantType grantType, Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidToken(final email , password, granttype, callback)"));
        Log.i((String)TAG, (String)(TAG + ". calling getPrepaidToken(final email , password, granttype, callback, true)"));
        this.getPrepaidToken(email, password, grantType, callback, true);
    }

    public void getPrepaidToken(String email, String password, OAuth2GrantType grantType, final Callback<AccessToken> callback, boolean saveToken) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidToken(final email , password, granttype, callback, " + saveToken));
        if (this.validate()) {
            ApiRequest prepaidTokenApi = this.getPrepaidTokenApi(this.tokenUtils.getSigninId(), this.tokenUtils.getSigninSecret(), email, password, grantType.toString());
            if (saveToken) {
                this.executor.executeCustomObjectApi(this, prepaidTokenApi, new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        if (accessToken != null) {
                            UmClient.this.tokenUtils.saveToken(Constants.TokenType.PREPAID_TOKEN, accessToken);
                            UmClient.this.sendResponse(callback, accessToken);
                        } else {
                            UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        UmClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.executor.executeCustomObjectApi(this, prepaidTokenApi, callback);
            }
        }
    }

    private ApiRequest getPrepaidTokenApi(String clientId, String clientSecret, String username, String password, String grantType) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidTokenApi(final clientId , clientSecret, username, password, grantType)"));
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("username", username);
        params.put("password", password);
        params.put("grant_type", grantType);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.GET_SIGNUP_TOKEN).params(params).build();
        return apiRequest;
    }

    private void getRefreshToken(final String tokenType, String refreshToken, final Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getRefreshToken(final tokenType , refreshToken,callback"));
        if (this.validate()) {
            ApiRequest refreshTokenApi = this.getRefreshTokenApi(this.tokenUtils.getSigninId(), this.tokenUtils.getSigninSecret(), OAuth2GrantType.refresh_token.toString(), refreshToken);
            this.executor.executeCustomObjectApi(this, refreshTokenApi, new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    UmClient.this.tokenUtils.saveToken(Constants.TokenType.valueOf(tokenType), accessToken);
                    UmClient.this.sendResponse(callback, accessToken);
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getRefreshTokenApi(String client_ID, String client_Secret, String grantType, String refreshToken) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("client_id", client_ID);
        params.put("client_secret", client_Secret);
        params.put("grant_type", grantType);
        params.put("refresh_token", refreshToken);
        ApiRequest refreshTokenApi = new ApiRequest.Builder(Api.GET_SIGNUP_TOKEN).params(params).build();
        return refreshTokenApi;
    }

    public void getUserNameToken(Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getUserNameToken( callback"));
        this.getSavedToken(Constants.TokenType.SIGNIN_TOKEN, callback);
    }

    private void getSavedToken(Constants.TokenType tokenType, Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getSavedToken( tokenType, callback)"));
        this.getSavedToken(false, tokenType, callback);
    }

    private void getSavedToken(boolean isPrepaidPayRequest, final Constants.TokenType tokenType, final Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getSavedToken( isPrepaidPayRequest, tokenType, callback"));
        this.tokenUtils.getToken(isPrepaidPayRequest, tokenType, new UMCallback<AccessToken>(){

            @Override
            public void expired(String token) {
                UmClient.this.getRefreshToken(tokenType.toString(), token, callback);
            }

            public void success(Object accessToken) {
                UmClient.this.sendResponse(callback, accessToken);
            }

            @Override
            public void error(CitrusError error) {
                UmClient.this.sendError(callback, error);
            }
        });
    }

    public void getPrepaidToken(Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidToken(  callback)"));
        this.getSavedToken(Constants.TokenType.PREPAID_TOKEN, callback);
    }

    public void getPrepaidPayToken(Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getPrepaidPayToken(  callback"));
        this.getSavedToken(true, Constants.TokenType.PREPAID_TOKEN, callback);
    }

    public synchronized void createUser(final String emailId, final String mobileNo, final Callback<String> callback) {
        Log.i((String)TAG, (String)(TAG + ".createUser( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken signupToken) {
                    if (signupToken != null && signupToken.getHeaderAccessToken() != null) {
                        OauthToken signuptoken = new OauthToken(UmClient.this.mContext, "signup_token");
                        signuptoken.createToken(signupToken.getJSON());
                        ApiRequest bindUserApi = UmClient.this.getBindResponseApi(signupToken.getHeaderAccessToken(), emailId, mobileNo);
                        UmClient.this.executor.executeCustomObjectApi(UmClient.this, bindUserApi, new Callback<UserBind>(){

                            @Override
                            public void success(UserBind userBind) {
                                if (userBind != null) {
                                    UmClient.this.getUserNameToken(userBind.getUsername(), new Callback<AccessToken>(){

                                        @Override
                                        public void success(AccessToken accessToken) {
                                            if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                                                OauthToken token = new OauthToken(UmClient.this.mContext, "signin_token");
                                                token.createToken(accessToken.getJSON());
                                                token.saveUserDetails(emailId, mobileNo);
                                                UmClient.this.sendResponse(callback, "User Bind Successfully.");
                                            } else {
                                                UmClient.this.sendError(callback, new CitrusError("Failed to bind User!!!", CitrusResponse.Status.FAILED));
                                            }
                                        }

                                        @Override
                                        public void error(CitrusError error) {
                                            UmClient.this.sendError(callback, error);
                                        }
                                    });
                                } else {
                                    UmClient.this.sendError(callback, new CitrusError("Failed to bind User!!!", CitrusResponse.Status.FAILED));
                                }
                            }

                            @Override
                            public void error(CitrusError error) {
                                UmClient.this.sendError(callback, error);
                            }
                        });
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getBindResponseApi(String accessToken, String email, String mobile) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("email", email);
        params.put("mobile", mobile);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.GET_BIND_RESPONSE).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public synchronized void isCitrusMember(final String emailId, final String mobileNo, final Callback<Boolean> callback) {
        if (this.validate()) {
            this.createUser(emailId, mobileNo, new Callback<String>(){

                @Override
                public void success(String s) {
                    if ("User Bind Successfully.".equalsIgnoreCase(s)) {
                        RandomPassword pwd = new RandomPassword();
                        String random_pass = pwd.generate(emailId, mobileNo);
                        UmClient.this.getPrepaidToken(emailId, random_pass, OAuth2GrantType.password, new Callback<AccessToken>(){

                            @Override
                            public void success(AccessToken accessToken) {
                                Logger.d((String)"User Not A Citrus Member. Please Sign Up User.", (Object[])new Object[0]);
                                UmClient.this.sendResponse(callback, false);
                            }

                            @Override
                            public void error(CitrusError error) {
                                Logger.d((String)"User Already A Citrus Member. Please Sign In User.", (Object[])new Object[0]);
                                UmClient.this.sendResponse(callback, true);
                            }
                        }, false);
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("Failed to bind User!!!", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void getMemberInfo(final String emailId, final String mobileNo, final Callback<MemberInfo> callback) {
        Log.i((String)TAG, (String)(TAG + ".getMemberInfo( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                        JSONObject jsonObject = new JSONObject();
                        OauthToken signuptoken = new OauthToken(UmClient.this.mContext, "signup_token");
                        signuptoken.createToken(accessToken.getJSON());
                        try {
                            jsonObject.put("email", (Object)emailId);
                            jsonObject.put("mobile", (Object)mobileNo);
                            ApiRequest memberInfoApi = UmClient.this.getMemberInfoApi(accessToken.getHeaderAccessToken(), jsonObject.toString());
                            UmClient.this.executor.executeCustomJsonApi(UmClient.this, memberInfoApi, new Callback<JSONObject>(){

                                @Override
                                public void success(JSONObject jsonObject) {
                                    if (jsonObject != null) {
                                        MemberInfo memberInfo = MemberInfo.fromJSON(jsonObject.toString());
                                        UmClient.this.sendResponse(callback, memberInfo);
                                    } else {
                                        UmClient.this.sendError(callback, new CitrusError("Unable to fetch Member info", CitrusResponse.Status.FAILED));
                                    }
                                }

                                @Override
                                public void error(CitrusError error) {
                                    UmClient.this.sendError(callback, error);
                                }
                            });
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            UmClient.this.sendError(callback, new CitrusError("Unable to fetch Member info", CitrusResponse.Status.FAILED));
                        }
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getMemberInfoApi(String accessToken, String body) {
        Log.i((String)TAG, (String)(TAG + ".getMemberInfoApi( )"));
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, body);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.GET_MEMBER_INFO).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public void bindUserByMobile(final String emailId, final String mobileNo, final Callback<BindUserResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".bindUserByMobile( )"));
        if (this.validate()) {
            this.getMemberInfo(emailId, mobileNo, new Callback<MemberInfo>(){

                @Override
                public void success(final MemberInfo memberInfo) {
                    UmClient.this.getSignUpToken(new Callback<AccessToken>(){

                        @Override
                        public void success(AccessToken accessToken) {
                            ApiRequest bindUserByMobileApi = UmClient.this.getbindUserByMobileApi(accessToken.getHeaderAccessToken(), emailId, mobileNo);
                            UmClient.this.executor.executeCustomObjectApi(UmClient.this, bindUserByMobileApi, new Callback<UserBind>(){

                                @Override
                                public void success(UserBind userBind) {
                                    BindUserResponse bindUserResponse;
                                    if (memberInfo.getProfileByMobile() == null && memberInfo.getProfileByEmail() == null) {
                                        bindUserResponse = new BindUserResponse(BindUserResponse.RESPONSE_CODE_NEW_USER_BOUND);
                                        UmClient.this.resetPassword(emailId, null);
                                    } else {
                                        bindUserResponse = new BindUserResponse(BindUserResponse.RESPONSE_CODE_EXISTING_USER_BOUND);
                                    }
                                    UmClient.this.getUserNameToken(userBind.getUsername(), new Callback<AccessToken>(){

                                        @Override
                                        public void success(AccessToken accessToken) {
                                            UmClient.this.sendResponse(callback, bindUserResponse);
                                        }

                                        @Override
                                        public void error(CitrusError error) {
                                            UmClient.this.sendError(callback, error);
                                        }
                                    });
                                }

                                @Override
                                public void error(CitrusError error) {
                                    UmClient.this.sendError(callback, error);
                                }
                            });
                        }

                        @Override
                        public void error(CitrusError error) {
                            UmClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getbindUserByMobileApi(String accessToken, String email, String mobile) {
        Log.i((String)TAG, (String)(TAG + ".getbindUserByMobileApi( )"));
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("email", email);
        params.put("mobile", mobile);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_BIND_USER_BY_MOBILE).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void resetPassword(final String emailId, final @NonNull Callback<CitrusResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".resetPassword( )"));
        this.getSignUpToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                if (accessToken != null) {
                    ApiRequest resetPasswordApi = UmClient.this.getResetPasswordApi(accessToken.getHeaderAccessToken(), emailId);
                    UmClient.this.executor.executeCustomJsonApi(UmClient.this, resetPasswordApi, new Callback<JSONObject>(){

                        @Override
                        public void success(JSONObject o) {
                            UmClient.this.sendResponse(callback, new CitrusResponse("Reset password link has been sent to your email id.", CitrusResponse.Status.SUCCESSFUL));
                        }

                        @Override
                        public void error(CitrusError error) {
                            UmClient.this.sendError(callback, error);
                        }
                    });
                } else {
                    UmClient.this.sendError(callback, new CitrusError("Error: Reset password failed", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                UmClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getResetPasswordApi(String accessToken, String username) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("username", username);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_RESET_PASSWORD).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void linkUserWithOTP(final String emailId, final String mobileNo, final boolean forceMobileVerification, final Callback<LinkUserResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".linkUserWithOTP( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("email", (Object)emailId);
                        jsonObject.put("mobile", (Object)mobileNo);
                        jsonObject.put("force_mobile_verification", forceMobileVerification);
                        ApiRequest linkUserResponseApi = UmClient.this.getLinkUserApi(accessToken.getHeaderAccessToken(), jsonObject);
                        UmClient.this.executor.executeCustomObjectApi(UmClient.this, linkUserResponseApi, callback);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to Link User", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getLinkUserApi(String signUpToken, JSONObject jsonBody) {
        Log.i((String)TAG, (String)(TAG + ".getLinkUserApi( )"));
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_LINK_USER).authorizationToken(signUpToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public synchronized void getUsernameAndPrepaidToken(String emailId, String password, Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getUsernameAndPrepaidToken( email, pwd, callback)"));
        this.getUsernameAndPrepaidToken(emailId, password, OAuth2GrantType.password, callback);
    }

    public synchronized void getUsernameAndPrepaidToken(final String emailId, final String password, final OAuth2GrantType grantType, final Callback<AccessToken> callback) {
        Log.i((String)TAG, (String)(TAG + ".getUsernameAndPrepaidToken(email, pwd, grantytype, callback )"));
        this.getUserNameToken(emailId, new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                UmClient.this.getPrepaidToken(emailId, password, grantType, callback);
            }

            @Override
            public void error(CitrusError error) {
                UmClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void signUp(final String emailId, final String mobileNo, final String password, final Callback<CitrusResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".signUp( )"));
        if (this.validate()) {
            this.getUserNameToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    RandomPassword pwd = new RandomPassword();
                    String random_pass = pwd.generate(emailId, mobileNo);
                    ApiRequest setPasswordApi = UmClient.this.getSetPasswordApi(accessToken.getHeaderAccessToken(), random_pass, password);
                    UmClient.this.executor.executeCustomJsonApi(UmClient.this, setPasswordApi, new Callback<JSONObject>(){

                        @Override
                        public void success(JSONObject jsonObject) {
                            UmClient.this.sendResponse(callback, new CitrusResponse("User Signed up successfully.", CitrusResponse.Status.SUCCESSFUL));
                        }

                        @Override
                        public void error(CitrusError error) {
                            UmClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getSetPasswordApi(String accessToken, String oldPassword, String newPassword) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("old", oldPassword);
        params.put("new", newPassword);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_SET_PASSWORD).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public synchronized void updateMobile(final String mobileNo, final Callback<String> callback) {
        Log.i((String)TAG, (String)(TAG + ".updateMobile( )"));
        if (this.validate()) {
            if (!TextUtils.isEmpty((CharSequence)mobileNo)) {
                this.getUserNameToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        if (accessToken != null) {
                            JSONObject jsonObject = new JSONObject();
                            try {
                                jsonObject.put("mobile", (Object)mobileNo);
                                ApiRequest updateMobileApi = UmClient.this.getUpdateMobileApi(accessToken.getHeaderAccessToken(), jsonObject);
                                UmClient.this.executor.executeCustomObjectApi(UmClient.this, updateMobileApi, callback);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                UmClient.this.sendError(callback, new CitrusError("Updating mobile failed. Please try again.", CitrusResponse.Status.FAILED));
                            }
                        } else {
                            UmClient.this.sendError(callback, new CitrusError("Have you Signed In? Token not found!!!", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        UmClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("Please enter the mobile number of your friend to send the money", CitrusResponse.Status.FAILED));
            }
        }
    }

    private ApiRequest getUpdateMobileApi(String accessToken, JSONObject jsonBody) {
        Log.i((String)TAG, (String)(TAG + ".getUpdateMobileApi( )"));
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_UPDATE_MOBILE).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public synchronized void verifyMobile(final String verificationCode, final Callback<String> callback) {
        Log.i((String)TAG, (String)(TAG + ".verifyMobile( )"));
        if (this.validate()) {
            if (!TextUtils.isEmpty((CharSequence)verificationCode)) {
                this.getPrepaidToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        if (accessToken != null) {
                            JSONObject jsonObject = new JSONObject();
                            try {
                                jsonObject.put("verificationCode", (Object)verificationCode);
                                ApiRequest verifyMobileApi = UmClient.this.getverifyMobileApi(accessToken.getHeaderAccessToken(), jsonObject);
                                UmClient.this.executor.executeCustomObjectApi(UmClient.this, verifyMobileApi, new Callback<VerifyMobileResponse>(){

                                    @Override
                                    public void success(VerifyMobileResponse verifyMobileResponse) {
                                        if (verifyMobileResponse != null && verifyMobileResponse.getResponseCode() == 1) {
                                            UmClient.this.sendResponse(callback, verifyMobileResponse.getResponseMessage());
                                            UmClient.this.citrusUser = null;
                                            UmClient.this.getProfileInfo(null);
                                        } else {
                                            UmClient.this.sendError(callback, new CitrusError(verifyMobileResponse.getResponseMessage(), CitrusResponse.Status.FAILED));
                                        }
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        UmClient.this.sendError(callback, error);
                                    }
                                });
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                UmClient.this.sendError(callback, new CitrusError("Updating mobile failed. Please try again.", CitrusResponse.Status.FAILED));
                            }
                        } else {
                            UmClient.this.sendError(callback, new CitrusError("Have you Signed In? Token not found!!!", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        UmClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("Verification Code can not be blank.", CitrusResponse.Status.FAILED));
            }
        }
    }

    private ApiRequest getverifyMobileApi(String accessToken, JSONObject jsonBody) {
        Log.i((String)TAG, (String)(TAG + ".getverifyMobileApi( )"));
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_VERIFY_MOBILE).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public void getProfileInfo(final Callback<CitrusUser> callback) {
        Log.i((String)TAG, (String)(TAG + ".getProfileInfo( )"));
        if (this.validate()) {
            if (this.citrusUser == null) {
                this.getUserNameToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken accessToken) {
                        ApiRequest profileInfoApi = UmClient.this.getProfileInfoApi(accessToken.getHeaderAccessToken());
                        UmClient.this.executor.executeCustomJsonApi(UmClient.this, profileInfoApi, new Callback<JSONObject>(){

                            @Override
                            public void success(JSONObject jsonObject) {
                                if (jsonObject != null) {
                                    String profileInfo = jsonObject.toString();
                                    UmClient.this.citrusUser = CitrusUser.fromJSON(profileInfo);
                                    UmClient.this.sendResponse(callback, UmClient.this.citrusUser);
                                } else {
                                    UmClient.this.sendError(callback, new CitrusError("Failed to update Profile Info", CitrusResponse.Status.FAILED));
                                }
                            }

                            @Override
                            public void error(CitrusError error) {
                                UmClient.this.sendError(callback, error);
                            }
                        });
                    }

                    @Override
                    public void error(CitrusError error) {
                        UmClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendResponse(callback, this.citrusUser);
            }
        }
    }

    private ApiRequest getProfileInfoApi(String accessToken) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_GET_PROFILE_INFO).authorizationToken(accessToken).build();
        return apiRequest;
    }

    public void changePassword(final String oldPassword, final String newPassword, final Callback<CitrusUMResponse> callback) {
        if (this.validate()) {
            this.getUserNameToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    ApiRequest changePasswordApi = UmClient.this.getChangePasswordApi(accessToken.getHeaderAccessToken(), oldPassword, newPassword);
                    UmClient.this.executor.executeCustomObjectApi(UmClient.this, changePasswordApi, callback);
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getChangePasswordApi(String accessToken, String oldPassword, String newPassword) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("old", oldPassword);
        params.put("new", newPassword);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_CHANGE_PASSWORD).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void updateProfileInfo(final String firstName, final String lastName, final Callback<CitrusUMResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".updateProfileInfo( )"));
        if (this.validate()) {
            this.getPrepaidToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    JSONObject profileInfoJSON = new JSONObject();
                    try {
                        profileInfoJSON.put("firstName", (Object)firstName);
                        profileInfoJSON.put("lastName", (Object)lastName);
                        ApiRequest updateUserProfileDetailsApi = UmClient.this.getUpdatUserProfileDetailsApi(accessToken.getHeaderAccessToken(), profileInfoJSON);
                        UmClient.this.executor.executeCustomObjectApi(UmClient.this, updateUserProfileDetailsApi, new Callback<CitrusUMResponse>(){

                            @Override
                            public void success(CitrusUMResponse citrusUMResponse) {
                                UmClient.this.citrusUser = null;
                                UmClient.this.getProfileInfo(null);
                                UmClient.this.sendResponse(callback, citrusUMResponse);
                            }

                            @Override
                            public void error(CitrusError error) {
                                UmClient.this.sendError(callback, error);
                            }
                        });
                    }
                    catch (JSONException e) {
                        UmClient.this.sendError(callback, new CitrusError("Failed to update Profile Info", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getUpdatUserProfileDetailsApi(String accessToken, JSONObject jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_UPDATE_USER_PROFILE).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public void sendOneTimePassword(String source, String otpType, String identity, Callback<CitrusUMResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".sendOneTimePassword( )"));
        if (this.validate()) {
            JSONObject rawObject = new JSONObject();
            try {
                rawObject.put("source", (Object)source);
                rawObject.put("otpType", (Object)otpType);
                rawObject.put("identity", (Object)identity);
                ApiRequest sendOneTimePasswordApi = this.getSendOneTimePasswordApi(rawObject);
                this.executor.executeCustomObjectApi(this, sendOneTimePasswordApi, callback);
            }
            catch (JSONException e) {
                this.sendError(callback, new CitrusError("Failed to Send OTP !", CitrusResponse.Status.FAILED));
            }
        }
    }

    private ApiRequest getSendOneTimePasswordApi(JSONObject jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_SEND_ONE_TIME_PASSWORD).requestBody(requestBody).build();
        return apiRequest;
    }

    public void resetUserPassword(final String emailId, final @NonNull Callback<CitrusUMResponse> callback) {
        this.getSignUpToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                if (accessToken != null) {
                    ApiRequest resetUserPasswordApi = UmClient.this.getResetUserPasswordApi(accessToken.getHeaderAccessToken(), emailId);
                    UmClient.this.executor.executeCustomObjectApi(UmClient.this, resetUserPasswordApi, callback);
                } else {
                    UmClient.this.sendError(callback, new CitrusError("Error: Reset password failed", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                UmClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getResetUserPasswordApi(String accessToken, String username) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("username", username);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_RESET_USER_PASSWORD).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void signUpUser(final String email, final String mobile, final String password, final String firstName, final String lastName, final String sourceType, final boolean markMobileVerified, final boolean markEmailVerified, final Callback<CitrusResponse> callback) {
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    ApiRequest signUpUserApi = UmClient.this.getsignUpUserApi(accessToken.getHeaderAccessToken(), email, mobile, password, firstName, lastName, sourceType, String.valueOf(markMobileVerified), String.valueOf(markEmailVerified));
                    UmClient.this.executor.executeCustomObjectApi(UmClient.this, signUpUserApi, new Callback<CitrusUMResponse>(){

                        @Override
                        public void success(CitrusUMResponse citrusUMResponse) {
                            if (citrusUMResponse.getResponseCode().equalsIgnoreCase("R-201-00")) {
                                UmClient.this.sendResponse(callback, new CitrusResponse("User Signed up successfully.", CitrusResponse.Status.SUCCESSFUL));
                            } else {
                                JSONObject errorJSON = new JSONObject();
                                try {
                                    errorJSON.put("responseCode", (Object)citrusUMResponse.getResponseCode());
                                    errorJSON.put("responseMessage", (Object)citrusUMResponse.getResponseMessage());
                                    UmClient.this.sendError(callback, new CitrusError(errorJSON.toString(), CitrusResponse.Status.FAILED));
                                }
                                catch (JSONException e) {
                                    UmClient.this.sendError(callback, new CitrusError("Failed to Sign Up user!", CitrusResponse.Status.FAILED));
                                }
                            }
                        }

                        @Override
                        public void error(CitrusError error) {
                            UmClient.this.sendError(callback, error);
                        }
                    });
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getsignUpUserApi(String accessToken, String email, String mobile, String password, String firstName, String lastName, String sourceType, String markMobileVerified, String markEmailVerified) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("email", email);
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("firstName", firstName);
        params.put("lastName", lastName);
        params.put("sourceType", sourceType);
        params.put("markMobileVerified", markMobileVerified);
        params.put("markEmailVerified", markEmailVerified);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_SIGN_UP_USER).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void linkUserExtended(final String emailId, final String mobileNo, final Callback<LinkUserExtendedResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".linkUserExtended( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                        try {
                            JSONObject jsonObject = new JSONObject();
                            if (!TextUtils.isEmpty((CharSequence)emailId)) {
                                jsonObject.put("email", (Object)emailId);
                            }
                            jsonObject.put("mobile", (Object)mobileNo);
                            ApiRequest linkUserExtendedApi = UmClient.this.getlinkUserExtendedApi(accessToken.getHeaderAccessToken(), jsonObject);
                            UmClient.this.executor.executeCustomJsonApi(UmClient.this, linkUserExtendedApi, new Callback<JSONObject>(){

                                @Override
                                public void success(JSONObject linkUserJsonObject) {
                                    LinkUserExtendedResponse linkUserExtendedResponse = LinkUserExtendedResponse.fromJSON(linkUserJsonObject.toString());
                                    linkUserExtendedResponse.setInputEmail(emailId);
                                    linkUserExtendedResponse.setInputMobile(mobileNo);
                                    UmClient.this.sendResponse(callback, linkUserExtendedResponse);
                                }

                                @Override
                                public void error(CitrusError error) {
                                    UmClient.this.sendError(callback, error);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to Link User", CitrusResponse.Status.FAILED));
                        }
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getlinkUserExtendedApi(String signUpToken, JSONObject jsonBody) {
        Log.i((String)TAG, (String)(TAG + ".getlinkUserExtendedApi( )"));
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_LINK_USER_EXTENDED).authorizationToken(signUpToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public void linkUserExtendedVerifyEOTPAndUpdateMobile(final String emailId, final String signInGrantType, final String linkUserPassword, final LinkUserExtendedResponse linkUserExtended, final Callback<CitrusResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".linkUserExtendedVerifyEOTPAndUpdateMobile( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(final AccessToken accessToken) {
                    if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                        OauthToken token = new OauthToken(UmClient.this.mContext, "signin_token");
                        token.createToken(accessToken.getJSON());
                        try {
                            ApiRequest linkUserExtendedVerifyEOTPAndUpdateMobileApi = UmClient.this.getlinkUserExtendedVerifyEOTPAndUpdateMobileApi(accessToken.getHeaderAccessToken(), signInGrantType, UmClient.this.tokenUtils.getSigninId(), UmClient.this.tokenUtils.getSigninSecret(), emailId, linkUserPassword, linkUserExtended.getRequestedMobile());
                            UmClient.this.executor.executeCustomObjectApi(UmClient.this, linkUserExtendedVerifyEOTPAndUpdateMobileApi, new Callback<LinkUserVerifyEOTPUpdateMobile>(){

                                @Override
                                public void success(LinkUserVerifyEOTPUpdateMobile linkUserVerifyEOTPUpdateMobile) {
                                    if (linkUserVerifyEOTPUpdateMobile != null) {
                                        AccessToken linkUserToken = linkUserVerifyEOTPUpdateMobile.getOAuth2AccessToken();
                                        if (linkUserToken != null && linkUserToken.getHeaderAccessToken() != null) {
                                            UmClient.this.tokenUtils.saveToken(Constants.TokenType.PREPAID_TOKEN, accessToken);
                                            String input = linkUserExtended.getInputEmail().equalsIgnoreCase("") ? linkUserExtended.getInputMobile() : linkUserExtended.getInputEmail();
                                            UmClient.this.getUserNameToken(input, new Callback<AccessToken>(){

                                                @Override
                                                public void success(AccessToken accessToken) {
                                                    UmClient.this.sendResponse(callback, null);
                                                }

                                                @Override
                                                public void error(CitrusError error) {
                                                    UmClient.this.sendError(callback, error);
                                                }
                                            });
                                        } else {
                                            CitrusError citrusError = new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
                                            UmClient.this.sendError(callback, citrusError);
                                        }
                                    } else {
                                        CitrusError citrusError = new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
                                        UmClient.this.sendError(callback, citrusError);
                                    }
                                }

                                @Override
                                public void error(CitrusError error) {
                                    UmClient.this.sendError(callback, error);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to Link User", CitrusResponse.Status.FAILED));
                        }
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    private ApiRequest getlinkUserExtendedVerifyEOTPAndUpdateMobileApi(String signUpToken, String grant_type, String client_ID, String client_Secret, String username, String password, String requestedMobile) {
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("grant_type", grant_type);
        params.put("client_id", client_ID);
        params.put("client_secret", client_Secret);
        params.put("username", username);
        params.put("password", password);
        params.put("requestedMobile", requestedMobile);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_LINK_USER_EXTENDED_VERIFY_EOTP_AND_UPDATE_MOBILE).authorizationToken(signUpToken).params(params).build();
        return apiRequest;
    }

    public synchronized void linkUserExtendedVerifyMobileAndSignIn(final LinkUserExtendedResponse linkUserExtendedResponse, final String verificationCode, final Callback<CitrusResponse> callback) {
        Log.i((String)TAG, (String)(TAG + ".linkUserExtendedVerifyMobileAndSignIn( )"));
        if (this.validate()) {
            this.getSignUpToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    if (accessToken != null && accessToken.getHeaderAccessToken() != null) {
                        OauthToken token = new OauthToken(UmClient.this.mContext, "signin_token");
                        token.createToken(accessToken.getJSON());
                        try {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("identity", (Object)linkUserExtendedResponse.getLinkUserUUID());
                            jsonObject.put("verificationCode", (Object)verificationCode);
                            jsonObject.put("client_id", (Object)UmClient.this.tokenUtils.getSigninId());
                            jsonObject.put("client_secret", (Object)UmClient.this.tokenUtils.getSigninSecret());
                            ApiRequest api = UmClient.this.getlinkUserExtendedVerifyMobileAndSignInApi(accessToken.getHeaderAccessToken(), jsonObject);
                            UmClient.this.executor.executeCustomObjectApi(UmClient.this, api, new Callback<AccessToken>(){

                                @Override
                                public void success(AccessToken accessToken) {
                                    Logger.d((String)("SIGN IN RESPONSE " + accessToken.getJSON().toString()), (Object[])new Object[0]);
                                    if (accessToken.getHeaderAccessToken() != null) {
                                        UmClient.this.tokenUtils.saveToken(Constants.TokenType.PREPAID_TOKEN, accessToken);
                                        UmClient.this.getUserNameToken(linkUserExtendedResponse.getInputMobile(), new Callback<AccessToken>(){

                                            @Override
                                            public void success(AccessToken accessToken) {
                                                UmClient.this.sendResponse(callback, null);
                                            }

                                            @Override
                                            public void error(CitrusError error) {
                                                UmClient.this.sendError(callback, error);
                                            }
                                        });
                                    } else {
                                        CitrusError citrusError = new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
                                        UmClient.this.sendError(callback, citrusError);
                                    }
                                }

                                @Override
                                public void error(CitrusError error) {
                                    UmClient.this.sendError(callback, error);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to Link User", CitrusResponse.Status.FAILED));
                        }
                    } else {
                        UmClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch Sign up token.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    UmClient.this.sendError(callback, error);
                }
            });
        }
    }

    public void signOut(Callback<Boolean> callback) {
        Log.i((String)TAG, (String)(TAG + ".signOut( )"));
        CookieSyncManager.createInstance((Context)this.mContext);
        CookieManager.getInstance().setCookie(this.environment.getBaseUrl(), "prepaiduser-payauth=''");
        new PersistentConfig(this.mContext).clearToken();
        OauthToken token = new OauthToken(this.mContext, "");
        boolean isUserSignedOut = false;
        isUserSignedOut = token.clearToken();
        this.citrusUser = null;
        this.signUpToken = null;
        callback.success(isUserSignedOut);
    }

    private ApiRequest getlinkUserExtendedVerifyMobileAndSignInApi(String signUpToken, JSONObject jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.UM_LINK_USER_EXTENDED_VERIFY_MOBILE_AND_SIGN_IN).authorizationToken(signUpToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public void setCitrusUser(CitrusUser citrusUser) {
        this.citrusUser = citrusUser;
    }
}

