/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.citrus.mobile.OauthToken;
import com.citrus.sdk.Constants;
import com.citrus.sdk.UMCallback;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.facebook.android.crypto.keychain.SharedPrefsBackedKeyChain;
import com.facebook.crypto.Crypto;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.util.NativeCryptoLibrary;
import com.facebook.crypto.util.SystemNativeCryptoLibrary;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenUtils {
    private Context mContext;
    private String signupId;
    private String signupSecret;
    private String signinId;
    private String signinSecret;
    private String vanity;
    private static TokenUtils instance = null;

    private TokenUtils(Context mContext) {
        this.mContext = mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenUtils getInstance(Context context) {
        if (instance != null) return instance;
        Class<TokenUtils> clazz = TokenUtils.class;
        synchronized (TokenUtils.class) {
            if (instance != null) return instance;
            instance = new TokenUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void init(String signupId, String signupSecret, String signinId, String signinSecret, String vanity) {
        this.signupId = signupId;
        this.signupSecret = signupSecret;
        this.signinId = signinId;
        this.signinSecret = signinSecret;
        this.vanity = vanity;
    }

    public boolean validate() {
        if (!(TextUtils.isEmpty((CharSequence)this.signinId) || TextUtils.isEmpty((CharSequence)this.signinSecret) || TextUtils.isEmpty((CharSequence)this.signupId) || TextUtils.isEmpty((CharSequence)this.signupSecret) || TextUtils.isEmpty((CharSequence)this.vanity))) {
            return true;
        }
        throw new IllegalArgumentException("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank");
    }

    public void getToken(boolean isPrepaidPayRequest, Constants.TokenType tokenType, UMCallback<AccessToken> callback) {
        JSONObject token = null;
        String originalToken = null;
        try {
            SharedPreferences tokenPrefs = this.mContext.getSharedPreferences("UserStorage", 0);
            if (tokenPrefs.contains(tokenType.toString())) {
                originalToken = tokenPrefs.getString(tokenType.toString(), null);
                if (originalToken != null) {
                    token = new JSONObject(originalToken);
                    if (token.has("refresh_token")) {
                        if (this.hasExpired(token) || !token.has("Prepaid_Pay_Token") && tokenType == Constants.TokenType.PREPAID_TOKEN && isPrepaidPayRequest && !tokenPrefs.getBoolean("IS_TOKEN_REFRESHED", false)) {
                            callback.expired(token.optString("refresh_token"));
                        } else {
                            Gson gson = new GsonBuilder().create();
                            AccessToken accessToken = (AccessToken)gson.fromJson(token.toString(), AccessToken.class);
                            callback.success((AccessToken)accessToken);
                        }
                    } else {
                        Gson gson = new GsonBuilder().create();
                        AccessToken accessToken = (AccessToken)gson.fromJson(token.toString(), AccessToken.class);
                        callback.success((AccessToken)accessToken);
                    }
                } else {
                    String errorMessage = tokenType.toString().equalsIgnoreCase("signup_token") ? "Have you Signed Up? Token not found!!!" : "Have you Signed In? Token not found!!!";
                    CitrusError error = new CitrusError(errorMessage, CitrusResponse.Status.FAILED);
                    callback.error(error);
                }
            } else {
                String errorMessage = tokenType.toString().equalsIgnoreCase("signup_token") ? "Have you Signed Up? Token not found!!!" : "Have you Signed In? Token not found!!!";
                CitrusError error = new CitrusError(errorMessage, CitrusResponse.Status.FAILED);
                callback.error(error);
            }
        }
        catch (JSONException e) {
            CitrusError error = new CitrusError("Failed to get Access Token", CitrusResponse.Status.FAILED);
            callback.error(error);
        }
    }

    private String getDecryptedToken(String token_type, String encryptedToken) {
        String decryptedToken = null;
        String seed = token_type + this.signinId + this.signinSecret;
        try {
            Crypto crypto = new Crypto((KeyChain)new SharedPrefsBackedKeyChain(this.mContext), (NativeCryptoLibrary)new SystemNativeCryptoLibrary());
            if (!crypto.isAvailable()) {
                return encryptedToken;
            }
            Entity myEntity = new Entity(seed);
            if (encryptedToken != null) {
                byte[] array = Base64.decode((String)encryptedToken, (int)0);
                byte[] decryptedtoken = crypto.decrypt(array, myEntity);
                decryptedToken = new String(decryptedtoken);
            } else {
                decryptedToken = null;
            }
        }
        catch (KeyChainException e) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException e) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return decryptedToken;
    }

    private boolean hasExpired(JSONObject token) {
        try {
            return token.getLong("expiry") <= new Date().getTime() / 1000L;
        }
        catch (JSONException e) {
            return true;
        }
    }

    public void saveToken(Constants.TokenType tokenType, AccessToken accessToken) {
        OauthToken oauthToken = new OauthToken(this.mContext, tokenType.toString(), this.signinId, this.signinSecret);
        oauthToken.createToken(accessToken.getJSON());
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public String getSigninId() {
        return this.signinId;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public String getVanity() {
        return this.vanity;
    }

    public void setVanity(String vanity) {
        this.vanity = vanity;
    }
}

