/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.UpdateSubscriptionRequest;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class PrepaidClient
extends BaseClient {
    private static PrepaidClient instance;
    private ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrepaidClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<PrepaidClient> clazz = PrepaidClient.class;
        synchronized (PrepaidClient.class) {
            if (instance != null) return instance;
            instance = new PrepaidClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private PrepaidClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(context);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getBaseUrl();
    }

    public void getPrepaymentTokenValidity(AccessToken signupToken, AccessToken prepaidToken, String scope, final Callback<Boolean> callback) {
        String prepaymentToken = prepaidToken.getPrepaidPayToken() != null ? prepaidToken.getPrepaidPayToken().getHeaderAccessToken() : "";
        ApiRequest prepaymentTokenValidityApi = this.getPrepaymentTokenValidityApi(signupToken.getHeaderAccessToken(), prepaymentToken, scope);
        this.executor.executeCustomJsonApi(this, prepaymentTokenValidityApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                boolean valid = false;
                if (jsonObject != null && !TextUtils.isEmpty((CharSequence)jsonObject.toString())) {
                    try {
                        String validity = jsonObject.optString("expiration");
                        valid = Utils.isTokenValid(validity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PrepaidClient.this.sendResponse(callback, valid);
                }
            }

            @Override
            public void error(CitrusError error) {
                PrepaidClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getPrepaymentTokenValidityApi(String signupToken, String prepaymentToken, String scope) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("OwnerAuthorization", prepaymentToken);
        headers.put("OwnerScope", scope);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_IS_PREPAID_TOKEN_VALID).authorizationToken(signupToken).headers(headers).build();
        return apiRequest;
    }

    public void getPrepaidBill(AccessToken accessToken, Amount amount, String returnUrl, Callback<CitrusPrepaidBill> callback) {
        ApiRequest prepaidBillApi = this.getPrepaidBillApi(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), returnUrl);
        this.executor.executeCustomObjectApi(this, prepaidBillApi, callback);
    }

    private ApiRequest getPrepaidBillApi(String accessToken, String amount, String currency, String redirectUrl) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("redirect", redirectUrl);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_GET_PREPAID_BILL).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public synchronized void getBalance(AccessToken accessToken, Callback<Amount> callback) {
        if (this.validate()) {
            ApiRequest getBalanceApi = this.getGetBalanceApi(accessToken.getHeaderAccessToken(), "");
            this.executor.executeCustomObjectApi(this, getBalanceApi, callback);
        }
    }

    private ApiRequest getGetBalanceApi(String accessToken, String dummyObject) {
        HashMap params = new HashMap(3);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_GET_BALANCE).authorizationToken(accessToken).build();
        return apiRequest;
    }

    public synchronized void activatePrepaidUser(AccessToken accessToken, Callback<Amount> callback) {
        if (this.validate()) {
            ApiRequest activatePrepaidUserApi = this.getActivatePrepaidUserApi(accessToken.getHeaderAccessToken());
            this.executor.executeCustomObjectApi(this, activatePrepaidUserApi, callback);
        }
    }

    private ApiRequest getActivatePrepaidUserApi(String accessToken) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_ACTIVATE_PREPAID_USER).authorizationToken(accessToken).build();
        return apiRequest;
    }

    public void newPrepaidPay(AccessToken accessToken, PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        ApiRequest newPrepaidApi = this.getNewPrepaidPayApi(accessToken.getPrepaidPayToken().getHeaderAccessToken(), citrusCash.getPaymentJSON());
        this.executor.executeCustomJsonApi(this, newPrepaidApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                PaymentResponse paymentResponse;
                if (jsonObject != null && (paymentResponse = PaymentResponse.fromJSON(jsonObject.toString())) != null) {
                    PrepaidClient.this.sendResponse(callback, paymentResponse);
                } else {
                    PrepaidClient.this.sendError(callback, new CitrusError("Error while making payment", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }

    private ApiRequest getNewPrepaidPayApi(String accessToken, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_NEW_PREPAID_PAY).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public synchronized void sendMoney(AccessToken accessToken, Amount amount, CitrusUser toUser, String message, Callback<PaymentResponse> callback) {
        if (this.validate()) {
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                this.sendError(callback, new CitrusError("Please enter the amount to be sent.", CitrusResponse.Status.FAILED));
                return;
            }
            if (toUser == null || TextUtils.isEmpty((CharSequence)toUser.getEmailId()) && TextUtils.isEmpty((CharSequence)toUser.getMobileNo())) {
                this.sendError(callback, new CitrusError("Please enter email id or the mobile number of your friend to send the money", CitrusResponse.Status.FAILED));
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)toUser.getEmailId())) {
                ApiRequest sendMoneyByEmailApi = this.getSendMoneyByEmailApi(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, toUser.getEmailId());
                this.executor.executeCustomObjectApi(this, sendMoneyByEmailApi, callback);
            } else {
                long mobileNo = Utils.isValidMobileNumber(toUser.getMobileNo());
                if (mobileNo != -1L) {
                    ApiRequest sendMoneyByMobileApi = this.getSendMoneyByMobileApi(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, String.valueOf(mobileNo));
                    this.executor.executeCustomObjectApi(this, sendMoneyByMobileApi, callback);
                } else {
                    this.sendError(callback, new CitrusError("Invalid Mobile Number", CitrusResponse.Status.FAILED));
                }
            }
        }
    }

    private ApiRequest getSendMoneyByEmailApi(String accessToken, String amount, String currency, String message, String emailId) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("message", message);
        params.put("to", emailId);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_SEND_MONEY_BY_EMAIL).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    private ApiRequest getSendMoneyByMobileApi(String accessToken, String amount, String currency, String message, String mobileNo) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("message", message);
        params.put("to", mobileNo);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_SEND_MONEY_BY_MOBILE).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public synchronized void sendMoneyToMoblieNo(AccessToken accessToken, Amount amount, String mobileNo, String message, Callback<PaymentResponse> callback) {
        if (this.validate()) {
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                this.sendError(callback, new CitrusError("Please enter the amount to be sent.", CitrusResponse.Status.FAILED));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)mobileNo)) {
                this.sendError(callback, new CitrusError("Please enter the mobile number of your friend to send the money", CitrusResponse.Status.FAILED));
                return;
            }
            long validMobileNo = Utils.isValidMobileNumber(mobileNo);
            if (validMobileNo != -1L) {
                ApiRequest sendMoneyByMobileApi = this.getSendMoneyByMobileApi(accessToken.getHeaderAccessToken(), amount.getValue(), amount.getCurrency(), message, String.valueOf(mobileNo));
                this.executor.executeCustomObjectApi(this, sendMoneyByMobileApi, callback);
            } else {
                this.sendError(callback, new CitrusError("Invalid Mobile Number", CitrusResponse.Status.FAILED));
            }
        }
    }

    public synchronized void cashout(final AccessToken accessToken, final @NonNull CashoutInfo cashoutInfo, final Callback<PaymentResponse> callback) {
        this.getBalance(accessToken, new Callback<Amount>(){

            @Override
            public void success(Amount balanceAmount) {
                if (balanceAmount.getValueAsDouble() >= cashoutInfo.getAmount().getValueAsDouble()) {
                    ApiRequest cashoutApi = PrepaidClient.this.getCashoutApi(accessToken.getHeaderAccessToken(), cashoutInfo.getAmount().getValue(), cashoutInfo.getAmount().getCurrency(), cashoutInfo.getAccountHolderName(), cashoutInfo.getAccountNo(), cashoutInfo.getIfscCode());
                    PrepaidClient.this.executor.executeCustomObjectApi(PrepaidClient.this, cashoutApi, callback);
                } else {
                    PrepaidClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                PrepaidClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getCashoutApi(String accessToken, String amount, String currency, String owner, String accountNo, String ifscCode) {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("owner", owner);
        params.put("account", accountNo);
        params.put("ifsc", ifscCode);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_CASHOUT).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public synchronized void getCashoutInfo(AccessToken accessToken, final Callback<CashoutInfo> callback) {
        ApiRequest cashoutInfoApi = this.getCashoutInfoApi(accessToken.getHeaderAccessToken());
        this.executor.executeCustomJsonApi(this, cashoutInfoApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                CashoutInfo cashoutInfo = CashoutInfo.fromJSON(jsonObject.toString());
                PrepaidClient.this.sendResponse(callback, cashoutInfo);
            }

            @Override
            public void error(CitrusError error) {
                PrepaidClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getCashoutInfoApi(String accessToken) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_GET_CASHOUT_INFO).authorizationToken(accessToken).build();
        return apiRequest;
    }

    public void saveCashoutInfo(AccessToken accessToken, CashoutInfo cashoutInfo, final Callback<CitrusResponse> callback) {
        if (cashoutInfo != null) {
            ApiRequest saveCashoutInfoApi = this.getSaveCashoutInfoApi(accessToken.getHeaderAccessToken(), CashoutInfo.toJSON(cashoutInfo));
            this.executor.executeCustomJsonApi(this, saveCashoutInfoApi, new Callback<JSONObject>(){

                @Override
                public void success(JSONObject jsonObject) {
                    PrepaidClient.this.sendResponse(callback, new CitrusResponse("Cashout Information Saved Successfully.", CitrusResponse.Status.SUCCESSFUL));
                }

                @Override
                public void error(CitrusError error) {
                    PrepaidClient.this.sendError(callback, error);
                }
            });
        } else {
            this.sendError(callback, new CitrusError("Please make sure amount, accountNo, accountHolderName and ifscCode are not null or empty.", CitrusResponse.Status.FAILED));
        }
    }

    private ApiRequest getSaveCashoutInfoApi(String accessToken, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_SAVE_CASHOUT_INFO).authorizationToken(accessToken).requestBody(requestBody).build();
        return apiRequest;
    }

    public void getActiveSubscriptions(AccessToken accessToken, final Callback<SubscriptionResponse> callback) {
        ApiRequest activeSubscriptionsRequest = this.getActiveSubscriptionsApi(accessToken.getHeaderAccessToken());
        Type type = new TypeToken<ArrayList<SubscriptionResponse>>(){}.getType();
        this.executor.executeCustomObjectApi(this, activeSubscriptionsRequest, type, new Callback<List<SubscriptionResponse>>(){

            @Override
            public void success(List<SubscriptionResponse> subscriptionResponses) {
                if (subscriptionResponses == null || subscriptionResponses.isEmpty()) {
                    PrepaidClient.this.sendResponse(callback, null);
                } else {
                    SubscriptionResponse subscriptionResponse = subscriptionResponses.get(0);
                    PrepaidClient.this.sendResponse(callback, subscriptionResponse);
                }
            }

            @Override
            public void error(CitrusError error) {
                PrepaidClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getActiveSubscriptionsApi(String accessToken) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_GET_ACTIVE_SUBSCRIPTION).authorizationToken(accessToken).build();
        return apiRequest;
    }

    public void deActivateSubscription(AccessToken accessToken, String subscriptionID, Callback<SubscriptionResponse> callback) {
        ApiRequest deActivateSubscriptionRequest = this.getDeactivateSubscriptionApi(accessToken.getHeaderAccessToken(), subscriptionID, "Inactive");
        this.executor.executeCustomObjectApi(this, deActivateSubscriptionRequest, callback);
    }

    private ApiRequest getDeactivateSubscriptionApi(String accessToken, String subscriptionID, String status) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscriptionId", subscriptionID);
        params.put("status", status);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_DEACTIVATE_SUBSCRIPTION).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void createSubscription(AccessToken accessToken, SubscriptionRequest subscriptionRequest, Callback<SubscriptionResponse> callback) {
        ApiRequest apiRequest = subscriptionRequest.isSavedCardSubscription() ? this.getCreateSubscriptionWithTokenApi(accessToken.getHeaderAccessToken(), subscriptionRequest.getAuthRefId(), subscriptionRequest.getThresholdAmount(), subscriptionRequest.getLoadAmount(), subscriptionRequest.getType(), subscriptionRequest.getToken()) : this.getCreateSubscriptionWithCardApi(accessToken.getHeaderAccessToken(), subscriptionRequest.getPan(), subscriptionRequest.getExpiry(), subscriptionRequest.getHolder(), subscriptionRequest.getAuthRefId(), subscriptionRequest.getThresholdAmount(), subscriptionRequest.getLoadAmount(), subscriptionRequest.getType());
        this.executor.executeCustomObjectApi(this, apiRequest, callback);
    }

    private ApiRequest getCreateSubscriptionWithTokenApi(String accessToken, String refID, String thresholdAmount, String loadAmount, String type, String token) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("authRefId", refID);
        params.put("thresholdAmount", thresholdAmount);
        params.put("loadAmount", loadAmount);
        params.put("type", type);
        params.put("token", token);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_CREATE_SUBSCRIPTION).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    private ApiRequest getCreateSubscriptionWithCardApi(String accessToken, String pan, String expiry, String holder, String refID, String thresholdAmount, String loadAmount, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pan", pan);
        params.put("expiry", expiry);
        params.put("holder", holder);
        params.put("authRefId", refID);
        params.put("thresholdAmount", thresholdAmount);
        params.put("loadAmount", loadAmount);
        params.put("type", type);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_CREATE_SUBSCRIPTION).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void updateSubscriptiontoLowerValue(AccessToken accessToken, UpdateSubscriptionRequest subscriptionRequest, Callback<SubscriptionResponse> callback) {
        ApiRequest updateSubscriptionRequest = this.getUpdateSubscriptiontoLowerValueApi(accessToken.getHeaderAccessToken(), subscriptionRequest.getSubscriptionId(), subscriptionRequest.getThresholdAmount(), subscriptionRequest.getLoadAmount());
        this.executor.executeCustomObjectApi(this, updateSubscriptionRequest, callback);
    }

    private ApiRequest getUpdateSubscriptiontoLowerValueApi(String accessToken, String subscriptionID, String thresholdAmount, String loadAmount) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscriptionId", subscriptionID);
        params.put("thresholdAmount", thresholdAmount);
        params.put("loadAmount", loadAmount);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_UPDATE_SUBSCRIPTION).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }

    public void updateSubscriptiontoHigherValue(AccessToken accessToken, UpdateSubscriptionRequest subscriptionRequest, Callback<SubscriptionResponse> callback) {
        ApiRequest updateSubscriptionRequest = this.getUpdateSubscriptiontoHigherValueApi(accessToken.getHeaderAccessToken(), subscriptionRequest.getSubscriptionId(), subscriptionRequest.getThresholdAmount(), subscriptionRequest.getLoadAmount(), subscriptionRequest.getAuthRefId());
        this.executor.executeCustomObjectApi(this, updateSubscriptionRequest, callback);
    }

    private ApiRequest getUpdateSubscriptiontoHigherValueApi(String accessToken, String subscriptionID, String thresholdAmount, String loadAmount, String authRefID) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscriptionId", subscriptionID);
        params.put("thresholdAmount", thresholdAmount);
        params.put("loadAmount", loadAmount);
        params.put("authRefId", authRefID);
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PREPAID_UPDATE_SUBSCRIPTION).authorizationToken(accessToken).params(params).build();
        return apiRequest;
    }
}

