/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.util.Log;
import com.citrus.sdk.AddCardResponse;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import java.util.HashMap;
import org.json.JSONObject;

public class PgClient
extends BaseClient {
    private static final String TAG = PgClient.class.getSimpleName();
    private MerchantPaymentOption merchantPaymentOption;
    private MerchantPaymentOption loadMoneyPaymentOption;
    private static PgClient instance = null;
    private ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PgClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<PgClient> clazz = PgClient.class;
        synchronized (PgClient.class) {
            if (instance != null) return instance;
            instance = new PgClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private PgClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(context);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getBaseUrl();
    }

    public ApiRequest getMotoRequestApi(String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest motoRequestApi = new ApiRequest.Builder(Api.PG_MOTO_REQUEST).requestBody(requestBody).build();
        return motoRequestApi;
    }

    public void saveCard(AccessToken accessToken, PaymentOption paymentOption, Callback<AddCardResponse> callback) {
        if (this.validate()) {
            if (paymentOption != null) {
                ApiRequest saveCardApi = this.getSaveCardApi(accessToken.getHeaderAccessToken(), paymentOption.getSavePaymentOptionObject());
                this.executor.executeCustomObjectApi(this, saveCardApi, callback);
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank", CitrusResponse.Status.FAILED));
        }
    }

    public ApiRequest getSaveCardApi(String accessToken, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest saveCardRequestApi = new ApiRequest.Builder(Api.PG_SAVE_CARD).authorizationToken(accessToken).requestBody(requestBody).build();
        return saveCardRequestApi;
    }

    private void getMerchantPaymentOptions(String vanity, final Callback<MerchantPaymentOption> callback) {
        if (this.validate()) {
            ApiRequest merchantPaymentOptionsApi = this.getMerchantPaymentOptionsApi(vanity);
            this.executor.executeCustomJsonApi(this, merchantPaymentOptionsApi, new Callback<JSONObject>(){

                @Override
                public void success(JSONObject paymentOptionObj) {
                    if (paymentOptionObj != null) {
                        MerchantPaymentOption merchantPaymentOption = MerchantPaymentOption.getMerchantPaymentOptions(paymentOptionObj);
                        PgClient.this.sendResponse(callback, merchantPaymentOption);
                    } else {
                        PgClient.this.sendError(callback, new CitrusError("ERROR: Unable to fetch merchant payment options", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                }
            });
        } else {
            this.sendError(callback, new CitrusError("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void getMerchantPaymentOptions(final Callback<MerchantPaymentOption> callback) {
        Log.v((String)TAG, (String)(TAG + ".getMerchantPaymentOptions() " + this.merchantPaymentOption));
        if (this.merchantPaymentOption == null) {
            this.getMerchantPaymentOptions(this.getVanity(), new Callback<MerchantPaymentOption>(){

                @Override
                public void success(MerchantPaymentOption merchantPaymentOption) {
                    Log.v((String)TAG, (String)(TAG + ".getMerchantPaymentOptions(): SUCCESS "));
                    PgClient.this.merchantPaymentOption = merchantPaymentOption;
                    PgClient.this.sendResponse(callback, merchantPaymentOption);
                }

                @Override
                public void error(CitrusError error) {
                    Log.e((String)TAG, (String)(TAG + ".getMerchantPaymentOptions().error():  " + error));
                    PgClient.this.sendError(callback, error);
                }
            });
        } else {
            this.sendResponse(callback, this.merchantPaymentOption);
        }
    }

    public synchronized void getLoadMoneyPaymentOptions(final Callback<MerchantPaymentOption> callback) {
        Log.v((String)TAG, (String)(TAG + ".getLoadMoneyPaymentOptions() "));
        if (this.loadMoneyPaymentOption == null) {
            this.getMerchantPaymentOptions("prepaid", new Callback<MerchantPaymentOption>(){

                @Override
                public void success(MerchantPaymentOption merchantPaymentOption) {
                    PgClient.this.loadMoneyPaymentOption = merchantPaymentOption;
                    PgClient.this.sendResponse(callback, merchantPaymentOption);
                }

                @Override
                public void error(CitrusError error) {
                    PgClient.this.sendError(callback, error);
                }
            });
        } else {
            this.sendResponse(callback, this.loadMoneyPaymentOption);
        }
    }

    private ApiRequest getMerchantPaymentOptionsApi(String vanity) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("vanity", vanity);
        ApiRequest merchantPaymentApi = new ApiRequest.Builder(Api.PG_MERCHANT_PAYMENT).params(params).build();
        return merchantPaymentApi;
    }

    public MerchantPaymentOption getMerchantPaymentOption() {
        return this.merchantPaymentOption;
    }

    public MerchantPaymentOption getLoadMoneyPaymentOption() {
        return this.loadMoneyPaymentOption;
    }

    public synchronized void setDefaultPaymentOption(AccessToken accessToken, PaymentOption defaultPaymentOption, final Callback<CitrusResponse> callback) {
        if (this.validate()) {
            if (defaultPaymentOption != null) {
                ApiRequest defaultPaymentApiRequest = this.getSetDefaultPaymentOptionsApi(accessToken.getHeaderAccessToken(), defaultPaymentOption.getSaveDefaultPaymentOptionObject());
                this.executor.executeCustomObjectApi(this, defaultPaymentApiRequest, new Callback<JSONObject>(){

                    @Override
                    public void success(JSONObject jsonObject) {
                        PgClient.this.sendResponse(callback, new CitrusResponse("Payment Option Saved Successfully.", CitrusResponse.Status.SUCCESSFUL));
                    }

                    @Override
                    public void error(CitrusError error) {
                        PgClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank", CitrusResponse.Status.FAILED));
        }
    }

    private ApiRequest getSetDefaultPaymentOptionsApi(String headerAccessToken, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest setDefaultPaymentApi = new ApiRequest.Builder(Api.PG_SET_DEFAULT_PAYMENT_OPTION).authorizationToken(headerAccessToken).requestBody(requestBody).build();
        return setDefaultPaymentApi;
    }

    public synchronized void savePaymentOption(AccessToken accessToken, PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        if (this.validate()) {
            if (paymentOption != null) {
                ApiRequest savePaymentApiRequest = this.getSavePaymentOptionsApi(accessToken.getHeaderAccessToken(), paymentOption.getSaveDefaultPaymentOptionObject());
                this.executor.executeCustomObjectApi(this, savePaymentApiRequest, callback);
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank", CitrusResponse.Status.FAILED));
        }
    }

    private ApiRequest getSavePaymentOptionsApi(String headerAccessToken, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest savePaymentOptionApi = new ApiRequest.Builder(Api.PG_SAVE_PAYMENT_OPTION).authorizationToken(headerAccessToken).requestBody(requestBody).build();
        return savePaymentOptionApi;
    }

    public synchronized void deletePaymentOption(AccessToken accessToken, PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        if (this.validate()) {
            if (paymentOption != null) {
                ApiRequest deletePaymentApiRequest = this.getDeletePaymentOptionsApi(accessToken.getHeaderAccessToken(), paymentOption.getToken());
                this.executor.executeCustomObjectApi(this, deletePaymentApiRequest, callback);
            } else {
                this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank", CitrusResponse.Status.FAILED));
        }
    }

    private ApiRequest getDeletePaymentOptionsApi(String headerAccessToken, String token) {
        ApiRequest deletePaymentOptionApi = new ApiRequest.Builder(Api.PG_DELETE_PAYMENT_OPTION).authorizationToken(headerAccessToken).pathParams(token).build();
        return deletePaymentOptionApi;
    }

    public synchronized void getBinInfoUsingToken(String token, final Callback<BinServiceResponse> callback) {
        ApiRequest binInfoUsingTokenApi = this.getBinInfoUsingTokenApiRequest(token);
        this.executor.executeCustomJsonApi(this, binInfoUsingTokenApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                if (jsonObject != null) {
                    String jsonString = jsonObject.toString();
                    BinServiceResponse binServiceResponse = BinServiceResponse.fromJSON(jsonString);
                    PgClient.this.sendResponse(callback, binServiceResponse);
                } else {
                    PgClient.this.sendError(callback, new CitrusError("Unable to get bin service response", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                PgClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getBinInfoUsingTokenApiRequest(String token) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PG_GET_BIN_INFO_USING_TOKEN).pathParams(token).build();
        return apiRequest;
    }

    public void getMerchantName(Callback<String> callback) {
        ApiRequest merchantNameApi = this.getMerchantNameApiRequest(super.getVanity());
        this.executor.executeStringApi(this, merchantNameApi, callback);
    }

    private ApiRequest getMerchantNameApiRequest(String vanity) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.PG_GET_MERCHANT_NAME).pathParams(vanity).build();
        return apiRequest;
    }
}

