/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.text.TextUtils;
import android.util.Log;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentOption;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class PaymentOptionAdapter
implements JsonDeserializer<PaymentOption> {
    private static final String TAG = PaymentOptionAdapter.class.getSimpleName();

    public PaymentOption deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Log.i((String)TAG, (String)(TAG + ".deserialize(): " + jsonElement + ", typeOfT = " + typeOfT));
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement typeJsonElement = jsonObject.get("type");
        if (typeJsonElement == null) {
            typeJsonElement = jsonObject.get("paymentMode");
        }
        String type = typeJsonElement.getAsString();
        Log.i((String)TAG, (String)(TAG + ".deserialize(): type = " + type));
        Gson gson = new Gson();
        PaymentOption paymentOptionReturn = null;
        if (TextUtils.equals((CharSequence)"credit", (CharSequence)type) || TextUtils.equals((CharSequence)"CREDIT_CARD", (CharSequence)type)) {
            CreditCardOption creditCardOption;
            paymentOptionReturn = creditCardOption = (CreditCardOption)gson.fromJson((JsonElement)jsonObject, CreditCardOption.class);
        } else if (TextUtils.equals((CharSequence)"debit", (CharSequence)type) || TextUtils.equals((CharSequence)"DEBIT_CARD", (CharSequence)type)) {
            DebitCardOption debitCardOption = (DebitCardOption)gson.fromJson((JsonElement)jsonObject, DebitCardOption.class);
            paymentOptionReturn = debitCardOption;
        } else if (TextUtils.equals((CharSequence)"netbanking", (CharSequence)type) || TextUtils.equals((CharSequence)"NET_BANKING", (CharSequence)type)) {
            NetbankingOption netbankingOption = (NetbankingOption)gson.fromJson((JsonElement)jsonObject, NetbankingOption.class);
            paymentOptionReturn = netbankingOption;
        } else if (TextUtils.equals((CharSequence)"MVC", (CharSequence)type)) {
            MVCOption mvcOption = (MVCOption)gson.fromJson((JsonElement)jsonObject, MVCOption.class);
            paymentOptionReturn = mvcOption;
        } else if (TextUtils.equals((CharSequence)"PREPAID_CARD", (CharSequence)type)) {
            CitrusCash citrusCash = (CitrusCash)gson.fromJson((JsonElement)jsonObject, CitrusCash.class);
            paymentOptionReturn = citrusCash;
        }
        return paymentOptionReturn;
    }
}

