/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequest;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.BillingClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import org.json.JSONObject;

public class DynamicPricingPgClient
extends BaseClient {
    private static DynamicPricingPgClient instance = null;
    final ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicPricingPgClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<DynamicPricingPgClient> clazz = DynamicPricingPgClient.class;
        synchronized (DynamicPricingPgClient.class) {
            if (instance != null) return instance;
            instance = new DynamicPricingPgClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private DynamicPricingPgClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(this.mContext);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getDynamicPricingBaseUrl();
    }

    public synchronized void performDynamicPricing(BillingClient billingApi, final @NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String billUrl, final @NonNull Callback<DynamicPricingResponse> callback) {
        if (this.validate()) {
            if (billingApi != null && dynamicPricingRequestType != null && !TextUtils.isEmpty((CharSequence)billUrl)) {
                Amount originalAmount = dynamicPricingRequestType.getOriginalAmount();
                String format = "#.00";
                String url = Utils.getUrlFormatted(billUrl, originalAmount, "#.00", dynamicPricingRequestType);
                billingApi.getBill(url, originalAmount, "#.00", new Callback<PaymentBill>(){

                    @Override
                    public void success(PaymentBill paymentBill) {
                        DynamicPricingPgClient.this.performDynamicPricing(dynamicPricingRequestType, paymentBill, callback);
                    }

                    @Override
                    public void error(CitrusError error) {
                        DynamicPricingPgClient.this.sendError(callback, error);
                    }
                });
            }
        } else {
            this.sendError(callback, new CitrusError("DynamicPriceRequestType, Bill Url or PaymentBill should not be null", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, final @NonNull PaymentBill paymentBill, final @NonNull Callback<DynamicPricingResponse> callback) {
        if (this.validate()) {
            if (dynamicPricingRequestType != null && paymentBill != null) {
                final PaymentOption paymentOption = dynamicPricingRequestType.getPaymentOption();
                final CitrusUser citrusUser = dynamicPricingRequestType.getCitrusUser();
                DynamicPricingRequest request = new DynamicPricingRequest(dynamicPricingRequestType, paymentBill);
                String dpPath = this.environment.getDynamicPricingPath();
                ApiRequest dyanamicPricingApi = this.getDynamicPricingApi(dpPath, DynamicPricingRequest.toJSON(request));
                this.executor.executeCustomJsonApi(this, dyanamicPricingApi, new Callback<JSONObject>(){

                    @Override
                    public void success(JSONObject jsonObject) {
                        if (jsonObject != null) {
                            DynamicPricingResponse dynamicPricingResponse = DynamicPricingResponse.fromJSON(jsonObject.toString());
                            dynamicPricingResponse.setPaymentBill(paymentBill);
                            dynamicPricingResponse.setPaymentOption(paymentOption);
                            dynamicPricingResponse.setCitrusUser(citrusUser);
                            DynamicPricingPgClient.this.sendResponse(callback, dynamicPricingResponse);
                        } else {
                            DynamicPricingPgClient.this.sendError(callback, new CitrusError("Unable to apply dynamic pricing", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        DynamicPricingPgClient.this.sendError(callback, error);
                    }
                });
            } else {
                this.sendError(callback, new CitrusError("DynamicPriceRequestType, Bill Url or PaymentBill should not be null", CitrusResponse.Status.FAILED));
            }
        }
    }

    private ApiRequest getDynamicPricingApi(String dpPath, String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest dynamicPricingApi = new ApiRequest.Builder(Api.DYNAMIC_PRICING_PERFORM).requestBody(requestBody).pathParams(dpPath).build();
        return dynamicPricingApi;
    }
}

