/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AllBanksHealth;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.PgClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class CitrusBasePgClient
extends BaseClient {
    private static CitrusBasePgClient instance = null;
    final ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusBasePgClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<PgClient> clazz = PgClient.class;
        synchronized (PgClient.class) {
            if (instance != null) return instance;
            instance = new CitrusBasePgClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private CitrusBasePgClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(this.mContext);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getBaseCitrusUrl();
    }

    public void newMakePayment(String paymentJSON, final Callback<String> callback) {
        ApiRequest makeNewPaymentApi = this.getNewMakePaymentApi(paymentJSON);
        this.executor.executeStringApi(this, makeNewPaymentApi, new Callback<String>(){

            @Override
            public void success(String response) {
                try {
                    String bankHTML = response;
                    if (bankHTML.contains("Access is denied")) {
                        String errorString = "";
                        int end = -1;
                        String[] errorCodes = bankHTML.split("class=\\\"transDetails\\\">(.*)\\s");
                        if (errorCodes != null && errorCodes.length == 2 && (end = errorCodes[1].indexOf("</div>")) != -1) {
                            String input = errorCodes[1];
                            String output = input.substring(0, end);
                            errorString = output.replaceAll("\n", "").replaceAll("\t", "");
                        } else {
                            errorString = "Some Error Occurred";
                        }
                        CitrusBasePgClient.this.sendError(callback, new CitrusError(errorString, CitrusResponse.Status.FAILED));
                    } else {
                        CitrusBasePgClient.this.sendResponse(callback, bankHTML);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CitrusBasePgClient.this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusBasePgClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getNewMakePaymentApi(String jsonBody) {
        RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        ApiRequest newMakePaymentApi = new ApiRequest.Builder(Api.CITRUSBASE_NEW_MAKE_PAYMENT).requestBody(requestBody).build();
        return newMakePaymentApi;
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, Callback<PGHealthResponse> callback) {
        if (!(paymentOption instanceof NetbankingOption)) {
            this.sendResponse(callback, new PGHealthResponse(PGHealth.GOOD, "All Good"));
        } else {
            ApiRequest pgHealthApi = this.getPGHealthApi(super.getVanity(), ((NetbankingOption)paymentOption).getBankCID());
            this.executor.executeCustomObjectApi(this, pgHealthApi, callback);
        }
    }

    private ApiRequest getPGHealthApi(String path, String bankCode) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("bankCode", bankCode);
        ApiRequest pgHealthApi = new ApiRequest.Builder(Api.CITRUSBASE_GET_PG_HEALTH).params(params).pathParams(path).build();
        return pgHealthApi;
    }

    public void fetchPGHealthForAllBanks() {
        ApiRequest pgHealthApi = this.getPGHealthApi(super.getVanity(), "ALLBANKS");
        this.executor.executeCustomJsonApi(this, pgHealthApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    AllBanksHealth allBanksHealth = AllBanksHealth.getInstance();
                    String key = (String)keys.next();
                    String health = jsonObject.optString(key);
                    allBanksHealth.addHealthForBank(key, PGHealth.getPGHealth(health));
                }
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }
}

