/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import org.json.JSONObject;

public class BinServiceClient
extends BaseClient {
    private static BinServiceClient instance = null;
    final ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BinServiceClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<BinServiceClient> clazz = BinServiceClient.class;
        synchronized (BinServiceClient.class) {
            if (instance != null) return instance;
            instance = new BinServiceClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private BinServiceClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(this.mContext);
    }

    @Override
    public String getBaseUrl() {
        return this.environment.getBinServiceURL();
    }

    public synchronized void getCardType(String first6Digits, Callback<CardBinDetails> callback) {
        ApiRequest getCardApi = this.getCardTypeApiRequest(first6Digits);
        this.executor.executeCustomObjectApi(this, getCardApi, callback);
    }

    private ApiRequest getCardTypeApiRequest(String first6Digits) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.BIN_GET_CARD_TYPE).pathParams(first6Digits).build();
        return apiRequest;
    }

    public synchronized void getBinInfo(String first6Digits, final Callback<BinServiceResponse> callback) {
        ApiRequest getCardApi = this.getBinInfoApiRequest(first6Digits);
        this.executor.executeCustomJsonApi(this, getCardApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                if (jsonObject != null) {
                    String jsonString = jsonObject.toString();
                    BinServiceResponse binServiceResponse = BinServiceResponse.fromJSON(jsonString);
                    BinServiceClient.this.sendResponse(callback, binServiceResponse);
                } else {
                    BinServiceClient.this.sendError(callback, new CitrusError("Unable to get bin service response", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                BinServiceClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getBinInfoApiRequest(String first6Digits) {
        ApiRequest apiRequest = new ApiRequest.Builder(Api.BIN_GET_INFO).pathParams(first6Digits).build();
        return apiRequest;
    }
}

