/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.BaseClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import org.json.JSONObject;

public class BillingClient
extends BaseClient {
    private static BillingClient instance = null;
    final ApiExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BillingClient getInstance(Context context, Environment environment) {
        if (instance != null) return instance;
        Class<BillingClient> clazz = BillingClient.class;
        synchronized (BillingClient.class) {
            if (instance != null) return instance;
            instance = new BillingClient(context, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private BillingClient(Context context, Environment environment) {
        super(context, environment);
        this.executor = ApiExecutor.getInstance(this.mContext);
    }

    @Override
    public String getBaseUrl() {
        return "";
    }

    public void getBill(String billUrl, Amount amount, String format, final Callback<PaymentBill> callback) {
        ApiRequest billApi = this.getBillApi(billUrl, amount, format);
        this.executor.executeCustomJsonApi(this, billApi, new Callback<JSONObject>(){

            @Override
            public void success(JSONObject jsonObject) {
                if (jsonObject != null) {
                    PaymentBill paymentBill = PaymentBill.fromJSON(jsonObject.toString());
                    BillingClient.this.sendResponse(callback, paymentBill);
                } else {
                    BillingClient.this.sendError(callback, new CitrusError("Invalid bill received from server.", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                BillingClient.this.sendError(callback, error);
            }
        });
    }

    private ApiRequest getBillApi(String billUrl, Amount amount, String format) {
        ApiRequest getBillApi = new ApiRequest.Builder(Api.GET_BILL).build();
        String relativeUrl = Utils.getUrlFormatted(billUrl, amount, format);
        getBillApi.setRelativeUrl(relativeUrl);
        return getBillApi;
    }
}

