/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.NetworkResponse;
import com.android.volley.VolleyError;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.network.TokenUtils;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseClient {
    protected final Context mContext;
    protected final Environment environment;
    protected TokenUtils tokenUtils;

    protected BaseClient(Context context, Environment environment) {
        this.mContext = context;
        this.environment = environment;
        this.tokenUtils = TokenUtils.getInstance(this.mContext);
    }

    protected boolean validate() {
        return this.tokenUtils.validate();
    }

    public abstract String getBaseUrl();

    public <T> void sendResponse(Callback callback, T t) {
        if (callback != null) {
            callback.success(t);
        }
    }

    public <T> void sendError(Callback callback, VolleyError volleyError) {
        if (callback != null) {
            CitrusError citrusError;
            NetworkResponse networkResponse = volleyError.networkResponse;
            String volleyErrorMessage = volleyError.getMessage();
            if (volleyErrorMessage != null) {
                if (networkResponse != null) {
                    int statusCode = networkResponse.statusCode;
                    if (statusCode == 500) {
                        citrusError = new CitrusError("Internal Server Error Occurred.", CitrusResponse.Status.FAILED);
                    } else {
                        String message = null;
                        try {
                            message = new String(networkResponse.data);
                            JSONObject jsonObject = new JSONObject(message);
                            String errorMessage = null;
                            errorMessage = !TextUtils.isEmpty((CharSequence)jsonObject.optString("error_description")) ? jsonObject.optString("error_description") : (!TextUtils.isEmpty((CharSequence)jsonObject.optString("errorMessage")) ? jsonObject.optString("errorMessage") : volleyErrorMessage);
                            citrusError = new CitrusError(errorMessage, CitrusResponse.Status.FAILED);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            citrusError = new CitrusError(volleyErrorMessage, CitrusResponse.Status.FAILED);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            citrusError = new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
                        }
                    }
                    citrusError.setStatusCode(statusCode);
                } else {
                    citrusError = volleyError.getCause() != null ? new CitrusError(volleyError.getCause().getMessage(), CitrusResponse.Status.FAILED) : new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
                }
            } else {
                citrusError = new CitrusError("OOPS! Something Went Wrong!", CitrusResponse.Status.FAILED);
            }
            this.sendError(callback, citrusError);
        }
    }

    protected void sendError(Callback callback, Throwable t) {
        if (callback != null) {
            this.sendError(callback, new CitrusError(t.getMessage(), CitrusResponse.Status.FAILED));
        }
    }

    protected void sendError(Callback callback, CitrusError citrusError) {
        if (callback != null) {
            callback.error(citrusError);
        }
    }

    protected void setVanity(String vanity) {
        this.tokenUtils.setVanity(vanity);
    }

    protected String getVanity() {
        return this.tokenUtils.getVanity();
    }
}

