/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;
import java.util.Map;

public abstract class DynamicPricingRequestType {
    protected Amount originalAmount;
    protected PaymentOption paymentOption;
    protected CitrusUser citrusUser;
    protected Map<String, String> extraParameters;

    public DynamicPricingRequestType(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser) throws IllegalArgumentException {
        this(originalAmount, paymentOption, citrusUser, null);
    }

    public DynamicPricingRequestType(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser, Map<String, String> extraParameters) throws IllegalArgumentException {
        this.originalAmount = originalAmount;
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
        this.extraParameters = extraParameters;
        if (originalAmount == null) {
            throw new IllegalArgumentException("originalAmount should not be null");
        }
        if (paymentOption == null) {
            throw new IllegalArgumentException("paymentOption should not be null");
        }
    }

    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public PaymentOption getPaymentOption() {
        return this.paymentOption;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public abstract String getDPOperationName();

    public static class ValidateRule
    extends DynamicPricingRequestType {
        private String ruleName;
        private Amount alteredAmount;

        public ValidateRule(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, @NonNull String ruleName, @NonNull Amount alteredAmount, CitrusUser citrusUser) throws IllegalArgumentException {
            this(originalAmount, paymentOption, ruleName, alteredAmount, citrusUser, null);
        }

        public ValidateRule(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, @NonNull String ruleName, @NonNull Amount alteredAmount, CitrusUser citrusUser, Map<String, String> extraParameters) throws IllegalArgumentException {
            super(originalAmount, paymentOption, citrusUser, extraParameters);
            this.ruleName = ruleName;
            this.alteredAmount = alteredAmount;
            if (TextUtils.isEmpty((CharSequence)ruleName)) {
                throw new IllegalArgumentException("ruleName should not be null.");
            }
            if (alteredAmount == null) {
                throw new IllegalArgumentException("alteredAmount should not be null.");
            }
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public Amount getAlteredAmount() {
            return this.alteredAmount;
        }

        @Override
        public String getDPOperationName() {
            return "validateRule";
        }
    }

    public static class CalculatePrice
    extends DynamicPricingRequestType {
        private String ruleName;

        public CalculatePrice(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, @NonNull String ruleName, CitrusUser citrusUser) throws IllegalArgumentException {
            this(originalAmount, paymentOption, ruleName, citrusUser, null);
        }

        public CalculatePrice(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, @NonNull String ruleName, CitrusUser citrusUser, Map<String, String> extraParameters) throws IllegalArgumentException {
            super(originalAmount, paymentOption, citrusUser, extraParameters);
            this.ruleName = ruleName;
            if (TextUtils.isEmpty((CharSequence)ruleName)) {
                throw new IllegalArgumentException("ruleName should not be null.");
            }
        }

        public String getRuleName() {
            return this.ruleName;
        }

        @Override
        public String getDPOperationName() {
            return "calculatePricing";
        }
    }

    public static class SearchAndApplyRule
    extends DynamicPricingRequestType {
        public SearchAndApplyRule(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser) throws IllegalArgumentException {
            this(originalAmount, paymentOption, citrusUser, null);
        }

        public SearchAndApplyRule(@NonNull Amount originalAmount, @NonNull PaymentOption paymentOption, CitrusUser citrusUser, Map<String, String> extraParameters) throws IllegalArgumentException {
            super(originalAmount, paymentOption, citrusUser, extraParameters);
        }

        @Override
        public String getDPOperationName() {
            return "searchAndApply";
        }
    }
}

