/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.WebView;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.response.PaymentResponse;
import com.orhanobut.logger.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Utils {
    private static final String VALIDATE_MOBILE_NUMBER_REGEX = "[789][0-9]{9}?";

    public static boolean hasAnyPrefix(String number, String ... prefixes) {
        if (number == null) {
            return false;
        }
        number = number.replaceAll("\\s+", "");
        for (String prefix : prefixes) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String getUrlFormatted(String billUrl, Amount amount, String format) {
        return Utils.getUrlFormatted(billUrl, amount, format, null);
    }

    public static String getUrlFormatted(String billUrl, Amount amount) {
        return Utils.getUrlFormatted(billUrl, amount, null, null);
    }

    public static String getUrlFormatted(String billUrl, Amount amount, String format, DynamicPricingRequestType dynamicPricingRequestType) {
        StringBuffer buffer = new StringBuffer();
        String urlFormat = "%s%s%s";
        String amountValue = format != null ? amount.getValueAsFormattedDouble(format) : String.valueOf(amount.getValueAsDouble());
        if (billUrl.contains("?")) {
            buffer.append(String.format(urlFormat, billUrl, "&amount=", amountValue));
        } else {
            buffer.append(String.format(urlFormat, billUrl, "?amount=", amountValue));
        }
        if (dynamicPricingRequestType != null) {
            String dpOperation = "&dpOperation=" + dynamicPricingRequestType.getDPOperationName();
            if (dynamicPricingRequestType instanceof DynamicPricingRequestType.SearchAndApplyRule) {
                buffer.append(dpOperation);
            } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.CalculatePrice) {
                String ruleName = "&ruleName=" + ((DynamicPricingRequestType.CalculatePrice)dynamicPricingRequestType).getRuleName();
                buffer.append(dpOperation);
                buffer.append(ruleName);
            } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.ValidateRule) {
                String ruleName = "&ruleName=" + ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getRuleName();
                Amount alteredAmount = ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getAlteredAmount();
                String alteredAmountValue = "&alteredAmount=" + alteredAmount.getValueAsFormattedDouble(format);
                buffer.append(dpOperation);
                buffer.append(ruleName);
                buffer.append(alteredAmountValue);
            }
        }
        return buffer.toString();
    }

    public static boolean isNetworkConnected(Context context) {
        boolean connected = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        connected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        cm = null;
        return connected;
    }

    public static String removeSpecialCharacters(String input) {
        String str = null;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            str = input.replaceAll("[^\\w\\s-]", "").replaceAll("[-_]", "");
        }
        return str;
    }

    public static void sendResponseToReturnUrlAsync(Context context, String returnUrl, PaymentResponse paymentResponse) {
        String urlEncodedParams = paymentResponse != null ? paymentResponse.getURLEncodedParams() : "";
        Utils.sendResponseToReturnUrlAsync(context, returnUrl, urlEncodedParams);
    }

    public static void sendResponseToReturnUrlAsync(Context context, String returnUrl, String urlEncodedParams) {
        WebView webView = new WebView(context);
        webView.getSettings().setJavaScriptEnabled(true);
        byte[] data = urlEncodedParams != null ? urlEncodedParams.getBytes() : null;
        webView.postUrl(returnUrl, data);
    }

    public static boolean isTokenValid(String expiryDateStr) {
        boolean valid = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date currentDate = new Date(System.currentTimeMillis());
        try {
            Date expiryDate = dateFormat.parse(expiryDateStr);
            Logger.d((String)"Expiry date : %s, Current Date : %s", (Object[])new Object[]{expiryDate, currentDate});
            if (currentDate.before(expiryDate)) {
                valid = true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            valid = true;
        }
        return valid;
    }

    public static long isValidMobileNumber(String mobileNumber) {
        if (mobileNumber.length() < 10) {
            return -1L;
        }
        mobileNumber = mobileNumber.replaceAll("-", "");
        mobileNumber = mobileNumber.replaceAll("\\(", "");
        mobileNumber = mobileNumber.replaceAll("\\)", "");
        mobileNumber = mobileNumber.replaceAll("\\s+", "");
        String startOne = "^0091.*";
        String startTwo = "^\\+91.*";
        String startThree = "^91.*";
        String startFour = "^0.*";
        String startFive = "^[7-9][0-9]{9}$";
        if (mobileNumber.matches(startFive) && mobileNumber.length() == 10) {
            return Long.parseLong(mobileNumber);
        }
        if (mobileNumber.matches(startOne)) {
            mobileNumber = mobileNumber.substring(4);
        } else if (mobileNumber.matches(startTwo)) {
            mobileNumber = mobileNumber.substring(3);
        } else if (mobileNumber.matches(startThree)) {
            mobileNumber = mobileNumber.substring(2);
        } else if (mobileNumber.matches(startFour)) {
            mobileNumber = mobileNumber.substring(1);
        }
        if (mobileNumber.length() < 10) {
            return -1L;
        }
        if (mobileNumber.matches(startFive)) {
            return Long.parseLong(mobileNumber);
        }
        return -1L;
    }

    public static String getOTP(String message, NetBankForOTP netBankForOTP) {
        String otp = "";
        int length = netBankForOTP.getOTPLength();
        String[] nbs = message.split("\\D+");
        if (nbs.length != 0) {
            for (String number : nbs) {
                if (number.length() != length) continue;
                return number;
            }
        }
        return otp;
    }

    public static String getURLEncodedParamsForCancelTransaction(CitrusUser citrusUser, PaymentBill paymentBill, PaymentOption paymentOption, DynamicPricingResponse dynamicPricingResponse, String vanity) {
        CitrusUser.Address address = citrusUser != null ? citrusUser.getAddress() : null;
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("vanityUrl=");
            if (!TextUtils.isEmpty((CharSequence)vanity)) {
                buffer.append(vanity);
            }
            buffer.append("&firstName=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getFirstName())) {
                buffer.append(URLEncoder.encode(citrusUser.getFirstName(), "utf-8"));
            }
            buffer.append("&lastName=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getLastName())) {
                buffer.append(URLEncoder.encode(citrusUser.getLastName(), "utf-8"));
            }
            buffer.append("&email=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getEmailId())) {
                buffer.append(URLEncoder.encode(citrusUser.getEmailId(), "utf-8"));
            }
            buffer.append("&phoneNumber=");
            if (citrusUser != null && !TextUtils.isEmpty((CharSequence)citrusUser.getMobileNo())) {
                buffer.append(URLEncoder.encode(citrusUser.getMobileNo(), "utf-8"));
            }
            buffer.append("&addressCountry=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getCountry())) {
                buffer.append(URLEncoder.encode(address.getCountry(), "utf-8"));
            }
            buffer.append("&addressState=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getState())) {
                buffer.append(URLEncoder.encode(address.getState(), "utf-8"));
            }
            buffer.append("&addressCity=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getCity())) {
                buffer.append(URLEncoder.encode(address.getCity(), "utf-8"));
            }
            buffer.append("&addressStreet1=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getStreet1())) {
                buffer.append(URLEncoder.encode(address.getStreet1(), "utf-8"));
            }
            buffer.append("&addressStreet2=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getStreet2())) {
                buffer.append(URLEncoder.encode(address.getStreet2(), "utf-8"));
            }
            buffer.append("&addressZip=");
            if (address != null && !TextUtils.isEmpty((CharSequence)address.getZip())) {
                buffer.append(URLEncoder.encode(address.getZip(), "utf-8"));
            }
            if (paymentOption != null) {
                if (paymentOption instanceof CardOption) {
                    CardOption cardOption = (CardOption)paymentOption;
                    buffer.append("&paymentMode=");
                    buffer.append(URLEncoder.encode(cardOption instanceof CreditCardOption ? "CREDIT_CARD" : "DEBIT_CARD", "utf-8"));
                    buffer.append("&cardNumber=");
                    if (!TextUtils.isEmpty((CharSequence)cardOption.getCardNumber())) {
                        buffer.append(URLEncoder.encode(cardOption.getCardNumber(), "utf-8"));
                    }
                    buffer.append("&cvvNumber=");
                    if (!TextUtils.isEmpty((CharSequence)cardOption.getCardCVV())) {
                        buffer.append(URLEncoder.encode(cardOption.getCardCVV(), "utf-8"));
                    }
                    buffer.append("&expiryMonth=");
                    if (!TextUtils.isEmpty((CharSequence)cardOption.getCardExpiryMonth())) {
                        buffer.append(URLEncoder.encode(cardOption.getCardExpiryMonth(), "utf-8"));
                    }
                    buffer.append("&expiryYear=");
                    if (!TextUtils.isEmpty((CharSequence)cardOption.getCardExpiryYear())) {
                        buffer.append(URLEncoder.encode(cardOption.getCardExpiryYear(), "utf-8"));
                    }
                    buffer.append("&cardType=");
                    if (cardOption.getCardScheme() != null) {
                        buffer.append(URLEncoder.encode(cardOption.getCardScheme().getName(), "utf-8"));
                    }
                } else if (paymentOption instanceof NetbankingOption) {
                    buffer.append("&paymentMode=");
                    buffer.append(URLEncoder.encode("NET_BANKING", "utf-8"));
                }
            }
            if (paymentBill != null) {
                Map<String, String> customParametersMap;
                Amount amount;
                buffer.append("&returnUrl=");
                if (!TextUtils.isEmpty((CharSequence)paymentBill.getReturnUrl())) {
                    buffer.append(URLEncoder.encode(paymentBill.getReturnUrl(), "utf-8"));
                }
                buffer.append("&notifyUrl=");
                if (!TextUtils.isEmpty((CharSequence)paymentBill.getNotifyUrl())) {
                    buffer.append(URLEncoder.encode(paymentBill.getNotifyUrl(), "utf-8"));
                }
                if ((amount = paymentBill.getAmount()) != null) {
                    buffer.append("&orderAmount=");
                    buffer.append(URLEncoder.encode(amount.getValue(), "utf-8"));
                    buffer.append("&currency=");
                    buffer.append(URLEncoder.encode(amount.getCurrency(), "utf-8"));
                }
                buffer.append("&secSignature=");
                if (!TextUtils.isEmpty((CharSequence)paymentBill.getRequestSignature())) {
                    buffer.append(URLEncoder.encode(paymentBill.getRequestSignature(), "utf-8"));
                }
                buffer.append("&merchantTxnId=");
                if (!TextUtils.isEmpty((CharSequence)paymentBill.getMerchantTransactionId())) {
                    buffer.append(URLEncoder.encode(paymentBill.getMerchantTransactionId(), "utf-8"));
                }
                buffer.append("&merchantAccessKey=");
                if (!TextUtils.isEmpty((CharSequence)paymentBill.getMerchantAccessKey())) {
                    buffer.append(URLEncoder.encode(paymentBill.getMerchantAccessKey(), "utf-8"));
                }
                buffer.append("&dpSignature=");
                if (TextUtils.isEmpty((CharSequence)paymentBill.getDpSignature())) {
                    buffer.append(URLEncoder.encode(paymentBill.getDpSignature(), "utf-8"));
                }
                if ((customParametersMap = paymentBill.getCustomParametersMap()) != null) {
                    Set<String> keys = customParametersMap.keySet();
                    int count = 0;
                    for (String key : keys) {
                        buffer.append("&");
                        buffer.append(URLEncoder.encode(String.format("customParams[%d].name", count), "utf-8"));
                        buffer.append(String.format("=%s", URLEncoder.encode(key, "utf-8")));
                        buffer.append("&");
                        buffer.append(URLEncoder.encode(String.format("customParams[%d].value", count), "utf-8"));
                        buffer.append(String.format("=%s", URLEncoder.encode(customParametersMap.get(key), "utf-8")));
                        ++count;
                    }
                }
            }
            if (dynamicPricingResponse != null) {
                buffer.append("&alteredAmount=");
                if (dynamicPricingResponse.getAlteredAmount() != null) {
                    buffer.append(URLEncoder.encode(dynamicPricingResponse.getAlteredAmount().getValue(), "utf-8"));
                }
            }
            buffer.append("&isEMI=");
            buffer.append("&pgCode=");
            buffer.append("&dpFlag=");
            buffer.append("&errorMessage=");
            buffer.append("&retryCount=0");
            buffer.append("&paymentModeType=Editable");
            buffer.append("&couponCode=");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static boolean isValidEmail(CharSequence target) {
        int emailLength = target.length();
        return emailLength <= 0 || !TextUtils.isEmpty((CharSequence)target) && Patterns.EMAIL_ADDRESS.matcher(target).matches();
    }

    public static boolean isValidMobile(String phone) {
        if (phone.length() > 0) {
            Pattern pattern = Pattern.compile(VALIDATE_MOBILE_NUMBER_REGEX);
            Matcher matcher = pattern.matcher(phone);
            return matcher.matches();
        }
        return true;
    }

    public static boolean hasYearPassed(int year) {
        Calendar now;
        int normalized = Utils.normalizeYear(year);
        return normalized < (now = Calendar.getInstance()).get(1);
    }

    public static boolean hasMonthPassed(int year, int month) {
        Calendar now = Calendar.getInstance();
        return Utils.hasYearPassed(year) || Utils.normalizeYear(year) == now.get(1) && month < now.get(2) + 1;
    }

    private static int normalizeYear(int year) {
        if (year < 100 && year >= 0) {
            Calendar now = Calendar.getInstance();
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }

    public static String getMaskedCardNumber(String cardNumber) {
        StringBuilder stringBuilder = new StringBuilder("XXXX-");
        stringBuilder.append(cardNumber.subSequence(cardNumber.length() - 4, cardNumber.length()));
        return stringBuilder.toString();
    }
}

