/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;

public class UpdateSubscriptionRequest {
    String subscriptionId;
    String loadAmount;
    String thresholdAmount;
    Amount loadAmt;
    Amount thresholdAmt;
    String authRefId;

    public void setAuthRefId(String authRefId) {
        this.authRefId = authRefId;
    }

    public String getAuthRefId() {
        return this.authRefId;
    }

    public UpdateSubscriptionRequest(String subscriptionId, Amount loadAmt, Amount thresholdAmt) throws CitrusException {
        this.subscriptionId = subscriptionId;
        this.loadAmt = loadAmt;
        this.thresholdAmt = thresholdAmt;
        try {
            Double.parseDouble(loadAmt.getValue());
            this.loadAmount = loadAmt.getValue();
        }
        catch (NumberFormatException e) {
            throw new CitrusException("LoadAmount is not valid");
        }
        try {
            Double.parseDouble(thresholdAmt.getValue());
            this.thresholdAmount = thresholdAmt.getValue();
        }
        catch (NumberFormatException e) {
            throw new CitrusException("ThresholdAmount is not valid");
        }
    }

    public UpdateSubscriptionRequest(String subscriptionId, String loadAmount, String thresholdAmount) throws CitrusException {
        this.subscriptionId = subscriptionId;
        this.loadAmount = loadAmount;
        this.thresholdAmount = thresholdAmount;
        try {
            Double.parseDouble(loadAmount);
        }
        catch (NumberFormatException e) {
            throw new CitrusException("LoadAmount is not valid");
        }
        try {
            Double.parseDouble(thresholdAmount);
        }
        catch (NumberFormatException e) {
            throw new CitrusException("ThresholdAmount is not valid");
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getLoadAmount() {
        return this.loadAmount;
    }

    public String getThresholdAmount() {
        return this.thresholdAmount;
    }
}

