/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.text.TextUtils;
import com.citrus.sdk.classes.LinkUserSignInType;
import com.google.gson.Gson;
import com.orhanobut.logger.Logger;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class LinkUserExtendedResponse {
    private static String replaceStr = "####";
    private String linkUserMessage = null;
    private String responseCode = null;
    private String linkUserEmail = null;
    private String linkUserMobile = null;
    private int emailVerified = -1;
    private int emailVerifiedDate = -1;
    private int mobileVerified = -1;
    private int mobileVerifiedDate = -1;
    private String linkUserFirstName = null;
    private String linkUserLastName = null;
    private String linkUserUUID = null;
    private String requestedMobile = null;
    private static final String MESSAGE_LOGIN_MOTP_PASSWORD = "Please Sign in with OTP sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD = "Please Sign in with Verification Code sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_EOTP_PASSWORD = "Please Sign in with OTP sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MOTP = "Please Sign in with OTP sent on " + replaceStr;
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE = "Please Sign in with Verification Code sent on " + replaceStr;
    private static final String MESSAGE_LOGIN_EOTP = "Please Sign in with OTP sent on " + replaceStr;
    private static final String MESSAGE_SOME_ERROR_OCCURRED = "Some Error Occurred";
    private String inputEmail = null;
    private String inputMobile = null;

    public LinkUserExtendedResponse(String responseCode, String responseMessage, JSONObject responseData) {
        this.responseCode = responseCode;
        this.linkUserMessage = responseMessage;
        this.parseResponseData(responseData);
    }

    private void parseResponseData(JSONObject responseData) {
        try {
            this.linkUserEmail = responseData.getString("email");
            if (!responseData.isNull("emailVerified")) {
                this.emailVerified = responseData.getInt("emailVerified");
            }
            if (!responseData.isNull("emailVerifiedDate")) {
                this.emailVerifiedDate = responseData.getInt("emailVerifiedDate");
            }
            if (!responseData.isNull("mobile")) {
                this.linkUserMobile = responseData.getString("mobile");
            }
            if (!responseData.isNull("mobileVerified")) {
                this.mobileVerified = responseData.getInt("mobileVerified");
            }
            if (!responseData.isNull("mobileVerifiedDate")) {
                this.mobileVerifiedDate = responseData.getInt("mobileVerifiedDate");
            }
            this.linkUserFirstName = responseData.getString("firstName");
            this.linkUserLastName = responseData.getString("lastName");
            this.linkUserUUID = responseData.getString("uuid");
            if (!responseData.isNull("requestedMobile") && responseData.has("requestedMobile")) {
                this.requestedMobile = responseData.getString("requestedMobile");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Logger.d((String)("Link User = " + this.toString()), (Object[])new Object[0]);
    }

    public static LinkUserExtendedResponse fromJSON(String jsonString) {
        LinkUserExtendedResponse linkUserExtendedResponse = null;
        if (!TextUtils.isEmpty((CharSequence)jsonString)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                JSONObject responseData = jsonObject.optJSONObject("responseData");
                String responseCode = jsonObject.optString("responseCode");
                String responseMessage = jsonObject.optString("responseMessage");
                linkUserExtendedResponse = new LinkUserExtendedResponse(responseCode, responseMessage, responseData);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return linkUserExtendedResponse;
    }

    public LinkUserSignInType getLinkUserSignInType() {
        LinkUserSignInType linkUserSignInType;
        if ("R-211-01".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
            this.linkUserMessage = MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-02".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MOTP.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-03".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-04".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-05".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-06".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtpOrPassword;
            this.linkUserMessage = MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-07".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MOTP.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-08".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeEOtpOrPassword;
            this.linkUserMessage = MESSAGE_LOGIN_EOTP_PASSWORD.replace(replaceStr, this.linkUserEmail);
        } else if ("R-211-09".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeEOtp;
            this.linkUserMessage = MESSAGE_LOGIN_EOTP.replace(replaceStr, this.linkUserEmail);
        } else if ("R-211-10".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-11".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, this.linkUserMobile);
        } else if ("R-211-12".equals(this.responseCode)) {
            linkUserSignInType = LinkUserSignInType.SignInTypeMOtp;
            this.linkUserMessage = MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, this.linkUserMobile);
        } else {
            linkUserSignInType = LinkUserSignInType.None;
            this.linkUserMessage = MESSAGE_SOME_ERROR_OCCURRED;
        }
        Logger.v((String)("Link User Sign in Type = " + linkUserSignInType.toString()), (Object[])new Object[0]);
        return linkUserSignInType;
    }

    public JSONObject getJSON() {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this);
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public int formatResponseCode() {
        Object[] responseCodeArray = this.responseCode.split("-");
        Logger.v((String)"array", (Object[])new Object[]{Arrays.toString(responseCodeArray)});
        Object code = responseCodeArray[2];
        return Integer.parseInt((String)code);
    }

    public String getLinkUserMessage() {
        return this.linkUserMessage;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getLinkUserUUID() {
        return this.linkUserUUID;
    }

    public String getRequestedMobile() {
        return this.requestedMobile;
    }

    public String getLinkUserEmail() {
        return this.linkUserEmail;
    }

    public String getLinkUserMobile() {
        return this.linkUserMobile;
    }

    public String getInputEmail() {
        return this.inputEmail;
    }

    public String getInputMobile() {
        return this.inputMobile;
    }

    public void setInputEmail(String inputEmail) {
        this.inputEmail = inputEmail;
    }

    public void setInputMobile(String inputMobile) {
        this.inputMobile = inputMobile;
    }

    public String toString() {
        return "Link User Extended Response{responseCode='" + this.responseCode + '\'' + ", linkUserEmail='" + this.linkUserEmail + '\'' + ", emailVerified='" + this.emailVerified + '\'' + ", emailVerifiedDate='" + this.emailVerifiedDate + '\'' + ", mobile='" + this.linkUserMobile + '\'' + ", mobileVerified='" + this.mobileVerified + '\'' + ", mobileVerifiedDate='" + this.mobileVerifiedDate + '\'' + ", linkUserFirstName='" + this.linkUserFirstName + '\'' + ", linkUserLastName='" + this.linkUserLastName + '\'' + ", linkUserUUID='" + this.linkUserUUID + '\'' + ", requestedMobile='" + this.requestedMobile + '\'' + '}';
    }
}

