/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.LinkUserSignInType;
import com.google.gson.Gson;
import com.orhanobut.logger.Logger;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class LinkBindUserResponse {
    private AccessToken limitedScopeToken = null;
    private CitrusUser citrusUser = null;
    private String responseCode = null;
    private String responseMessage = null;
    private LinkUserSignInType linkUserSignInType = null;
    private static String replaceStr = "####";
    private static final String MESSAGE_LOGIN_MOTP_PASSWORD = "Please Sign in with OTP sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD = "Please Sign in with Verification Code sent on " + replaceStr + " or by using your Citrus Password";
    private static final String MESSAGE_LOGIN_MOTP = "Please Sign in with OTP sent on " + replaceStr;
    private static final String MESSAGE_LOGIN_MVERIFICATION_CODE = "Please Sign in with Verification Code sent on " + replaceStr;
    private static final String MESSAGE_SIGNED_IN_LIMITED_SCOPE = "User signed in with limited scope token";
    private static final String MESSAGE_SOME_ERROR_OCCURRED = "Some Error Occurred";
    private String inputEmail = null;
    private String inputMobile = null;

    private LinkBindUserResponse(String responseCode, String responseMessage, AccessToken limitedScopeToken, CitrusUser citrusUser, LinkUserSignInType signInType) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.limitedScopeToken = limitedScopeToken;
        this.citrusUser = citrusUser;
        this.linkUserSignInType = signInType;
    }

    public static LinkBindUserResponse fromJSON(String json) {
        LinkBindUserResponse linkBindUserResponse = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                JSONObject responseDataObject = jsonObject.getJSONObject("responseData");
                JSONObject limitedAccessTokenObject = responseDataObject.getJSONObject("limitedAccessToken");
                JSONObject profileDataObject = responseDataObject.getJSONObject("profileData");
                Gson gson = new Gson();
                AccessToken limitedAccessToken = (AccessToken)gson.fromJson(limitedAccessTokenObject.toString(), AccessToken.class);
                CitrusUser citrusUser = CitrusUser.fromJSONObject(profileDataObject);
                String responseCode = jsonObject.optString("responseCode");
                String responseMessage = LinkBindUserResponse.getSignInTypeMessage(responseCode, citrusUser.getMobileNo());
                LinkUserSignInType signInType = LinkBindUserResponse.getLinkBindUserSignInType(responseCode);
                linkBindUserResponse = new LinkBindUserResponse(responseCode, responseMessage, limitedAccessToken, citrusUser, signInType);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return linkBindUserResponse;
    }

    public static LinkUserSignInType getLinkBindUserSignInType(String responseCode) {
        LinkUserSignInType linkUserSignInType = "R-222-01".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtp : ("R-222-02".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtpOrPassword : ("R-222-03".equals(responseCode) ? LinkUserSignInType.SignInTypeLimitedScope : ("R-222-04".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtp : ("R-222-05".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtpOrPassword : ("R-222-06".equals(responseCode) ? LinkUserSignInType.SignInTypeLimitedScope : ("R-222-07".equals(responseCode) ? LinkUserSignInType.SignInTypeLimitedScope : ("R-222-08".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtp : ("R-222-09".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtpOrPassword : ("R-222-10".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtp : ("R-222-11".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtp : ("R-222-12".equals(responseCode) ? LinkUserSignInType.SignInTypeMOtpOrPassword : ("R-222-13".equals(responseCode) ? LinkUserSignInType.SignInTypeLimitedScope : LinkUserSignInType.None))))))))))));
        Logger.v((String)("Link Bind User Sign in Type = " + linkUserSignInType.toString()), (Object[])new Object[0]);
        return linkUserSignInType;
    }

    private static String getSignInTypeMessage(String responseCode, String mobileNo) {
        String message = null;
        message = "R-222-01".equals(responseCode) ? MESSAGE_LOGIN_MOTP.replace(replaceStr, mobileNo) : ("R-222-02".equals(responseCode) ? MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, mobileNo) : ("R-222-03".equals(responseCode) ? MESSAGE_SIGNED_IN_LIMITED_SCOPE : ("R-222-04".equals(responseCode) ? MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, mobileNo) : ("R-222-05".equals(responseCode) ? MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD.replace(replaceStr, mobileNo) : ("R-222-06".equals(responseCode) ? MESSAGE_SIGNED_IN_LIMITED_SCOPE : ("R-222-07".equals(responseCode) ? MESSAGE_SIGNED_IN_LIMITED_SCOPE : ("R-222-08".equals(responseCode) ? MESSAGE_LOGIN_MOTP.replace(replaceStr, mobileNo) : ("R-222-09".equals(responseCode) ? MESSAGE_LOGIN_MOTP_PASSWORD.replace(replaceStr, mobileNo) : ("R-222-10".equals(responseCode) ? MESSAGE_SIGNED_IN_LIMITED_SCOPE : ("R-222-11".equals(responseCode) ? MESSAGE_LOGIN_MVERIFICATION_CODE.replace(replaceStr, mobileNo) : ("R-222-12".equals(responseCode) ? MESSAGE_LOGIN_MVERIFICATION_CODE_PASSWORD.replace(replaceStr, mobileNo) : ("R-222-13".equals(responseCode) ? MESSAGE_SIGNED_IN_LIMITED_SCOPE : MESSAGE_SOME_ERROR_OCCURRED))))))))))));
        return message;
    }

    public JSONObject getJSON() {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this);
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public int formatResponseCode() {
        Object[] responseCodeArray = this.responseCode.split("-");
        Logger.v((String)"array", (Object[])new Object[]{Arrays.toString(responseCodeArray)});
        Object code = responseCodeArray[2];
        return Integer.parseInt((String)code);
    }

    public String getUserUUID() {
        return this.citrusUser != null ? this.citrusUser.getUuid() : "";
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public LinkUserSignInType getLinkUserSignInType() {
        return this.linkUserSignInType;
    }

    public String getInputEmail() {
        return this.inputEmail;
    }

    public String getInputMobile() {
        return this.inputMobile;
    }

    public void setInputEmail(String inputEmail) {
        this.inputEmail = inputEmail;
    }

    public void setInputMobile(String inputMobile) {
        this.inputMobile = inputMobile;
    }

    public AccessToken getLimitedScopeToken() {
        return this.limitedScopeToken;
    }
}

