/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import com.citrus.sdk.ConfigChangeListener;
import com.citrus.sdk.LogChangeListener;
import com.citrus.sdk.response.CitrusLogger;

public class CitrusConfig {
    private static CitrusConfig instance = null;
    private ConfigChangeListener configChangeListener = null;
    private LogChangeListener logChangeListener = null;
    private boolean pgHealthEnabled = false;
    private boolean autoReadOTP = false;
    private boolean isBlazeCardEnabled = false;
    private boolean oneTapPaymentEnabled = false;
    private String colorPrimaryDark = "#E7961D";
    private String colorPrimary = "#F9A323";
    private String textColorPrimary = "#ffffff";
    private String accentColor = "";
    private String citrusActivityTitle = null;
    private String doneButtonText = null;

    public boolean isBlazeCardEnabled() {
        return this.isBlazeCardEnabled;
    }

    public void enableOneTapPayment(boolean oneTapEnable) {
        this.oneTapPaymentEnabled = oneTapEnable;
        if (this.configChangeListener != null) {
            this.configChangeListener.onOneTapPaymentEnabled(oneTapEnable);
        }
    }

    private void setLogsEnabled(boolean isLogsEnabled) {
        if (isLogsEnabled) {
            CitrusLogger.enableLogs();
            this.logChangeListener.onLogsEnabled(isLogsEnabled);
        }
    }

    private void enableBlazeCard(boolean blazeCardEnabled) {
        this.isBlazeCardEnabled = blazeCardEnabled;
    }

    public boolean isOneTapPaymentEnabled() {
        return this.oneTapPaymentEnabled;
    }

    private CitrusConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusConfig getInstance() {
        if (instance != null) return instance;
        Class<CitrusConfig> clazz = CitrusConfig.class;
        synchronized (CitrusConfig.class) {
            if (instance != null) return instance;
            instance = new CitrusConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void setColorPrimaryDark(String colorPrimaryDark) {
        this.colorPrimaryDark = colorPrimaryDark;
    }

    public synchronized void setColorPrimary(String colorPrimary) {
        this.colorPrimary = colorPrimary;
    }

    public synchronized void setTextColorPrimary(String textColorPrimary) {
        this.textColorPrimary = textColorPrimary;
    }

    public synchronized void setAccentColor(String accentColor) {
        this.accentColor = accentColor;
    }

    public String getColorPrimaryDark() {
        return this.colorPrimaryDark;
    }

    public String getColorPrimary() {
        return this.colorPrimary;
    }

    public String getTextColorPrimary() {
        return this.textColorPrimary;
    }

    public String getAccentColor() {
        return this.accentColor;
    }

    public String getCitrusActivityTitle() {
        return this.citrusActivityTitle;
    }

    public void setCitrusActivityTitle(String citrusActivityTitle) {
        this.citrusActivityTitle = citrusActivityTitle;
    }

    public String getDoneButtonText() {
        return this.doneButtonText;
    }

    public void setDoneButtonText(String doneButtonText) {
        this.doneButtonText = doneButtonText;
    }

    public void setConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configChangeListener = configChangeListener;
    }

    private void setLogChangeListener(LogChangeListener logChangeListener) {
        this.logChangeListener = logChangeListener;
    }
}

