/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.text.TextUtils;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import org.json.JSONException;
import org.json.JSONObject;

public class BinServiceResponse {
    private CardOption.CardScheme cardScheme = null;
    private NetBankForOTP netBankForOTP = null;
    private String cardType = null;
    private String country = null;

    public String getCardType() {
        return this.cardType;
    }

    public String getCountry() {
        return this.country;
    }

    public BinServiceResponse(CardOption.CardScheme cardScheme, NetBankForOTP netBankForOTP, String country, String cardType) {
        this.cardScheme = cardScheme;
        this.netBankForOTP = netBankForOTP;
        this.country = country;
        this.cardType = cardType;
    }

    public static BinServiceResponse fromJSON(String json) {
        BinServiceResponse response = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                String scheme = jsonObject.optString("cardscheme");
                String cardtype = jsonObject.optString("cardtype");
                CardOption.CardScheme cardScheme = CardOption.CardScheme.getCardScheme(scheme);
                String issuingbank = jsonObject.optString("issuingbank");
                String country = jsonObject.optString("country");
                NetBankForOTP netBankForOTP = NetBankForOTP.getNetBankForOTP(cardtype, issuingbank);
                netBankForOTP.setCardScheme(cardScheme);
                response = new BinServiceResponse(cardScheme, netBankForOTP, country, cardtype);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    public CardOption.CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public NetBankForOTP getNetBankForOTP() {
        return this.netBankForOTP;
    }
}

