/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import java.math.BigDecimal;
import java.util.List;

class WalletPGPayment
extends PaymentType
implements Parcelable {
    private PaymentOption otherPaymentOption = null;
    private CitrusCash mCitrusCashOption = null;
    private MVCOption mMVCOption = null;
    public static final Parcelable.Creator<WalletPGPayment> CREATOR = new Parcelable.Creator<WalletPGPayment>(){

        public WalletPGPayment createFromParcel(Parcel source) {
            return new WalletPGPayment(source);
        }

        public WalletPGPayment[] newArray(int size) {
            return new WalletPGPayment[size];
        }
    };

    protected WalletPGPayment() {
    }

    public WalletPGPayment(Amount amount, String billUrl, List<PaymentOption> paymentOptionList) throws CitrusException {
        super(amount, billUrl, paymentOptionList);
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Amount should be not null or blank.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Amount should be greater than 0");
        }
        if (billUrl == null) {
            throw new CitrusException("billUrl should be not null.");
        }
        if (paymentOptionList == null && paymentOptionList.size() == 0) {
            throw new CitrusException("PaymentOptions List should be not null or empty");
        }
        this.separatePaymentOptions();
    }

    public WalletPGPayment(PaymentType.SplitPayment splitPayment, List<PaymentOption> paymentOptionList) throws CitrusException {
        if (splitPayment.getPaymentBill() != null) {
            this.paymentBill = splitPayment.getPaymentBill();
        } else {
            this.amount = splitPayment.getAmount();
            this.url = splitPayment.getUrl();
        }
        this.paymentOptionList = paymentOptionList;
        if (this.amount == null || TextUtils.isEmpty((CharSequence)this.amount.getValue())) {
            throw new CitrusException("Amount should be not null or blank.");
        }
        if (!(this.amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Amount should be greater than 0");
        }
        if (this.url == null) {
            throw new CitrusException("billUrl should be not null.");
        }
        if (paymentOptionList == null && paymentOptionList.size() == 0) {
            throw new CitrusException("PaymentOptions List should be not null or empty");
        }
        this.separatePaymentOptions();
    }

    public WalletPGPayment(PaymentBill paymentBill, List<PaymentOption> paymentOptionList) throws CitrusException {
        super(paymentBill);
        this.paymentOptionList = paymentOptionList;
        if (paymentBill == null) {
            throw new CitrusException("PaymentBill should not be null.");
        }
        if (paymentOptionList == null && paymentOptionList.size() == 0) {
            throw new CitrusException("PaymentOptions List should be not null or empty");
        }
        this.separatePaymentOptions();
    }

    private void separatePaymentOptions() {
        if (this.paymentOptionList != null) {
            for (PaymentOption paymentOption : this.paymentOptionList) {
                if (paymentOption instanceof NetbankingOption || paymentOption instanceof CardOption) {
                    this.otherPaymentOption = paymentOption;
                    continue;
                }
                if (paymentOption instanceof CitrusCash) {
                    this.mCitrusCashOption = (CitrusCash)paymentOption;
                    continue;
                }
                if (!(paymentOption instanceof MVCOption)) continue;
                this.mMVCOption = (MVCOption)paymentOption;
            }
        }
    }

    public boolean validateTotalTransactionAmount() {
        BigDecimal amount;
        BigDecimal transactionAmount = new BigDecimal(this.amount.getValue());
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (this.otherPaymentOption != null && this.otherPaymentOption.getTransactionAmount() != null) {
            amount = new BigDecimal(this.otherPaymentOption.getTransactionAmount().getValue());
            totalAmount = totalAmount.add(amount);
        }
        if (this.mMVCOption != null && this.mMVCOption.getTransactionAmount() != null) {
            amount = new BigDecimal(this.mMVCOption.getTransactionAmount().getValue());
            totalAmount = totalAmount.add(amount);
        }
        if (this.mCitrusCashOption != null && this.mCitrusCashOption.getTransactionAmount() != null) {
            amount = new BigDecimal(this.mCitrusCashOption.getTransactionAmount().getValue());
            totalAmount = totalAmount.add(amount);
        }
        return transactionAmount.compareTo(totalAmount) == 0;
    }

    public PaymentOption getOtherPaymentOption() {
        return this.otherPaymentOption;
    }

    public CitrusCash getCitrusCashOption() {
        return this.mCitrusCashOption;
    }

    public MVCOption getMVCOption() {
        return this.mMVCOption;
    }

    public boolean isWalletOnlyPayment() {
        return this.otherPaymentOption == null;
    }

    @Override
    public final String getIntentAction() {
        return "ACTION_WALLET_PG_PAYMENT";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.otherPaymentOption, 0);
        dest.writeParcelable((Parcelable)this.mCitrusCashOption, 0);
        dest.writeParcelable((Parcelable)this.mMVCOption, 0);
    }

    protected WalletPGPayment(Parcel in) {
        super(in);
        this.otherPaymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
        this.mCitrusCashOption = (CitrusCash)in.readParcelable(CitrusCash.class.getClassLoader());
        this.mMVCOption = (MVCOption)in.readParcelable(MVCOption.class.getClassLoader());
    }
}

