/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.citrus.mobile.OAuth2GrantType;
import com.citrus.sdk.AddCardResponse;
import com.citrus.sdk.BankCID;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BCCancelResponse;
import com.citrus.sdk.classes.BCResponse;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.classes.UpdateSubscriptionRequest;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.network.BillingClient;
import com.citrus.sdk.network.BinServiceClient;
import com.citrus.sdk.network.CitrusBasePgClient;
import com.citrus.sdk.network.DynamicPricingPgClient;
import com.citrus.sdk.network.PgClient;
import com.citrus.sdk.network.PrepaidClient;
import com.citrus.sdk.network.TokenUtils;
import com.citrus.sdk.network.UmClient;
import com.citrus.sdk.network.WalletPgClient;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.citrus.sdk.walletpg.WalletConsumerProfile;
import com.citrus.sdk.walletpg.WalletPGPaymentResponse;
import com.orhanobut.logger.Logger;
import java.util.List;

public class RetrofitAPIWrapper {
    private static final String TAG = RetrofitAPIWrapper.class.getSimpleName();
    private static RetrofitAPIWrapper instance = null;
    private Context context = null;
    private boolean isPrepaymentTokenValid = false;
    private PgClient volleyPgApi;
    private CitrusBasePgClient citrusBasePgApi;
    private UmClient volleyUmApi;
    private WalletPgClient volleyWalletPgApi;
    private BinServiceClient volleyBinServiceApi;
    private DynamicPricingPgClient volleyDynamicPricingPgApi;
    private BillingClient volleyBillingApi;
    private PrepaidClient volleyPrePaidApi;
    private ApiExecutor volleyApiExecutor;
    private NetBankForOTP netBankForOTP = NetBankForOTP.UNKNOWN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RetrofitAPIWrapper getInstance(Context context) {
        if (instance != null) return instance;
        Class<RetrofitAPIWrapper> clazz = RetrofitAPIWrapper.class;
        synchronized (RetrofitAPIWrapper.class) {
            if (instance != null) return instance;
            instance = new RetrofitAPIWrapper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private RetrofitAPIWrapper(Context context) {
        this.context = context;
    }

    public synchronized void init(String signupId, String signupSecret, String signinId, String signinSecret, String vanity, Environment environment) {
        TokenUtils tokenUtils = TokenUtils.getInstance(this.context);
        tokenUtils.init(signupId, signupSecret, signinId, signinSecret, vanity);
        this.volleyPgApi = PgClient.getInstance(this.context, environment);
        this.citrusBasePgApi = CitrusBasePgClient.getInstance(this.context, environment);
        this.volleyWalletPgApi = WalletPgClient.getInstance(this.context, environment);
        this.volleyUmApi = UmClient.getInstance(this.context, environment);
        this.volleyBinServiceApi = BinServiceClient.getInstance(this.context, environment);
        this.volleyBillingApi = BillingClient.getInstance(this.context, environment);
        this.volleyDynamicPricingPgApi = DynamicPricingPgClient.getInstance(this.context, environment);
        this.volleyPrePaidApi = PrepaidClient.getInstance(this.context, environment);
        this.volleyApiExecutor = ApiExecutor.getInstance(this.context);
    }

    public synchronized void getSignUpToken(Callback<AccessToken> callback) {
        this.volleyUmApi.getSignUpToken(callback);
    }

    public synchronized void createUser(String emailId, String mobileNo, Callback<String> callback) {
        this.volleyUmApi.createUser(emailId, mobileNo, callback);
    }

    public synchronized void getUserNameToken(String userName, Callback<AccessToken> callback) {
        this.volleyUmApi.getUserNameToken(userName, callback);
    }

    public void getUserNameToken(Callback<AccessToken> callback) {
        this.volleyUmApi.getUserNameToken(callback);
    }

    public void getPrepaidToken(Callback<AccessToken> callback) {
        this.volleyUmApi.getPrepaidToken(callback);
    }

    public void getPrepaidPayToken(Callback<AccessToken> callback) {
        this.volleyUmApi.getPrepaidPayToken(callback);
    }

    public synchronized void isCitrusMember(String emailId, String mobileNo, Callback<Boolean> callback) {
        this.volleyUmApi.isCitrusMember(emailId, mobileNo, callback);
    }

    public synchronized void getMemberInfo(String emailId, String mobileNo, Callback<MemberInfo> callback) {
        this.volleyUmApi.getMemberInfo(emailId, mobileNo, callback);
    }

    public synchronized void bindUserByMobile(String emailId, String mobileNo, Callback<BindUserResponse> callback) {
        this.volleyUmApi.bindUserByMobile(emailId, mobileNo, callback);
    }

    @Deprecated
    public synchronized void linkUserWithOTP(String emailId, String mobileNo, boolean forceMobileVerification, Callback<LinkUserResponse> callback) {
        this.volleyUmApi.linkUserWithOTP(emailId, mobileNo, forceMobileVerification, callback);
    }

    public synchronized void linkUserExtended(String emailId, String mobileNo, Callback<LinkUserExtendedResponse> callback) {
        this.volleyUmApi.linkUserExtended(emailId, mobileNo, callback);
    }

    public void linkUserExtendedVerifyEOTPAndUpdateMobile(String emailId, String signInGrantType, String linkUserPassword, LinkUserExtendedResponse linkUserExtended, final Callback<CitrusResponse> callback) {
        this.volleyUmApi.linkUserExtendedVerifyEOTPAndUpdateMobile(emailId, signInGrantType, linkUserPassword, linkUserExtended, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
                RetrofitAPIWrapper.this.isPrepaymentTokenValid = true;
                RetrofitAPIWrapper.this.sendResponse(callback, new CitrusResponse("User Signed In Successfully.", CitrusResponse.Status.SUCCESSFUL));
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public void linkUserExtendedVerifyMobileAndSignIn(LinkUserExtendedResponse linkUserExtendedResponse, String verificationCode, final Callback<CitrusResponse> callback) {
        this.volleyUmApi.linkUserExtendedVerifyMobileAndSignIn(linkUserExtendedResponse, verificationCode, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
                RetrofitAPIWrapper.this.isPrepaymentTokenValid = true;
                RetrofitAPIWrapper.this.sendResponse(callback, new CitrusResponse("User Signed In Successfully.", CitrusResponse.Status.SUCCESSFUL));
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    @Deprecated
    public synchronized void signUp(final String emailId, String mobileNo, final String password, final Callback<CitrusResponse> callback) {
        this.volleyUmApi.signUp(emailId, mobileNo, password, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
                RetrofitAPIWrapper.this.signIn(emailId, password, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    @Deprecated
    public synchronized void signIn(String emailId, String password, Callback<CitrusResponse> callback) {
        this.signIn(emailId, password, OAuth2GrantType.password, callback);
    }

    private synchronized void signIn(String emailId, String password, OAuth2GrantType grantType, final Callback<CitrusResponse> callback) {
        this.volleyUmApi.getUsernameAndPrepaidToken(emailId, password, grantType, new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.activatePrepaidUser(new Callback<Amount>(){

                    @Override
                    public void success(Amount amount) {
                        RetrofitAPIWrapper.this.sendResponse(callback, new CitrusResponse("User Signed In Successfully.", CitrusResponse.Status.SUCCESSFUL));
                        RetrofitAPIWrapper.this.isPrepaymentTokenValid = true;
                    }

                    @Override
                    public void error(CitrusError error) {
                        RetrofitAPIWrapper.this.sendError(callback, error);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void signInWithMobileNo(String mobileNo, String password, Callback<CitrusResponse> callback) {
        this.signIn(mobileNo, password, callback);
    }

    public synchronized void signInWithOTP(String emailIdOrMobileNo, String otp, Callback<CitrusResponse> callback) {
        this.signIn(emailIdOrMobileNo, otp, OAuth2GrantType.onetimepass, callback);
    }

    public synchronized void resetPassword(String emailId, @NonNull Callback<CitrusResponse> callback) {
        this.volleyUmApi.resetPassword(emailId, callback);
    }

    public synchronized void updateMobile(String mobileNo, Callback<String> callback) {
        this.volleyUmApi.updateMobile(mobileNo, callback);
    }

    public synchronized void verifyMobile(String verificationCode, Callback<String> callback) {
        this.volleyUmApi.verifyMobile(verificationCode, callback);
    }

    public synchronized void getProfileInfo(Callback<CitrusUser> callback) {
        this.volleyUmApi.getProfileInfo(callback);
    }

    public synchronized void changePassword(String oldPassword, String newPassword, Callback<CitrusUMResponse> changePasswordResponseCallback) {
        this.volleyUmApi.changePassword(oldPassword, newPassword, changePasswordResponseCallback);
    }

    public synchronized void updateProfileInfo(String firstName, String lastName, Callback<CitrusUMResponse> citrusUMResponseCallback) {
        this.volleyUmApi.updateProfileInfo(firstName, lastName, citrusUMResponseCallback);
    }

    public synchronized void sendOneTimePassword(String source, String otpType, String identity, Callback<CitrusUMResponse> umResponseCallback) {
        this.volleyUmApi.sendOneTimePassword(source, otpType, identity, umResponseCallback);
    }

    public synchronized void resetUserPassword(String emailId, @NonNull Callback<CitrusUMResponse> callback) {
        this.volleyUmApi.resetUserPassword(emailId, callback);
    }

    public synchronized void signUpUser(final String email, String mobile, final String password, String firstName, String lastName, String sourceType, boolean markMobileVerified, boolean markEmailVerified, final Callback<CitrusResponse> callback) {
        this.volleyUmApi.signUpUser(email, mobile, password, firstName, lastName, sourceType, markMobileVerified, markEmailVerified, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
                RetrofitAPIWrapper.this.signIn(email, password, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void signOut(final Callback<CitrusResponse> callback) {
        this.volleyUmApi.signOut(new Callback<Boolean>(){

            @Override
            public void success(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    RetrofitAPIWrapper.this.resetPrepaymentTokenValidity();
                    CitrusResponse citrusResponse = new CitrusResponse("User Logged Out Successfully.", CitrusResponse.Status.SUCCESSFUL);
                    RetrofitAPIWrapper.this.sendResponse(callback, citrusResponse);
                } else {
                    CitrusError citrusError = new CitrusError("Failed to logout.", CitrusResponse.Status.FAILED);
                    callback.error(citrusError);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusError citrusError = new CitrusError("Failed to logout.", CitrusResponse.Status.FAILED);
                callback.error(citrusError);
            }
        });
    }

    public synchronized void resetPrepaymentTokenValidity() {
        this.isPrepaymentTokenValid = false;
    }

    public synchronized void checkPrepaymentTokenValidity(final Callback<Boolean> callback) {
        this.getSignUpToken(new Callback<AccessToken>(){

            @Override
            public void success(final AccessToken signUpToken) {
                RetrofitAPIWrapper.this.getPrepaidToken(new Callback<AccessToken>(){

                    @Override
                    public void success(AccessToken prepaidToken) {
                        if (prepaidToken.hasPrepaidPayToken()) {
                            RetrofitAPIWrapper.this.volleyPrePaidApi.getPrepaymentTokenValidity(signUpToken, prepaidToken, "prepaid_merchant_pay", new Callback<Boolean>(){

                                @Override
                                public void success(Boolean valid) {
                                    RetrofitAPIWrapper.this.isPrepaymentTokenValid = true;
                                    RetrofitAPIWrapper.this.sendResponse(callback, valid);
                                }

                                @Override
                                public void error(CitrusError error) {
                                    RetrofitAPIWrapper.this.isPrepaymentTokenValid = false;
                                    RetrofitAPIWrapper.this.sendError(callback, error);
                                }
                            });
                        } else {
                            RetrofitAPIWrapper.this.isPrepaymentTokenValid = true;
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        RetrofitAPIWrapper.this.sendError(callback, error);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getPrepaidBill(final Amount amount, final String returnUrl, final Callback<CitrusPrepaidBill> callback) {
        this.volleyUmApi.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.getPrepaidBill(accessToken, amount, returnUrl, new Callback<CitrusPrepaidBill>(){

                    @Override
                    public void success(CitrusPrepaidBill citrusPrepaidBill) {
                        RetrofitAPIWrapper.this.sendResponse(callback, citrusPrepaidBill);
                    }

                    @Override
                    public void error(CitrusError error) {
                        RetrofitAPIWrapper.this.sendError(callback, error);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getBalance(final Callback<Amount> callback) {
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.getBalance(accessToken, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void activatePrepaidUser(final Callback<Amount> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.activatePrepaidUser(accessToken, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void newPrepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        if (this.isPrepaymentTokenValid) {
            Amount amountToBePaid = null;
            amountToBePaid = citrusCash.getPaymentBill() != null ? citrusCash.getPaymentBill().getAmount() : citrusCash.getAmount();
            this.isEnoughPrepaidBalance(amountToBePaid, new Callback<Boolean>(){

                @Override
                public void success(Boolean sufficientBalance) {
                    if (sufficientBalance.booleanValue()) {
                        if (citrusCash.getPaymentBill() != null) {
                            RetrofitAPIWrapper.this.proceedToPayUsingCitrusCash(citrusCash, callback);
                        } else {
                            String billUrl = citrusCash.getUrl();
                            RetrofitAPIWrapper.this.getBill(billUrl, citrusCash.getAmount(), null, new Callback<PaymentBill>(){

                                @Override
                                public void success(PaymentBill paymentBill) {
                                    citrusCash.setPaymentBill(paymentBill);
                                    RetrofitAPIWrapper.this.proceedToPayUsingCitrusCash(citrusCash, callback);
                                }

                                @Override
                                public void error(CitrusError error) {
                                    RetrofitAPIWrapper.this.sendError(callback, error);
                                }
                            });
                        }
                    } else {
                        RetrofitAPIWrapper.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    RetrofitAPIWrapper.this.sendError(callback, error);
                }
            });
        } else {
            Logger.d((String)"User's cookie has expired. Please signin", (Object[])new Object[0]);
            this.sendError(callback, new CitrusError("User's cookie has expired. Please signin.", CitrusResponse.Status.FAILED));
        }
    }

    private void proceedToPayUsingCitrusCash(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        this.getPrepaidPayToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken prepaidToken) {
                if (citrusCash.getCitrusUser() == null) {
                    CitrusUser citrusUser = RetrofitAPIWrapper.this.getCitrusUser();
                    citrusCash.setCitrusUser(citrusUser);
                }
                if (prepaidToken.hasPrepaidPayToken()) {
                    RetrofitAPIWrapper.this.volleyPrePaidApi.newPrepaidPay(prepaidToken, citrusCash, new Callback<PaymentResponse>(){

                        @Override
                        public void success(PaymentResponse paymentResponse) {
                            RetrofitAPIWrapper.this.sendResponse(callback, paymentResponse);
                            Utils.sendResponseToReturnUrlAsync(RetrofitAPIWrapper.this.context, citrusCash.getPaymentBill().getReturnUrl(), paymentResponse);
                        }

                        @Override
                        public void error(CitrusError error) {
                            RetrofitAPIWrapper.this.sendError(callback, error);
                        }
                    });
                } else {
                    Logger.d((String)"Please contact our dev support and configure your signup & signin keys to access this API", (Object[])new Object[0]);
                    RetrofitAPIWrapper.this.sendError(callback, new CitrusError("Access denied. Please configure your keys for Prepaid Pay.", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    private void isEnoughPrepaidBalance(final Amount transactionAmount, final Callback<Boolean> callback) {
        this.getBalance(new Callback<Amount>(){

            @Override
            public void success(Amount userBalance) {
                if (userBalance.getValueAsDouble() >= transactionAmount.getValueAsDouble()) {
                    RetrofitAPIWrapper.this.sendResponse(callback, true);
                } else {
                    RetrofitAPIWrapper.this.sendResponse(callback, false);
                }
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void sendMoney(final Amount amount, final CitrusUser toUser, final String message, final Callback<PaymentResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.sendMoney(accessToken, amount, toUser, message, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void sendMoneyToMoblieNo(final Amount amount, final String mobileNo, final String message, final Callback<PaymentResponse> callback) {
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            this.sendError(callback, new CitrusError("Amount should be not null or blank.", CitrusResponse.Status.FAILED));
            return;
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            this.sendError(callback, new CitrusError("Amount should be greater than 0", CitrusResponse.Status.FAILED));
            return;
        }
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.sendMoneyToMoblieNo(accessToken, amount, mobileNo, message, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void cashout(final @NonNull CashoutInfo cashoutInfo, final Callback<PaymentResponse> callback) {
        if (cashoutInfo != null && cashoutInfo.validate()) {
            Amount amount = cashoutInfo.getAmount();
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                this.sendError(callback, new CitrusError("Amount should be not null or blank.", CitrusResponse.Status.FAILED));
                return;
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                this.sendError(callback, new CitrusError("Amount should be greater than 0", CitrusResponse.Status.FAILED));
                return;
            }
            this.getPrepaidToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    RetrofitAPIWrapper.this.volleyPrePaidApi.cashout(accessToken, cashoutInfo, callback);
                }

                @Override
                public void error(CitrusError error) {
                    RetrofitAPIWrapper.this.sendError(callback, error);
                }
            });
        } else {
            this.sendError(callback, new CitrusError("Please make sure amount, accountNo, accountHolderName and ifscCode are not null or empty.", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void getCashoutInfo(final Callback<CashoutInfo> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.getCashoutInfo(accessToken, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void saveCashoutInfo(final CashoutInfo cashoutInfo, final Callback<CitrusResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.saveCashoutInfo(accessToken, cashoutInfo, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getMerchantPaymentOptions(Callback<MerchantPaymentOption> callback) {
        Log.v((String)TAG, (String)(TAG + ".getMerchantPaymentOptions() "));
        this.volleyPgApi.getMerchantPaymentOptions(callback);
    }

    public synchronized void getLoadMoneyPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.volleyPgApi.getLoadMoneyPaymentOptions(callback);
    }

    public synchronized void getWallet(final Callback<List<PaymentOption>> callback) {
        Log.v((String)TAG, (String)(TAG + ".getWallet() "));
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPgApi.getMerchantPaymentOptions(new Callback<MerchantPaymentOption>(){

                    @Override
                    public void success(MerchantPaymentOption merchantPaymentOption) {
                        RetrofitAPIWrapper.this.fetchConsumerProfile(callback);
                    }

                    @Override
                    public void error(CitrusError error) {
                        RetrofitAPIWrapper.this.fetchConsumerProfile(callback);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getWalletWithDefaultBank(Callback<List<PaymentOption>> callback, BankCID bankCID) {
        this.getWallet(callback);
    }

    public synchronized void fetchConsumerProfile(final Callback<List<PaymentOption>> callback) {
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                Amount amount = new Amount("1");
                RetrofitAPIWrapper.this.volleyWalletPgApi.fetchConsumerProfile(amount, accessToken, new Callback<WalletConsumerProfile>(){

                    @Override
                    public void success(WalletConsumerProfile walletConsumerProfile) {
                        if (walletConsumerProfile != null) {
                            RetrofitAPIWrapper.this.setCitrusUser(walletConsumerProfile.getCitrusUser());
                            RetrofitAPIWrapper.this.sendResponse(callback, walletConsumerProfile.getPaymentOptionList());
                        } else {
                            RetrofitAPIWrapper.this.sendError(callback, new CitrusError("Unable to fetch wallet", CitrusResponse.Status.FAILED));
                        }
                    }

                    @Override
                    public void error(CitrusError error) {
                        RetrofitAPIWrapper.this.sendError(callback, error);
                    }
                });
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void savePaymentOption(final PaymentOption paymentOption, final Callback<CitrusResponse> callback) {
        if (paymentOption != null) {
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateForSaveCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasonsForSaveCard(), CitrusResponse.Status.FAILED));
                return;
            }
            this.getUserNameToken(new Callback<AccessToken>(){

                @Override
                public void success(AccessToken accessToken) {
                    RetrofitAPIWrapper.this.volleyPgApi.savePaymentOption(accessToken, paymentOption, callback);
                }

                @Override
                public void error(CitrusError error) {
                    RetrofitAPIWrapper.this.sendError(callback, error);
                }
            });
        } else {
            this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void saveCard(final PaymentOption paymentOption, final Callback<AddCardResponse> callback) {
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPgApi.saveCard(accessToken, paymentOption, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void deletePaymentOption(final PaymentOption paymentOption, final Callback<CitrusResponse> callback) {
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPgApi.deletePaymentOption(accessToken, paymentOption, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void setDefaultPaymentOption(final PaymentOption defaultPaymentOption, final Callback<CitrusResponse> callback) {
        this.getUserNameToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPgApi.setDefaultPaymentOption(accessToken, defaultPaymentOption, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getBINDetails(CardOption cardOption, Callback<BinServiceResponse> callback) {
        this.getBinServiceResponse(cardOption, callback);
    }

    private void getBinServiceResponse(CardOption cardOption, final Callback<BinServiceResponse> callback) {
        if (cardOption != null) {
            String cardNumber = cardOption.getCardNumber();
            String first6Digits = "";
            String token = "";
            if (!TextUtils.isEmpty((CharSequence)cardOption.getToken())) {
                token = cardOption.getToken();
            } else {
                first6Digits = cardNumber.length() > 6 ? cardNumber.substring(0, 6) : "";
            }
            Callback<BinServiceResponse> callbackBinService = new Callback<BinServiceResponse>(){

                @Override
                public void success(BinServiceResponse binServiceResponse) {
                    if (binServiceResponse != null) {
                        RetrofitAPIWrapper.this.netBankForOTP = binServiceResponse.getNetBankForOTP();
                    }
                    RetrofitAPIWrapper.this.sendResponse(callback, binServiceResponse);
                }

                @Override
                public void error(CitrusError error) {
                    RetrofitAPIWrapper.this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
                }
            };
            if (!TextUtils.isEmpty((CharSequence)first6Digits)) {
                this.volleyBinServiceApi.getBinInfo(first6Digits, callbackBinService);
            } else if (!TextUtils.isEmpty((CharSequence)token)) {
                this.volleyPgApi.getBinInfoUsingToken(token, callbackBinService);
            } else {
                this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Unable to get BIN Details", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void getCardType(String first6Digits, Callback<CardBinDetails> cardDetailsCallback) {
        this.volleyBinServiceApi.getCardType(first6Digits, cardDetailsCallback);
    }

    public synchronized void getBill(String billUrl, Amount amount, String format, Callback<PaymentBill> callback) {
        this.volleyBillingApi.getBill(billUrl, amount, format, callback);
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, Callback<PGHealthResponse> callback) {
        this.citrusBasePgApi.getPGHealth(paymentOption, callback);
    }

    void fetchPGHealthForAllBanks() {
        this.citrusBasePgApi.fetchPGHealthForAllBanks();
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String billUrl, @NonNull Callback<DynamicPricingResponse> callback) {
        this.volleyDynamicPricingPgApi.performDynamicPricing(this.volleyBillingApi, dynamicPricingRequestType, billUrl, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull PaymentBill paymentBill, @NonNull Callback<DynamicPricingResponse> callback) {
        this.volleyDynamicPricingPgApi.performDynamicPricing(dynamicPricingRequestType, paymentBill, callback);
    }

    public synchronized void makeMOTOPayment(String paymentJSON, Callback<StructResponsePOJO> callback) {
        Log.i((String)TAG, (String)(TAG + ".makeMOTOPayment(): paymentJSON = " + paymentJSON));
        ApiRequest motoApiRequest = this.volleyPgApi.getMotoRequestApi(paymentJSON);
        this.volleyApiExecutor.executeCustomObjectApi(this.volleyPgApi, motoApiRequest, callback);
    }

    public synchronized void newMakePayment(String paymentJSON, Callback<String> callback) {
        this.citrusBasePgApi.newMakePayment(paymentJSON, callback);
    }

    public synchronized void makeWalletPGPayment(final String walletPGPaymentJSON, final Callback<WalletPGPaymentResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyWalletPgApi.makeWalletPGPayment(accessToken, walletPGPaymentJSON, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public synchronized void getMerchantName(@NonNull Callback<String> callback) {
        this.volleyPgApi.getMerchantName(callback);
    }

    public synchronized MerchantPaymentOption getPaymentOption(PaymentType paymentType) {
        if (paymentType instanceof PaymentType.LoadMoney) {
            return this.volleyPgApi.getLoadMoneyPaymentOption();
        }
        return this.volleyPgApi.getMerchantPaymentOption();
    }

    public NetBankForOTP getNetBankForOTP() {
        return this.netBankForOTP;
    }

    public CitrusUser getCitrusUser() {
        return this.volleyUmApi.getCitrusUser();
    }

    private void setCitrusUser(CitrusUser citrusUser) {
        this.volleyUmApi.setCitrusUser(citrusUser);
    }

    public void resetNetBankForOTP() {
        this.netBankForOTP = NetBankForOTP.UNKNOWN;
    }

    private <T> void sendResponse(Callback<T> callback, T t) {
        if (callback != null) {
            callback.success(t);
        }
    }

    private <T> void sendError(Callback<T> callback, CitrusError citrusError) {
        if (callback != null) {
            callback.error(citrusError);
        }
    }

    public void cancelAllRequests() {
        ApiExecutor.getInstance(this.context).cancelAllApiRequests();
    }

    public void makeBlazeCardPayment(String paymentJSON, Callback<BCResponse> callback) {
    }

    public void makeBlazeCardTokenizedPayment(String paymentJSON, Callback<BCResponse> callback) {
    }

    public void getBlazeCardPaymentOptions(String vanity, Callback<List<String>> callback) {
    }

    public void cancelBCTransaction(String cancelPaymentJSON, Callback<BCCancelResponse> callback) {
    }

    public void getActiveSubscriptions(final Callback<SubscriptionResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.getActiveSubscriptions(accessToken, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public void deActivateSubscription(final String subscriptionID, final Callback<SubscriptionResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.deActivateSubscription(accessToken, subscriptionID, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public void createAutoLoadSubscription(final SubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.createSubscription(accessToken, subscriptionRequest, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public void updateSubScriptiontoLowerValue(final UpdateSubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.updateSubscriptiontoLowerValue(accessToken, subscriptionRequest, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }

    public void updateSubScriptiontoHigherValue(final UpdateSubscriptionRequest subscriptionRequest, final Callback<SubscriptionResponse> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                RetrofitAPIWrapper.this.volleyPrePaidApi.updateSubscriptiontoHigherValue(accessToken, subscriptionRequest, callback);
            }

            @Override
            public void error(CitrusError error) {
                RetrofitAPIWrapper.this.sendError(callback, error);
            }
        });
    }
}

