/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.widget.Toast;
import com.citrus.mobile.OAuth2GrantType;
import com.citrus.mobile.OauthToken;
import com.citrus.sdk.AddCardResponse;
import com.citrus.sdk.BankCID;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusActivity;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.ConfigChangeListener;
import com.citrus.sdk.Constants;
import com.citrus.sdk.Environment;
import com.citrus.sdk.PaymentDistribution;
import com.citrus.sdk.RetrofitAPIWrapper;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.WalletPGPayment;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BCCancelResponse;
import com.citrus.sdk.classes.BCResponse;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserPasswordType;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.classes.UpdateSubscriptionRequest;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.login.AccessType;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusLogger;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.citrus.sdk.walletpg.WalletPGPaymentResponse;
import com.facebook.android.crypto.keychain.SharedPrefsBackedKeyChain;
import com.facebook.crypto.Crypto;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.util.NativeCryptoLibrary;
import com.facebook.crypto.util.SystemNativeCryptoLibrary;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class CitrusClient
implements ConfigChangeListener {
    private String signinId;
    private String signinSecret;
    private String signupId;
    private String signupSecret;
    private String vanity;
    private String merchantName;
    private Environment environment = Environment.SANDBOX;
    private Amount balanceAmount;
    private static CitrusClient instance;
    private final Context mContext;
    private MerchantPaymentOption merchantPaymentOption = null;
    private OauthToken oauthToken = null;
    private BroadcastReceiver paymentEventReceiver = null;
    private boolean initialized = false;
    private boolean showDummyScreen = false;
    private boolean autoOtpReading = false;
    private RetrofitAPIWrapper retrofitAPIWrapper = null;
    private PaymentOption persistPaymentOption = null;
    private boolean checkPrepaidTokenValidityCalled = false;
    private Crypto crypto = null;
    private UpdateSubscriptionRequest updateSubscriptionRequest = null;
    private SubscriptionRequest subscriptionRequest = null;
    private SubscriptionResponse activeSubscription = null;
    public static boolean isCitrusNativeLibraryLoaded;
    public static boolean isFacebookNativeLibraryLoaded;
    public boolean isUserLoggedIn = false;
    private AUTO_LOAD_TYPE mAUTO_load_type = null;

    public Crypto getCrypto() {
        return this.crypto;
    }

    public UpdateSubscriptionRequest getUpdateSubscriptionRequest() {
        return this.updateSubscriptionRequest;
    }

    public SubscriptionRequest getSubscriptionRequest() {
        return this.subscriptionRequest;
    }

    private CitrusClient(Context context) {
        this.mContext = context;
        this.retrofitAPIWrapper = RetrofitAPIWrapper.getInstance(context);
        CitrusConfig.getInstance().setConfigChangeListener(this);
    }

    public void enableLog(boolean enable) {
        if (enable) {
            CitrusLogger.enableLogs();
        } else {
            CitrusLogger.disableLogs();
        }
    }

    public void showDummyScreenWhilePayments(boolean showDummyScreen) {
        this.showDummyScreen = showDummyScreen;
    }

    public boolean isShowDummyScreenWhilePayments() {
        return this.showDummyScreen;
    }

    public boolean isAutoOtpReading() {
        return this.autoOtpReading;
    }

    public void enableAutoOtpReading(boolean enable) {
        this.autoOtpReading = enable;
    }

    public native String getEncryptionKey();

    public AUTO_LOAD_TYPE getAUTO_load_type() {
        return this.mAUTO_load_type;
    }

    public void destroy() {
        this.initialized = false;
        this.signinId = null;
        this.signinSecret = null;
        this.signupId = null;
        this.signupSecret = null;
        this.vanity = null;
        this.environment = null;
        this.oauthToken = null;
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.retrofitAPIWrapper.cancelAllRequests();
    }

    public void cancelAllRequests() {
        this.retrofitAPIWrapper.cancelAllRequests();
    }

    public void init(@NonNull String signupId, @NonNull String signupSecret, @NonNull String signinId, @NonNull String signinSecret, @NonNull String vanity, @NonNull Environment environment) {
        if (!this.initialized) {
            this.oauthToken = new OauthToken(this.mContext);
            this.signupId = signupId;
            this.signupSecret = signupSecret;
            this.signinId = signinId;
            this.signinSecret = signinSecret;
            this.vanity = vanity;
            if (this.validate()) {
                this.retrofitAPIWrapper.init(signupId, signupSecret, signinId, signinSecret, vanity, environment);
            }
            if (!CitrusLogger.isEnableLogs()) {
                CitrusLogger.disableLogs();
            }
            if (environment == null) {
                this.environment = Environment.SANDBOX;
            }
            this.environment = environment;
            this.saveSDKEnvironment();
            this.isUserSignedIn(new Callback<Boolean>(){

                @Override
                public void success(Boolean signedIn) {
                    if (signedIn.booleanValue()) {
                        CitrusClient.this.isUserLoggedIn = true;
                    }
                }

                @Override
                public void error(CitrusError error) {
                }
            });
            this.initialized = true;
        }
        if (environment != Environment.PRODUCTION) {
            Toast.makeText((Context)this.mContext, (CharSequence)("Environment is *** " + environment.toString()), (int)1).show();
        }
    }

    private void fetchPGHealthForAllBanks() {
        this.retrofitAPIWrapper.fetchPGHealthForAllBanks();
    }

    private void saveSDKEnvironment() {
        if (this.oauthToken.getCurrentEnvironment() == Environment.NONE) {
            this.oauthToken.saveEnvironment(this.environment);
            Logger.d((String)"NO ENVIRONMENT EXISTS earlier", (Object[])new Object[0]);
        } else if (this.oauthToken.getCurrentEnvironment() == this.environment) {
            Logger.d((String)"PREVIOUS AND CURRENT ENVIRONMENT IS SAME", (Object[])new Object[0]);
        } else {
            this.signOut(new Callback<CitrusResponse>(){

                @Override
                public void success(CitrusResponse citrusResponse) {
                    CitrusClient.this.oauthToken.saveEnvironment(CitrusClient.this.environment);
                    Logger.d((String)"ENVIRONMMENT MISMATCH ***user Logging out", (Object[])new Object[0]);
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.oauthToken.saveEnvironment(CitrusClient.this.environment);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusClient getInstance(Context context) {
        if (instance != null) return instance;
        Class<CitrusClient> clazz = CitrusClient.class;
        synchronized (CitrusClient.class) {
            if (instance != null) return instance;
            instance = new CitrusClient(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void validateLinkUserCredentials(String email, String mobileNo, Callback callback) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            this.sendError(callback, new CitrusError("Email ID should not be null.", CitrusResponse.Status.FAILED));
        } else if (TextUtils.isEmpty((CharSequence)mobileNo)) {
            this.sendError(callback, new CitrusError("Mobile number should not be null.", CitrusResponse.Status.FAILED));
        } else if (!Utils.isValidEmail(email) && !Utils.isValidMobile(mobileNo)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
        } else if (!Utils.isValidEmail(email)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (!Utils.isValidMobile(mobileNo)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
        } else {
            this.sendResponse(callback, true);
        }
    }

    private void validateLinkBindUserCredentials(String email, String mobileNo, AccessType accessType, Callback callback) {
        if (!Utils.isValidEmail(email) && !Utils.isValidMobile(mobileNo)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
        } else if (!Utils.isValidEmail(email)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (!Utils.isValidMobile(mobileNo)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (TextUtils.isEmpty((CharSequence)mobileNo) && accessType == AccessType.FULL) {
            this.sendError(callback, new CitrusError("Mobile No is required for Full Access.", CitrusResponse.Status.FAILED));
        } else {
            this.sendResponse(callback, true);
        }
    }

    public synchronized void linkUserExtended(final String emailId, final String mobileNo, final Callback<LinkUserExtendedResponse> callback) {
        this.validateLinkUserCredentials(emailId, mobileNo, new Callback(){

            public void success(Object o) {
                CitrusClient.this.retrofitAPIWrapper.linkUserExtended(emailId, mobileNo, callback);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkUserExtendedSignIn(LinkUserExtendedResponse linkUserExtended, LinkUserPasswordType linkUserPasswordType, String linkUserPassword, Callback<CitrusResponse> callback) {
        String inputEmail = linkUserExtended.getInputEmail();
        if (linkUserPassword == null || linkUserPassword.equalsIgnoreCase("")) {
            this.sendError(callback, new CitrusError(linkUserExtended.getLinkUserMessage(), CitrusResponse.Status.FAILED));
        } else if (linkUserPasswordType == LinkUserPasswordType.None) {
            this.sendError(callback, new CitrusError(linkUserExtended.getLinkUserMessage(), CitrusResponse.Status.FAILED));
        } else {
            int linkUserCase = linkUserExtended.formatResponseCode();
            switch (linkUserPasswordType) {
                case Otp: {
                    if (linkUserCase == 1 || linkUserCase == 6 || linkUserCase == 2 || linkUserCase == 7) {
                        Logger.d((String)"old sigin, otp", (Object[])new Object[0]);
                        this.signInWithOTP(linkUserExtended, linkUserPassword, callback);
                        break;
                    }
                    if (linkUserCase == 3 || linkUserCase == 4 || linkUserCase == 5 || linkUserCase == 10 || linkUserCase == 11 || linkUserCase == 12) {
                        Logger.d((String)"verify and sigin, otp", (Object[])new Object[0]);
                        CitrusClient citrusClient = this;
                        synchronized (citrusClient) {
                            this.linkUserExtendedVerifyMobileAndSignIn(linkUserExtended, linkUserPassword, callback);
                            break;
                        }
                    }
                    if (linkUserCase != 8 && linkUserCase != 9) break;
                    Logger.d((String)"Update mobile sigin, e-otp", (Object[])new Object[0]);
                    String signInGrantType = OAuth2GrantType.onetimepass.toString();
                    CitrusClient citrusClient = this;
                    synchronized (citrusClient) {
                        this.linkUserExtendedVerifyEOTPAndUpdateMobile(inputEmail, signInGrantType, linkUserPassword, linkUserExtended, callback);
                        break;
                    }
                }
                case Password: {
                    if (linkUserCase == 1 || linkUserCase == 6 || linkUserCase == 2 || linkUserCase == 5) {
                        Logger.d((String)"old sigin, password", (Object[])new Object[0]);
                        this.signIn(inputEmail, linkUserPassword, callback);
                        break;
                    }
                    if (linkUserCase != 8) break;
                    Logger.d((String)"Update mobile sigin, password", (Object[])new Object[0]);
                    String signInGrantType = OAuth2GrantType.password.toString();
                    CitrusClient citrusClient = this;
                    synchronized (citrusClient) {
                        this.linkUserExtendedVerifyEOTPAndUpdateMobile(inputEmail, signInGrantType, linkUserPassword, linkUserExtended, callback);
                        break;
                    }
                }
            }
        }
    }

    public void linkUserExtendedVerifyEOTPAndUpdateMobile(String emailId, String signInGrantType, String linkUserPassword, LinkUserExtendedResponse linkUserExtended, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.linkUserExtendedVerifyEOTPAndUpdateMobile(emailId, signInGrantType, linkUserPassword, linkUserExtended, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void linkUserExtendedVerifyMobileAndSignIn(LinkUserExtendedResponse linkUserExtendedResponse, String verificationCode, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.linkUserExtendedVerifyMobileAndSignIn(linkUserExtendedResponse, verificationCode, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void isCitrusMember(String emailId, String mobileNo, Callback<Boolean> callback) {
        this.retrofitAPIWrapper.isCitrusMember(emailId, mobileNo, callback);
    }

    public synchronized void getMemberInfo(String emailId, String mobileNo, Callback<MemberInfo> callback) {
        this.retrofitAPIWrapper.getMemberInfo(emailId, mobileNo, callback);
    }

    public synchronized void bindUser(String emailId, String mobileNo, Callback<String> callback) {
        this.retrofitAPIWrapper.createUser(emailId, mobileNo, callback);
    }

    public synchronized void bindUserByMobile(String emailId, String mobileNo, Callback<BindUserResponse> callback) {
        this.retrofitAPIWrapper.bindUserByMobile(emailId, mobileNo, callback);
    }

    public synchronized void linkUserWithOTP(String emailId, String mobileNo, boolean forceMobileVerification, Callback<LinkUserResponse> callback) {
        this.retrofitAPIWrapper.linkUserWithOTP(emailId, mobileNo, forceMobileVerification, callback);
    }

    public synchronized void signIn(String emailId, String password, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.signIn(emailId, password, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithMobileNo(String mobileNo, String password, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.signInWithMobileNo(mobileNo, password, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithOTP(LinkUserExtendedResponse linkUserExtended, String otp, Callback<CitrusResponse> callback) {
        String linkUserMobile = linkUserExtended.getLinkUserMobile();
        this.retrofitAPIWrapper.signInWithOTP(linkUserMobile, otp, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signOut(Callback<CitrusResponse> callback) {
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.activeSubscription = null;
        this.retrofitAPIWrapper.signOut(callback);
    }

    public synchronized void signUp(String emailId, String mobileNo, String password, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.signUp(emailId, mobileNo, password, callback);
    }

    public synchronized void resetPassword(String emailId, @NonNull Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.resetPassword(emailId, callback);
    }

    public synchronized void updateMobile(String mobileNo, Callback<String> callback) {
        this.retrofitAPIWrapper.updateMobile(mobileNo, callback);
    }

    public synchronized void verifyMobile(String verificationCode, Callback<String> callback) {
        this.retrofitAPIWrapper.verifyMobile(verificationCode, callback);
    }

    public synchronized void getWallet(Callback<List<PaymentOption>> callback) {
        this.retrofitAPIWrapper.getWallet(callback);
    }

    public synchronized void getWalletWithDefaultBank(Callback<List<PaymentOption>> callback, BankCID bankCID) {
        this.retrofitAPIWrapper.getWalletWithDefaultBank(callback, bankCID);
    }

    @Deprecated
    public synchronized void activatePrepaidUser(Callback<Amount> callback) {
        this.retrofitAPIWrapper.activatePrepaidUser(callback);
    }

    public synchronized void getProfileInfo(Callback<CitrusUser> callback) {
        this.retrofitAPIWrapper.getProfileInfo(callback);
    }

    public synchronized void getBalance(Callback<Amount> callback) {
        this.retrofitAPIWrapper.getBalance(callback);
    }

    public synchronized void savePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.savePaymentOption(paymentOption, callback);
    }

    private synchronized void saveCard(PaymentOption paymentOption, Callback<AddCardResponse> callback) {
        if (CitrusConfig.getInstance().isOneTapPaymentEnabled() && this.isOneTapPaymentSupported()) {
            this.retrofitAPIWrapper.saveCard(paymentOption, callback);
        }
    }

    public synchronized void deletePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.deletePaymentOption(paymentOption, callback);
    }

    public synchronized void getBill(String billUrl, Amount amount, String format, Callback<PaymentBill> callback) {
        this.retrofitAPIWrapper.getBill(billUrl, amount, format, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String billUrl, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.performDynamicPricing(dynamicPricingRequestType, billUrl, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull PaymentBill paymentBill, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.performDynamicPricing(dynamicPricingRequestType, paymentBill, callback);
    }

    public synchronized void sendMoney(Amount amount, CitrusUser toUser, String message, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.sendMoney(amount, toUser, message, callback);
    }

    public synchronized void sendMoneyToMoblieNo(Amount amount, String mobileNo, String message, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.sendMoneyToMoblieNo(amount, mobileNo, message, callback);
    }

    public void getPrepaidToken(Callback<AccessToken> callback) {
        this.retrofitAPIWrapper.getPrepaidToken(callback);
    }

    public synchronized void getMerchantPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.getMerchantPaymentOptions(callback);
    }

    public synchronized void getLoadMoneyPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.getLoadMoneyPaymentOptions(callback);
    }

    public synchronized void isUserSignedIn(final Callback<Boolean> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            @Override
            public void success(AccessToken accessToken) {
                CitrusClient.this.sendResponse(callback, true);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendResponse(callback, false);
            }
        });
    }

    public synchronized void loadMoney(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = loadMoney.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                this.subscriptionRequest = null;
                this.mAUTO_load_type = null;
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.getPaymentOption(loadMoney))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        if (this.mAUTO_load_type == null) {
            this.mAUTO_load_type = AUTO_LOAD_TYPE.LAZY_AUTO_LOAD;
        }
        this.createAutoLoadRequest(loadMoney.getPaymentOption());
        this.registerReceiver(callback, new IntentFilter(loadMoney.getIntentAction()));
        this.startCitrusActivity(loadMoney, false);
    }

    public synchronized void loadMoneyWithOneTap(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            if (loadMoney.getPaymentOption() instanceof CardOption) {
                if (loadMoney.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)loadMoney.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()));
                this.persistPaymentOption = loadMoney.getPaymentOption();
                this.loadMoney(loadMoney, callback);
            } else {
                this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void pgPayment(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        if (pgPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pgPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.getPaymentOption(pgPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
        this.startCitrusActivity(pgPayment, false);
    }

    public synchronized void pgPaymentWithOneTap(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        if (pgPayment != null) {
            if (pgPayment.getPaymentOption() instanceof CardOption) {
                if (pgPayment.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)pgPayment.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)pgPayment.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)pgPayment.getPaymentOption()));
                this.persistPaymentOption = pgPayment.getPaymentOption();
                this.pgPayment(pgPayment, callback);
            } else {
                this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
        }
    }

    @Deprecated
    public synchronized void pgPayment(DynamicPricingResponse dynamicPricingResponse, Callback<TransactionResponse> callback) {
        if (dynamicPricingResponse != null) {
            PaymentBill paymentBill = dynamicPricingResponse.getPaymentBill();
            try {
                PaymentType.PGPayment pgPayment = new PaymentType.PGPayment(paymentBill, dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
                this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
                this.startCitrusActivity(pgPayment, dynamicPricingResponse, false);
            }
            catch (CitrusException e) {
                e.printStackTrace();
                this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Dynamic Pricing Response can not be null", CitrusResponse.Status.FAILED));
        }
    }

    private synchronized void walletPGCharge(WalletPGPayment walletPGPayment, Callback<TransactionResponse> callback) {
        PaymentOption otherPaymentOption = walletPGPayment.getOtherPaymentOption();
        if (otherPaymentOption != null) {
            if (otherPaymentOption instanceof CardOption && !((CardOption)otherPaymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)otherPaymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(otherPaymentOption, this.retrofitAPIWrapper.getPaymentOption(walletPGPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        if (!walletPGPayment.validateTotalTransactionAmount()) {
            this.sendError(callback, new CitrusError("Total Transaction of all the payment options should be equal to actual transaction amount.", CitrusResponse.Status.FAILED));
            return;
        }
        this.persistPaymentOption = otherPaymentOption;
        this.registerReceiver(callback, new IntentFilter(walletPGPayment.getIntentAction()));
        this.startCitrusActivity(walletPGPayment, false);
    }

    public synchronized void makePayment(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        if (pgPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pgPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.getPaymentOption(pgPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
        this.startCitrusActivity(pgPayment, true);
    }

    public synchronized void makePaymentWithOneTap(PaymentType.PGPayment pgPayment, Callback<TransactionResponse> callback) {
        if (pgPayment != null) {
            PaymentOption paymentOption = pgPayment.getPaymentOption();
            if (paymentOption instanceof CardOption) {
                CardOption savedCardOption = (CardOption)paymentOption;
                if (savedCardOption.getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint(savedCardOption) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint(savedCardOption));
                this.persistPaymentOption = paymentOption;
            }
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pgPayment.getIntentAction()));
        this.startCitrusActivity(pgPayment, true);
    }

    private void isEnoughPrepaidBalance(final Amount amount, final Callback<Boolean> callback) {
        this.getBalance(new Callback<Amount>(){

            @Override
            public void success(Amount userBalance) {
                if (userBalance.getValueAsDouble() >= amount.getValueAsDouble()) {
                    CitrusClient.this.sendResponse(callback, true);
                } else {
                    CitrusClient.this.sendResponse(callback, false);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    @Deprecated
    public synchronized void prepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        this.getProfileInfo(new Callback<CitrusUser>(){

            @Override
            public void success(CitrusUser citrusUser) {
                CitrusClient.this.proceedWithNewPrepaidPay(citrusCash, callback);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.proceedWithNewPrepaidPay(citrusCash, callback);
            }
        });
    }

    private void proceedWithNewPrepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        if (!this.checkPrepaidTokenValidityCalled) {
            this.checkPrepaymentTokenValidity(new Callback<Boolean>(){

                @Override
                public void success(Boolean isValid) {
                    if (isValid.booleanValue()) {
                        CitrusClient.this.retrofitAPIWrapper.newPrepaidPay(citrusCash, callback);
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("User's cookie has expired. Please signin.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, new CitrusError(error.getMessage(), CitrusResponse.Status.FAILED));
                }
            });
            this.checkPrepaidTokenValidityCalled = true;
        } else {
            this.retrofitAPIWrapper.newPrepaidPay(citrusCash, callback);
        }
    }

    private void checkPrepaymentTokenValidity(Callback<Boolean> callback) {
        this.retrofitAPIWrapper.checkPrepaymentTokenValidity(callback);
    }

    public synchronized void cashout(@NonNull CashoutInfo cashoutInfo, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.cashout(cashoutInfo, callback);
    }

    public synchronized void getCashoutInfo(Callback<CashoutInfo> callback) {
        this.retrofitAPIWrapper.getCashoutInfo(callback);
    }

    public synchronized void saveCashoutInfo(CashoutInfo cashoutInfo, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.saveCashoutInfo(cashoutInfo, callback);
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, Callback<PGHealthResponse> callback) {
        this.retrofitAPIWrapper.getPGHealth(paymentOption, callback);
    }

    public void getBINDetails(CardOption cardOption, Callback<BinServiceResponse> callback) {
        this.retrofitAPIWrapper.getBINDetails(cardOption, callback);
    }

    public NetBankForOTP getNetBankForOTP() {
        return this.retrofitAPIWrapper.getNetBankForOTP();
    }

    public void resetNetBankForOTP() {
        this.retrofitAPIWrapper.resetNetBankForOTP();
    }

    public synchronized String getUserEmailId() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getEmailId();
        }
        return null;
    }

    public synchronized String getUserMobileNumber() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getMobileNo();
        }
        return null;
    }

    public synchronized CitrusUser getCitrusUser() {
        return this.retrofitAPIWrapper.getCitrusUser();
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(receiver);
    }

    private void startCitrusActivity(final PaymentType paymentType, final DynamicPricingResponse dynamicPricingResponse, final boolean useNewAPI) {
        this.getProfileInfo(new Callback<CitrusUser>(){

            @Override
            public void success(CitrusUser citrusUser) {
                Intent intent = new Intent(CitrusClient.this.mContext, CitrusActivity.class);
                intent.setFlags(0x10000000);
                intent.putExtra("INTENT_EXTRA_PAYMENT_TYPE", (Parcelable)paymentType);
                intent.putExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE", (Parcelable)dynamicPricingResponse);
                intent.putExtra("INTENT_EXTRA_USE_NEW_API", useNewAPI);
                CitrusClient.this.mContext.startActivity(intent);
            }

            @Override
            public void error(CitrusError error) {
                Intent intent = new Intent(CitrusClient.this.mContext, CitrusActivity.class);
                intent.setFlags(0x10000000);
                intent.putExtra("INTENT_EXTRA_PAYMENT_TYPE", (Parcelable)paymentType);
                intent.putExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE", (Parcelable)dynamicPricingResponse);
                intent.putExtra("INTENT_EXTRA_USE_NEW_API", useNewAPI);
                CitrusClient.this.mContext.startActivity(intent);
            }
        });
    }

    private void startCitrusActivity(PaymentType paymentType, boolean useNewAPI) {
        if (!useNewAPI && paymentType instanceof PaymentType.PGPayment && ((PaymentType.PGPayment)paymentType).isSingleHop()) {
            useNewAPI = true;
        }
        this.startCitrusActivity(paymentType, null, useNewAPI);
    }

    private <T> void registerReceiver(final Callback<T> callback, IntentFilter intentFilter) {
        this.paymentEventReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CitrusClient.this.unregisterReceiver(this);
                CitrusClient.this.resetNetBankForOTP();
                TransactionResponse transactionResponse = (TransactionResponse)intent.getParcelableExtra("INTENT_EXTRA_TRANSACTION_RESPONSE");
                String action = intent.getAction();
                if (transactionResponse != null) {
                    TransactionResponse.TransactionStatus transactionStatus = transactionResponse.getTransactionStatus();
                    CitrusResponse.Status status = null;
                    if (transactionStatus != null) {
                        switch (transactionStatus) {
                            case SUCCESSFUL: {
                                status = CitrusResponse.Status.SUCCESSFUL;
                                break;
                            }
                            case FAILED: {
                                status = CitrusResponse.Status.FAILED;
                                CitrusClient.this.persistPaymentOption = null;
                                break;
                            }
                            case CANCELLED: {
                                status = CitrusResponse.Status.CANCELLED;
                                CitrusClient.this.persistPaymentOption = null;
                                break;
                            }
                            case PG_REJECTED: {
                                status = CitrusResponse.Status.PG_REJECTED;
                                CitrusClient.this.persistPaymentOption = null;
                            }
                        }
                    }
                    if (transactionStatus == TransactionResponse.TransactionStatus.SUCCESSFUL) {
                        if (transactionResponse.getBinCardType() != null && !transactionResponse.getBinCardType().contains("Credit")) {
                            CitrusClient.this.subscriptionRequest = null;
                            CitrusClient.this.mAUTO_load_type = null;
                        }
                        if (CitrusClient.this.persistPaymentOption != null && CitrusClient.this.persistPaymentOption instanceof CardOption && "INDIA".equalsIgnoreCase(transactionResponse.getCountry())) {
                            CardOption cardOption = (CardOption)CitrusClient.this.persistPaymentOption;
                            if (cardOption.isTokenizedPayment()) {
                                if (cardOption.getCardCVV() != null && cardOption.getFingerPrint() != null) {
                                    CitrusClient.this.saveCVV(CitrusClient.this.persistPaymentOption.getFingerPrint(), ((CardOption)CitrusClient.this.persistPaymentOption).getCardCVV());
                                    CitrusClient.this.persistPaymentOption = null;
                                }
                            } else {
                                CitrusClient.this.saveCard(CitrusClient.this.persistPaymentOption, new Callback<AddCardResponse>(){

                                    @Override
                                    public void success(AddCardResponse addCardResponse) {
                                        CitrusClient.this.saveCVV(addCardResponse.getFingerPrint(), ((CardOption)CitrusClient.this.persistPaymentOption).getCardCVV());
                                        CitrusClient.this.persistPaymentOption = null;
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                    }
                                });
                            }
                        }
                        CitrusClient.this.sendResponse(callback, transactionResponse);
                    } else {
                        CitrusClient.this.updateSubscriptionRequest = null;
                        CitrusClient.this.subscriptionRequest = null;
                        CitrusClient.this.mAUTO_load_type = null;
                        CitrusClient.this.sendError(callback, new CitrusError(transactionResponse.getMessage(), transactionResponse.getJsonResponse(), status, transactionResponse));
                    }
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.paymentEventReceiver, intentFilter);
    }

    private synchronized boolean validate() {
        if (!(TextUtils.isEmpty((CharSequence)this.signinId) || TextUtils.isEmpty((CharSequence)this.signinSecret) || TextUtils.isEmpty((CharSequence)this.signupId) || TextUtils.isEmpty((CharSequence)this.signupSecret) || TextUtils.isEmpty((CharSequence)this.vanity))) {
            return true;
        }
        throw new IllegalArgumentException("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank");
    }

    private <T> void sendResponse(Callback callback, T t) {
        if (callback != null) {
            callback.success(t);
        }
    }

    private void sendError(Callback callback, CitrusError error) {
        if (callback != null) {
            callback.error(error);
        }
    }

    public synchronized void resetUserPassword(String emailId, @NonNull Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.resetUserPassword(emailId, callback);
    }

    public synchronized void setDefaultPaymentOption(PaymentOption defaultPaymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.setDefaultPaymentOption(defaultPaymentOption, callback);
    }

    public synchronized void signUpUser(String email, String mobile, String password, String firstName, String lastName, String sourceType, boolean markMobileVerified, boolean markEmailVerified, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.signUpUser(email, mobile, password, firstName, lastName, sourceType, markMobileVerified, markEmailVerified, callback);
    }

    public synchronized void changePassword(String oldPassword, String newPassword, Callback<CitrusUMResponse> changePasswordResponseCallback) {
        this.retrofitAPIWrapper.changePassword(oldPassword, newPassword, changePasswordResponseCallback);
    }

    public synchronized void updateProfileInfo(String firstName, String lastName, Callback<CitrusUMResponse> citrusUMResponseCallback) {
        this.retrofitAPIWrapper.updateProfileInfo(firstName, lastName, citrusUMResponseCallback);
    }

    public synchronized void sendOneTimePassword(String source, String otpType, String identity, Callback<CitrusUMResponse> umResponseCallback) {
        this.retrofitAPIWrapper.sendOneTimePassword(source, otpType, identity, umResponseCallback);
    }

    public synchronized void getCardType(String first6Digits, Callback<CardBinDetails> cardDetailsCallback) {
        this.retrofitAPIWrapper.getCardType(first6Digits, cardDetailsCallback);
    }

    public synchronized void getMerchantName(Callback<String> callback) {
        this.retrofitAPIWrapper.getMerchantName(callback);
    }

    public synchronized void makeWalletPGPayment(String walletPGPaymentJSON, Callback<WalletPGPaymentResponse> callback) {
        this.retrofitAPIWrapper.makeWalletPGPayment(walletPGPaymentJSON, callback);
    }

    public synchronized void makeMOTOPayment(String paymentJSON, Callback<StructResponsePOJO> callback) {
        this.retrofitAPIWrapper.makeMOTOPayment(paymentJSON, callback);
    }

    synchronized void newMakePayment(String paymentJSON, Callback<String> callback) {
        this.retrofitAPIWrapper.newMakePayment(paymentJSON, callback);
    }

    public synchronized void getPrepaidBill(Amount amount, String returnUrl, Callback<CitrusPrepaidBill> callback) {
        this.retrofitAPIWrapper.getPrepaidBill(amount, returnUrl, callback);
    }

    public String getSigninId() {
        return this.signinId;
    }

    public void setSigninId(String signinId) {
        this.signinId = signinId;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public void setSigninSecret(String signinSecret) {
        this.signinSecret = signinSecret;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public void setSignupId(String signupId) {
        this.signupId = signupId;
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public void setSignupSecret(String signupSecret) {
        this.signupSecret = signupSecret;
    }

    public String getVanity() {
        return this.vanity;
    }

    public void setVanity(String vanity) {
        this.vanity = vanity;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String generateDeviceSpecificKeys() {
        String android_id = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        String str1 = Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.DISPLAY + Build.FINGERPRINT + Build.HOST + Build.ID + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.TAGS + Build.TYPE + Build.USER;
        String key2 = str1 + android_id;
        return key2;
    }

    private void initCrypto() {
        this.crypto = new Crypto((KeyChain)new SharedPrefsBackedKeyChain(this.mContext), (NativeCryptoLibrary)new SystemNativeCryptoLibrary());
        if (this.crypto.isAvailable()) {
            isFacebookNativeLibraryLoaded = true;
        } else {
            isFacebookNativeLibraryLoaded = false;
            this.crypto = null;
        }
    }

    private void saveCVV(String fingerPrint, String CVV) {
        if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
            return;
        }
        String seed = this.generateDeviceSpecificKeys() + fingerPrint + this.getEncryptionKey();
        Entity myEntity = new Entity(seed);
        try {
            byte[] cipherTextToken = this.crypto.encrypt(fingerPrint.getBytes(), myEntity);
            byte[] cipherText = this.crypto.encrypt(CVV.getBytes(), myEntity);
            byte[] cipherText2 = this.crypto.encrypt(CVV.getBytes(), myEntity);
            this.oauthToken.saveCVV(cipherTextToken, cipherText);
        }
        catch (KeyChainException e) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException e) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
    }

    private String getCVVOfFingerPrint(CardOption cardOption) {
        String cvv = null;
        try {
            if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
                return null;
            }
            String seed = this.generateDeviceSpecificKeys() + cardOption.getFingerPrint() + this.getEncryptionKey();
            Entity myEntity = new Entity(seed);
            byte[] encryptedCVV = this.oauthToken.getCVV(cardOption.getFingerPrint(), seed);
            if (encryptedCVV != null) {
                byte[] decryptedCVV = this.crypto.decrypt(encryptedCVV, myEntity);
                cvv = new String(decryptedCVV);
            } else {
                cvv = null;
            }
        }
        catch (KeyChainException e) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException e) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return cvv;
    }

    public synchronized boolean isOneTapPaymentEnabledForCard(CardOption cardOption) {
        if (cardOption != null) {
            String cvv = this.getCVVOfFingerPrint(cardOption);
            return cvv != null;
        }
        return false;
    }

    public synchronized boolean isOneTapPaymentSupported() {
        return isCitrusNativeLibraryLoaded && isFacebookNativeLibraryLoaded;
    }

    @Override
    public void onOneTapPaymentEnabled(boolean isEnabled) {
        if (isEnabled) {
            try {
                System.loadLibrary("citruslibrary");
                isCitrusNativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError error) {
                isCitrusNativeLibraryLoaded = false;
            }
            this.initCrypto();
            if (this.isOneTapPaymentSupported()) {
                Logger.d((String)"This device supports One Tap Payment.", (Object[])new Object[0]);
            } else {
                Logger.d((String)"This device does not support One Tap Payment.", (Object[])new Object[0]);
            }
        }
    }

    private synchronized boolean validatePaymentOptionForMerchant(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption) {
        if (paymentOption != null) {
            if (merchantPaymentOption != null) {
                CardOption.CardScheme cardScheme = null;
                if (paymentOption instanceof CreditCardOption) {
                    cardScheme = ((CreditCardOption)paymentOption).getCardScheme();
                    Set<CardOption.CardScheme> cardSchemeSet = merchantPaymentOption.getCreditCardSchemeSet();
                    if (cardSchemeSet != null) {
                        return cardSchemeSet.contains((Object)cardScheme);
                    }
                    return true;
                }
                if (paymentOption instanceof DebitCardOption) {
                    cardScheme = ((DebitCardOption)paymentOption).getCardScheme();
                    Set<CardOption.CardScheme> cardSchemeSet = merchantPaymentOption.getDebitCardSchemeSet();
                    if (cardSchemeSet != null) {
                        return cardSchemeSet.contains((Object)cardScheme);
                    }
                    return true;
                }
                if (paymentOption instanceof NetbankingOption) {
                    if (!paymentOption.isTokenizedPayment()) {
                        Set<String> netbankingCIDSet = merchantPaymentOption.getBankCIDSet();
                        return netbankingCIDSet == null || netbankingCIDSet.contains(((NetbankingOption)paymentOption).getBankCID());
                    }
                    return merchantPaymentOption.getNetbankingOptionList().contains(paymentOption);
                }
            }
            return true;
        }
        return false;
    }

    void makeBlazeCardPayment(String paymentJSON, Callback<BCResponse> callback) {
        this.retrofitAPIWrapper.makeBlazeCardPayment(paymentJSON, callback);
    }

    void makeBlazeCardTokenizedPayment(String paymentJSON, Callback<BCResponse> callback) {
        this.retrofitAPIWrapper.makeBlazeCardTokenizedPayment(paymentJSON, callback);
    }

    void cancelBCTransaction(String cancelPaymentJSON, Callback<BCCancelResponse> callback) {
        this.retrofitAPIWrapper.cancelBCTransaction(cancelPaymentJSON, callback);
    }

    public void simpliPay(PaymentType paymentType, Callback<TransactionResponse> callback) {
        if (paymentType instanceof PaymentType.SplitPayment) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.getPaymentOption(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.createWalletPGPaymentOption(paymentType, callback);
        } else if (paymentType instanceof PaymentType.LoadMoney) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.getPaymentOption(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.loadMoney((PaymentType.LoadMoney)paymentType, callback);
        } else if (paymentType instanceof PaymentType.CitrusCash) {
            if (!this.validateLogin(callback)) {
                return;
            }
            try {
                PaymentType.SplitPayment splitPayment = null;
                splitPayment = paymentType.getPaymentBill() == null ? new PaymentType.SplitPayment(paymentType.getAmount(), paymentType.getUrl(), null, true, false) : new PaymentType.SplitPayment(paymentType.getPaymentBill(), null, true, false);
                this.createWalletPGPaymentOption(splitPayment, callback);
            }
            catch (CitrusException e) {
                e.printStackTrace();
            }
        } else if (paymentType instanceof PaymentType.PGPayment) {
            PaymentType.PGPayment pgPayment = (PaymentType.PGPayment)paymentType;
            if (!this.validatePaymentOptions(pgPayment.getPaymentOption(), this.retrofitAPIWrapper.getPaymentOption(pgPayment), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(pgPayment.getPaymentOption(), callback)) {
                return;
            }
            if (this.isUserLoggedIn && pgPayment.getPaymentOption().isTokenizedPayment() && !pgPayment.isDyanmicPricingRequest()) {
                PaymentType.SplitPayment splitPayment = new PaymentType.SplitPayment(pgPayment);
                this.createWalletPGPaymentOption(splitPayment, callback);
            } else if (pgPayment.isDyanmicPricingRequest()) {
                this.pgPayment(pgPayment.getDynamicPricingResponse(), callback);
            } else {
                this.pgPayment(pgPayment, callback);
            }
        }
    }

    private void createWalletPGPaymentOption(final PaymentType paymentType, final Callback<TransactionResponse> callback) {
        if (((PaymentType.SplitPayment)paymentType).isCitrusCashEnabled() || ((PaymentType.SplitPayment)paymentType).isMVCEnabled()) {
            this.getWallet(new Callback<List<PaymentOption>>(){

                @Override
                public void success(List<PaymentOption> paymentOptionList) {
                    BigDecimal difference;
                    BigDecimal amount2;
                    BigDecimal amount1;
                    ArrayList<PaymentOption> walletList = new ArrayList<PaymentOption>();
                    MVCOption mvcOption = null;
                    CitrusCash citrusCash = null;
                    Amount transactionAmount = paymentType.getAmount();
                    double transactionAmountInDouble = transactionAmount.getValueAsDouble();
                    boolean isAmountCompleted = false;
                    PaymentType.SplitPayment splitPayment = (PaymentType.SplitPayment)paymentType;
                    double mvcAmount = 0.0;
                    double citrusCashAmount = 0.0;
                    for (PaymentOption paymentOption : paymentOptionList) {
                        if (splitPayment.isMVCEnabled() && paymentOption instanceof MVCOption) {
                            mvcOption = (MVCOption)paymentOption;
                        }
                        if (!splitPayment.isCitrusCashEnabled() || !(paymentOption instanceof CitrusCash)) continue;
                        citrusCash = (CitrusCash)paymentOption;
                    }
                    if (splitPayment.isCitrusCashEnabled() && !splitPayment.isMVCEnabled() && splitPayment.getPaymentOption() == null && citrusCash.getMaxBalance().getValueAsDouble() < transactionAmount.getValueAsDouble()) {
                        CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                        return;
                    }
                    if (splitPayment.isMVCEnabled() && mvcOption != null && mvcOption.getMaxBalance().getValueAsDouble() >= 1.0) {
                        if (transactionAmount.getValueAsDouble() <= mvcOption.getMaxBalance().getValueAsDouble()) {
                            mvcAmount = paymentType.getAmount().getValueAsDouble();
                            isAmountCompleted = true;
                        } else {
                            mvcAmount = mvcOption.getMaxBalanceRounded().getValueAsDouble();
                        }
                        amount1 = BigDecimal.valueOf(transactionAmountInDouble);
                        amount2 = BigDecimal.valueOf(mvcAmount);
                        difference = amount1.subtract(amount2);
                        transactionAmountInDouble = difference.doubleValue();
                        mvcOption.setTransactionAmount(new Amount(String.valueOf(mvcAmount)));
                        walletList.add(mvcOption);
                    }
                    if (splitPayment.isCitrusCashEnabled() && !isAmountCompleted && citrusCash.getMaxBalance().getValueAsDouble() >= 1.0) {
                        if (transactionAmountInDouble <= citrusCash.getMaxBalance().getValueAsDouble()) {
                            citrusCashAmount = transactionAmountInDouble;
                            isAmountCompleted = true;
                        } else {
                            citrusCashAmount = citrusCash.getMaxBalanceRounded().getValueAsDouble();
                        }
                        amount1 = BigDecimal.valueOf(transactionAmountInDouble);
                        amount2 = BigDecimal.valueOf(citrusCashAmount);
                        difference = amount1.subtract(amount2);
                        transactionAmountInDouble = difference.doubleValue();
                        citrusCash.setTransactionAmount(new Amount(String.valueOf(citrusCashAmount)));
                        walletList.add(citrusCash);
                    }
                    if (!isAmountCompleted) {
                        paymentType.getPaymentOption().setTransactionAmount(new Amount(String.valueOf(transactionAmountInDouble)));
                        walletList.add(paymentType.getPaymentOption());
                    }
                    try {
                        WalletPGPayment walletPGPayment = new WalletPGPayment((PaymentType.SplitPayment)paymentType, walletList);
                        CitrusClient.this.walletPGCharge(walletPGPayment, callback);
                    }
                    catch (CitrusException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        } else if (paymentType.getPaymentOption().isTokenizedPayment()) {
            ArrayList<PaymentOption> walletList = new ArrayList<PaymentOption>();
            if (paymentType.getPaymentOption().getTransactionAmount() == null) {
                paymentType.getPaymentOption().setTransactionAmount(paymentType.getAmount());
            }
            walletList.add(paymentType.getPaymentOption());
            try {
                WalletPGPayment walletPGPayment = new WalletPGPayment((PaymentType.SplitPayment)paymentType, walletList);
                this.walletPGCharge(walletPGPayment, callback);
            }
            catch (CitrusException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.pgPayment(new PaymentType.PGPayment((PaymentType.SplitPayment)paymentType), callback);
            }
            catch (CitrusException e) {
                e.printStackTrace();
            }
        }
    }

    boolean validateLogin(Callback callback) {
        if (!this.isUserLoggedIn) {
            this.sendError(callback, new CitrusError("Have you Signed In? Token not found!!!", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean validatePaymentOptions(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        if (paymentOption != null && !this.validatePaymentOptionForMerchant(paymentOption, merchantPaymentOption)) {
            this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean preValidation(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        boolean isValid = false;
        isValid = this.validateLogin(callback);
        if (isValid) {
            isValid = this.validatePaymentOptions(paymentOption, merchantPaymentOption, callback);
            return isValid;
        }
        return false;
    }

    boolean updateOneTapPaymentOption(PaymentOption paymentOption, Callback callback) {
        if (!CitrusConfig.getInstance().isOneTapPaymentEnabled()) {
            return true;
        }
        if (!(paymentOption instanceof CardOption)) {
            return true;
        }
        if (((CardOption)paymentOption).getCardScheme() == CardOption.CardScheme.MAESTRO) {
            return true;
        }
        if (((CardOption)paymentOption).getCardCVV() != null) {
            return true;
        }
        if (this.getCVVOfFingerPrint((CardOption)paymentOption) == null) {
            this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
            return false;
        }
        ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint((CardOption)paymentOption));
        return true;
    }

    public void getPaymentDistribution(final Amount transactionAmount, final Callback<PaymentDistribution> callback) {
        this.getWallet(new Callback<List<PaymentOption>>(){

            @Override
            public void success(List<PaymentOption> paymentOptionList) {
                BigDecimal difference;
                BigDecimal amount2;
                BigDecimal amount1;
                MVCOption mvcOption = null;
                CitrusCash citrusCash = null;
                PaymentDistribution paymentDistribution = new PaymentDistribution();
                double transactionAmountInDouble = transactionAmount.getValueAsDouble();
                boolean isAmountCompleted = false;
                double mvcAmount = 0.0;
                double citrusCashAmount = 0.0;
                for (PaymentOption paymentOption : paymentOptionList) {
                    if (paymentOption instanceof MVCOption) {
                        mvcOption = (MVCOption)paymentOption;
                    }
                    if (!(paymentOption instanceof CitrusCash)) continue;
                    citrusCash = (CitrusCash)paymentOption;
                }
                if (mvcOption != null && mvcOption.getMaxBalance().getValueAsDouble() >= 1.0) {
                    if (transactionAmount.getValueAsDouble() <= mvcOption.getMaxBalance().getValueAsDouble()) {
                        mvcAmount = transactionAmount.getValueAsDouble();
                        isAmountCompleted = true;
                    } else {
                        mvcAmount = mvcOption.getMaxBalanceRounded().getValueAsDouble();
                    }
                    amount1 = BigDecimal.valueOf(transactionAmountInDouble);
                    amount2 = BigDecimal.valueOf(mvcAmount);
                    difference = amount1.subtract(amount2);
                    transactionAmountInDouble = difference.doubleValue();
                    mvcOption.setTransactionAmount(new Amount(String.valueOf(mvcAmount)));
                    paymentDistribution.setMVCAvailable(true);
                    paymentDistribution.setMvcAmount(new Amount(String.valueOf(mvcAmount)));
                }
                if (!isAmountCompleted && citrusCash != null && citrusCash.getMaxBalance().getValueAsDouble() >= 1.0) {
                    if (transactionAmountInDouble <= citrusCash.getMaxBalance().getValueAsDouble()) {
                        citrusCashAmount = transactionAmountInDouble;
                        isAmountCompleted = true;
                    } else {
                        citrusCashAmount = citrusCash.getMaxBalanceRounded().getValueAsDouble();
                    }
                    amount1 = BigDecimal.valueOf(transactionAmountInDouble);
                    amount2 = BigDecimal.valueOf(citrusCashAmount);
                    difference = amount1.subtract(amount2);
                    transactionAmountInDouble = difference.doubleValue();
                    citrusCash.setTransactionAmount(new Amount(String.valueOf(citrusCashAmount)));
                    paymentDistribution.setCitrusCashAvailable(true);
                    paymentDistribution.setCitrusCashAmount(new Amount(String.valueOf(citrusCashAmount)));
                }
                if (!isAmountCompleted) {
                    paymentDistribution.setOthePaymentOptionAvailable(true);
                    paymentDistribution.setOtherPaymentOptionAmount(new Amount(String.valueOf(transactionAmountInDouble)));
                }
                CitrusClient.this.sendResponse(callback, paymentDistribution);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public void getActiveSubscriptions(final Callback<SubscriptionResponse> callback) {
        this.retrofitAPIWrapper.getActiveSubscriptions(new Callback<SubscriptionResponse>(){

            @Override
            public void success(SubscriptionResponse subscriptionResponse) {
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public void deActivateSubscription(final Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            @Override
            public void success(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Callback<SubscriptionResponse> responseCallback = new Callback<SubscriptionResponse>(){

                        @Override
                        public void success(SubscriptionResponse subscriptionResponse) {
                            CitrusClient.this.activeSubscription = null;
                            CitrusClient.this.sendResponse(callback, subscriptionResponse);
                        }

                        @Override
                        public void error(CitrusError error) {
                            CitrusClient.this.sendError(callback, error);
                        }
                    };
                    CitrusClient.this.retrofitAPIWrapper.deActivateSubscription(CitrusClient.this.activeSubscription.getSubscriptionId(), responseCallback);
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    private void createAutoLoadSubscription(final Callback callback, final TransactionResponse transactionResponse) {
        Callback<SubscriptionResponse> subscriptionResponseCallback = new Callback<SubscriptionResponse>(){

            @Override
            public void success(SubscriptionResponse subscriptionResponse) {
                subscriptionResponse.setTransactionResponse(transactionResponse);
                subscriptionResponse.setSubscriptionResponseMessage("Auto Load Subscription created Successfully.");
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.subscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.subscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendError(callback, error);
            }
        };
        this.retrofitAPIWrapper.createAutoLoadSubscription(this.subscriptionRequest, subscriptionResponseCallback);
    }

    private void updateAutoLoadSubscriptiontoHigherValue(final Callback callback, final TransactionResponse transactionResponse) {
        Callback<SubscriptionResponse> subscriptionResponseCallback = new Callback<SubscriptionResponse>(){

            @Override
            public void success(SubscriptionResponse subscriptionResponse) {
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.updateSubscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                subscriptionResponse.setTransactionResponse(transactionResponse);
                subscriptionResponse.setSubscriptionResponseMessage("Auto Load Subscription Updated Successfully.");
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.updateSubscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendError(callback, error);
            }
        };
        this.retrofitAPIWrapper.updateSubScriptiontoHigherValue(this.updateSubscriptionRequest, subscriptionResponseCallback);
    }

    public void isActiveSubscriptionPresent(final Callback<Boolean> callback) {
        if (this.activeSubscription != null) {
            callback.success(true);
        } else {
            this.retrofitAPIWrapper.getActiveSubscriptions(new Callback<SubscriptionResponse>(){

                @Override
                public void success(SubscriptionResponse subscriptionResponses) {
                    if (subscriptionResponses != null) {
                        CitrusClient.this.activeSubscription = subscriptionResponses;
                        callback.success(true);
                    } else {
                        callback.success(false);
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusClient.this.sendError(callback, error);
                }
            });
        }
    }

    public synchronized void autoLoadMoney(final PaymentType.LoadMoney loadMoney, final Amount thresholdAmount, final Amount loadAmount, final Callback<SubscriptionResponse> callback) throws CitrusException {
        if (thresholdAmount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (loadAmount == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (loadAmount.compareTo(thresholdAmount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d = new Double("500");
        if (thresholdAmount.getValueAsDouble() < d) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d2 = new Double("500");
        if (loadAmount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        final PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(Constants.AUTO_LOAD_CARD_SCHEMS).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            @Override
            public void success(Boolean isAcitive) {
                if (!isAcitive.booleanValue()) {
                    CitrusClient.this.getBINDetails((CardOption)paymentOption, new Callback<BinServiceResponse>(){

                        @Override
                        public void success(BinServiceResponse binServiceResponse) {
                            if (binServiceResponse.getCardType().contains("Credit")) {
                                CitrusClient.this.mAUTO_load_type = AUTO_LOAD_TYPE.QUICK_AUTO_LOAD;
                                CitrusClient.this.createAutoLoadRequest(paymentOption);
                                CitrusClient.this.subscriptionRequest.setLoadAmount(loadAmount.getValue());
                                CitrusClient.this.subscriptionRequest.setThresholdAmount(thresholdAmount.getValue());
                                Callback<TransactionResponse> responseCallback = new Callback<TransactionResponse>(){

                                    @Override
                                    public void success(TransactionResponse transactionResponse) {
                                        CitrusClient.this.createAutoLoadSubscription(callback, transactionResponse);
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                };
                                CitrusClient.this.simpliPay(loadMoney, responseCallback);
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
                            }
                        }

                        @Override
                        public void error(CitrusError error) {
                            CitrusClient.this.mAUTO_load_type = AUTO_LOAD_TYPE.QUICK_AUTO_LOAD;
                            CitrusClient.this.createAutoLoadRequest(paymentOption);
                            CitrusClient.this.subscriptionRequest.setLoadAmount(loadAmount.getValue());
                            CitrusClient.this.subscriptionRequest.setThresholdAmount(thresholdAmount.getValue());
                            Callback<TransactionResponse> responseCallback = new Callback<TransactionResponse>(){

                                @Override
                                public void success(TransactionResponse transactionResponse) {
                                    CitrusClient.this.createAutoLoadSubscription(callback, transactionResponse);
                                }

                                @Override
                                public void error(CitrusError error) {
                                    CitrusClient.this.sendError(callback, error);
                                }
                            };
                            CitrusClient.this.simpliPay(loadMoney, responseCallback);
                        }
                    });
                } else {
                    CitrusError citrusError = new CitrusError("Active subscription already exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public synchronized void autoLoadMoney(Amount thresholdAmount, Amount loadAmount, Callback<SubscriptionResponse> callback) throws CitrusException {
        if (thresholdAmount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (loadAmount == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (loadAmount.compareTo(thresholdAmount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d = new Double("500");
        if (thresholdAmount.getValueAsDouble() < d) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d2 = new Double("500");
        if (loadAmount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        if (this.subscriptionRequest == null) {
            this.sendError(callback, new CitrusError("Could not create active subscription.", CitrusResponse.Status.FAILED));
        } else {
            this.subscriptionRequest.setLoadAmount(loadAmount.getValue());
            this.subscriptionRequest.setThresholdAmount(thresholdAmount.getValue());
            this.createAutoLoadSubscription(callback, null);
        }
    }

    private void createAutoLoadRequest(PaymentOption paymentOption) {
        if (paymentOption instanceof CreditCardOption && Arrays.asList(Constants.AUTO_LOAD_CARD_SCHEMS).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            if (this.subscriptionRequest == null) {
                if (paymentOption.isTokenizedPayment()) {
                    this.subscriptionRequest = new SubscriptionRequest(paymentOption.getToken());
                } else {
                    CardOption cardOption = (CardOption)paymentOption;
                    String holder = null;
                    holder = this.getCitrusUser() != null ? (!TextUtils.isEmpty((CharSequence)this.getCitrusUser().getFirstName()) ? this.getCitrusUser().getFirstName() : Utils.getMaskedCardNumber(cardOption.getCardNumber())) : Utils.getMaskedCardNumber(cardOption.getCardNumber());
                    this.subscriptionRequest = new SubscriptionRequest(cardOption.getCardNumber(), cardOption.getCardExpiry(), holder);
                }
            }
        } else {
            this.subscriptionRequest = null;
            this.mAUTO_load_type = null;
        }
    }

    public void isAutoLoadAvailable(final Callback<Boolean> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            @Override
            public void success(Boolean aBoolean) {
                if (!aBoolean.booleanValue()) {
                    if (CitrusClient.this.mAUTO_load_type != null && CitrusClient.this.mAUTO_load_type == AUTO_LOAD_TYPE.LAZY_AUTO_LOAD) {
                        callback.success(true);
                    } else {
                        callback.success(false);
                    }
                } else {
                    callback.success(false);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    public void updateSubScriptiontoLoweValue(final Amount thresholdAmount, final Amount autoloadAmount, final Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            @Override
            public void success(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Callback<SubscriptionResponse> subscriptionResponseCallback = new Callback<SubscriptionResponse>(){

                        @Override
                        public void success(SubscriptionResponse subscriptionResponse) {
                            CitrusClient.this.activeSubscription = subscriptionResponse;
                            CitrusClient.this.sendResponse(callback, subscriptionResponse);
                        }

                        @Override
                        public void error(CitrusError error) {
                            if (TextUtils.equals((CharSequence)error.getMessage(), (CharSequence)"authRefId field is required")) {
                                CitrusError citrusError = new CitrusError("Load Amount should be less than current Load Amount.", CitrusResponse.Status.FAILED);
                                CitrusClient.this.sendError(callback, citrusError);
                            } else {
                                CitrusClient.this.sendError(callback, error);
                            }
                        }
                    };
                    UpdateSubscriptionRequest updateSubscriptionRequest = null;
                    try {
                        updateSubscriptionRequest = new UpdateSubscriptionRequest(CitrusClient.this.activeSubscription.getSubscriptionId(), autoloadAmount, thresholdAmount);
                        CitrusClient.this.retrofitAPIWrapper.updateSubScriptiontoLowerValue(updateSubscriptionRequest, subscriptionResponseCallback);
                    }
                    catch (CitrusException e) {
                        CitrusClient.this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
                    }
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError error) {
                callback.error(error);
            }
        });
    }

    public void updateSubscriptiontoHigherValue(final PaymentType.LoadMoney loadMoney, final Amount thresholdAmount, final Amount autoloadAmount, final Callback<SubscriptionResponse> callback) throws CitrusException {
        if (thresholdAmount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (autoloadAmount == null) {
            throw new CitrusException("Auto Load amount should not be null or empty.");
        }
        if (autoloadAmount.compareTo(thresholdAmount) < 0) {
            throw new CitrusException("Auto Load amount should not be less than ThresHold amount.");
        }
        Double d = new Double("500");
        if (thresholdAmount.getValueAsDouble() < d) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d2 = new Double("500");
        if (autoloadAmount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(Constants.AUTO_LOAD_CARD_SCHEMS).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            @Override
            public void success(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    Amount currentThresholdAmount = new Amount(String.valueOf(CitrusClient.this.activeSubscription.getThresholdAmount()));
                    if (thresholdAmount.compareTo(currentThresholdAmount) < 0) {
                        CitrusClient.this.sendError(callback, new CitrusError("Threshold amount is less than current active threshold amount", CitrusResponse.Status.FAILED));
                        return;
                    }
                    Amount currentLoadAmount = new Amount(String.valueOf(CitrusClient.this.activeSubscription.getLoadAmount()));
                    if (autoloadAmount.compareTo(currentLoadAmount) < 0) {
                        CitrusClient.this.sendError(callback, new CitrusError("Auto load amount is less than current active auto load amount", CitrusResponse.Status.FAILED));
                        return;
                    }
                    CitrusClient.this.getBINDetails((CardOption)loadMoney.getPaymentOption(), new Callback<BinServiceResponse>(){

                        @Override
                        public void success(BinServiceResponse binServiceResponse) {
                            if (binServiceResponse.getCardType().contains("Credit")) {
                                try {
                                    CitrusClient.this.updateSubscriptionRequest = new UpdateSubscriptionRequest(CitrusClient.this.activeSubscription.getSubscriptionId(), autoloadAmount, thresholdAmount);
                                    CitrusClient.this.mAUTO_load_type = AUTO_LOAD_TYPE.UPDATE_AUTO_LOAD;
                                    Callback<TransactionResponse> responseCallback = new Callback<TransactionResponse>(){

                                        @Override
                                        public void success(TransactionResponse transactionResponse) {
                                            CitrusClient.this.updateAutoLoadSubscriptiontoHigherValue(callback, transactionResponse);
                                        }

                                        @Override
                                        public void error(CitrusError error) {
                                            CitrusClient.this.sendError(callback, error);
                                        }
                                    };
                                    CitrusClient.this.simpliPay(loadMoney, responseCallback);
                                }
                                catch (CitrusException e) {
                                    CitrusClient.this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
                                }
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
                            }
                        }

                        @Override
                        public void error(CitrusError error) {
                            try {
                                CitrusClient.this.updateSubscriptionRequest = new UpdateSubscriptionRequest(CitrusClient.this.activeSubscription.getSubscriptionId(), autoloadAmount, thresholdAmount);
                                CitrusClient.this.mAUTO_load_type = AUTO_LOAD_TYPE.UPDATE_AUTO_LOAD;
                                Callback<TransactionResponse> responseCallback = new Callback<TransactionResponse>(){

                                    @Override
                                    public void success(TransactionResponse transactionResponse) {
                                        CitrusClient.this.updateAutoLoadSubscriptiontoHigherValue(callback, transactionResponse);
                                    }

                                    @Override
                                    public void error(CitrusError error) {
                                        CitrusClient.this.sendError(callback, error);
                                    }
                                };
                                CitrusClient.this.simpliPay(loadMoney, responseCallback);
                            }
                            catch (CitrusException e) {
                                CitrusClient.this.sendError(callback, new CitrusError(e.getMessage(), CitrusResponse.Status.FAILED));
                            }
                        }
                    });
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusClient.this.sendError(callback, error);
            }
        });
    }

    static {
        isCitrusNativeLibraryLoaded = false;
        isFacebookNativeLibraryLoaded = false;
    }

    public static enum AUTO_LOAD_TYPE {
        QUICK_AUTO_LOAD,
        UPDATE_AUTO_LOAD,
        LAZY_AUTO_LOAD;

    }
}

