/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import com.citrus.cash.PersistentConfig;
import com.citrus.library.R;
import com.citrus.sdk.BlazeWrapper;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.WalletPGPayment;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BCCancelResponse;
import com.citrus.sdk.classes.BCCancelTransactionDetails;
import com.citrus.sdk.classes.BCResponse;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.otp.OTPPopupView;
import com.citrus.sdk.otp.OTPViewListener;
import com.citrus.sdk.otp.SMSReceiver;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentData;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.views.CitrusProgressBar;
import com.citrus.sdk.walletpg.WalletPGPaymentResponse;
import com.orhanobut.logger.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CitrusActivity
extends AppCompatActivity
implements OTPViewListener {
    private final int WAIT_TIME = 300;
    private final String WAIT_MESSAGE = "Processing Payment. Please Wait...";
    private final String CANCEL_MESSAGE = "Cancelling Transaction. Please Wait...";
    private WebView mPaymentWebview = null;
    private Context mContext = this;
    private PaymentType mPaymentType = null;
    private PaymentOption mPaymentOption = null;
    private List<PaymentOption> mPaymentOptionList = null;
    private String mTransactionId = null;
    private ActionBar mActionBar = null;
    private CitrusProgressBar mProgressBar = null;
    private String mColorPrimary = null;
    private String mColorPrimaryDark = null;
    private String mTextColorPrimary = null;
    private CitrusConfig mCitrusConfig = null;
    private CitrusUser mCitrusUser = null;
    private String sessionCookie;
    private CookieManager cookieManager;
    private String mpiServletUrl = null;
    private Map<String, String> customParametersOriginalMap = null;
    private CitrusClient mCitrusClient = null;
    private String mActivityTitle = null;
    private int mRequestCode = -1;
    private CountDownTimer mTimer = null;
    private boolean mLoading = false;
    private boolean mShowingDialog = false;
    private boolean isBackKeyPressedByUser = false;
    private DynamicPricingResponse mDynamicPricingResponse = null;
    private PaymentBill mPaymentBill = null;
    private SMSReceiver mSMSReceiver = null;
    private BroadcastReceiver mAutoOtpSMSReceiveListener = null;
    private OTPPopupView mOTPPopupView = null;
    private String otpProcessTransactionJS = null;
    private ImageView otpPopupCancelImgView = null;
    private boolean autoOTPEnabled = false;
    private NetBankForOTP netBankForOTP = NetBankForOTP.UNKNOWN;
    private String country = null;
    private String binCardType = null;
    private String otp;
    private static final long OTP_READ_TIMEOUT = 45000L;
    private boolean transactionProcessed = false;
    private boolean mMultipartSendOTPJS = false;
    private boolean mMultipartEnterPasswordJS = false;
    private boolean useNewAPI = false;
    private boolean otpPopupDismissed = false;
    private boolean autoReadOTP = false;
    private boolean isCardUnRegistered = false;
    private Environment mEnvironment;
    private boolean mSMSReceiverRegistered = false;
    private BlazePayments mBlazePayments = null;
    private BCCancelTransactionDetails mBCCancelTransactionDetails = null;

    protected void onCreate(Bundle savedInstanceState) {
        this.mPaymentType = (PaymentType)this.getIntent().getParcelableExtra("INTENT_EXTRA_PAYMENT_TYPE");
        this.mRequestCode = this.getIntent().getIntExtra("INTENT_EXTRA_REQUEST_CODE_PAYMENT", -1);
        this.useNewAPI = this.getIntent().getBooleanExtra("INTENT_EXTRA_USE_NEW_API", false);
        this.mCitrusClient = CitrusClient.getInstance(this.mContext);
        this.mEnvironment = this.mCitrusClient.getEnvironment();
        this.autoOTPEnabled = this.mCitrusClient.isAutoOtpReading();
        if (this.mPaymentType instanceof PaymentType.PGPayment || this.mPaymentType instanceof PaymentType.LoadMoney) {
            this.setTheme(R.style.Base_Theme_AppCompat_Light_DarkActionBar);
        } else if (this.mPaymentType instanceof WalletPGPayment && !((WalletPGPayment)this.mPaymentType).isWalletOnlyPayment()) {
            this.setTheme(R.style.Base_Theme_AppCompat_Light_DarkActionBar);
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_citrus);
        this.mOTPPopupView = (OTPPopupView)this.findViewById(R.id.otpPopupViewId);
        this.otpPopupCancelImgView = (ImageView)this.findViewById(R.id.otpPopupCancelImgViewId);
        this.otpPopupCancelImgView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CitrusActivity.this.mOTPPopupView.getOtpViewToggleStatus()) {
                    CitrusActivity.this.mOTPPopupView.setVisibility(0);
                    CitrusActivity.this.mOTPPopupView.setOtpViewToggleStatus(false);
                    CitrusActivity.this.otpPopupCancelImgView.setBackgroundResource(R.drawable.arrow_down_icon);
                    CitrusActivity.this.findViewById(R.id.otpPopupSeparatorId).setVisibility(0);
                    CitrusActivity.this.findViewById(R.id.otpPopupOverlayId).setVisibility(0);
                } else {
                    CitrusActivity.this.mOTPPopupView.setVisibility(8);
                    CitrusActivity.this.mOTPPopupView.setOtpViewToggleStatus(true);
                    CitrusActivity.this.otpPopupCancelImgView.setBackgroundResource(R.drawable.arrow_up_icon);
                    CitrusActivity.this.findViewById(R.id.otpPopupSeparatorId).setVisibility(8);
                    CitrusActivity.this.findViewById(R.id.otpPopupOverlayId).setVisibility(8);
                }
            }
        });
        this.mOTPPopupView.setListener(this);
        this.mSMSReceiver = new SMSReceiver();
        this.mAutoOtpSMSReceiveListener = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CitrusActivity.this.autoOtpReceived(intent);
            }
        };
        this.mDynamicPricingResponse = (DynamicPricingResponse)this.getIntent().getParcelableExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE");
        this.mCitrusConfig = CitrusConfig.getInstance();
        this.mActivityTitle = this.mCitrusConfig.getCitrusActivityTitle();
        this.initializeTimer();
        if (this.mPaymentType != null) {
            this.mPaymentOption = this.mPaymentType.getPaymentOption();
            this.mCitrusUser = this.mPaymentType.getCitrusUser();
            this.mColorPrimary = this.mCitrusConfig.getColorPrimary();
            this.mColorPrimaryDark = this.mCitrusConfig.getColorPrimaryDark();
            this.mTextColorPrimary = this.mCitrusConfig.getTextColorPrimary();
            if (this.mPaymentType instanceof WalletPGPayment) {
                this.mPaymentOptionList = this.mPaymentType.getPaymentOptionList();
                this.mPaymentOption = ((WalletPGPayment)this.mPaymentType).getOtherPaymentOption();
            }
        } else {
            throw new IllegalArgumentException("Payment Type Should not be null");
        }
        this.registerSMSReceivers();
        final CitrusUser citrusUser = this.mCitrusClient.getCitrusUser();
        if (this.mPaymentType instanceof PaymentType.LoadMoney || this.mPaymentType instanceof PaymentType.CitrusCash || this.mPaymentType instanceof WalletPGPayment) {
            if (citrusUser != null) {
                this.mCitrusUser = citrusUser;
            } else if (this.mCitrusUser == null) {
                this.mCitrusUser = CitrusUser.DEFAULT_USER;
            }
        } else if (this.mPaymentType instanceof PaymentType.PGPayment && this.mCitrusUser == null) {
            this.mCitrusUser = citrusUser != null ? citrusUser : CitrusUser.DEFAULT_USER;
        }
        this.mActionBar = this.getSupportActionBar();
        this.mProgressBar = new CitrusProgressBar(this.mContext);
        this.mPaymentWebview = (WebView)this.findViewById(R.id.payment_webview);
        this.mPaymentWebview.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        this.mPaymentWebview.getSettings().setJavaScriptEnabled(true);
        if (this.mPaymentOption instanceof NetbankingOption) {
            this.useNewAPI = false;
            NetbankingOption netbankingOption = (NetbankingOption)this.mPaymentOption;
            if ("CID032".equalsIgnoreCase(netbankingOption.getBankCID()) || "CID029".equalsIgnoreCase(netbankingOption.getBankCID()) || "CID066".equalsIgnoreCase(netbankingOption.getBankCID()) || "CID051".equalsIgnoreCase(netbankingOption.getBankCID())) {
                this.mPaymentWebview.getSettings().setUseWideViewPort(true);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mPaymentWebview.getSettings().setMixedContentMode(0);
        }
        this.mPaymentWebview.addJavascriptInterface((Object)new JsInterface(), "CitrusResponse");
        this.mPaymentWebview.setWebChromeClient(new WebChromeClient());
        this.mPaymentWebview.setWebViewClient((WebViewClient)new CitrusWebClient());
        if (this.mPaymentType instanceof PaymentType.CitrusCash || this.mPaymentType instanceof WalletPGPayment && ((WalletPGPayment)this.mPaymentType).isWalletOnlyPayment()) {
            this.mPaymentWebview.setVisibility(8);
        }
        if ((this.autoOTPEnabled || CitrusConfig.getInstance().isOneTapPaymentEnabled()) && this.mPaymentOption instanceof CardOption) {
            this.fetchBinRequestData((CardOption)this.mPaymentOption);
        }
        if (this.mRequestCode == 10000 && this.mPaymentOption instanceof CardOption && !((CardOption)this.mPaymentOption).validateCard()) {
            this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, ((CardOption)this.mPaymentOption).getCardValidityFailureReasons(), null));
            return;
        }
        if (this.mPaymentType instanceof PaymentType.PGPayment || this.mPaymentType instanceof PaymentType.CitrusCash || this.mPaymentType instanceof WalletPGPayment) {
            if (this.mPaymentType.getPaymentBill() != null) {
                this.mPaymentBill = this.mPaymentType.getPaymentBill();
                this.proceedToPayment(this.mPaymentBill);
            } else {
                if (this.mCitrusClient.isShowDummyScreenWhilePayments()) {
                    this.mPaymentWebview.loadData("<html><body><h5><center>Processing, please wait...<center></h5></body></html>", "text/html", "utf-8");
                }
                this.showDialog("Processing Payment. Please Wait...", true);
                this.fetchBill();
            }
        } else {
            Amount amount = this.mPaymentType.getAmount();
            this.showDialog("Processing Payment. Please Wait...", true);
            this.mCitrusClient.getPrepaidBill(amount, this.mPaymentType.getUrl(), new Callback<CitrusPrepaidBill>(){

                @Override
                public void success(CitrusPrepaidBill citrusPrepaidBill) {
                    SubscriptionRequest subscriptionRequest;
                    PaymentData paymentData = new PaymentData(citrusPrepaidBill, CitrusActivity.this.mPaymentOption, citrusUser);
                    if ((CitrusActivity.this.mCitrusClient.getAUTO_load_type() == CitrusClient.AUTO_LOAD_TYPE.QUICK_AUTO_LOAD || CitrusActivity.this.mCitrusClient.getAUTO_load_type() == CitrusClient.AUTO_LOAD_TYPE.LAZY_AUTO_LOAD) && (subscriptionRequest = CitrusActivity.this.mCitrusClient.getSubscriptionRequest()) != null) {
                        CitrusActivity.this.mCitrusClient.getSubscriptionRequest().setAuthRefId(citrusPrepaidBill.getMerchantTransactionId());
                    }
                    if (CitrusActivity.this.mCitrusClient.getAUTO_load_type() == CitrusClient.AUTO_LOAD_TYPE.UPDATE_AUTO_LOAD && CitrusActivity.this.mCitrusClient.getUpdateSubscriptionRequest() != null) {
                        CitrusActivity.this.mCitrusClient.getUpdateSubscriptionRequest().setAuthRefId(citrusPrepaidBill.getMerchantTransactionId());
                    }
                    if (CitrusActivity.this.isBlazePaymentAvailable()) {
                        if (CitrusActivity.this.mBlazePayments == BlazePayments.BlazeCard) {
                            CitrusActivity.this.makeBlazeCardLoadMoneyPayment(paymentData, CitrusActivity.this.mPaymentOption.isTokenizedPayment());
                        }
                    } else if (CitrusActivity.this.isSingleHopAvailable()) {
                        CitrusActivity.this.useNewAPI = true;
                        CitrusActivity.this.processNewMakePaymentTransaction(paymentData);
                    } else {
                        CitrusActivity.this.mCitrusClient.makeMOTOPayment(paymentData.getPaymentJSON(), new Callback<StructResponsePOJO>(){

                            @Override
                            public void success(StructResponsePOJO structResponsePOJO) {
                                CitrusActivity.this.openPaymentUrl(structResponsePOJO);
                            }

                            @Override
                            public void error(CitrusError error) {
                                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), null));
                            }
                        });
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), null));
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)this.mActivityTitle)) {
            this.mActivityTitle = "Processing...";
        }
        this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + this.mTextColorPrimary + "\">" + this.mActivityTitle + "</font>")));
        this.setActionBarBackground();
        this.enableWebContentDebugging();
    }

    protected void onResume() {
        super.onResume();
        this.registerSMSReceivers();
    }

    protected void onPause() {
        super.onPause();
        if (this.mAutoOtpSMSReceiveListener != null) {
            this.unregisterSMSReceivers();
        }
    }

    private void initializeTimer() {
        this.mTimer = new CountDownTimer(300L, 100L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (!CitrusActivity.this.mLoading) {
                    CitrusActivity.this.dismissDialog();
                    if (!(CitrusActivity.this.transactionProcessed || CitrusActivity.this.mMultipartEnterPasswordJS || CitrusActivity.this.isBackKeyPressedByUser || CitrusActivity.this.isCardUnRegistered)) {
                        CitrusActivity.this.displayOtpPopup();
                    }
                    if (CitrusActivity.this.mMultipartSendOTPJS) {
                        CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.netBankForOTP.getMultiPartSendOTPJS());
                        CitrusActivity.this.mMultipartSendOTPJS = false;
                    }
                    if (CitrusActivity.this.mMultipartEnterPasswordJS) {
                        CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.netBankForOTP.getMultiPartEnterPasswordJS());
                        CitrusActivity.this.mMultipartEnterPasswordJS = false;
                    }
                    CitrusActivity.this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + CitrusActivity.this.mTextColorPrimary + "\"> 3D Secure </font>")));
                }
            }
        };
    }

    @TargetApi(value=21)
    private void setActionBarBackground() {
        if (this.mColorPrimary != null && this.mActionBar != null) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.mColorPrimary)));
        }
        if (Build.VERSION.SDK_INT >= 21 && this.mColorPrimaryDark != null) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)this.mColorPrimaryDark));
        }
    }

    private void fetchBill() {
        String billUrl = this.mPaymentType.getUrl();
        String format = null;
        if (this.mPaymentType instanceof WalletPGPayment) {
            format = "#.00";
        }
        this.mCitrusClient.getBill(billUrl, this.mPaymentType.getAmount(), format, new Callback<PaymentBill>(){

            @Override
            public void success(PaymentBill paymentBill) {
                CitrusActivity.this.mPaymentBill = paymentBill;
                if (paymentBill != null) {
                    CitrusActivity.this.customParametersOriginalMap = paymentBill.getCustomParametersMap();
                    CitrusActivity.this.proceedToPayment(paymentBill);
                } else {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, "Invalid bill received from server.", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                }
            }

            @Override
            public void error(CitrusError error) {
                TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId);
                CitrusActivity.this.sendResult(transactionResponse);
            }
        });
    }

    private void openPaymentUrl(StructResponsePOJO structResponsePOJO) {
        String redirectUrl = structResponsePOJO.getRedirectUrl();
        if (!TextUtils.isEmpty((CharSequence)redirectUrl)) {
            this.mpiServletUrl = redirectUrl;
            this.mPaymentWebview.loadUrl(redirectUrl);
        } else {
            this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, structResponsePOJO.getTxMsg(), this.mTransactionId));
        }
    }

    private void openPaymentUrl(WalletPGPaymentResponse walletPGPaymentResponse) {
        String redirectUrl = walletPGPaymentResponse.getRedirectUrl();
        if (!TextUtils.isEmpty((CharSequence)redirectUrl)) {
            this.mpiServletUrl = redirectUrl;
            this.mPaymentWebview.loadUrl(redirectUrl);
        } else {
            this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, walletPGPaymentResponse.getDescription(), this.mTransactionId));
        }
    }

    private void proceedToPayment(PaymentBill paymentBill) {
        if (this.mPaymentType instanceof PaymentType.CitrusCash) {
            this.processPayUsingCitrusCashPayment(paymentBill);
        } else if (this.mPaymentType instanceof PaymentType.PGPayment) {
            if (this.useNewAPI) {
                this.processNewMakePaymentTransaction(paymentBill);
            } else {
                this.processMOTOTransaction(paymentBill);
            }
        } else if (this.mPaymentType instanceof WalletPGPayment) {
            this.processWalletPGTransaction(paymentBill);
        }
    }

    private boolean isBlazePaymentAvailable() {
        if (this.mPaymentOption instanceof CardOption) {
            if (CitrusConfig.getInstance().isBlazeCardEnabled() && Arrays.asList(BlazeWrapper.cardSchemes).contains(((CardOption)this.mPaymentOption).getCardScheme().toString())) {
                this.mBlazePayments = BlazePayments.BlazeCard;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSingleHopAvailable() {
        return false;
    }

    private void processWalletPGTransaction(PaymentBill paymentBill) {
        PaymentData paymentData = new PaymentData(paymentBill, this.mPaymentOptionList, this.mCitrusUser, this.mDynamicPricingResponse);
        this.mCitrusClient.makeWalletPGPayment(paymentData.getWalletPGPaymentJSON(), new Callback<WalletPGPaymentResponse>(){

            @Override
            public void success(WalletPGPaymentResponse walletPGPaymentResponse) {
                TransactionResponse.TransactionStatus transactionStatus = walletPGPaymentResponse.getTransactionStatus();
                if (transactionStatus == TransactionResponse.TransactionStatus.PG_FORWARD_REQUESTED) {
                    CitrusActivity.this.openPaymentUrl(walletPGPaymentResponse);
                } else if (transactionStatus == TransactionResponse.TransactionStatus.SUCCESSFUL) {
                    Utils.sendResponseToReturnUrlAsync(CitrusActivity.this.mContext, walletPGPaymentResponse.getRedirectUrl(), walletPGPaymentResponse.getURLEncodedParams());
                    CitrusActivity.this.sendResult(new TransactionResponse(transactionStatus, "Transaction Successful.", walletPGPaymentResponse.getTransactionId()));
                } else if (transactionStatus == TransactionResponse.TransactionStatus.FAILED) {
                    CitrusActivity.this.sendResult(new TransactionResponse(transactionStatus, walletPGPaymentResponse.getDescription(), walletPGPaymentResponse.getTransactionId()));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
            }
        });
    }

    private void processMOTOTransaction(PaymentBill paymentBill) {
        PaymentData paymentData = new PaymentData(paymentBill, this.mPaymentOption, this.mCitrusUser, this.mDynamicPricingResponse);
        this.mCitrusClient.makeMOTOPayment(paymentData.getPaymentJSON(), new Callback<StructResponsePOJO>(){

            @Override
            public void success(StructResponsePOJO structResponsePOJO) {
                CitrusActivity.this.openPaymentUrl(structResponsePOJO);
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
            }
        });
    }

    private void makeBlazeCardPayment(PaymentBill paymentBill) {
        final PaymentData paymentData = new PaymentData(paymentBill, this.mPaymentOption, this.mCitrusUser, this.mDynamicPricingResponse);
        this.mCitrusClient.makeBlazeCardPayment(paymentData.getPaymentJSON(), new Callback<BCResponse>(){

            @Override
            public void success(BCResponse bcResponse) {
                Logger.d((String)("RESPONSE **** ***" + bcResponse.toString()), (Object[])new Object[0]);
                int errorCode = bcResponse.getErrorCode();
                CitrusActivity.this.mBCCancelTransactionDetails = new BCCancelTransactionDetails(bcResponse, paymentData);
                if (errorCode == 0) {
                    String html = String.format("<html><head><title>Redirecting to Bank</title></head><body>%s</body><script type=\"text/javascript\">document.citrusSubmitForm.submit();</script></html>", bcResponse.getInfo().getCitrusSubmitForm());
                    CitrusActivity.this.mPaymentWebview.loadData(html, "text/html", "utf-8");
                } else {
                    CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, bcResponse.getErrorMessage(), CitrusActivity.this.mTransactionId));
                }
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
            }
        });
    }

    private void makeBlazeCardLoadMoneyPayment(final PaymentData paymentData, boolean isTokenizedPayment) {
        if (isTokenizedPayment) {
            this.mCitrusClient.makeBlazeCardTokenizedPayment(paymentData.getPaymentJSON(), new Callback<BCResponse>(){

                @Override
                public void success(BCResponse bcResponse) {
                    Logger.d((String)("RESPONSE **** ***" + bcResponse.toString()), (Object[])new Object[0]);
                    int errorCode = bcResponse.getErrorCode();
                    CitrusActivity.this.mBCCancelTransactionDetails = new BCCancelTransactionDetails(bcResponse, paymentData);
                    if (errorCode == 0) {
                        String html = String.format("<html><head><title>Redirecting to Bank</title></head><body>%s</body><script type=\"text/javascript\">document.citrusSubmitForm.submit();</script></html>", bcResponse.getInfo().getCitrusSubmitForm());
                        CitrusActivity.this.mPaymentWebview.loadData(html, "text/html", "utf-8");
                    } else {
                        CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, bcResponse.getErrorMessage(), CitrusActivity.this.mTransactionId));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
                }
            });
        } else {
            this.mCitrusClient.makeBlazeCardPayment(paymentData.getPaymentJSON(), new Callback<BCResponse>(){

                @Override
                public void success(BCResponse bcResponse) {
                    Logger.d((String)("RESPONSE **** ***" + bcResponse.toString()), (Object[])new Object[0]);
                    int errorCode = bcResponse.getErrorCode();
                    CitrusActivity.this.mBCCancelTransactionDetails = new BCCancelTransactionDetails(bcResponse, paymentData);
                    if (errorCode == 0) {
                        String html = String.format("<html><head><title>Redirecting to Bank</title></head><body>%s</body><script type=\"text/javascript\">document.citrusSubmitForm.submit();</script></html>", bcResponse.getInfo().getCitrusSubmitForm());
                        CitrusActivity.this.mPaymentWebview.loadData(html, "text/html", "utf-8");
                    } else {
                        CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, bcResponse.getErrorMessage(), CitrusActivity.this.mTransactionId));
                    }
                }

                @Override
                public void error(CitrusError error) {
                    CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
                }
            });
        }
    }

    private void processNewMakePaymentTransaction(PaymentBill paymentBill) {
        PaymentData paymentData = new PaymentData(paymentBill, this.mPaymentOption, this.mCitrusUser, this.mDynamicPricingResponse);
        this.mCitrusClient.newMakePayment(paymentData.getPaymentJSON(), new Callback<String>(){

            @Override
            public void success(String bankHTML) {
                CitrusActivity.this.mPaymentWebview.loadDataWithBaseURL(CitrusActivity.this.mCitrusClient.getEnvironment().getBaseCitrusUrl(), bankHTML, "text/html", "utf-8", null);
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
            }
        });
    }

    private void processNewMakePaymentTransaction(PaymentData paymentData) {
        this.mCitrusClient.newMakePayment(paymentData.getPaymentJSON(), new Callback<String>(){

            @Override
            public void success(String bankHTML) {
                CitrusActivity.this.mPaymentWebview.loadDataWithBaseURL(CitrusActivity.this.mCitrusClient.getEnvironment().getBaseCitrusUrl(), bankHTML, "text/html", "utf-8", null);
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId));
            }
        });
    }

    private void processPayUsingCitrusCashPayment(PaymentBill paymentBill) {
        Amount amount = paymentBill.getAmount();
        CitrusCash citrusCashOption = new CitrusCash(amount, this.mCitrusUser);
        PaymentData paymentData = new PaymentData(paymentBill, citrusCashOption, this.mCitrusUser, this.mDynamicPricingResponse);
        this.mCitrusClient.makeMOTOPayment(paymentData.getPaymentJSON(), new Callback<StructResponsePOJO>(){

            @Override
            public void success(StructResponsePOJO structResponsePOJO) {
                CitrusActivity.this.setCookie();
                CitrusActivity.this.openPaymentUrl(structResponsePOJO);
            }

            @Override
            public void error(CitrusError error) {
                CitrusActivity.this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), null));
            }
        });
    }

    private void showDialog(String message, boolean cancelable) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setMessage(message);
            this.mProgressBar.show();
            this.mProgressBar.setCanceledOnTouchOutside(false);
            this.mProgressBar.setCancelable(cancelable);
            this.mShowingDialog = true;
        }
    }

    private void dismissDialog() {
        if (this.mProgressBar != null) {
            this.mProgressBar.dismiss();
            this.mShowingDialog = false;
        }
    }

    private void registerSMSReceivers() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption && this.mEnvironment == Environment.PRODUCTION) {
            Logger.d((String)"Registering SMS receivers", (Object[])new Object[0]);
            this.mSMSReceiverRegistered = true;
            if (this.mSMSReceiver == null) {
                this.mSMSReceiver = new SMSReceiver();
            }
            if (this.mAutoOtpSMSReceiveListener == null) {
                this.mAutoOtpSMSReceiveListener = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        CitrusActivity.this.autoOtpReceived(intent);
                    }
                };
            }
            IntentFilter intentFilter = new IntentFilter("android.provider.Telephony.SMS_RECEIVED");
            intentFilter.setPriority(999);
            this.registerReceiver(this.mSMSReceiver, intentFilter);
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mAutoOtpSMSReceiveListener, new IntentFilter("com.citrus.sdk.otp.AUTO_READ_OTP"));
        }
    }

    private void unregisterSMSReceivers() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption && this.mSMSReceiverRegistered) {
            Logger.d((String)"Unregistering SMS receivers", (Object[])new Object[0]);
            if (this.mSMSReceiver != null) {
                this.unregisterReceiver(this.mSMSReceiver);
                this.mSMSReceiverRegistered = false;
                this.mSMSReceiver = null;
            }
            if (this.mAutoOtpSMSReceiveListener != null) {
                LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mAutoOtpSMSReceiveListener);
                this.mAutoOtpSMSReceiveListener = null;
            }
        }
    }

    private void autoOtpReceived(Intent intent) {
        this.otp = intent.getStringExtra("INTENT_EXTRA_AUTO_OTP");
        if (!TextUtils.isEmpty((CharSequence)this.otp)) {
            this.otpProcessTransactionJS = String.format(this.netBankForOTP.getTransactionJS(), this.otp);
            this.unregisterSMSReceivers();
            this.autoReadOTP = true;
            if (!this.otpPopupDismissed) {
                this.mOTPPopupView.setOTP(this.otp);
            }
        }
    }

    private void displayOtpPopup() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption && this.netBankForOTP != NetBankForOTP.UNKNOWN && this.mEnvironment == Environment.PRODUCTION) {
            this.getWindow().addFlags(128);
            this.findViewById(R.id.otpPopupOverlayId).setVisibility(0);
            this.findViewById(R.id.otp_popup_layout).setVisibility(0);
            if (this.netBankForOTP.isBypassEnterPasswordButton()) {
                this.mOTPPopupView.enableEnterPasswordButton(false);
            }
            if (this.netBankForOTP.isBypassSendOTPButton()) {
                this.mOTPPopupView.displayOtpAutoDetectPopup();
                this.startOtpReadTimer();
            }
        }
    }

    private void dismissOtpPopup() {
        this.findViewById(R.id.otpPopupOverlayId).setVisibility(8);
        this.findViewById(R.id.otp_popup_layout).setVisibility(8);
        this.otpPopupDismissed = true;
    }

    private void fetchBinRequestData(CardOption cardOption) {
        this.mCitrusClient.getBINDetails(cardOption, new Callback<BinServiceResponse>(){

            @Override
            public void success(BinServiceResponse binServiceResponse) {
                CitrusActivity.this.netBankForOTP = binServiceResponse.getNetBankForOTP();
                CitrusActivity.this.country = binServiceResponse.getCountry();
                CitrusActivity.this.binCardType = binServiceResponse.getCardType();
                Logger.d((String)("netbankForOTP : " + (Object)((Object)CitrusActivity.this.netBankForOTP)), (Object[])new Object[0]);
                CitrusActivity.this.mOTPPopupView.setNetBankForOTP(CitrusActivity.this.netBankForOTP);
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }

    private void enableWebContentDebugging() {
        this.mPaymentWebview.setEnabled(true);
        if (Build.VERSION.SDK_INT >= 19 && 0 != (this.getApplicationInfo().flags &= 2)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    public void onBackPressed() {
        this.handleCancelTransaction();
    }

    private void handleCancelTransaction() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                CitrusActivity.this.isBackKeyPressedByUser = true;
                CitrusActivity.this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + CitrusActivity.this.mTextColorPrimary + "\"> Cancelling... </font>")));
                if (CitrusActivity.this.useNewAPI || CitrusActivity.this.mPaymentType instanceof WalletPGPayment) {
                    String vanity = CitrusActivity.this.mCitrusClient.getVanity();
                    String postData = Utils.getURLEncodedParamsForCancelTransaction(CitrusActivity.this.mCitrusUser, CitrusActivity.this.mPaymentBill, CitrusActivity.this.mPaymentOption, CitrusActivity.this.mDynamicPricingResponse, vanity);
                    Environment environment = CitrusActivity.this.mCitrusClient.getEnvironment();
                    CitrusActivity.this.mPaymentWebview.postUrl(environment.getCancelUrl(vanity), postData.getBytes());
                    CitrusActivity.this.dismissOtpPopup();
                } else if (CitrusActivity.this.mBlazePayments != null) {
                    if (CitrusActivity.this.mBlazePayments == BlazePayments.BlazeCard) {
                        String cancelTransactionJSON = CitrusActivity.this.mBCCancelTransactionDetails.getPaymentData().getBCCancelJSON(CitrusActivity.this.mBCCancelTransactionDetails.getBCResponse().getCitrusTransactionId());
                        CitrusActivity.this.mCitrusClient.cancelBCTransaction(cancelTransactionJSON, new Callback<BCCancelResponse>(){

                            @Override
                            public void success(BCCancelResponse bcCancelResponse) {
                                Logger.d((String)"BC CANCEL SUCCESS RESPONSE ***", (Object[])new Object[]{bcCancelResponse.toString()});
                                String html = String.format("<html><head><title>Redirecting to Bank</title></head><body>%s</body><script type=\"text/javascript\">document.citrusReturnUrlForm.submit();</script></html>", bcCancelResponse.getInfo().getHtmlData());
                                CitrusActivity.this.mPaymentWebview.loadData(html, "text/html", "utf-8");
                            }

                            @Override
                            public void error(CitrusError error) {
                                Logger.d((String)"BC CANCEL RESPONSE ***", (Object[])new Object[]{error.getMessage()});
                            }
                        });
                    }
                } else if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash || !Utils.isNetworkConnected(CitrusActivity.this.mContext)) {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.CANCELLED, "Cancelled By User", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                } else {
                    CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.mpiServletUrl);
                    CitrusActivity.this.dismissOtpPopup();
                }
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        builder.setMessage((CharSequence)"Do you want to cancel the transaction?").setTitle((CharSequence)"Cancel Transaction?");
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    private void setCookie() {
        String baseUrl = this.mCitrusClient.getEnvironment().getBaseUrl();
        this.cookieManager = CookieManager.getInstance();
        this.sessionCookie = new PersistentConfig((Context)this).getCookieString();
        this.cookieManager.setCookie(baseUrl, this.sessionCookie);
    }

    private void removeCookies() {
        String baseUrl = this.mCitrusClient.getEnvironment().getBaseUrl();
        CookieManager.getInstance().setCookie(baseUrl, "prepaiduser-payauth=''");
    }

    private void sendResult(TransactionResponse transactionResponse) {
        if (!this.isFinishing()) {
            transactionResponse.setCountry(this.country);
            transactionResponse.setBinCardType(this.binCardType);
            Intent intent = new Intent();
            intent.putExtra("INTENT_EXTRA_TRANSACTION_RESPONSE", (Parcelable)transactionResponse);
            intent.setAction(this.mPaymentType.getIntentAction());
            if (this.mRequestCode != 10000) {
                LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
            }
            this.setResult(-1, intent);
            this.finish();
        }
    }

    protected void onStop() {
        super.onStop();
        this.dismissDialog();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPaymentWebview != null) {
            this.mPaymentWebview.stopLoading();
            this.mPaymentWebview.destroy();
        }
        this.mPaymentBill = null;
        this.mPaymentWebview = null;
        this.mPaymentType = null;
        this.mCitrusConfig = null;
        this.mCitrusUser = null;
        this.mTransactionId = null;
        this.dismissDialog();
        this.netBankForOTP = NetBankForOTP.UNKNOWN;
        this.mProgressBar = null;
        this.mPaymentOption = null;
        this.mActivityTitle = null;
        this.transactionProcessed = false;
        this.mMultipartSendOTPJS = false;
    }

    @Override
    public void onSendOtpClicked() {
        this.mMultipartSendOTPJS = this.netBankForOTP.isMultipartSendOTPJS();
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getSendOTPJS());
        this.mOTPPopupView.displayOtpAutoDetectPopup();
        this.startOtpReadTimer();
    }

    @Override
    public void onEnterPasswordClicked() {
        this.mMultipartEnterPasswordJS = this.netBankForOTP.isMultipartEnterPasswordJS();
        String enterPwdJS = this.netBankForOTP.getEnterPasswordJS();
        this.mPaymentWebview.loadUrl(enterPwdJS);
        this.dismissOtpPopup();
    }

    @Override
    public void onCancelClicked() {
        this.handleCancelTransaction();
    }

    @Override
    public void onProcessTransactionClicked(String otp) {
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getSetOTPJS(otp));
        String js = String.format(this.netBankForOTP.getTransactionJS(), otp);
        this.mPaymentWebview.loadUrl(js);
        this.transactionProcessed = true;
        this.dismissOtpPopup();
    }

    @Override
    public void onResendOTPClicked() {
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getReSendOTPJS());
        this.registerSMSReceivers();
        this.startOtpReadTimer();
        this.autoReadOTP = false;
    }

    @Override
    public void startOtpReadTimer() {
        this.mOTPPopupView.handleResendOTP();
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CitrusActivity.this.unregisterSMSReceivers();
                if (!CitrusActivity.this.autoReadOTP) {
                    CitrusActivity.this.mOTPPopupView.otpReadTimeout();
                }
            }
        }, 45000L);
    }

    private class JsInterface {
        private JsInterface() {
        }

        @JavascriptInterface
        public void pgResponse(String response) {
            Logger.d((String)("PG Response :: " + response), (Object[])new Object[0]);
            if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash) {
                CitrusActivity.this.removeCookies();
            }
            TransactionResponse transactionResponse = TransactionResponse.fromJSON(response, CitrusActivity.this.customParametersOriginalMap);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void loadWalletResponse(String response) {
            Logger.d((String)("Wallet response :: " + response), (Object[])new Object[0]);
            TransactionResponse transactionResponse = TransactionResponse.parseLoadMoneyResponse(response);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void rawPGResponse(String response) {
            Logger.d((String)("rawPGResponse :: " + response), (Object[])new Object[0]);
            TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.SUCCESSFUL, "", null);
            transactionResponse.setJsonResponse(response);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void printHTML(String response) {
            if (!TextUtils.isEmpty((CharSequence)response) && (response.contains("Un-Registered") || response.contains("Registration") || response.contains("Step 1"))) {
                CitrusActivity.this.isCardUnRegistered = true;
            }
        }
    }

    private class CitrusWebClient
    extends WebViewClient {
        private CitrusWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(url);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (CitrusActivity.this.isBackKeyPressedByUser) {
                CitrusActivity.this.showDialog("Cancelling Transaction. Please Wait...", true);
            } else if (!CitrusActivity.this.mShowingDialog) {
                CitrusActivity.this.showDialog("Processing Payment. Please Wait...", true);
            }
            CitrusActivity.this.mTimer.cancel();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (!CitrusActivity.this.mCitrusClient.isShowDummyScreenWhilePayments() || !url.startsWith("data:text/html")) {
                CitrusActivity.this.mTimer.start();
            }
            view.loadUrl("javascript:window.CitrusResponse.printHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            CitrusActivity.this.dismissDialog();
            handler.cancel();
        }
    }

    private static enum BlazePayments {
        BlazeCard,
        BlazeNet;

    }
}

