/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import org.json.JSONException;
import org.json.JSONObject;

public class BlazeWrapper {
    public static String[] cardSchemes = new String[]{"MASTER_CARD", "VISA"};

    public static JSONObject getBlazeNetPaymentObject(String paymentJSON) {
        JSONObject paymentObject = null;
        try {
            paymentObject = new JSONObject(paymentJSON);
            JSONObject blazeNetRequest = new JSONObject();
            blazeNetRequest.put("returnUrl", (Object)paymentObject.optString("returnUrl"));
            blazeNetRequest.put("notifyUrl", (Object)paymentObject.optString("notifyUrl"));
            blazeNetRequest.put("requestSignature", (Object)paymentObject.optString("requestSignature"));
            blazeNetRequest.put("merchantAccessKey", (Object)paymentObject.optString("merchantAccessKey"));
            blazeNetRequest.put("merchantTxnId", (Object)paymentObject.optString("merchantTxnId"));
            blazeNetRequest.put("email", (Object)paymentObject.optString("email"));
            blazeNetRequest.put("amount", (Object)paymentObject.getJSONObject("amount"));
            blazeNetRequest.put("userDetails", (Object)paymentObject.getJSONObject("userDetails"));
            blazeNetRequest.put("paymentToken", (Object)paymentObject.getJSONObject("paymentToken"));
            blazeNetRequest.put("customParameters", (Object)paymentObject.getJSONObject("customParameters"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return paymentObject;
    }

    public static JSONObject getBlazeCardPaymentObject(String paymentJSON) {
        JSONObject bcRequestObject = new JSONObject();
        try {
            JSONObject paymentObject = new JSONObject(paymentJSON);
            if (paymentObject.has("citrusTransactionId")) {
                bcRequestObject.put("citrusTransactionId", (Object)paymentObject.optString("citrusTransactionId"));
            }
            if (paymentObject.has("customParameters")) {
                bcRequestObject.put("customParameters", (Object)paymentObject.getJSONObject("customParameters"));
            }
            bcRequestObject.put("merchantTransactionId", (Object)paymentObject.optString("merchantTxnId"));
            bcRequestObject.put("merchantAccessKey", (Object)paymentObject.optString("merchantAccessKey"));
            JSONObject amountObj = paymentObject.getJSONObject("amount");
            bcRequestObject.put("amount", (Object)amountObj.optString("value"));
            bcRequestObject.put("currency", (Object)amountObj.optString("currency"));
            JSONObject userDetails = paymentObject.getJSONObject("userDetails");
            bcRequestObject.put("firstName", (Object)userDetails.optString("firstName"));
            bcRequestObject.put("lastName", (Object)userDetails.optString("lastName"));
            bcRequestObject.put("email", (Object)userDetails.optString("email"));
            bcRequestObject.put("phone", (Object)userDetails.optString("mobileNo"));
            JSONObject addressObject = userDetails.getJSONObject("address");
            bcRequestObject.put("addressStreet1", (Object)addressObject.optString("street1"));
            bcRequestObject.put("addressCity", (Object)addressObject.optString("city"));
            bcRequestObject.put("addressState", (Object)addressObject.optString("state"));
            bcRequestObject.put("addressZip", (Object)addressObject.optString("zip"));
            JSONObject cardDetails = paymentObject.getJSONObject("paymentToken");
            if (cardDetails.has("paymentMode")) {
                JSONObject paymentMode = cardDetails.getJSONObject("paymentMode");
                bcRequestObject.put("cardType", (Object)paymentMode.optString("type").toUpperCase());
                bcRequestObject.put("cardScheme", (Object)BlazeWrapper.getBlazeCardCardScheme(paymentMode.optString("scheme")));
                bcRequestObject.put("cardNo", (Object)paymentMode.optString("number"));
                bcRequestObject.put("cvv", (Object)paymentMode.optString("cvv"));
                bcRequestObject.put("expiry", (Object)paymentMode.optString("expiry"));
            } else {
                bcRequestObject.put("cvv", (Object)cardDetails.optString("cvv"));
                bcRequestObject.put("extraInfoMap", (Object)new JSONObject().put("paymentToken", (Object)cardDetails.optString("id")));
            }
            bcRequestObject.put("returnUrl", (Object)paymentObject.optString("returnUrl"));
            bcRequestObject.put("notifyUrl", (Object)paymentObject.optString("notifyUrl"));
            bcRequestObject.put("signature", (Object)paymentObject.optString("requestSignature"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return bcRequestObject;
    }

    public static String getBlazeCardCardScheme(String motoCardScheme) {
        switch (motoCardScheme) {
            case "VISA": {
                return "VISA";
            }
            case "MCRD": {
                return "MASTERCARD";
            }
            case "MTRO": {
                return "MAESTRO";
            }
            case "DINERS": {
                return "DINERS";
            }
            case "JCB": {
                return "JCB";
            }
            case "AMEX": {
                return "AMEX";
            }
            case "DISCOVER": {
                return "DISCOVER";
            }
            case "RPAY": {
                return "RPAY";
            }
        }
        return null;
    }

    public static String getSystemParametersObject() {
        String json = "{ \"app_version\": \"1.0.0\",  \"app_bundle\": \"com.citrus.sample\" ,\"sdk_version\": \"3.4.5\" ,\"platform\": \"Android\" ,\"platform_version\": \"5.0\" }";
        return json;
    }
}

