/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.AccessToken;
import com.facebook.crypto.Crypto;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OauthToken {
    private Context context;
    private Activity activity;
    private JSONObject jsontoken;
    private SharedPreferences tokenPrefs;
    private String token_type;
    private Callback callback;
    private CitrusClient citrusClient;
    private String signinId = null;
    private String signinSecret = null;

    public OauthToken(Context context, String token_type) {
        this.context = context;
        this.tokenPrefs = this.context.getSharedPreferences("UserStorage", 0);
        this.token_type = token_type;
    }

    public OauthToken(Context context, String token_type, String signinId, String signinSecret) {
        this.context = context;
        this.tokenPrefs = this.context.getSharedPreferences("UserStorage", 0);
        this.token_type = token_type;
        this.signinId = signinId;
        this.signinSecret = signinSecret;
    }

    public OauthToken(Context context) {
        this.context = context;
        this.tokenPrefs = this.context.getSharedPreferences("UserStorage", 0);
    }

    public boolean createToken(JSONObject usertoken) {
        this.jsontoken = new JSONObject();
        long expiry = new Date().getTime() / 1000L;
        try {
            this.jsontoken.put("expiry", expiry += usertoken.getLong("expires_in"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator keys = usertoken.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                this.jsontoken.put(key, usertoken.get(key));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this.storeToken();
    }

    private boolean storeToken() {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString(this.token_type, this.jsontoken.toString());
        return editor.commit();
    }

    private String getEncryptedToken() {
        String seed = this.token_type + this.signinId + this.signinSecret;
        if (!CitrusClient.isCitrusNativeLibraryLoaded && !CitrusClient.isFacebookNativeLibraryLoaded) {
            return this.jsontoken.toString();
        }
        Crypto crypto = this.citrusClient.getCrypto();
        Entity myEntity = new Entity(seed);
        String encryptedToken = null;
        try {
            byte[] cipherTextToken = crypto.encrypt(this.jsontoken.toString().getBytes(), myEntity);
            encryptedToken = Base64.encodeToString((byte[])cipherTextToken, (int)0);
        }
        catch (KeyChainException e) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException e) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return encryptedToken;
    }

    public synchronized void getSignUpToken(Callback<AccessToken> callback) {
        this.token_type = "signup_token";
    }

    public synchronized void getSignInToken(Callback<AccessToken> callback) {
        this.token_type = "signin_token";
    }

    public synchronized void getPrepaidToken(Callback<AccessToken> callback) {
        this.token_type = "prepaid_token";
    }

    public synchronized void getPayUsingCitrusCashToken(Callback<AccessToken> callback) {
        this.token_type = "pay_using_citrus_cash_token";
    }

    public boolean clearToken() {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.clear();
        return editor.commit();
    }

    public boolean saveUserDetails(String emailId, String mobileNo) {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString("email_id", emailId);
        editor.putString("mobile_no", mobileNo);
        return editor.commit();
    }

    public String getEmailId() {
        return this.tokenPrefs.getString("email_id", null);
    }

    public String getMobileNumber() {
        return this.tokenPrefs.getString("mobile_no", null);
    }

    public boolean saveEnvironment(Environment environment) {
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString("environment", environment.toString());
        return editor.commit();
    }

    public Environment getCurrentEnvironment() {
        String environment = this.tokenPrefs.getString("environment", null);
        return environment == null ? Environment.NONE : Environment.valueOf(environment);
    }

    public boolean saveCVV(byte[] encryptedFingerPrint, byte[] encryptedCVV) {
        String token = Base64.encodeToString((byte[])encryptedFingerPrint, (int)0);
        String CVV = Base64.encodeToString((byte[])encryptedCVV, (int)0);
        SharedPreferences.Editor editor = this.tokenPrefs.edit();
        editor.putString(token, CVV);
        return editor.commit();
    }

    public byte[] getCVV(String fingerPrint, String seed) {
        byte[] array = null;
        Map prefsMap = this.tokenPrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String strEntry = (String)entry.getKey();
            if ("environment".equals(strEntry) || "email_id".equals(strEntry) || "mobile_no".equals(strEntry) || "signup_token".equals(strEntry) || "signin_token".equals(strEntry) || "prepaid_token".equals(strEntry) || !this.isFingerPrintPresent(fingerPrint, strEntry, seed)) continue;
            array = Base64.decode((String)entry.getValue().toString(), (int)0);
            break;
        }
        return array;
    }

    public boolean isFingerPrintPresent(String originalToken, String encryptedToken, String seed) {
        this.citrusClient = CitrusClient.getInstance(this.context);
        boolean isTokenPresent = false;
        if (!CitrusClient.isCitrusNativeLibraryLoaded && !CitrusClient.isFacebookNativeLibraryLoaded) {
            return false;
        }
        try {
            Crypto crypto = this.citrusClient.getCrypto();
            Entity myEntity = new Entity(seed);
            byte[] decryptedBytes = crypto.decrypt(Base64.decode((String)encryptedToken, (int)0), myEntity);
            String decryptedOriginalToekn = new String(decryptedBytes);
            if (decryptedOriginalToekn.equalsIgnoreCase(originalToken)) {
                isTokenPresent = true;
            }
        }
        catch (KeyChainException e) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException e) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return isTokenPresent;
    }
}

