package com.citrus.sdk.walletpg;

import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.PaymentOption;

/**
 * Created by vinay on 11/4/16.
 */
public class WalletPgPaymentDetails {
    /**"paymentDetailsLst": [
     * {
     * "paymentMode": "PREPAID_CARD",
     * "status": "Success",
     * "description": "Transaction successful",
     * "amount": "30.0",
     * "currency": "INR"
     * }
     * ],
     */

    private String paymentMode ;
    private String amount;
    private String currency;

    public WalletPgPaymentDetails() {
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getPaymentMode() {
        return paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentOption getPaymentOption(){
        PaymentOption paymentOption = null ;

        final String paymentMode = getPaymentMode();
        if( paymentMode != null && !paymentMode.isEmpty() ){
            final Amount paymentOptionAmount = new Amount(getAmount(), getCurrency()) ;
            if ("PREPAID_CARD".equalsIgnoreCase(paymentMode)) {
                paymentOption = new CitrusCash(paymentOptionAmount);
            } else if ("MVC".equalsIgnoreCase(paymentMode)) {
                paymentOption = new MVCOption(paymentOptionAmount, null);
            }
        }
        return paymentOption ;
    }


}
