/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.widgets;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import com.citrus.sdk.payment.CardOption;
import java.util.regex.Pattern;

public class CardNumberEditText
extends EditText {
    private final int DEFAULT_CARD_NUMBER_LENGTH = 19;
    public static final Pattern CODE_PATTERN = Pattern.compile("([0-9]{0,4})|([0-9]{4}-)+|([0-9]{4}-[0-9]{0,4})+");
    public static final Pattern EXP_PATTERN = Pattern.compile("^((0[1-9])|(1[0-2]))//((2009)|(20[1-2][0-9]))$");
    public Context context;
    private TextWatcher customTextWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            String string2 = "";
            string2 = charSequence.toString().contains(" ") ? charSequence.toString().replace(" ", "") : charSequence.toString();
            try {
                CardOption.CardScheme cardScheme = CardOption.CardScheme.getCardSchemeUsingNumber(string2);
                String string3 = cardScheme.getIconName();
                int n5 = CardOption.CardScheme.getFilterLength(cardScheme);
                CardNumberEditText.this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(n5)});
                int n6 = CardNumberEditText.this.context.getResources().getIdentifier(string3, "drawable", CardNumberEditText.this.context.getPackageName());
                if (Build.VERSION.SDK_INT >= 21) {
                    CardNumberEditText.this.setCompoundDrawablesWithIntrinsicBounds(null, null, CardNumberEditText.this.getResources().getDrawable(n6, null), null);
                } else {
                    CardNumberEditText.this.setCompoundDrawablesWithIntrinsicBounds(null, null, CardNumberEditText.this.getResources().getDrawable(n6), null);
                }
                CardNumberEditText.this.setError(null);
            }
            catch (Exception exception) {
                CardNumberEditText.this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            }
        }

        public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
        }

        public void afterTextChanged(Editable editable) {
            if (editable.length() > 0 && !CODE_PATTERN.matcher((CharSequence)editable).matches()) {
                String string2 = editable.toString();
                String string3 = CardNumberEditText.this.keepNumbersOnly(string2);
                String string4 = CardNumberEditText.this.formatNumbersAsCode(string3);
                CardNumberEditText.this.removeTextChangedListener(this);
                CardNumberEditText.this.setText(string4);
                CardNumberEditText.this.setSelection(string4.length());
                CardNumberEditText.this.addTextChangedListener(this);
            }
        }
    };

    public CardNumberEditText(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.context = context;
        this.init();
    }

    public CardNumberEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.init();
    }

    public CardNumberEditText(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    private void init() {
        this.addTextChangedListener(this.customTextWatcher);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(19)});
    }

    private String keepNumbersOnly(CharSequence charSequence) {
        return charSequence.toString().replaceAll("[^0-9]", "");
    }

    private String formatNumbersAsCode(CharSequence charSequence) {
        int n2 = 0;
        String string2 = "";
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            string2 = string2 + charSequence.charAt(i2);
            if (++n2 != 4) continue;
            string2 = string2 + " ";
            n2 = 0;
        }
        try {
            if (string2.charAt(string2.length() - 1) == ' ') {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    public int getCVVLength() {
        String string2 = this.keepNumbersOnly((CharSequence)this.getText());
        return CardOption.CardScheme.getCVVLength(string2);
    }

    public CardOption.CardScheme getCardScheme() {
        String string2 = this.keepNumbersOnly((CharSequence)this.getText());
        return CardOption.CardScheme.getCardSchemeUsingNumber(string2);
    }
}

