/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.response.CitrusResponse;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentResponse
extends CitrusResponse
implements Parcelable {
    @SerializedName(value="id")
    protected String transactionId = null;
    @SerializedName(value="amount")
    protected Amount transactionAmount = null;
    @SerializedName(value="balance")
    protected Amount balanceAmount = null;
    @SerializedName(value="cutsomer")
    protected String customer = null;
    @SerializedName(value="merchant")
    protected String merchantName = null;
    @SerializedName(value="date")
    protected String date = null;
    protected TransactionResponse transactionResponse = null;
    private JSONObject responseParams = null;
    protected CitrusUser user = null;
    public static final Parcelable.Creator<PaymentResponse> CREATOR = new Parcelable.Creator<PaymentResponse>(){

        public PaymentResponse createFromParcel(Parcel parcel) {
            return new PaymentResponse(parcel);
        }

        public PaymentResponse[] newArray(int n2) {
            return new PaymentResponse[n2];
        }
    };

    public TransactionResponse getTransactionResponse() {
        return this.transactionResponse;
    }

    PaymentResponse() {
    }

    public PaymentResponse(String string, CitrusResponse.Status status, String string2, Amount amount, Amount amount2, CitrusUser citrusUser) {
        super(string, status);
        this.transactionId = string2;
        this.transactionAmount = amount;
        this.balanceAmount = amount2;
        this.user = citrusUser;
    }

    public PaymentResponse(String string, CitrusResponse.Status status, String string2, Amount amount, Amount amount2, CitrusUser citrusUser, String string3, String string4, String string5, TransactionResponse transactionResponse) {
        super(string, status);
        this.transactionId = string2;
        this.transactionAmount = amount;
        this.balanceAmount = amount2;
        this.customer = string3;
        this.merchantName = string4;
        this.date = string5;
        this.transactionResponse = transactionResponse;
        this.user = citrusUser;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public CitrusUser getUser() {
        return this.user;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getDate() {
        return this.date;
    }

    public String getCustomer() {
        return this.customer;
    }

    private void setResponseParams(JSONObject jSONObject) {
        this.responseParams = jSONObject;
    }

    public String getURLEncodedParams() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.responseParams != null) {
            Iterator iterator = this.responseParams.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append("=");
                try {
                    stringBuffer.append(URLEncoder.encode(this.responseParams.optString(string), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                stringBuffer.append("&");
            }
        }
        return stringBuffer.toString();
    }

    public static PaymentResponse fromJSON(String string) {
        PaymentResponse paymentResponse = null;
        try {
            String string2;
            Object object;
            Object object2;
            JSONObject jSONObject = new JSONObject(string);
            String string3 = jSONObject.optString("customer", jSONObject.optString("cutsomer"));
            CitrusResponse.Status status = CitrusResponse.Status.valueOf(jSONObject.optString("status"));
            String string4 = status == CitrusResponse.Status.SUCCESSFUL ? "Transaction Successful" : jSONObject.optString("reason");
            String string5 = jSONObject.optString("date");
            String string6 = jSONObject.optString("merchant");
            Amount amount = Amount.fromJSONObject(jSONObject.optJSONObject("amount"));
            Amount amount2 = Amount.fromJSONObject(jSONObject.optJSONObject("balance"));
            HashMap<String, String> hashMap = null;
            JSONObject jSONObject2 = jSONObject.optJSONObject("customParams");
            if (jSONObject2 != null) {
                hashMap = new HashMap<String, String>();
                object2 = jSONObject2.keys();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    string2 = jSONObject2.optString((String)object);
                    hashMap.put((String)object, string2);
                }
            }
            string2 = (object = TransactionResponse.fromJSONObject((JSONObject)(object2 = jSONObject.optJSONObject("responseParams")), hashMap)) != null ? ((TransactionResponse)object).getTransactionId() : null;
            CitrusUser citrusUser = ((TransactionResponse)object).getCitrusUser();
            paymentResponse = new PaymentResponse(string4, status, string2, amount, amount2, citrusUser, string3, string6, string5, (TransactionResponse)object);
            paymentResponse.setResponseParams((JSONObject)object2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return paymentResponse;
    }

    public String toString() {
        return "PaymentResponse{transactionId='" + this.transactionId + '\'' + ", transactionAmount=" + this.transactionAmount + ", balanceAmount=" + this.balanceAmount + ", customer='" + this.customer + '\'' + ", merchantName='" + this.merchantName + '\'' + ", date='" + this.date + '\'' + ", transactionResponse=" + this.transactionResponse + ", user=" + this.user + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.transactionId);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
        parcel.writeParcelable((Parcelable)this.balanceAmount, 0);
        parcel.writeString(this.customer);
        parcel.writeString(this.merchantName);
        parcel.writeString(this.date);
        parcel.writeParcelable((Parcelable)this.transactionResponse, 0);
        parcel.writeParcelable((Parcelable)this.user, 0);
    }

    protected PaymentResponse(Parcel parcel) {
        super(parcel);
        this.transactionId = parcel.readString();
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.balanceAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.customer = parcel.readString();
        this.merchantName = parcel.readString();
        this.date = parcel.readString();
        this.transactionResponse = (TransactionResponse)parcel.readParcelable(TransactionResponse.class.getClassLoader());
        this.user = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }
}

