/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentType
implements Parcelable {
    protected Amount a;
    protected String b;
    protected PaymentBill c = null;
    protected PaymentOption d = null;
    protected List<PaymentOption> e = null;
    protected CitrusUser f = null;

    protected PaymentType() {
    }

    protected PaymentType(PaymentBill paymentBill) {
        this.c = paymentBill;
        this.a = paymentBill.getAmount();
    }

    public PaymentType(Amount amount, String string2, PaymentOption paymentOption, CitrusUser citrusUser) {
        this.a = amount;
        this.b = string2;
        this.d = paymentOption;
        this.f = citrusUser;
    }

    public PaymentType(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) {
        this(paymentBill);
        this.d = paymentOption;
        this.f = citrusUser;
    }

    public PaymentType(Amount amount, String string2, List<PaymentOption> list) {
        this(amount, string2, null, null);
        this.e = list;
    }

    public PaymentType(PaymentBill paymentBill, List<PaymentOption> list) {
        this(paymentBill, null, null);
        this.e = list;
    }

    public Amount getAmount() {
        return this.a;
    }

    public String getUrl() {
        return this.b;
    }

    public PaymentBill getPaymentBill() {
        return this.c;
    }

    public PaymentOption getPaymentOption() {
        return this.d;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return this.e;
    }

    public CitrusUser getCitrusUser() {
        return this.f;
    }

    public abstract String getIntentAction();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.a, 0);
        parcel.writeString(this.b);
        parcel.writeParcelable((Parcelable)this.c, 0);
        parcel.writeParcelable((Parcelable)this.d, 0);
        parcel.writeList(this.e);
        parcel.writeParcelable((Parcelable)this.f, 0);
    }

    protected PaymentType(Parcel parcel) {
        this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.b = parcel.readString();
        this.c = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
        this.d = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
        this.e = parcel.readArrayList(PaymentOption.class.getClassLoader());
        this.f = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }

    public static class SplitPayment
    extends PaymentType {
        private boolean g = false;
        private boolean h = false;
        public static final Parcelable.Creator<SplitPayment> CREATOR = new Parcelable.Creator<SplitPayment>(){

            public SplitPayment a(Parcel parcel) {
                return new SplitPayment(parcel);
            }

            public SplitPayment[] a(int n2) {
                return new SplitPayment[n2];
            }

            public /* synthetic */ Object[] newArray(int n2) {
                return this.a(n2);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };

        public SplitPayment(Amount amount, String string2, PaymentOption paymentOption, boolean bl, boolean bl2) throws CitrusException {
            super(amount, string2, paymentOption, null);
            this.h = bl;
            this.g = bl2;
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string2 == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (!this.a.isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PaymentBill paymentBill, PaymentOption paymentOption, boolean bl, boolean bl2) throws CitrusException {
            super(paymentBill, paymentOption, null);
            this.h = bl;
            this.g = bl2;
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (!paymentBill.getAmount().isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PGPayment pGPayment) {
            if (pGPayment.getPaymentBill() != null) {
                this.c = pGPayment.getPaymentBill();
            } else {
                this.a = pGPayment.getAmount();
                this.b = pGPayment.getUrl();
            }
            this.d = pGPayment.getPaymentOption();
            this.d.transactionAmount = pGPayment.getAmount();
        }

        public boolean isCitrusCashEnabled() {
            return this.h;
        }

        public boolean isMVCEnabled() {
            return this.g;
        }

        @Override
        public String getIntentAction() {
            return "ACTION_WALLET_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeByte(this.g ? (byte)1 : 0);
            parcel.writeByte(this.h ? (byte)1 : 0);
        }

        protected SplitPayment(Parcel parcel) {
            super(parcel);
            this.g = parcel.readByte() != 0;
            this.h = parcel.readByte() != 0;
        }
    }

    public static class PGPayment
    extends PaymentType
    implements Parcelable {
        private boolean g = false;
        private boolean h = false;
        private DynamicPricingResponse i = null;
        public static final Parcelable.Creator<PGPayment> CREATOR = new Parcelable.Creator<PGPayment>(){

            public PGPayment a(Parcel parcel) {
                return new PGPayment(parcel);
            }

            public PGPayment[] a(int n2) {
                return new PGPayment[n2];
            }

            public /* synthetic */ Object[] newArray(int n2) {
                return this.a(n2);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };

        private PGPayment() {
        }

        public PGPayment(Amount amount, String string2, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(amount, string2, paymentOption, citrusUser);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string2 == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        public PGPayment(DynamicPricingResponse dynamicPricingResponse) throws CitrusException {
            this(dynamicPricingResponse.getPaymentBill(), dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
            this.h = true;
            this.i = dynamicPricingResponse;
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption) throws CitrusException {
            super(paymentBill);
            this.d = paymentOption;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("paymentOption should not be null.");
            }
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(paymentBill, paymentOption, citrusUser);
            this.d = paymentOption;
            this.f = citrusUser;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
        }

        public PGPayment(SplitPayment splitPayment) throws CitrusException {
            if (splitPayment.getPaymentBill() != null) {
                this.c = splitPayment.getPaymentBill();
                this.a = this.c.getAmount();
            } else {
                this.a = splitPayment.getAmount();
                this.b = splitPayment.getUrl();
            }
            this.d = splitPayment.getPaymentOption();
        }

        public boolean isSingleHop() {
            return this.g;
        }

        public void useSingleHop(boolean bl) {
            this.g = bl;
        }

        public boolean isDyanmicPricingRequest() {
            return this.h;
        }

        public DynamicPricingResponse getDynamicPricingResponse() {
            return this.i;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.d, 0);
            parcel.writeParcelable((Parcelable)this.f, 0);
            parcel.writeParcelable((Parcelable)this.a, 0);
            parcel.writeString(this.b);
            parcel.writeParcelable((Parcelable)this.c, 0);
        }

        private PGPayment(Parcel parcel) {
            this.d = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.f = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
            this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.b = parcel.readString();
            this.c = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
        }
    }

    public static class CitrusCash
    extends PaymentType
    implements Parcelable {
        public static final Parcelable.Creator<CitrusCash> CREATOR = new Parcelable.Creator<CitrusCash>(){

            public CitrusCash a(Parcel parcel) {
                return new CitrusCash(parcel);
            }

            public CitrusCash[] a(int n2) {
                return new CitrusCash[n2];
            }

            public /* synthetic */ Object[] newArray(int n2) {
                return this.a(n2);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };

        private CitrusCash() {
        }

        public CitrusCash(Amount amount, String string2) throws CitrusException {
            super(amount, string2, null, null);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string2 == null) {
                throw new CitrusException("billUrl should be not null.");
            }
        }

        public CitrusCash(PaymentBill paymentBill) {
            super(paymentBill);
        }

        public final void setPaymentBill(PaymentBill paymentBill) {
            this.c = paymentBill;
        }

        public final void setCitrusUser(CitrusUser citrusUser) {
            this.f = citrusUser;
        }

        public final String getPaymentJSON() {
            String string2 = "";
            JSONObject jSONObject = PaymentBill.toJSONObject(this.c);
            if (jSONObject != null) {
                try {
                    jSONObject.put("userDetails", (Object)CitrusUser.toJSONObject(this.f, true));
                    jSONObject.put("requestOrigin", (Object)"MSDKW");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                string2 = jSONObject.toString();
            }
            return string2;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PAY_USING_CASH";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.a, 0);
            parcel.writeString(this.b);
            parcel.writeParcelable((Parcelable)this.c, 0);
            parcel.writeParcelable((Parcelable)this.d, 0);
            parcel.writeParcelable((Parcelable)this.f, 0);
        }

        private CitrusCash(Parcel parcel) {
            this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.b = parcel.readString();
            this.c = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
            this.d = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.f = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
        }
    }

    public static class LoadMoney
    extends PaymentType
    implements Parcelable {
        private PaymentOption g = null;
        public static final Parcelable.Creator<LoadMoney> CREATOR = new Parcelable.Creator<LoadMoney>(){

            public LoadMoney a(Parcel parcel) {
                return new LoadMoney(parcel);
            }

            public LoadMoney[] a(int n2) {
                return new LoadMoney[n2];
            }

            public /* synthetic */ Object[] newArray(int n2) {
                return this.a(n2);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };

        private LoadMoney() {
        }

        public LoadMoney(Amount amount, String string2, PaymentOption paymentOption) throws CitrusException {
            super(amount, string2, paymentOption, null);
            this.g = paymentOption;
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (string2 == null) {
                throw new CitrusException("returnUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        @Override
        public PaymentOption getPaymentOption() {
            return this.g;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_LOAD_MONEY";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeParcelable((Parcelable)this.g, 0);
            parcel.writeParcelable((Parcelable)this.a, 0);
            parcel.writeString(this.b);
            parcel.writeParcelable((Parcelable)this.c, 0);
            parcel.writeParcelable((Parcelable)this.g, 0);
            parcel.writeParcelable((Parcelable)this.f, 0);
        }

        private LoadMoney(Parcel parcel) {
            this.g = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
            this.b = parcel.readString();
            this.c = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
            this.g = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
            this.f = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
        }
    }
}

