/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.classes.j;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentOption
implements Parcelable {
    protected String name = null;
    protected String token = null;
    protected boolean savePaymentOption = false;
    protected Amount transactionAmount = null;
    protected j pgHealth = j.UNKNOWN;
    protected boolean defaultPaymentMode = false;
    protected boolean selected = false;
    protected boolean shown = false;
    protected String fingerPrint = null;
    private int amount;
    private String cvvText = "";

    PaymentOption() {
    }

    PaymentOption(String string2, String string3) {
        this.name = string2;
        this.token = string3;
    }

    PaymentOption(Amount amount, String string2, String string3) {
        this.transactionAmount = amount;
        this.name = string2;
        this.token = string3;
    }

    public static PaymentOption fromJSONObject(JSONObject jSONObject) {
        return PaymentOption.fromJSONObject(jSONObject, false);
    }

    public static PaymentOption fromJSONObject(JSONObject jSONObject, boolean bl) {
        String string2;
        String string3;
        String string4;
        CardOption.CardScheme cardScheme;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        PaymentOption paymentOption = null;
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        boolean bl2 = false;
        if (bl) {
            string9 = jSONObject.optString("paymentMode");
            string8 = jSONObject.optString("name");
            string7 = jSONObject.optString("savedCardToken");
            string6 = jSONObject.optString("cardExpiryDate");
            string5 = jSONObject.optString("cardNumber");
            String string15 = jSONObject.optString("cardScheme");
            cardScheme = CardOption.CardScheme.getCardScheme(string15);
            string4 = jSONObject.optString("fingerPrint");
            string3 = jSONObject.optString("bank");
            string2 = "";
            string12 = jSONObject.optString("amount");
            string13 = jSONObject.optString("campaignCode");
            string14 = jSONObject.optString("maxBalance");
            bl2 = jSONObject.optBoolean("defaultPaymentMode", false);
        } else {
            string9 = jSONObject.optString("type");
            string8 = jSONObject.optString("name");
            string7 = jSONObject.optString("token");
            string2 = jSONObject.optString("owner");
            string6 = jSONObject.optString("expiryDate");
            string5 = jSONObject.optString("number");
            String string16 = jSONObject.optString("scheme");
            cardScheme = CardOption.CardScheme.getCardScheme(string16);
            string4 = jSONObject.optString("fingerPrint");
            string3 = jSONObject.optString("bank");
        }
        if (!TextUtils.isEmpty((CharSequence)string6) && string6.length() > 2) {
            string10 = TextUtils.substring((CharSequence)string6, (int)0, (int)2);
            string11 = TextUtils.substring((CharSequence)string6, (int)2, (int)string6.length());
        }
        if (TextUtils.equals((CharSequence)"credit", (CharSequence)string9) || TextUtils.equals((CharSequence)"CREDIT_CARD", (CharSequence)string9)) {
            paymentOption = new CreditCardOption(string2, string5, null, Month.getMonth(string10), Year.getYear(string11));
            super.setName(string8);
            super.setToken(string7);
            ((CardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"debit", (CharSequence)string9) || TextUtils.equals((CharSequence)"DEBIT_CARD", (CharSequence)string9)) {
            paymentOption = new DebitCardOption(string2, string5, null, Month.getMonth(string10), Year.getYear(string11));
            super.setName(string8);
            super.setToken(string7);
            ((DebitCardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"netbanking", (CharSequence)string9) || TextUtils.equals((CharSequence)"NET_BANKING", (CharSequence)string9)) {
            paymentOption = new NetbankingOption(string8, string7, string3);
        } else if (TextUtils.equals((CharSequence)"MVC", (CharSequence)string9)) {
            Amount amount = new Amount(string14);
            Amount amount2 = new Amount(string12);
            paymentOption = new MVCOption(amount2, string13, amount);
        } else if (TextUtils.equals((CharSequence)"PREPAID_CARD", (CharSequence)string9)) {
            Amount amount = new Amount(string14);
            Amount amount3 = new Amount(string12);
            paymentOption = new CitrusCash(amount3, amount);
        }
        paymentOption.setDefaultPaymentMode(bl2);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            paymentOption.setFingerPrint(string4);
        }
        return paymentOption;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount amount) {
        this.transactionAmount = amount;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string2) {
        this.name = string2;
    }

    public String getToken() {
        return this.token;
    }

    private void setToken(String string2) {
        this.token = string2;
    }

    public boolean isSavePaymentOption() {
        return this.savePaymentOption;
    }

    public void setSavePaymentOption(boolean bl) {
        this.savePaymentOption = bl;
    }

    public j getPgHealth() {
        return this.pgHealth;
    }

    protected void setPgHealth(j j2) {
        this.pgHealth = j2;
    }

    public void setFingerPrint(String string2) {
        this.fingerPrint = string2;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public boolean isDefaultPaymentMode() {
        return this.defaultPaymentMode;
    }

    void setDefaultPaymentMode(boolean bl) {
        this.defaultPaymentMode = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShown() {
        return this.shown;
    }

    public int getCashAmount() {
        return this.amount;
    }

    public void setCashAmount(int n2) {
        this.amount = n2;
    }

    public String getCvvText() {
        return this.cvvText;
    }

    public void setCvvText(String string2) {
        this.cvvText = string2;
    }

    public abstract String getSavePaymentOptionObject();

    public abstract String getSaveDefaultPaymentOptionObject();

    public abstract JSONObject getMOTOPaymentOptionObject() throws JSONException;

    public abstract JSONObject getWalletChargePaymentOptionObject() throws JSONException;

    public abstract Drawable getOptionIcon(Context var1);

    public abstract String getDynamicPricingPaymentMode();

    public String toString() {
        return "PaymentOption{name='" + this.name + '\'' + ", token='" + this.token + '\'' + ", defaultPaymentMode=" + this.defaultPaymentMode + ", selected=" + this.selected + '}';
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null || object.getClass() != this.getClass()) {
            bl = false;
        } else {
            PaymentOption paymentOption = (PaymentOption)object;
            if (this.name.equalsIgnoreCase(paymentOption.getName())) {
                bl = true;
            }
        }
        return bl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.name);
        parcel.writeString(this.token);
        parcel.writeByte(this.savePaymentOption ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
        parcel.writeInt(this.pgHealth == null ? -1 : this.pgHealth.ordinal());
        parcel.writeByte(this.defaultPaymentMode ? (byte)1 : 0);
        parcel.writeByte(this.selected ? (byte)1 : 0);
        parcel.writeByte(this.shown ? (byte)1 : 0);
        parcel.writeString(this.fingerPrint);
        parcel.writeInt(this.amount);
        parcel.writeString(this.cvvText);
    }

    protected PaymentOption(Parcel parcel) {
        this.name = parcel.readString();
        this.token = parcel.readString();
        this.savePaymentOption = parcel.readByte() != 0;
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        int n2 = parcel.readInt();
        this.pgHealth = n2 == -1 ? null : j.values()[n2];
        this.defaultPaymentMode = parcel.readByte() != 0;
        this.selected = parcel.readByte() != 0;
        this.shown = parcel.readByte() != 0;
        this.fingerPrint = parcel.readString();
        this.amount = parcel.readInt();
        this.cvvText = parcel.readString();
    }

    public final boolean isTokenizedPayment() {
        return !TextUtils.isEmpty((CharSequence)this.token);
    }
}

