/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentBill
implements Parcelable {
    @SerializedName(value="amount")
    private Amount a = null;
    @SerializedName(value="alteredAmount")
    private Amount b = null;
    @SerializedName(value="requestSignature")
    private String c = null;
    @SerializedName(value="merchantTxnId")
    private String d = null;
    @SerializedName(value="merchantAccessKey")
    private String e = null;
    @SerializedName(value="returnUrl")
    private String f = null;
    @SerializedName(value="notifyUrl")
    private String g = null;
    @SerializedName(value="dpSignature")
    private String h = null;
    @SerializedName(value="customParameters")
    private Map<String, String> i = null;
    public static final Parcelable.Creator<PaymentBill> CREATOR = new Parcelable.Creator<PaymentBill>(){

        public PaymentBill a(Parcel parcel) {
            return new PaymentBill(parcel);
        }

        public PaymentBill[] a(int n2) {
            return new PaymentBill[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public PaymentBill(Amount amount, Amount amount2, String string2, String string3, String string4, String string5, String string6, String string7, Map<String, String> map) throws CitrusException {
        this.a = amount;
        this.b = amount2;
        this.c = string2;
        this.d = string3;
        this.e = string4;
        this.f = string5;
        this.g = string6;
        this.h = string7;
        this.i = map;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string3.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string5)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String string2, String string3, String string4, String string5) throws CitrusException {
        this.a = amount;
        this.c = string2;
        this.d = string3;
        this.e = string4;
        this.f = string5;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string3.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string5)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String string2, String string3, String string4, String string5, String string6, Map<String, String> map) throws CitrusException {
        this.a = amount;
        this.c = string2;
        this.d = string3;
        this.e = string4;
        this.f = string5;
        this.g = string6;
        this.i = map;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string3.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string5)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    private PaymentBill() {
    }

    public Amount getAmount() {
        return this.a;
    }

    public String getRequestSignature() {
        return this.c;
    }

    public String getMerchantTransactionId() {
        return this.d;
    }

    public String getMerchantAccessKey() {
        return this.e;
    }

    public String getReturnUrl() {
        return this.f;
    }

    public String getNotifyUrl() {
        return this.g;
    }

    public String getDpSignature() {
        return this.h;
    }

    public Map<String, String> getCustomParametersMap() {
        return this.i;
    }

    public static PaymentBill fromJSON(String string2) {
        PaymentBill paymentBill = null;
        JSONObject jSONObject = null;
        if (string2 != null) {
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject != null) {
                Amount amount = null;
                Amount amount2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                HashMap<String, String> hashMap = null;
                amount = Amount.fromJSONObject(jSONObject.optJSONObject("amount"));
                amount2 = Amount.fromJSONObject(jSONObject.optJSONObject("alteredAmount"));
                string3 = jSONObject.optString("requestSignature");
                string4 = jSONObject.optString("merchantTxnId");
                string5 = jSONObject.optString("merchantAccessKey");
                string6 = jSONObject.optString("returnUrl");
                string7 = jSONObject.optString("notifyUrl");
                string8 = jSONObject.optString("dpSignature");
                JSONObject jSONObject2 = jSONObject.optJSONObject("customParameters");
                if (jSONObject2 != null) {
                    hashMap = new HashMap<String, String>();
                    Iterator iterator = jSONObject2.keys();
                    while (iterator.hasNext()) {
                        String string9 = (String)iterator.next();
                        String string10 = jSONObject2.optString(string9);
                        hashMap.put(string9, string10);
                    }
                }
                if (amount != null && string3 != null && string6 != null && string5 != null && string4 != null) {
                    try {
                        paymentBill = new PaymentBill(amount, amount2, string3, string4, string5, string6, string7, string8, hashMap);
                    }
                    catch (CitrusException citrusException) {
                        citrusException.printStackTrace();
                    }
                }
            }
        }
        return paymentBill;
    }

    public static String toJSON(PaymentBill paymentBill) {
        JSONObject jSONObject = PaymentBill.toJSONObject(paymentBill);
        return paymentBill != null ? jSONObject.toString() : "";
    }

    public static JSONObject toJSONObject(PaymentBill paymentBill) {
        return PaymentBill.toJSONObject(paymentBill, false);
    }

    public static JSONObject toJSONObject(PaymentBill paymentBill, boolean bl) {
        JSONObject jSONObject = null;
        if (paymentBill != null) {
            Amount amount = paymentBill.getAmount();
            String string2 = paymentBill.getMerchantAccessKey();
            String string3 = paymentBill.getMerchantTransactionId();
            String string4 = paymentBill.getRequestSignature();
            String string5 = paymentBill.getReturnUrl();
            String string6 = paymentBill.getNotifyUrl();
            Map<String, String> map = paymentBill.getCustomParametersMap();
            if (amount != null && string4 != null && string2 != null && string3 != null && string5 != null) {
                try {
                    jSONObject = new JSONObject();
                    if (bl) {
                        jSONObject.put("amount", (Object)amount.getValueAsFormattedDouble("#.00"));
                        jSONObject.put("currency", (Object)amount.getCurrency());
                        jSONObject.put("merchantTransactionId", (Object)string3);
                        jSONObject.put("signature", (Object)string4);
                    } else {
                        jSONObject.put("amount", (Object)Amount.toJSONObject(amount));
                        jSONObject.put("merchantTxnId", (Object)string3);
                        jSONObject.put("requestSignature", (Object)string4);
                    }
                    jSONObject.put("merchantAccessKey", (Object)string2);
                    jSONObject.put("returnUrl", (Object)string5);
                    if (!TextUtils.isEmpty((CharSequence)string6)) {
                        jSONObject.put("notifyUrl", (Object)string6);
                    }
                    if (!bl && map != null && map.size() > 0) {
                        JSONObject jSONObject2 = new JSONObject();
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            jSONObject2.put(entry.getKey(), (Object)entry.getValue());
                        }
                        jSONObject.put("customParameters", (Object)jSONObject2);
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        return jSONObject;
    }

    public String toString() {
        return "PaymentBill{amount=" + this.a + ", requestSignature='" + this.c + '\'' + ", merchantTransactionId='" + this.d + '\'' + ", merchantAccessKey='" + this.e + '\'' + ", returnUrl='" + this.f + '\'' + ", notifyUrl='" + this.g + '\'' + ", dpSignature='" + this.h + '\'' + ", customParametersMap=" + this.i + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.a, 0);
        parcel.writeString(this.c);
        parcel.writeString(this.d);
        parcel.writeString(this.e);
        parcel.writeString(this.f);
        parcel.writeString(this.g);
        parcel.writeString(this.h);
        parcel.writeMap(this.i);
    }

    protected PaymentBill(Parcel parcel) {
        this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.c = parcel.readString();
        this.d = parcel.readString();
        this.e = parcel.readString();
        this.f = parcel.readString();
        this.g = parcel.readString();
        this.h = parcel.readString();
        this.i = parcel.readHashMap(String.class.getClassLoader());
    }
}

