/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.text.TextUtils;
import com.citrus.sdk.classes.j;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerchantPaymentOption {
    private Set<CardOption.CardScheme> a = null;
    private Set<CardOption.CardScheme> b = null;
    private ArrayList<NetbankingOption> c = null;
    private Set<String> d = null;

    private MerchantPaymentOption(Set<CardOption.CardScheme> set, Set<CardOption.CardScheme> set2, ArrayList<NetbankingOption> arrayList, Set<String> set3) {
        this.a = set;
        this.b = set2;
        this.c = arrayList;
        this.d = set3;
    }

    public Set<CardOption.CardScheme> getCreditCardSchemeSet() {
        return this.a;
    }

    public Set<CardOption.CardScheme> getDebitCardSchemeSet() {
        return this.b;
    }

    public ArrayList<NetbankingOption> getNetbankingOptionList() {
        return this.c;
    }

    public Set<String> getBankCIDSet() {
        return this.d;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject jsonObject) {
        return MerchantPaymentOption.getMerchantPaymentOptions(jsonObject, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject jsonObject, Map<String, j> map) {
        String string2;
        JsonElement jsonElement;
        int n2;
        HashSet<CardOption.CardScheme> hashSet = null;
        HashSet<CardOption.CardScheme> hashSet2 = null;
        ArrayList<NetbankingOption> arrayList = null;
        HashSet<String> hashSet3 = null;
        JsonArray jsonArray = jsonObject.getAsJsonArray("netBanking");
        JsonArray jsonArray2 = jsonObject.getAsJsonArray("creditCard");
        JsonArray jsonArray3 = jsonObject.getAsJsonArray("debitCard");
        int n3 = -1;
        n3 = jsonArray2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            jsonElement = jsonArray2.get(n2);
            string2 = jsonElement.getAsString();
            if (hashSet2 == null) {
                hashSet2 = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(string2) == null) continue;
            hashSet2.add(CardOption.CardScheme.getCardScheme(string2));
        }
        n3 = jsonArray3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            jsonElement = jsonArray3.get(n2);
            string2 = jsonElement.getAsString();
            if (hashSet == null) {
                hashSet = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(string2) == null) continue;
            hashSet.add(CardOption.CardScheme.getCardScheme(string2));
        }
        n3 = jsonArray.size();
        for (n2 = 0; n2 < n3; ++n2) {
            jsonElement = jsonArray.get(n2);
            if (!jsonElement.isJsonObject()) continue;
            string2 = jsonElement.getAsJsonObject();
            jsonElement = string2.get("bankName");
            String string3 = jsonElement.getAsString();
            jsonElement = string2.get("issuerCode");
            String string4 = jsonElement.getAsString();
            if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) continue;
            NetbankingOption netbankingOption = new NetbankingOption(string3, string4);
            if (map != null) {
                netbankingOption.setPgHealth(map.get(string4));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<NetbankingOption>();
            }
            if (hashSet3 == null) {
                hashSet3 = new HashSet<String>();
            }
            arrayList.add(netbankingOption);
            hashSet3.add(netbankingOption.getBankCID());
        }
        MerchantPaymentOption merchantPaymentOption = new MerchantPaymentOption(hashSet2, hashSet, arrayList, hashSet3);
        return merchantPaymentOption;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject jSONObject) {
        return MerchantPaymentOption.getMerchantPaymentOptions(jSONObject, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject jSONObject, Map<String, j> map) {
        MerchantPaymentOption merchantPaymentOption = null;
        try {
            String string2;
            int n2;
            HashSet<CardOption.CardScheme> hashSet = null;
            HashSet<CardOption.CardScheme> hashSet2 = null;
            ArrayList<NetbankingOption> arrayList = null;
            HashSet<String> hashSet3 = null;
            JSONArray jSONArray = jSONObject.getJSONArray("netBanking");
            JSONArray jSONArray2 = jSONObject.getJSONArray("creditCard");
            JSONArray jSONArray3 = jSONObject.getJSONArray("debitCard");
            int n3 = -1;
            n3 = jSONArray2.length();
            try {
                for (n2 = 0; n2 < n3; ++n2) {
                    string2 = jSONArray2.getString(n2);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(string2) == null) continue;
                    hashSet2.add(CardOption.CardScheme.getCardScheme(string2));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            try {
                n3 = jSONArray3.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    string2 = jSONArray3.getString(n2);
                    if (hashSet == null) {
                        hashSet = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(string2) == null) continue;
                    hashSet.add(CardOption.CardScheme.getCardScheme(string2));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            try {
                n3 = jSONArray.length();
                for (int i2 = 0; i2 < n3; ++i2) {
                    string2 = jSONArray.getJSONObject(i2);
                    String string3 = string2.getString("bankName");
                    String string4 = string2.getString("issuerCode");
                    if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) continue;
                    NetbankingOption netbankingOption = new NetbankingOption(string3, string4);
                    if (map != null) {
                        netbankingOption.setPgHealth(map.get(string4));
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<NetbankingOption>();
                    }
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet<String>();
                    }
                    arrayList.add(netbankingOption);
                    hashSet3.add(netbankingOption.getBankCID());
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            merchantPaymentOption = new MerchantPaymentOption(hashSet2, hashSet, arrayList, hashSet3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return merchantPaymentOption;
    }

    public String toString() {
        return "MerchantPaymentOption{creditCardSchemeSet=" + this.a + ", debitCardSchemeSet=" + this.b + ", netbankingOptionList=" + this.c + '}';
    }
}

