/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.CardOption;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CreditCardOption
extends CardOption
implements Parcelable {
    public static final Parcelable.Creator<CreditCardOption> CREATOR = new Parcelable.Creator<CreditCardOption>(){

        public CreditCardOption a(Parcel parcel) {
            return new CreditCardOption(parcel);
        }

        public CreditCardOption[] a(int n2) {
            return new CreditCardOption[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public CreditCardOption() {
    }

    public CreditCardOption(String string2, String string3) {
        super(string2, string3);
    }

    public CreditCardOption(String string2, String string3, String string4, Month month, Year year) {
        super(string2, string3, string4, month, year);
    }

    public CreditCardOption(Amount amount, String string2, String string3, String string4, Month month, Year year) {
        super(amount, string2, string3, string4, month, year);
    }

    public CreditCardOption(String string2, CardOption.CardScheme cardScheme) {
        super(string2, cardScheme);
    }

    @Override
    public String getCardType() {
        if (this.cardScheme == CardOption.CardScheme.MAESTRO || this.cardScheme == CardOption.CardScheme.RPAY) {
            return CardOption.CardType.DEBIT.getCardType();
        }
        return CardOption.CardType.CREDIT.getCardType();
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            return "CITRUS_WALLET";
        }
        return "CREDIT_CARD";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.cardHolderName);
        parcel.writeString(this.cardNumber);
        parcel.writeString(this.cardCVV);
        parcel.writeString(this.cardExpiry);
        parcel.writeString(this.cardExpiryMonth);
        parcel.writeString(this.cardExpiryYear);
        parcel.writeSerializable((Serializable)((Object)this.cardScheme));
        parcel.writeString(this.name);
        parcel.writeString(this.token);
        parcel.writeByte(this.savePaymentOption ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
    }

    private CreditCardOption(Parcel parcel) {
        this.cardHolderName = parcel.readString();
        this.cardNumber = parcel.readString();
        this.cardCVV = parcel.readString();
        this.cardExpiry = parcel.readString();
        this.cardExpiryMonth = parcel.readString();
        this.cardExpiryYear = parcel.readString();
        this.cardScheme = (CardOption.CardScheme)((Object)parcel.readSerializable());
        this.name = parcel.readString();
        this.token = parcel.readString();
        this.savePaymentOption = parcel.readByte() != 0;
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("owner", (Object)this.cardHolderName);
            jSONObject2.put("bank", (Object)"null");
            jSONObject2.put("type", (Object)"credit");
            jSONObject2.put("number", (Object)this.cardNumber);
            jSONObject2.put("scheme", (Object)this.cardScheme);
            jSONObject2.put("expiryDate", (Object)this.cardExpiry);
            jSONObject2.put("name", (Object)super.getName());
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("paymentOptions", (Object)jSONArray);
            jSONObject.put("type", (Object)"payment");
            jSONObject.put("defaultOption", (Object)super.getName());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }
}

