/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.classes.j;
import com.citrus.sdk.classes.q;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CardOption
extends PaymentOption {
    protected String cardHolderName = null;
    protected String cardNumber = null;
    protected String cardCVV = null;
    protected String cardExpiry = null;
    protected String cardExpiryMonth = null;
    protected String cardExpiryYear = null;
    protected CardScheme cardScheme = null;
    protected String nickName = null;
    public static final Parcelable.Creator<CardOption> CREATOR = new Parcelable.Creator<CardOption>(){

        public CardOption a(Parcel parcel) {
            return null;
        }

        public CardOption[] a(int n2) {
            return new CardOption[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    CardOption(Amount amount, String string2, String string3, String string4, Month month, Year year) {
        this(string2, string3, string4, month, year);
        this.transactionAmount = amount;
    }

    CardOption(String string2, String string3, String string4, Month month, Year year) {
        this.cardHolderName = !TextUtils.isEmpty((CharSequence)string2) ? q.a(string2) : "Card Holder Name";
        this.cardNumber = CardOption.normalizeCardNumber(string3);
        this.cardCVV = string4;
        this.cardScheme = CardScheme.getCardSchemeUsingNumber(string3);
        if (month != null) {
            this.cardExpiryMonth = month.toString();
        }
        if (year != null) {
            this.cardExpiryYear = year.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && !TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            this.cardExpiry = (Object)((Object)month) + "/" + (Object)((Object)year);
        }
    }

    CardOption(String string2, String string3) {
        this.token = string2;
        this.cardCVV = string3;
    }

    CardOption(String string2, CardScheme cardScheme) {
        this.cardNumber = string2;
        this.cardScheme = cardScheme;
    }

    CardOption() {
    }

    public abstract String getCardType();

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public String getNickName() {
        String string2 = this.getName();
        if ("---".equalsIgnoreCase(string2)) {
            string2 = String.format(this instanceof CreditCardOption ? "Credit Card (%s)" : "Debit Card (%s)", this.getLast4Digits());
        }
        return string2;
    }

    public String getCardExpiryYear() {
        return this.cardExpiryYear;
    }

    public String getCardExpiry() {
        return this.cardExpiry;
    }

    public String getCardExpiryMonth() {
        return this.cardExpiryMonth;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String string2) {
        this.cardCVV = string2;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public void setCardScheme(CardScheme cardScheme) {
        this.cardScheme = cardScheme;
    }

    public void setNickName(String string2) {
        this.nickName = q.a(string2);
    }

    @Override
    public j getPgHealth() {
        return j.GOOD;
    }

    private static String normalizeCardNumber(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.trim().replaceAll("\\s+|-", "");
    }

    public String getLast4Digits() {
        int n2;
        String string2 = null;
        if (!TextUtils.isEmpty((CharSequence)this.cardNumber) && (n2 = this.cardNumber.length()) - 4 > 0) {
            string2 = this.cardNumber.substring(n2 - 4, n2);
        }
        return string2;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        Drawable drawable2 = null;
        int n2 = 0;
        if (this.cardScheme == CardScheme.VISA) {
            n2 = context.getResources().getIdentifier("visa", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MASTER_CARD) {
            n2 = context.getResources().getIdentifier("mcrd", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MAESTRO) {
            n2 = context.getResources().getIdentifier("mtro", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.DINERS) {
            n2 = context.getResources().getIdentifier("dinerclub", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.JCB) {
            n2 = context.getResources().getIdentifier("jcb", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.AMEX) {
            n2 = context.getResources().getIdentifier("amex", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.RPAY) {
            n2 = context.getResources().getIdentifier("rupay", "drawable", context.getPackageName());
            if (n2 == 0) {
                n2 = context.getResources().getIdentifier("rpay", "drawable", context.getPackageName());
            }
        } else if (this.cardScheme == CardScheme.DISCOVER) {
            n2 = context.getResources().getIdentifier("discover", "drawable", context.getPackageName());
        }
        if (n2 == 0) {
            n2 = context.getResources().getIdentifier("default_card", "drawable", context.getPackageName());
            if (n2 != 0) {
                drawable2 = context.getResources().getDrawable(n2);
            }
        } else {
            drawable2 = context.getResources().getDrawable(n2);
        }
        return drawable2;
    }

    @Override
    public String toString() {
        return super.toString() + "CardOption{" + "cardHolderName='" + this.cardHolderName + '\'' + ", cardNumber='" + this.cardNumber + '\'' + ", cardCVV='" + this.cardCVV + '\'' + ", cardExpiry='" + this.cardExpiry + '\'' + ", cardExpiryMonth='" + this.cardExpiryMonth + '\'' + ", cardExpiryYear='" + this.cardExpiryYear + '\'' + ", cardScheme='" + (Object)((Object)this.cardScheme) + '\'' + '}';
    }

    public int getCVVLength() {
        int n2 = 3;
        if (this.cardScheme == CardScheme.AMEX) {
            n2 = 4;
        }
        return n2;
    }

    public boolean validateCard() {
        if (!TextUtils.isEmpty((CharSequence)this.token) && this.cardScheme != CardScheme.MAESTRO) {
            return this.validateCVV();
        }
        if (this.cardScheme == CardScheme.MAESTRO) {
            if (TextUtils.isEmpty((CharSequence)this.token)) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    return this.cardCVV.length() == 3 && this.validateCardNumber();
                }
                return this.validateCardNumber();
            }
            if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                return this.cardCVV.length() == 3;
            }
            return true;
        }
        return this.validateCardNumber() && this.validateExpiryDate() && this.validateCVV();
    }

    public boolean validateForSaveCard() {
        if (this.cardScheme == CardScheme.MAESTRO) {
            return this.validateCardNumber();
        }
        return this.validateCardNumber() && this.validateExpiryDate();
    }

    public boolean validateCardNumber() {
        if (TextUtils.isEmpty((CharSequence)this.cardNumber)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.cardNumber) || !TextUtils.isDigitsOnly((CharSequence)this.cardNumber) || !this.isValidLuhnNumber(this.cardNumber)) {
            return false;
        }
        return !(this.cardScheme == CardScheme.AMEX ? this.cardNumber.length() != 15 : (this.cardScheme == CardScheme.VISA ? this.cardNumber.length() != 13 && this.cardNumber.length() != 16 : (this.cardScheme != CardScheme.MAESTRO ? this.cardNumber.length() != 16 : this.cardNumber.length() < 12 || this.cardNumber.length() > 19)));
    }

    public boolean validateExpiryDate() {
        if (this.cardScheme == CardScheme.MAESTRO && TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            return true;
        }
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !q.a(Integer.valueOf(this.cardExpiryYear), Integer.valueOf(this.cardExpiryMonth));
    }

    private boolean validateExpMonth() {
        if (this.cardExpiryMonth == null) {
            return false;
        }
        return Integer.valueOf(this.cardExpiryMonth) >= 1 && Integer.valueOf(this.cardExpiryMonth) <= 12;
    }

    private boolean validateExpYear() {
        if (this.cardExpiryYear == null) {
            return false;
        }
        return !q.a(Integer.valueOf(this.cardExpiryYear));
    }

    public boolean validateCVV() {
        if (TextUtils.isEmpty((CharSequence)this.cardCVV)) {
            return false;
        }
        if (this.cardScheme == CardScheme.AMEX) {
            return this.cardCVV.length() == 4;
        }
        return this.cardCVV.length() == 3;
    }

    public String getCardValidityFailureReasonsForSaveCard() {
        String string2 = null;
        if (!this.validateForSaveCard()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                stringBuilder.append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                stringBuilder.append(" Invalid Expiry Date. ");
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public String getCardValidityFailureReasons() {
        String string2 = null;
        if (!this.validateCard()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                stringBuilder.append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                stringBuilder.append(" Invalid Expiry Date. ");
            }
            if (this.cardScheme == CardScheme.MAESTRO) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV) && !this.validateCVV()) {
                    stringBuilder.append(" Invalid CVV. ");
                }
            } else if (!this.validateCVV()) {
                stringBuilder.append(" Invalid CVV. ");
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Override
    public String getSavePaymentOptionObject() {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("owner", (Object)this.cardHolderName);
            if (!TextUtils.isEmpty((CharSequence)this.nickName)) {
                jSONObject2.put("name", (Object)this.nickName);
            }
            jSONObject2.put("number", (Object)this.cardNumber);
            jSONObject2.put("scheme", (Object)this.cardScheme.toString());
            if (TextUtils.isEmpty((CharSequence)this.cardExpiry) && this.cardScheme == CardScheme.MAESTRO) {
                jSONObject2.put("expiryDate", (Object)"12/2049");
            } else {
                jSONObject2.put("expiryDate", (Object)this.cardExpiry);
            }
            jSONObject2.put("type", (Object)this.getCardType());
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("paymentOptions", (Object)jSONArray);
            jSONObject.put("type", (Object)"payment");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.isTokenizedPayment()) {
            jSONObject.put("type", (Object)"paymentOptionIdToken");
            jSONObject.put("id", (Object)this.token);
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                jSONObject.put("cvv", (Object)"123");
            } else {
                jSONObject.put("cvv", (Object)this.cardCVV);
            }
        } else {
            jSONObject.put("type", (Object)"paymentOptionToken");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("holder", (Object)this.cardHolderName);
            jSONObject2.put("number", (Object)this.cardNumber);
            jSONObject2.put("scheme", (Object)this.cardScheme.getName().toUpperCase());
            jSONObject2.put("type", (Object)this.getCardType());
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                jSONObject2.put("cvv", (Object)"123");
            } else {
                jSONObject2.put("cvv", (Object)this.cardCVV);
            }
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                jSONObject2.put("expiry", (Object)"11/2049");
            } else {
                jSONObject2.put("expiry", (Object)this.cardExpiry);
            }
            jSONObject.put("paymentMode", (Object)jSONObject2);
        }
        return jSONObject;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jSONObject = null;
        if (this.transactionAmount != null) {
            jSONObject = new JSONObject();
            if (this instanceof CreditCardOption) {
                jSONObject.put("paymentMode", (Object)"CREDIT_CARD");
            } else {
                jSONObject.put("paymentMode", (Object)"DEBIT_CARD");
            }
            if (this.isTokenizedPayment()) {
                jSONObject.put("name", (Object)"");
                jSONObject.put("cardNumber", (Object)"");
                jSONObject.put("cardExpiryDate", (Object)"");
                jSONObject.put("cardScheme", (Object)"");
                jSONObject.put("cvv", (Object)this.cardCVV);
                jSONObject.put("savedCardToken", (Object)this.token);
            } else {
                jSONObject.put("name", (Object)this.cardHolderName);
                jSONObject.put("cardNumber", (Object)this.cardNumber);
                jSONObject.put("cardScheme", (Object)this.cardScheme.getName().toUpperCase());
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                    jSONObject.put("cardExpiryDate", (Object)"11/2049");
                } else {
                    jSONObject.put("cardExpiryDate", (Object)this.cardExpiry);
                }
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    jSONObject.put("cvv", (Object)"123");
                } else {
                    jSONObject.put("cvv", (Object)this.cardCVV);
                }
            }
            jSONObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jSONObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jSONObject;
    }

    private boolean isValidLuhnNumber(String string2) {
        boolean bl = true;
        int n2 = 0;
        for (int i2 = string2.length() - 1; i2 >= 0; --i2) {
            char c2 = string2.charAt(i2);
            if (!Character.isDigit(c2)) {
                return false;
            }
            int n3 = Integer.parseInt("" + c2);
            boolean bl2 = bl = !bl;
            if (bl) {
                n3 *= 2;
            }
            if (n3 > 9) {
                n3 -= 9;
            }
            n2 += n3;
        }
        return n2 % 10 == 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.cardHolderName);
        parcel.writeString(this.cardNumber);
        parcel.writeString(this.cardCVV);
        parcel.writeString(this.cardExpiry);
        parcel.writeString(this.cardExpiryMonth);
        parcel.writeString(this.cardExpiryYear);
        parcel.writeInt(this.cardScheme == null ? -1 : this.cardScheme.ordinal());
        parcel.writeString(this.nickName);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
    }

    protected CardOption(Parcel parcel) {
        super(parcel);
        this.cardHolderName = parcel.readString();
        this.cardNumber = parcel.readString();
        this.cardCVV = parcel.readString();
        this.cardExpiry = parcel.readString();
        this.cardExpiryMonth = parcel.readString();
        this.cardExpiryYear = parcel.readString();
        int n2 = parcel.readInt();
        this.cardScheme = n2 == -1 ? null : CardScheme.values()[n2];
        this.nickName = parcel.readString();
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
    }

    public static enum CardScheme {
        VISA(new String[]{"4"}){

            @Override
            public String getName() {
                return "visa";
            }
        }
        ,
        MASTER_CARD(new String[]{"5"}){

            @Override
            public String getName() {
                return "mcrd";
            }
        }
        ,
        MAESTRO(new String[]{"502260", "504433", "504434", "504435", "504437", "504645", "504681", "504753", "504775", "504809", "504817", "504834", "504848", "504884", "504973", "504993", "508125", "508126", "508159", "508192", "508227", "56", "600206", "603123", "603741", "603845", "622018", "67"}){

            @Override
            public String getName() {
                return "mtro";
            }
        }
        ,
        DINERS(new String[]{"30", "36", "38", "39"}){

            @Override
            public String getName() {
                return "DINERS";
            }
        }
        ,
        JCB(new String[]{"35"}){

            @Override
            public String getName() {
                return "jcb";
            }
        }
        ,
        AMEX(new String[]{"34", "37"}){

            @Override
            public String getName() {
                return "amex";
            }
        }
        ,
        RPAY(new String[]{"5085", "5086", "5087", "5088", "6069", "607", "6081", "6521", "6522", "6524"}){

            @Override
            public String getName() {
                return "RPAY";
            }
        }
        ,
        DISCOVER(new String[]{"60", "62", "64", "65"}){

            @Override
            public String getName() {
                return "DISCOVER";
            }
        }
        ,
        UNKNOWN(new String[]{"0"}){

            @Override
            public String getName() {
                return "UNKNOWN";
            }
        };

        private final String[] pattern;

        private CardScheme(String ... stringArray) {
            this.pattern = stringArray;
        }

        public abstract String getName();

        public String getIconName() {
            return this.getName().toLowerCase();
        }

        public static CardScheme getCardScheme(String string2) {
            if ("visa".equalsIgnoreCase(string2)) {
                return VISA;
            }
            if ("mcrd".equalsIgnoreCase(string2) || "Master Card".equalsIgnoreCase(string2)) {
                return MASTER_CARD;
            }
            if ("mtro".equalsIgnoreCase(string2) || "Maestro Card".equalsIgnoreCase(string2)) {
                return MAESTRO;
            }
            if ("DINERS".equalsIgnoreCase(string2)) {
                return DINERS;
            }
            if ("jcb".equalsIgnoreCase(string2)) {
                return JCB;
            }
            if ("amex".equalsIgnoreCase(string2)) {
                return AMEX;
            }
            if ("DISCOVER".equalsIgnoreCase(string2)) {
                return DISCOVER;
            }
            if ("RPAY".equalsIgnoreCase(string2) || "RuPay".equalsIgnoreCase(string2)) {
                return RPAY;
            }
            return null;
        }

        public static CardScheme getCardSchemeUsingNumber(String string2) {
            CardScheme cardScheme = UNKNOWN;
            for (CardScheme cardScheme2 : CardScheme.values()) {
                if (!q.a(string2, cardScheme2.pattern)) continue;
                cardScheme = cardScheme2;
                break;
            }
            return cardScheme;
        }

        public static int getCVVLength(String string2) {
            CardScheme cardScheme = CardScheme.getCardSchemeUsingNumber(string2);
            if (cardScheme == AMEX) {
                return 4;
            }
            return 3;
        }

        public static int getFilterLength(CardScheme cardScheme) {
            if (cardScheme == AMEX) {
                return 18;
            }
            if (cardScheme == MAESTRO) {
                return 23;
            }
            return 19;
        }
    }

    public static enum CardType {
        DEBIT{

            @Override
            public String getCardType() {
                return "debit";
            }
        }
        ,
        CREDIT{

            @Override
            public String getCardType() {
                return "credit";
            }
        };


        public abstract String getCardType();
    }
}

