/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DynamicPricingRequest {
    private DynamicPricingRequestType dynamicPricingRequestType;
    private PaymentBill paymentBill;

    public DynamicPricingRequest(DynamicPricingRequestType dynamicPricingRequestType, PaymentBill paymentBill) {
        this.dynamicPricingRequestType = dynamicPricingRequestType;
        this.paymentBill = paymentBill;
    }

    public DynamicPricingRequestType getDynamicPricingRequestType() {
        return this.dynamicPricingRequestType;
    }

    public PaymentBill getPaymentBill() {
        return this.paymentBill;
    }

    public static String toJSON(DynamicPricingRequest dynamicPricingRequest) {
        String string2 = null;
        if (dynamicPricingRequest != null) {
            JSONObject jSONObject = new JSONObject();
            DynamicPricingRequestType dynamicPricingRequestType = dynamicPricingRequest.getDynamicPricingRequestType();
            Amount amount = dynamicPricingRequestType.getOriginalAmount();
            CitrusUser citrusUser = dynamicPricingRequestType.getCitrusUser();
            PaymentOption paymentOption = dynamicPricingRequestType.getPaymentOption();
            PaymentBill paymentBill = dynamicPricingRequest.getPaymentBill();
            Map<String, String> map = dynamicPricingRequestType.getExtraParameters();
            try {
                jSONObject.put("email", (Object)(citrusUser != null ? citrusUser.getEmailId() : null));
                jSONObject.put("phone", (Object)(citrusUser != null ? citrusUser.getMobileNo() : null));
                jSONObject.put("merchantTransactionId", (Object)paymentBill.getMerchantTransactionId());
                jSONObject.put("merchantAccessKey", (Object)paymentBill.getMerchantAccessKey());
                jSONObject.put("signature", (Object)paymentBill.getDpSignature());
                jSONObject.put("originalAmount", (Object)Amount.toJSONObject(amount));
                jSONObject.put("paymentInfo", (Object)DynamicPricingRequest.getPaymentInformation(paymentOption));
                JSONObject jSONObject2 = new JSONObject();
                if (map != null) {
                    for (String string3 : map.keySet()) {
                        jSONObject2.put(string3, (Object)map.get(string3));
                    }
                }
                jSONObject2.put("operation", (Object)dynamicPricingRequestType.getDPOperationName());
                jSONObject.put("extraParams", (Object)jSONObject2);
                if (dynamicPricingRequestType instanceof DynamicPricingRequestType.CalculatePrice) {
                    jSONObject.put("ruleName", (Object)((DynamicPricingRequestType.CalculatePrice)dynamicPricingRequestType).getRuleName());
                } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.ValidateRule) {
                    Amount amount2 = ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getAlteredAmount();
                    jSONObject.put("ruleName", (Object)((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getRuleName());
                    jSONObject.put("alteredAmount", (Object)Amount.toJSONObject(amount2));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            string2 = jSONObject.toString();
        }
        return string2;
    }

    private static JSONObject getPaymentInformation(PaymentOption paymentOption) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (paymentOption != null) {
                if (paymentOption.getToken() != null) {
                    jSONObject.put("paymentToken", (Object)paymentOption.getToken());
                } else if (paymentOption instanceof NetbankingOption) {
                    jSONObject.put("issuerId", (Object)((NetbankingOption)paymentOption).getBankCID());
                } else if (paymentOption instanceof CardOption) {
                    jSONObject.put("cardNo", (Object)((CardOption)paymentOption).getCardNumber());
                    jSONObject.put("cardType", (Object)((CardOption)paymentOption).getCardScheme().getName().toUpperCase());
                }
                jSONObject.put("paymentMode", (Object)paymentOption.getDynamicPricingPaymentMode());
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }
}

