/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class Amount
implements Parcelable,
Comparable<Amount> {
    @SerializedName(value="value")
    private final String a;
    @SerializedName(value="currency")
    private final String b;
    public static final Parcelable.Creator<Amount> CREATOR = new Parcelable.Creator<Amount>(){

        public Amount a(Parcel parcel) {
            return new Amount(parcel);
        }

        public Amount[] a(int n2) {
            return new Amount[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public Amount(String string2) {
        this.a = string2;
        this.b = "INR";
    }

    public Amount(String string2, String string3) {
        this.a = string2;
        this.b = string3;
    }

    public String getValue() {
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            return this.a.replaceFirst("^0+(?!$)", "");
        }
        return this.a;
    }

    public String getCurrency() {
        return this.b;
    }

    public String getValueAsFormattedDouble(String string2) throws NumberFormatException {
        DecimalFormat decimalFormat = new DecimalFormat(string2);
        return decimalFormat.format(this.getValueAsDouble());
    }

    public double getValueAsDouble() throws NumberFormatException {
        double d2 = 0.0;
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            d2 = Double.parseDouble(this.a);
        }
        return d2;
    }

    public static Amount fromJSON(String string2) {
        Amount amount = null;
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                jSONObject = new JSONObject(string2);
                amount = Amount.fromJSONObject(jSONObject);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return amount;
    }

    public static Amount fromJSONObject(JSONObject jSONObject) {
        Amount amount = null;
        if (jSONObject != null) {
            String string2 = jSONObject.optString("value");
            String string3 = jSONObject.optString("currency");
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
                amount = new Amount(string2, string3);
            }
        }
        return amount;
    }

    public static String toJSON(Amount amount) {
        JSONObject jSONObject = Amount.toJSONObject(amount);
        if (jSONObject != null) {
            return jSONObject.toString();
        }
        return null;
    }

    public static JSONObject toJSONObject(Amount amount) {
        JSONObject jSONObject = null;
        if (amount != null) {
            try {
                jSONObject = new JSONObject();
                jSONObject.put("value", (Object)amount.a);
                jSONObject.put("currency", (Object)amount.b);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.a);
        parcel.writeString(this.b);
    }

    private Amount(Parcel parcel) {
        this.a = parcel.readString();
        this.b = parcel.readString();
    }

    public String toString() {
        return "Amount{value='" + this.a + '\'' + ", currency='" + this.b + '\'' + '}';
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Amount) {
            Amount amount = (Amount)object;
            return this.getValueAsDouble() == amount.getValueAsDouble() && this.b.equalsIgnoreCase(amount.getCurrency());
        }
        return false;
    }

    @Override
    public int compareTo(Amount amount) {
        if (this.getValueAsDouble() > amount.getValueAsDouble()) {
            return 1;
        }
        if (this.getValueAsDouble() < amount.getValueAsDouble()) {
            return -1;
        }
        return 0;
    }

    public boolean isValidAmount() {
        String[] stringArray = this.a.split("\\.");
        if (stringArray.length > 1) {
            int n2 = stringArray[1].length();
            return n2 <= 2;
        }
        return true;
    }
}

