/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.text.TextUtils;

public enum Environment {
    SANDBOX{

        @Override
        public String getBaseUrl() {
            return "https://sandboxadmin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://sandbox.citruspay.com";
        }

        @Override
        public String getWalletPGBaseUrl() {
            return "https://betawallet.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://sandboxmars.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamic-pricing";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String string2) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", string2);
        }

        @Override
        public String getBlazeCardUrl() {
            return "https://blazecardsbox.citruspay.com";
        }

        @Override
        public String getBlazeNetUrl() {
            return "https://sboxblazenet.citruspay.com";
        }

        public String toString() {
            return "SANDBOX";
        }
    }
    ,
    PRODUCTION{

        @Override
        public String getBaseUrl() {
            return "https://admin.citruspay.com";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://citruspay.com";
        }

        @Override
        public String getWalletPGBaseUrl() {
            return "https://wallet.citruspay.com";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://mars.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamicpricing";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-5";
        }

        @Override
        public String getCancelUrl(String string2) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", string2);
        }

        @Override
        public String getBlazeCardUrl() {
            return "https://citruspay.com";
        }

        @Override
        public String getBlazeNetUrl() {
            return "https://sboxblazenet.citruspay.com";
        }

        public String toString() {
            return "PRODUCTION";
        }
    }
    ,
    CUSTOM{
        String baseUrl;
        String baseCitrusUrl;
        String dynamicPricingBaseUrl;
        String dynamicPricingPath;

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public String getBaseCitrusUrl() {
            return this.baseCitrusUrl;
        }

        @Override
        public String getWalletPGBaseUrl() {
            return null;
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return this.dynamicPricingBaseUrl;
        }

        @Override
        public String getDynamicPricingPath() {
            if (!TextUtils.isEmpty((CharSequence)this.dynamicPricingPath)) {
                return this.dynamicPricingPath;
            }
            return "dynamic-pricing";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        @Override
        public String getCancelUrl(String string2) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", string2);
        }

        @Override
        public String getBlazeCardUrl() {
            return null;
        }

        @Override
        public String getBlazeNetUrl() {
            return null;
        }

        public String toString() {
            return "CUSTOM";
        }
    }
    ,
    STG18{

        @Override
        public String getBaseUrl() {
            return "https://stgadmin18.citruspay.com/";
        }

        @Override
        public String getBaseCitrusUrl() {
            return "https://stgpg18.citruspay.com/";
        }

        @Override
        public String getWalletPGBaseUrl() {
            return null;
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return "https://stgadmin18.citruspay.com";
        }

        @Override
        public String getDynamicPricingPath() {
            return "dynamic-pricing";
        }

        @Override
        public String getAnalyticsID() {
            return "UA-33514461-4";
        }

        public String toString() {
            return "STG18";
        }

        @Override
        public String getBinServiceURL() {
            return "https://citrusapi.citruspay.com";
        }

        @Override
        public String getCancelUrl(String string2) {
            return String.format(this.getBaseCitrusUrl() + "/sslperf/%s/cancel", string2);
        }

        @Override
        public String getBlazeCardUrl() {
            return null;
        }

        @Override
        public String getBlazeNetUrl() {
            return null;
        }
    }
    ,
    NONE{

        @Override
        public String getBaseUrl() {
            return null;
        }

        public String toString() {
            return null;
        }

        @Override
        public String getBaseCitrusUrl() {
            return null;
        }

        @Override
        public String getWalletPGBaseUrl() {
            return null;
        }

        @Override
        public String getBinServiceURL() {
            return null;
        }

        @Override
        public String getDynamicPricingBaseUrl() {
            return null;
        }

        @Override
        public String getDynamicPricingPath() {
            return null;
        }

        @Override
        public String getAnalyticsID() {
            return null;
        }

        @Override
        public String getCancelUrl(String string2) {
            return null;
        }

        @Override
        public String getBlazeCardUrl() {
            return null;
        }

        @Override
        public String getBlazeNetUrl() {
            return null;
        }
    };


    public abstract String getBaseUrl();

    public abstract String getBaseCitrusUrl();

    public abstract String getWalletPGBaseUrl();

    public abstract String getBinServiceURL();

    public abstract String getDynamicPricingBaseUrl();

    public abstract String getDynamicPricingPath();

    public abstract String getAnalyticsID();

    public abstract String getCancelUrl(String var1);

    public abstract String getBlazeCardUrl();

    public abstract String getBlazeNetUrl();
}

