/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.widget.Toast;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusActivity;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.Environment;
import com.citrus.sdk.PaymentDistribution;
import com.citrus.sdk.SubscriptionRequest;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.b.b;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserPasswordType;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.c;
import com.citrus.sdk.classes.f;
import com.citrus.sdk.classes.h;
import com.citrus.sdk.classes.m;
import com.citrus.sdk.classes.o;
import com.citrus.sdk.classes.q;
import com.citrus.sdk.d;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.e;
import com.citrus.sdk.g;
import com.citrus.sdk.i;
import com.citrus.sdk.login.AccessType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.BindUserResponse;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusLogger;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.facebook.android.crypto.keychain.SharedPrefsBackedKeyChain;
import com.facebook.crypto.Crypto;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.util.NativeCryptoLibrary;
import com.facebook.crypto.util.SystemNativeCryptoLibrary;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class CitrusClient
implements d {
    private String signinId;
    private String signinSecret;
    private String signupId;
    private String signupSecret;
    private String vanity;
    private String merchantName;
    private Environment environment = Environment.SANDBOX;
    private Amount balanceAmount;
    private static CitrusClient instance;
    private final Context mContext;
    private MerchantPaymentOption merchantPaymentOption = null;
    private com.citrus.c.b oauthToken = null;
    private BroadcastReceiver paymentEventReceiver = null;
    private boolean initialized = false;
    private boolean showDummyScreen = false;
    private boolean autoOtpReading = false;
    private g retrofitAPIWrapper = null;
    private PaymentOption persistPaymentOption = null;
    private boolean checkPrepaidTokenValidityCalled = false;
    private Crypto crypto = null;
    private o updateSubscriptionRequest = null;
    private SubscriptionRequest subscriptionRequest = null;
    private SubscriptionResponse activeSubscription = null;
    public static boolean isCitrusNativeLibraryLoaded;
    public static boolean isFacebookNativeLibraryLoaded;
    public boolean isUserLoggedIn = false;
    private a mAUTO_load_type = null;

    public Crypto getCrypto() {
        return this.crypto;
    }

    public o getUpdateSubscriptionRequest() {
        return this.updateSubscriptionRequest;
    }

    public SubscriptionRequest getSubscriptionRequest() {
        return this.subscriptionRequest;
    }

    private CitrusClient(Context context) {
        this.mContext = context;
        this.retrofitAPIWrapper = g.a(context);
        CitrusConfig.getInstance().setConfigChangeListener(this);
    }

    public void enableLog(boolean bl) {
        if (bl) {
            CitrusLogger.enableLogs();
        } else {
            CitrusLogger.disableLogs();
        }
    }

    public void showDummyScreenWhilePayments(boolean bl) {
        this.showDummyScreen = bl;
    }

    public boolean isShowDummyScreenWhilePayments() {
        return this.showDummyScreen;
    }

    public boolean isAutoOtpReading() {
        return this.autoOtpReading;
    }

    public void enableAutoOtpReading(boolean bl) {
        this.autoOtpReading = bl;
    }

    public native String getEncryptionKey();

    public a getAUTO_load_type() {
        return this.mAUTO_load_type;
    }

    public void destroy() {
        this.initialized = false;
        this.signinId = null;
        this.signinSecret = null;
        this.signupId = null;
        this.signupSecret = null;
        this.vanity = null;
        this.environment = null;
        this.oauthToken = null;
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.retrofitAPIWrapper.f();
    }

    public void cancelAllRequests() {
        this.retrofitAPIWrapper.f();
    }

    public void init(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull String string6, @NonNull Environment environment) {
        if (!this.initialized) {
            this.oauthToken = new com.citrus.c.b(this.mContext);
            this.signupId = string2;
            this.signupSecret = string3;
            this.signinId = string4;
            this.signinSecret = string5;
            this.vanity = string6;
            if (this.validate()) {
                this.retrofitAPIWrapper.a(string2, string3, string4, string5, string6, environment);
            }
            if (!CitrusLogger.isEnableLogs()) {
                CitrusLogger.disableLogs();
            }
            if (environment == null) {
                this.environment = Environment.SANDBOX;
            }
            this.environment = environment;
            this.saveSDKEnvironment();
            this.isUserSignedIn(new Callback<Boolean>(){

                public void a(Boolean bl) {
                    if (bl.booleanValue()) {
                        CitrusClient.this.isUserLoggedIn = true;
                    }
                }

                @Override
                public void error(CitrusError citrusError) {
                }

                @Override
                public /* synthetic */ void success(Object object) {
                    this.a((Boolean)object);
                }
            });
            this.initialized = true;
        }
        if (environment != Environment.PRODUCTION) {
            Toast.makeText((Context)this.mContext, (CharSequence)("Environment is *** " + environment.toString()), (int)1).show();
        }
    }

    private void fetchPGHealthForAllBanks() {
        this.retrofitAPIWrapper.b();
    }

    private void saveSDKEnvironment() {
        if (this.oauthToken.b() == Environment.NONE) {
            this.oauthToken.a(this.environment);
            Logger.d((String)"NO ENVIRONMENT EXISTS earlier", (Object[])new Object[0]);
        } else if (this.oauthToken.b() == this.environment) {
            Logger.d((String)"PREVIOUS AND CURRENT ENVIRONMENT IS SAME", (Object[])new Object[0]);
        } else {
            this.signOut(new Callback<CitrusResponse>(){

                public void a(CitrusResponse citrusResponse) {
                    CitrusClient.this.oauthToken.a(CitrusClient.this.environment);
                    Logger.d((String)"ENVIRONMMENT MISMATCH ***user Logging out", (Object[])new Object[0]);
                }

                @Override
                public void error(CitrusError citrusError) {
                    CitrusClient.this.oauthToken.a(CitrusClient.this.environment);
                }

                @Override
                public /* synthetic */ void success(Object object) {
                    this.a((CitrusResponse)object);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusClient getInstance(Context context) {
        if (instance != null) return instance;
        Class<CitrusClient> clazz = CitrusClient.class;
        synchronized (CitrusClient.class) {
            if (instance != null) return instance;
            instance = new CitrusClient(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void validateLinkUserCredentials(String string2, String string3, Callback callback) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.sendError(callback, new CitrusError("Email ID should not be null.", CitrusResponse.Status.FAILED));
        } else if (TextUtils.isEmpty((CharSequence)string3)) {
            this.sendError(callback, new CitrusError("Mobile number should not be null.", CitrusResponse.Status.FAILED));
        } else if (!q.a((CharSequence)string2) && !q.d(string3)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
        } else if (!q.a((CharSequence)string2)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (!q.d(string3)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
        } else {
            this.sendResponse(callback, true);
        }
    }

    private void validateLinkBindUserCredentials(String string2, String string3, AccessType accessType, Callback callback) {
        if (!q.a((CharSequence)string2) && !q.d(string3)) {
            this.sendError(callback, new CitrusError("Invalid Credentials entered.", CitrusResponse.Status.FAILED));
        } else if (!q.a((CharSequence)string2)) {
            this.sendError(callback, new CitrusError("Email is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (!q.d(string3)) {
            this.sendError(callback, new CitrusError("Mobile number is not in proper format.", CitrusResponse.Status.FAILED));
        } else if (TextUtils.isEmpty((CharSequence)string3) && accessType == AccessType.FULL) {
            this.sendError(callback, new CitrusError("Mobile No is required for Full Access.", CitrusResponse.Status.FAILED));
        } else {
            this.sendResponse(callback, true);
        }
    }

    public synchronized void linkUserExtended(final String string2, final String string3, final Callback<LinkUserExtendedResponse> callback) {
        this.validateLinkUserCredentials(string2, string3, new Callback(){

            public void success(Object object) {
                CitrusClient.this.retrofitAPIWrapper.e(string2, string3, callback);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkUserExtendedSignIn(LinkUserExtendedResponse linkUserExtendedResponse, LinkUserPasswordType linkUserPasswordType, String string2, Callback<CitrusResponse> callback) {
        String string3 = linkUserExtendedResponse.getInputEmail();
        if (string2 == null || string2.equalsIgnoreCase("")) {
            this.sendError(callback, new CitrusError(linkUserExtendedResponse.getLinkUserMessage(), CitrusResponse.Status.FAILED));
        } else if (linkUserPasswordType == LinkUserPasswordType.None) {
            this.sendError(callback, new CitrusError(linkUserExtendedResponse.getLinkUserMessage(), CitrusResponse.Status.FAILED));
        } else {
            int n2 = linkUserExtendedResponse.formatResponseCode();
            switch (linkUserPasswordType) {
                case Otp: {
                    if (n2 == 1 || n2 == 6 || n2 == 2 || n2 == 7) {
                        Logger.d((String)"old sigin, otp", (Object[])new Object[0]);
                        this.signInWithOTP(linkUserExtendedResponse, string2, callback);
                        break;
                    }
                    if (n2 == 3 || n2 == 4 || n2 == 5 || n2 == 10 || n2 == 11 || n2 == 12) {
                        Logger.d((String)"verify and sigin, otp", (Object[])new Object[0]);
                        CitrusClient citrusClient = this;
                        synchronized (citrusClient) {
                            this.linkUserExtendedVerifyMobileAndSignIn(linkUserExtendedResponse, string2, callback);
                            break;
                        }
                    }
                    if (n2 != 8 && n2 != 9) break;
                    Logger.d((String)"Update mobile sigin, e-otp", (Object[])new Object[0]);
                    String string4 = com.citrus.c.a.onetimepass.toString();
                    CitrusClient citrusClient = this;
                    synchronized (citrusClient) {
                        this.linkUserExtendedVerifyEOTPAndUpdateMobile(string3, string4, string2, linkUserExtendedResponse, callback);
                        break;
                    }
                }
                case Password: {
                    if (n2 == 1 || n2 == 6 || n2 == 2 || n2 == 5) {
                        Logger.d((String)"old sigin, password", (Object[])new Object[0]);
                        this.signIn(string3, string2, callback);
                        break;
                    }
                    if (n2 != 8) break;
                    Logger.d((String)"Update mobile sigin, password", (Object[])new Object[0]);
                    String string5 = com.citrus.c.a.password.toString();
                    CitrusClient citrusClient = this;
                    synchronized (citrusClient) {
                        this.linkUserExtendedVerifyEOTPAndUpdateMobile(string3, string5, string2, linkUserExtendedResponse, callback);
                        break;
                    }
                }
            }
        }
    }

    public void linkUserExtendedVerifyEOTPAndUpdateMobile(String string2, String string3, String string4, LinkUserExtendedResponse linkUserExtendedResponse, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string2, string3, string4, linkUserExtendedResponse, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void linkUserExtendedVerifyMobileAndSignIn(LinkUserExtendedResponse linkUserExtendedResponse, String string2, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(linkUserExtendedResponse, string2, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void isCitrusMember(String string2, String string3, Callback<Boolean> callback) {
        this.retrofitAPIWrapper.b(string2, string3, callback);
    }

    public synchronized void getMemberInfo(String string2, String string3, Callback<MemberInfo> callback) {
        this.retrofitAPIWrapper.c(string2, string3, callback);
    }

    public synchronized void bindUser(String string2, String string3, Callback<String> callback) {
        this.retrofitAPIWrapper.a(string2, string3, callback);
    }

    public synchronized void bindUserByMobile(String string2, String string3, Callback<BindUserResponse> callback) {
        this.retrofitAPIWrapper.d(string2, string3, callback);
    }

    public synchronized void linkUserWithOTP(String string2, String string3, boolean bl, Callback<LinkUserResponse> callback) {
        this.retrofitAPIWrapper.a(string2, string3, bl, callback);
    }

    public synchronized void signIn(String string2, String string3, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.f(string2, string3, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithMobileNo(String string2, String string3, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.g(string2, string3, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signInWithOTP(LinkUserExtendedResponse linkUserExtendedResponse, String string2, Callback<CitrusResponse> callback) {
        String string3 = linkUserExtendedResponse.getLinkUserMobile();
        this.retrofitAPIWrapper.h(string3, string2, callback);
        this.checkPrepaidTokenValidityCalled = true;
        this.isUserLoggedIn = true;
    }

    public synchronized void signOut(Callback<CitrusResponse> callback) {
        this.isUserLoggedIn = false;
        this.checkPrepaidTokenValidityCalled = false;
        this.activeSubscription = null;
        this.retrofitAPIWrapper.f(callback);
    }

    public synchronized void signUp(String string2, String string3, String string4, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string2, string3, string4, callback);
    }

    public synchronized void resetPassword(String string2, @NonNull Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string2, callback);
    }

    public synchronized void updateMobile(String string2, Callback<String> callback) {
        this.retrofitAPIWrapper.b(string2, callback);
    }

    public synchronized void verifyMobile(String string2, Callback<String> callback) {
        this.retrofitAPIWrapper.c(string2, callback);
    }

    public synchronized void getWallet(Callback<List<PaymentOption>> callback) {
        this.retrofitAPIWrapper.m(callback);
    }

    public synchronized void getWalletWithDefaultBank(Callback<List<PaymentOption>> callback, com.citrus.sdk.b b2) {
        this.retrofitAPIWrapper.a(callback, b2);
    }

    @Deprecated
    public synchronized void activatePrepaidUser(Callback<Amount> callback) {
        this.retrofitAPIWrapper.i(callback);
    }

    public synchronized void getProfileInfo(Callback<CitrusUser> callback) {
        this.retrofitAPIWrapper.e(callback);
    }

    public synchronized void getBalance(Callback<Amount> callback) {
        this.retrofitAPIWrapper.h(callback);
    }

    public synchronized void savePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(paymentOption, callback);
    }

    private synchronized void saveCard(PaymentOption paymentOption, Callback<com.citrus.sdk.a> callback) {
        if (CitrusConfig.getInstance().isOneTapPaymentEnabled() && this.isOneTapPaymentSupported()) {
            this.retrofitAPIWrapper.b(paymentOption, callback);
        }
    }

    public synchronized void deletePaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.c(paymentOption, callback);
    }

    public synchronized void getBill(String string2, Amount amount, String string3, Callback<PaymentBill> callback) {
        this.retrofitAPIWrapper.a(string2, amount, string3, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull String string2, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.a(dynamicPricingRequestType, string2, callback);
    }

    public synchronized void performDynamicPricing(@NonNull DynamicPricingRequestType dynamicPricingRequestType, @NonNull PaymentBill paymentBill, @NonNull Callback<DynamicPricingResponse> callback) {
        this.retrofitAPIWrapper.a(dynamicPricingRequestType, paymentBill, callback);
    }

    public synchronized void sendMoney(Amount amount, CitrusUser citrusUser, String string2, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(amount, citrusUser, string2, callback);
    }

    public synchronized void sendMoneyToMoblieNo(Amount amount, String string2, String string3, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(amount, string2, string3, callback);
    }

    public void getPrepaidToken(Callback<AccessToken> callback) {
        this.retrofitAPIWrapper.c(callback);
    }

    public synchronized void getMerchantPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.k(callback);
    }

    public synchronized void getLoadMoneyPaymentOptions(Callback<MerchantPaymentOption> callback) {
        this.retrofitAPIWrapper.l(callback);
    }

    public synchronized void isUserSignedIn(final Callback<Boolean> callback) {
        this.getPrepaidToken(new Callback<AccessToken>(){

            public void a(AccessToken accessToken) {
                CitrusClient.this.sendResponse(callback, true);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendResponse(callback, false);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((AccessToken)object);
            }
        });
    }

    public synchronized void loadMoney(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = loadMoney.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                this.subscriptionRequest = null;
                this.mAUTO_load_type = null;
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(loadMoney))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        if (this.mAUTO_load_type == null) {
            this.mAUTO_load_type = a.LAZY_AUTO_LOAD;
        }
        this.createAutoLoadRequest(loadMoney.getPaymentOption());
        this.registerReceiver(callback, new IntentFilter(loadMoney.getIntentAction()));
        this.startCitrusActivity(loadMoney, false);
    }

    public synchronized void loadMoneyWithOneTap(PaymentType.LoadMoney loadMoney, Callback<TransactionResponse> callback) {
        if (loadMoney != null) {
            if (loadMoney.getPaymentOption() instanceof CardOption) {
                if (loadMoney.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)loadMoney.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)loadMoney.getPaymentOption()));
                this.persistPaymentOption = loadMoney.getPaymentOption();
                this.loadMoney(loadMoney, callback);
            } else {
                this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
        }
    }

    public synchronized void pgPayment(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(pGPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, false);
    }

    public synchronized void pgPaymentWithOneTap(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            if (pGPayment.getPaymentOption() instanceof CardOption) {
                if (pGPayment.getPaymentOption().getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint((CardOption)pGPayment.getPaymentOption()) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)pGPayment.getPaymentOption()).setCardCVV(this.getCVVOfFingerPrint((CardOption)pGPayment.getPaymentOption()));
                this.persistPaymentOption = pGPayment.getPaymentOption();
                this.pgPayment(pGPayment, callback);
            } else {
                this.sendError(callback, new CitrusError("One tap payment is available only for Card Payment", CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("PaymentOption is null.", CitrusResponse.Status.FAILED));
        }
    }

    @Deprecated
    public synchronized void pgPayment(DynamicPricingResponse dynamicPricingResponse, Callback<TransactionResponse> callback) {
        if (dynamicPricingResponse != null) {
            PaymentBill paymentBill = dynamicPricingResponse.getPaymentBill();
            try {
                PaymentType.PGPayment pGPayment = new PaymentType.PGPayment(paymentBill, dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
                this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
                this.startCitrusActivity(pGPayment, dynamicPricingResponse, false);
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
                this.sendError(callback, new CitrusError(citrusException.getMessage(), CitrusResponse.Status.FAILED));
            }
        } else {
            this.sendError(callback, new CitrusError("Dynamic Pricing Response can not be null", CitrusResponse.Status.FAILED));
        }
    }

    private synchronized void walletPGCharge(i i2, Callback<TransactionResponse> callback) {
        PaymentOption paymentOption = i2.b();
        if (paymentOption != null) {
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(i2))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        if (!i2.a()) {
            this.sendError(callback, new CitrusError("Total Transaction of all the payment options should be equal to actual transaction amount.", CitrusResponse.Status.FAILED));
            return;
        }
        this.persistPaymentOption = paymentOption;
        this.registerReceiver(callback, new IntentFilter(i2.getIntentAction()));
        this.startCitrusActivity(i2, false);
    }

    public synchronized void makePayment(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption;
            this.persistPaymentOption = paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
            if (!this.validatePaymentOptionForMerchant(paymentOption, this.retrofitAPIWrapper.a(pGPayment))) {
                this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, true);
    }

    public synchronized void makePaymentWithOneTap(PaymentType.PGPayment pGPayment, Callback<TransactionResponse> callback) {
        if (pGPayment != null) {
            PaymentOption paymentOption = pGPayment.getPaymentOption();
            if (paymentOption instanceof CardOption) {
                CardOption cardOption = (CardOption)paymentOption;
                if (cardOption.getFingerPrint() == null) {
                    this.sendError(callback, new CitrusError("This payment is available only for saved cards", CitrusResponse.Status.FAILED));
                    return;
                }
                if (this.getCVVOfFingerPrint(cardOption) == null) {
                    this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
                    return;
                }
                ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint(cardOption));
                this.persistPaymentOption = paymentOption;
            }
            if (paymentOption instanceof CardOption && !((CardOption)paymentOption).validateCard()) {
                this.sendError(callback, new CitrusError(((CardOption)paymentOption).getCardValidityFailureReasons(), CitrusResponse.Status.FAILED));
                return;
            }
        }
        this.registerReceiver(callback, new IntentFilter(pGPayment.getIntentAction()));
        this.startCitrusActivity(pGPayment, true);
    }

    private void isEnoughPrepaidBalance(final Amount amount, final Callback<Boolean> callback) {
        this.getBalance(new Callback<Amount>(){

            public void a(Amount amount2) {
                if (amount2.getValueAsDouble() >= amount.getValueAsDouble()) {
                    CitrusClient.this.sendResponse(callback, true);
                } else {
                    CitrusClient.this.sendResponse(callback, false);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Amount)object);
            }
        });
    }

    @Deprecated
    public synchronized void prepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        this.getProfileInfo(new Callback<CitrusUser>(){

            public void a(CitrusUser citrusUser) {
                CitrusClient.this.proceedWithNewPrepaidPay(citrusCash, callback);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.proceedWithNewPrepaidPay(citrusCash, callback);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((CitrusUser)object);
            }
        });
    }

    private void proceedWithNewPrepaidPay(final PaymentType.CitrusCash citrusCash, final Callback<PaymentResponse> callback) {
        if (!this.checkPrepaidTokenValidityCalled) {
            this.checkPrepaymentTokenValidity(new Callback<Boolean>(){

                public void a(Boolean bl) {
                    if (bl.booleanValue()) {
                        CitrusClient.this.retrofitAPIWrapper.a(citrusCash, (Callback<PaymentResponse>)callback);
                    } else {
                        CitrusClient.this.sendError(callback, new CitrusError("User's cookie has expired. Please signin.", CitrusResponse.Status.FAILED));
                    }
                }

                @Override
                public void error(CitrusError citrusError) {
                    CitrusClient.this.sendError(callback, new CitrusError(citrusError.getMessage(), CitrusResponse.Status.FAILED));
                }

                @Override
                public /* synthetic */ void success(Object object) {
                    this.a((Boolean)object);
                }
            });
            this.checkPrepaidTokenValidityCalled = true;
        } else {
            this.retrofitAPIWrapper.a(citrusCash, callback);
        }
    }

    private void checkPrepaymentTokenValidity(Callback<Boolean> callback) {
        this.retrofitAPIWrapper.g(callback);
    }

    public synchronized void cashout(@NonNull CashoutInfo cashoutInfo, Callback<PaymentResponse> callback) {
        this.retrofitAPIWrapper.a(cashoutInfo, callback);
    }

    public synchronized void getCashoutInfo(Callback<CashoutInfo> callback) {
        this.retrofitAPIWrapper.j(callback);
    }

    public synchronized void saveCashoutInfo(CashoutInfo cashoutInfo, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.b(cashoutInfo, callback);
    }

    public synchronized void getPGHealth(PaymentOption paymentOption, Callback<PGHealthResponse> callback) {
        this.retrofitAPIWrapper.e(paymentOption, callback);
    }

    public void getBINDetails(CardOption cardOption, Callback<f> callback) {
        this.retrofitAPIWrapper.a(cardOption, callback);
    }

    public com.citrus.sdk.otp.a getNetBankForOTP() {
        return this.retrofitAPIWrapper.c();
    }

    public void resetNetBankForOTP() {
        this.retrofitAPIWrapper.e();
    }

    public synchronized String getUserEmailId() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getEmailId();
        }
        return null;
    }

    public synchronized String getUserMobileNumber() {
        CitrusUser citrusUser = this.getCitrusUser();
        if (citrusUser != null) {
            return citrusUser.getMobileNo();
        }
        return null;
    }

    public synchronized CitrusUser getCitrusUser() {
        return this.retrofitAPIWrapper.d();
    }

    private void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(broadcastReceiver);
    }

    private void startCitrusActivity(final PaymentType paymentType, final DynamicPricingResponse dynamicPricingResponse, final boolean bl) {
        this.getProfileInfo(new Callback<CitrusUser>(){

            public void a(CitrusUser citrusUser) {
                Intent intent = new Intent(CitrusClient.this.mContext, CitrusActivity.class);
                intent.setFlags(0x10000000);
                intent.putExtra("INTENT_EXTRA_PAYMENT_TYPE", (Parcelable)paymentType);
                intent.putExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE", (Parcelable)dynamicPricingResponse);
                intent.putExtra("INTENT_EXTRA_USE_NEW_API", bl);
                CitrusClient.this.mContext.startActivity(intent);
            }

            @Override
            public void error(CitrusError citrusError) {
                Intent intent = new Intent(CitrusClient.this.mContext, CitrusActivity.class);
                intent.setFlags(0x10000000);
                intent.putExtra("INTENT_EXTRA_PAYMENT_TYPE", (Parcelable)paymentType);
                intent.putExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE", (Parcelable)dynamicPricingResponse);
                intent.putExtra("INTENT_EXTRA_USE_NEW_API", bl);
                CitrusClient.this.mContext.startActivity(intent);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((CitrusUser)object);
            }
        });
    }

    private void startCitrusActivity(PaymentType paymentType, boolean bl) {
        if (!bl && paymentType instanceof PaymentType.PGPayment && ((PaymentType.PGPayment)paymentType).isSingleHop()) {
            bl = true;
        }
        this.startCitrusActivity(paymentType, null, bl);
    }

    private <T> void registerReceiver(final Callback<T> callback, IntentFilter intentFilter) {
        this.paymentEventReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CitrusClient.this.unregisterReceiver(this);
                CitrusClient.this.resetNetBankForOTP();
                TransactionResponse transactionResponse = (TransactionResponse)intent.getParcelableExtra("INTENT_EXTRA_TRANSACTION_RESPONSE");
                String string2 = intent.getAction();
                if (transactionResponse != null) {
                    TransactionResponse.c c2 = transactionResponse.getTransactionStatus();
                    CitrusResponse.Status status = null;
                    if (c2 != null) {
                        switch (c2) {
                            case SUCCESSFUL: {
                                status = CitrusResponse.Status.SUCCESSFUL;
                                break;
                            }
                            case FAILED: {
                                status = CitrusResponse.Status.FAILED;
                                CitrusClient.this.persistPaymentOption = null;
                                break;
                            }
                            case CANCELLED: {
                                status = CitrusResponse.Status.CANCELLED;
                                CitrusClient.this.persistPaymentOption = null;
                                break;
                            }
                            case PG_REJECTED: {
                                status = CitrusResponse.Status.PG_REJECTED;
                                CitrusClient.this.persistPaymentOption = null;
                            }
                        }
                    }
                    if (c2 == TransactionResponse.c.SUCCESSFUL) {
                        if (transactionResponse.getBinCardType() != null && !transactionResponse.getBinCardType().contains("Credit")) {
                            CitrusClient.this.subscriptionRequest = null;
                            CitrusClient.this.mAUTO_load_type = null;
                        }
                        if (CitrusClient.this.persistPaymentOption != null && CitrusClient.this.persistPaymentOption instanceof CardOption && "INDIA".equalsIgnoreCase(transactionResponse.getCountry())) {
                            CardOption cardOption = (CardOption)CitrusClient.this.persistPaymentOption;
                            if (cardOption.isTokenizedPayment()) {
                                if (cardOption.getCardCVV() != null && cardOption.getFingerPrint() != null) {
                                    CitrusClient.this.saveCVV(CitrusClient.this.persistPaymentOption.getFingerPrint(), ((CardOption)CitrusClient.this.persistPaymentOption).getCardCVV());
                                    CitrusClient.this.persistPaymentOption = null;
                                }
                            } else {
                                CitrusClient.this.saveCard(CitrusClient.this.persistPaymentOption, new Callback<com.citrus.sdk.a>(){

                                    public void a(com.citrus.sdk.a a2) {
                                        CitrusClient.this.saveCVV(a2.a(), ((CardOption)CitrusClient.this.persistPaymentOption).getCardCVV());
                                        CitrusClient.this.persistPaymentOption = null;
                                    }

                                    @Override
                                    public void error(CitrusError citrusError) {
                                    }

                                    @Override
                                    public /* synthetic */ void success(Object object) {
                                        this.a((com.citrus.sdk.a)object);
                                    }
                                });
                            }
                        }
                        CitrusClient.this.sendResponse(callback, transactionResponse);
                    } else {
                        CitrusClient.this.updateSubscriptionRequest = null;
                        CitrusClient.this.subscriptionRequest = null;
                        CitrusClient.this.mAUTO_load_type = null;
                        CitrusClient.this.sendError(callback, new CitrusError(transactionResponse.getMessage(), transactionResponse.getJsonResponse(), status, transactionResponse));
                    }
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.paymentEventReceiver, intentFilter);
    }

    private synchronized boolean validate() {
        if (!(TextUtils.isEmpty((CharSequence)this.signinId) || TextUtils.isEmpty((CharSequence)this.signinSecret) || TextUtils.isEmpty((CharSequence)this.signupId) || TextUtils.isEmpty((CharSequence)this.signupSecret) || TextUtils.isEmpty((CharSequence)this.vanity))) {
            return true;
        }
        throw new IllegalArgumentException("Please make sure SignIn Id, SignIn Secret, SignUp Id, SignUp Secret & Vanity are not blank");
    }

    private <T> void sendResponse(Callback callback, T t) {
        if (callback != null) {
            callback.success(t);
        }
    }

    private void sendError(Callback callback, CitrusError citrusError) {
        if (callback != null) {
            callback.error(citrusError);
        }
    }

    public synchronized void resetUserPassword(String string2, @NonNull Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.d(string2, callback);
    }

    public synchronized void setDefaultPaymentOption(PaymentOption paymentOption, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.d(paymentOption, callback);
    }

    public synchronized void signUpUser(String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, Callback<CitrusResponse> callback) {
        this.retrofitAPIWrapper.a(string2, string3, string4, string5, string6, string7, bl, bl2, callback);
    }

    public synchronized void changePassword(String string2, String string3, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.i(string2, string3, callback);
    }

    public synchronized void updateProfileInfo(String string2, String string3, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.j(string2, string3, callback);
    }

    public synchronized void sendOneTimePassword(String string2, String string3, String string4, Callback<CitrusUMResponse> callback) {
        this.retrofitAPIWrapper.b(string2, string3, string4, callback);
    }

    public synchronized void getCardType(String string2, Callback<com.citrus.sdk.classes.g> callback) {
        this.retrofitAPIWrapper.e(string2, callback);
    }

    public synchronized void getMerchantName(Callback<String> callback) {
        this.retrofitAPIWrapper.o(callback);
    }

    public synchronized void makeWalletPGPayment(String string2, Callback<b> callback) {
        this.retrofitAPIWrapper.h(string2, callback);
    }

    public synchronized void makeMOTOPayment(String string2, Callback<m> callback) {
        this.retrofitAPIWrapper.f(string2, callback);
    }

    synchronized void newMakePayment(String string2, Callback<String> callback) {
        this.retrofitAPIWrapper.g(string2, callback);
    }

    public synchronized void getPrepaidBill(Amount amount, String string2, Callback<h> callback) {
        this.retrofitAPIWrapper.a(amount, string2, callback);
    }

    public String getSigninId() {
        return this.signinId;
    }

    public void setSigninId(String string2) {
        this.signinId = string2;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public void setSigninSecret(String string2) {
        this.signinSecret = string2;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public void setSignupId(String string2) {
        this.signupId = string2;
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public void setSignupSecret(String string2) {
        this.signupSecret = string2;
    }

    public String getVanity() {
        return this.vanity;
    }

    public void setVanity(String string2) {
        this.vanity = string2;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String generateDeviceSpecificKeys() {
        String string2 = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        String string3 = Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.DISPLAY + Build.FINGERPRINT + Build.HOST + Build.ID + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.TAGS + Build.TYPE + Build.USER;
        String string4 = string3 + string2;
        return string4;
    }

    private void initCrypto() {
        this.crypto = new Crypto((KeyChain)new SharedPrefsBackedKeyChain(this.mContext), (NativeCryptoLibrary)new SystemNativeCryptoLibrary());
        if (this.crypto.isAvailable()) {
            isFacebookNativeLibraryLoaded = true;
        } else {
            isFacebookNativeLibraryLoaded = false;
            this.crypto = null;
        }
    }

    private void saveCVV(String string2, String string3) {
        if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
            return;
        }
        String string4 = this.generateDeviceSpecificKeys() + string2 + this.getEncryptionKey();
        Entity entity = new Entity(string4);
        try {
            byte[] byArray = this.crypto.encrypt(string2.getBytes(), entity);
            byte[] byArray2 = this.crypto.encrypt(string3.getBytes(), entity);
            byte[] byArray3 = this.crypto.encrypt(string3.getBytes(), entity);
            this.oauthToken.a(byArray, byArray2);
        }
        catch (KeyChainException keyChainException) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException cryptoInitializationException) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException iOException) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
    }

    private String getCVVOfFingerPrint(CardOption cardOption) {
        String string2 = null;
        try {
            if (!(CitrusConfig.getInstance().isOneTapPaymentEnabled() && isFacebookNativeLibraryLoaded && isCitrusNativeLibraryLoaded)) {
                return null;
            }
            String string3 = this.generateDeviceSpecificKeys() + cardOption.getFingerPrint() + this.getEncryptionKey();
            Entity entity = new Entity(string3);
            byte[] byArray = this.oauthToken.b(cardOption.getFingerPrint(), string3);
            if (byArray != null) {
                byte[] byArray2 = this.crypto.decrypt(byArray, entity);
                string2 = new String(byArray2);
            } else {
                string2 = null;
            }
        }
        catch (KeyChainException keyChainException) {
            Logger.d((String)"KeyChainException ", (Object[])new Object[0]);
        }
        catch (CryptoInitializationException cryptoInitializationException) {
            Logger.d((String)"CryptoInitializationException", (Object[])new Object[0]);
        }
        catch (IOException iOException) {
            Logger.d((String)"IOException", (Object[])new Object[0]);
        }
        return string2;
    }

    public synchronized boolean isOneTapPaymentEnabledForCard(CardOption cardOption) {
        if (cardOption != null) {
            String string2 = this.getCVVOfFingerPrint(cardOption);
            return string2 != null;
        }
        return false;
    }

    public synchronized boolean isOneTapPaymentSupported() {
        return isCitrusNativeLibraryLoaded && isFacebookNativeLibraryLoaded;
    }

    @Override
    public void onOneTapPaymentEnabled(boolean bl) {
        if (bl) {
            try {
                System.loadLibrary("citruslibrary");
                isCitrusNativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                isCitrusNativeLibraryLoaded = false;
            }
            this.initCrypto();
            if (this.isOneTapPaymentSupported()) {
                Logger.d((String)"This device supports One Tap Payment.", (Object[])new Object[0]);
            } else {
                Logger.d((String)"This device does not support One Tap Payment.", (Object[])new Object[0]);
            }
        }
    }

    private synchronized boolean validatePaymentOptionForMerchant(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption) {
        if (paymentOption != null) {
            if (merchantPaymentOption != null) {
                CardOption.CardScheme cardScheme = null;
                if (paymentOption instanceof CreditCardOption) {
                    cardScheme = ((CreditCardOption)paymentOption).getCardScheme();
                    Set<CardOption.CardScheme> set = merchantPaymentOption.getCreditCardSchemeSet();
                    if (set != null) {
                        return set.contains((Object)cardScheme);
                    }
                    return true;
                }
                if (paymentOption instanceof DebitCardOption) {
                    cardScheme = ((DebitCardOption)paymentOption).getCardScheme();
                    Set<CardOption.CardScheme> set = merchantPaymentOption.getDebitCardSchemeSet();
                    if (set != null) {
                        return set.contains((Object)cardScheme);
                    }
                    return true;
                }
                if (paymentOption instanceof NetbankingOption) {
                    if (!paymentOption.isTokenizedPayment()) {
                        Set<String> set = merchantPaymentOption.getBankCIDSet();
                        return set == null || set.contains(((NetbankingOption)paymentOption).getBankCID());
                    }
                    return merchantPaymentOption.getNetbankingOptionList().contains(paymentOption);
                }
            }
            return true;
        }
        return false;
    }

    void makeBlazeCardPayment(String string2, Callback<com.citrus.sdk.classes.e> callback) {
        this.retrofitAPIWrapper.i(string2, callback);
    }

    void makeBlazeCardTokenizedPayment(String string2, Callback<com.citrus.sdk.classes.e> callback) {
        this.retrofitAPIWrapper.j(string2, callback);
    }

    void cancelBCTransaction(String string2, Callback<c> callback) {
        this.retrofitAPIWrapper.k(string2, callback);
    }

    public void simpliPay(PaymentType paymentType, Callback<TransactionResponse> callback) {
        if (paymentType instanceof PaymentType.SplitPayment) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.a(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.createWalletPGPaymentOption(paymentType, callback);
        } else if (paymentType instanceof PaymentType.LoadMoney) {
            if (!this.preValidation(paymentType.getPaymentOption(), this.retrofitAPIWrapper.a(paymentType), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(paymentType.getPaymentOption(), callback)) {
                return;
            }
            this.loadMoney((PaymentType.LoadMoney)paymentType, callback);
        } else if (paymentType instanceof PaymentType.CitrusCash) {
            if (!this.validateLogin(callback)) {
                return;
            }
            try {
                PaymentType.SplitPayment splitPayment = null;
                splitPayment = paymentType.getPaymentBill() == null ? new PaymentType.SplitPayment(paymentType.getAmount(), paymentType.getUrl(), null, true, false) : new PaymentType.SplitPayment(paymentType.getPaymentBill(), null, true, false);
                this.createWalletPGPaymentOption(splitPayment, callback);
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
            }
        } else if (paymentType instanceof PaymentType.PGPayment) {
            PaymentType.PGPayment pGPayment = (PaymentType.PGPayment)paymentType;
            if (!this.validatePaymentOptions(pGPayment.getPaymentOption(), this.retrofitAPIWrapper.a(pGPayment), callback)) {
                return;
            }
            if (!this.updateOneTapPaymentOption(pGPayment.getPaymentOption(), callback)) {
                return;
            }
            if (this.isUserLoggedIn && pGPayment.getPaymentOption().isTokenizedPayment() && !pGPayment.isDyanmicPricingRequest()) {
                PaymentType.SplitPayment splitPayment = new PaymentType.SplitPayment(pGPayment);
                this.createWalletPGPaymentOption(splitPayment, callback);
            } else if (pGPayment.isDyanmicPricingRequest()) {
                this.pgPayment(pGPayment.getDynamicPricingResponse(), callback);
            } else {
                this.pgPayment(pGPayment, callback);
            }
        }
    }

    private void createWalletPGPaymentOption(final PaymentType paymentType, final Callback<TransactionResponse> callback) {
        if (((PaymentType.SplitPayment)paymentType).isCitrusCashEnabled() || ((PaymentType.SplitPayment)paymentType).isMVCEnabled()) {
            this.getWallet(new Callback<List<PaymentOption>>(){

                public void a(List<PaymentOption> list) {
                    BigDecimal bigDecimal;
                    Object object;
                    ArrayList<PaymentOption> arrayList = new ArrayList<PaymentOption>();
                    MVCOption mVCOption = null;
                    CitrusCash citrusCash = null;
                    Amount amount = paymentType.getAmount();
                    double d2 = amount.getValueAsDouble();
                    boolean bl = false;
                    PaymentType.SplitPayment splitPayment = (PaymentType.SplitPayment)paymentType;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    for (PaymentOption object22 : list) {
                        if (splitPayment.isMVCEnabled() && object22 instanceof MVCOption) {
                            mVCOption = (MVCOption)object22;
                        }
                        if (!splitPayment.isCitrusCashEnabled() || !(object22 instanceof CitrusCash)) continue;
                        citrusCash = (CitrusCash)object22;
                    }
                    if (splitPayment.isCitrusCashEnabled() && !splitPayment.isMVCEnabled() && splitPayment.getPaymentOption() == null && citrusCash.getMaxBalance().getValueAsDouble() < amount.getValueAsDouble()) {
                        CitrusClient.this.sendError(callback, new CitrusError("The balance in your Citrus Cash account is insufficient. Please load money.", CitrusResponse.Status.FAILED));
                        return;
                    }
                    if (splitPayment.isMVCEnabled() && mVCOption != null && mVCOption.getMaxBalance().getValueAsDouble() >= 1.0) {
                        if (amount.getValueAsDouble() <= mVCOption.getMaxBalance().getValueAsDouble()) {
                            d3 = paymentType.getAmount().getValueAsDouble();
                            bl = true;
                        } else {
                            d3 = mVCOption.getMaxBalanceRounded().getValueAsDouble();
                        }
                        object = BigDecimal.valueOf(d2);
                        BigDecimal bigDecimal2 = BigDecimal.valueOf(d3);
                        bigDecimal = ((BigDecimal)object).subtract(bigDecimal2);
                        d2 = bigDecimal.doubleValue();
                        mVCOption.setTransactionAmount(new Amount(String.valueOf(d3)));
                        arrayList.add(mVCOption);
                    }
                    if (splitPayment.isCitrusCashEnabled() && !bl && citrusCash.getMaxBalance().getValueAsDouble() >= 1.0) {
                        if (d2 <= citrusCash.getMaxBalance().getValueAsDouble()) {
                            d4 = d2;
                            bl = true;
                        } else {
                            d4 = citrusCash.getMaxBalanceRounded().getValueAsDouble();
                        }
                        object = BigDecimal.valueOf(d2);
                        BigDecimal bigDecimal3 = BigDecimal.valueOf(d4);
                        bigDecimal = ((BigDecimal)object).subtract(bigDecimal3);
                        d2 = bigDecimal.doubleValue();
                        citrusCash.setTransactionAmount(new Amount(String.valueOf(d4)));
                        arrayList.add(citrusCash);
                    }
                    if (!bl) {
                        paymentType.getPaymentOption().setTransactionAmount(new Amount(String.valueOf(d2)));
                        arrayList.add(paymentType.getPaymentOption());
                    }
                    try {
                        object = new i((PaymentType.SplitPayment)paymentType, arrayList);
                        CitrusClient.this.walletPGCharge((i)object, callback);
                    }
                    catch (CitrusException citrusException) {
                        citrusException.printStackTrace();
                    }
                }

                @Override
                public void error(CitrusError citrusError) {
                    CitrusClient.this.sendError(callback, citrusError);
                }

                @Override
                public /* synthetic */ void success(Object object) {
                    this.a((List)object);
                }
            });
        } else if (paymentType.getPaymentOption().isTokenizedPayment()) {
            ArrayList<PaymentOption> arrayList = new ArrayList<PaymentOption>();
            if (paymentType.getPaymentOption().getTransactionAmount() == null) {
                paymentType.getPaymentOption().setTransactionAmount(paymentType.getAmount());
            }
            arrayList.add(paymentType.getPaymentOption());
            try {
                i i2 = new i((PaymentType.SplitPayment)paymentType, arrayList);
                this.walletPGCharge(i2, callback);
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
            }
        } else {
            try {
                this.pgPayment(new PaymentType.PGPayment((PaymentType.SplitPayment)paymentType), callback);
            }
            catch (CitrusException citrusException) {
                citrusException.printStackTrace();
            }
        }
    }

    boolean validateLogin(Callback callback) {
        if (!this.isUserLoggedIn) {
            this.sendError(callback, new CitrusError("Have you Signed In? Token not found!!!", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean validatePaymentOptions(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        if (paymentOption != null && !this.validatePaymentOptionForMerchant(paymentOption, merchantPaymentOption)) {
            this.sendError(callback, new CitrusError("This Payment Option is not Supported. Please use another payment option.", CitrusResponse.Status.FAILED));
            return false;
        }
        return true;
    }

    boolean preValidation(PaymentOption paymentOption, MerchantPaymentOption merchantPaymentOption, Callback callback) {
        boolean bl = false;
        bl = this.validateLogin(callback);
        if (bl) {
            bl = this.validatePaymentOptions(paymentOption, merchantPaymentOption, callback);
            return bl;
        }
        return false;
    }

    boolean updateOneTapPaymentOption(PaymentOption paymentOption, Callback callback) {
        if (!CitrusConfig.getInstance().isOneTapPaymentEnabled()) {
            return true;
        }
        if (!(paymentOption instanceof CardOption)) {
            return true;
        }
        if (((CardOption)paymentOption).getCardScheme() == CardOption.CardScheme.MAESTRO) {
            return true;
        }
        if (((CardOption)paymentOption).getCardCVV() != null) {
            return true;
        }
        if (this.getCVVOfFingerPrint((CardOption)paymentOption) == null) {
            this.sendError(callback, new CitrusError("CVV does not exist for this saved Card", CitrusResponse.Status.FAILED));
            return false;
        }
        ((CardOption)paymentOption).setCardCVV(this.getCVVOfFingerPrint((CardOption)paymentOption));
        return true;
    }

    public void getPaymentDistribution(final Amount amount, final Callback<PaymentDistribution> callback) {
        this.getWallet(new Callback<List<PaymentOption>>(){

            public void a(List<PaymentOption> list) {
                BigDecimal bigDecimal;
                Object object;
                MVCOption mVCOption = null;
                CitrusCash citrusCash = null;
                PaymentDistribution paymentDistribution = new PaymentDistribution();
                double d2 = amount.getValueAsDouble();
                boolean bl = false;
                double d3 = 0.0;
                double d4 = 0.0;
                for (PaymentOption object22 : list) {
                    if (object22 instanceof MVCOption) {
                        mVCOption = (MVCOption)object22;
                    }
                    if (!(object22 instanceof CitrusCash)) continue;
                    citrusCash = (CitrusCash)object22;
                }
                if (mVCOption != null && mVCOption.getMaxBalance().getValueAsDouble() >= 1.0) {
                    if (amount.getValueAsDouble() <= mVCOption.getMaxBalance().getValueAsDouble()) {
                        d3 = amount.getValueAsDouble();
                        bl = true;
                    } else {
                        d3 = mVCOption.getMaxBalanceRounded().getValueAsDouble();
                    }
                    object = BigDecimal.valueOf(d2);
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(d3);
                    bigDecimal = ((BigDecimal)object).subtract(bigDecimal2);
                    d2 = bigDecimal.doubleValue();
                    mVCOption.setTransactionAmount(new Amount(String.valueOf(d3)));
                    paymentDistribution.setMVCAvailable(true);
                    paymentDistribution.setMvcAmount(new Amount(String.valueOf(d3)));
                }
                if (!bl && citrusCash != null && citrusCash.getMaxBalance().getValueAsDouble() >= 1.0) {
                    if (d2 <= citrusCash.getMaxBalance().getValueAsDouble()) {
                        d4 = d2;
                        bl = true;
                    } else {
                        d4 = citrusCash.getMaxBalanceRounded().getValueAsDouble();
                    }
                    object = BigDecimal.valueOf(d2);
                    BigDecimal bigDecimal3 = BigDecimal.valueOf(d4);
                    bigDecimal = ((BigDecimal)object).subtract(bigDecimal3);
                    d2 = bigDecimal.doubleValue();
                    citrusCash.setTransactionAmount(new Amount(String.valueOf(d4)));
                    paymentDistribution.setCitrusCashAvailable(true);
                    paymentDistribution.setCitrusCashAmount(new Amount(String.valueOf(d4)));
                }
                if (!bl) {
                    paymentDistribution.setOthePaymentOptionAvailable(true);
                    paymentDistribution.setOtherPaymentOptionAmount(new Amount(String.valueOf(d2)));
                }
                CitrusClient.this.sendResponse(callback, paymentDistribution);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((List)object);
            }
        });
    }

    public void getActiveSubscriptions(final Callback<SubscriptionResponse> callback) {
        this.retrofitAPIWrapper.p(new Callback<SubscriptionResponse>(){

            public void a(SubscriptionResponse subscriptionResponse) {
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((SubscriptionResponse)object);
            }
        });
    }

    public void deActivateSubscription(final Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            public void a(Boolean bl) {
                if (bl.booleanValue()) {
                    Callback<SubscriptionResponse> callback2 = new Callback<SubscriptionResponse>(){

                        public void a(SubscriptionResponse subscriptionResponse) {
                            CitrusClient.this.activeSubscription = null;
                            CitrusClient.this.sendResponse(callback, subscriptionResponse);
                        }

                        @Override
                        public void error(CitrusError citrusError) {
                            CitrusClient.this.sendError(callback, citrusError);
                        }

                        @Override
                        public /* synthetic */ void success(Object object) {
                            this.a((SubscriptionResponse)object);
                        }
                    };
                    CitrusClient.this.retrofitAPIWrapper.l(CitrusClient.this.activeSubscription.getSubscriptionId(), callback2);
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void createAutoLoadSubscription(final Callback callback, final TransactionResponse transactionResponse) {
        Callback<SubscriptionResponse> callback2 = new Callback<SubscriptionResponse>(){

            public void a(SubscriptionResponse subscriptionResponse) {
                subscriptionResponse.setTransactionResponse(transactionResponse);
                subscriptionResponse.setSubscriptionResponseMessage("Auto Load Subscription created Successfully.");
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.subscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.subscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((SubscriptionResponse)object);
            }
        };
        this.retrofitAPIWrapper.a(this.subscriptionRequest, callback2);
    }

    private void updateAutoLoadSubscriptiontoHigherValue(final Callback callback, final TransactionResponse transactionResponse) {
        Callback<SubscriptionResponse> callback2 = new Callback<SubscriptionResponse>(){

            public void a(SubscriptionResponse subscriptionResponse) {
                CitrusClient.this.activeSubscription = subscriptionResponse;
                CitrusClient.this.updateSubscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                subscriptionResponse.setTransactionResponse(transactionResponse);
                subscriptionResponse.setSubscriptionResponseMessage("Auto Load Subscription Updated Successfully.");
                CitrusClient.this.sendResponse(callback, subscriptionResponse);
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.updateSubscriptionRequest = null;
                CitrusClient.this.mAUTO_load_type = null;
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((SubscriptionResponse)object);
            }
        };
        this.retrofitAPIWrapper.b(this.updateSubscriptionRequest, callback2);
    }

    public void isActiveSubscriptionPresent(final Callback<Boolean> callback) {
        if (this.activeSubscription != null) {
            callback.success(true);
        } else {
            this.retrofitAPIWrapper.p(new Callback<SubscriptionResponse>(){

                public void a(SubscriptionResponse subscriptionResponse) {
                    if (subscriptionResponse != null) {
                        CitrusClient.this.activeSubscription = subscriptionResponse;
                        callback.success(true);
                    } else {
                        callback.success(false);
                    }
                }

                @Override
                public void error(CitrusError citrusError) {
                    CitrusClient.this.sendError(callback, citrusError);
                }

                @Override
                public /* synthetic */ void success(Object object) {
                    this.a((SubscriptionResponse)object);
                }
            });
        }
    }

    public synchronized void autoLoadMoney(final PaymentType.LoadMoney loadMoney, final Amount amount, final Amount amount2, final Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        final PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(e.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            public void a(Boolean bl) {
                if (!bl.booleanValue()) {
                    CitrusClient.this.getBINDetails((CardOption)paymentOption, new Callback<f>(){

                        public void a(f f2) {
                            if (f2.a().contains("Credit")) {
                                CitrusClient.this.mAUTO_load_type = a.QUICK_AUTO_LOAD;
                                CitrusClient.this.createAutoLoadRequest(paymentOption);
                                CitrusClient.this.subscriptionRequest.setLoadAmount(amount2.getValue());
                                CitrusClient.this.subscriptionRequest.setThresholdAmount(amount.getValue());
                                Callback<TransactionResponse> callback = new Callback<TransactionResponse>(){

                                    public void a(TransactionResponse transactionResponse) {
                                        CitrusClient.this.createAutoLoadSubscription(callback, transactionResponse);
                                    }

                                    @Override
                                    public void error(CitrusError citrusError) {
                                        CitrusClient.this.sendError(callback, citrusError);
                                    }

                                    @Override
                                    public /* synthetic */ void success(Object object) {
                                        this.a((TransactionResponse)object);
                                    }
                                };
                                CitrusClient.this.simpliPay(loadMoney, callback);
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
                            }
                        }

                        @Override
                        public void error(CitrusError citrusError) {
                            CitrusClient.this.mAUTO_load_type = a.QUICK_AUTO_LOAD;
                            CitrusClient.this.createAutoLoadRequest(paymentOption);
                            CitrusClient.this.subscriptionRequest.setLoadAmount(amount2.getValue());
                            CitrusClient.this.subscriptionRequest.setThresholdAmount(amount.getValue());
                            Callback<TransactionResponse> callback = new Callback<TransactionResponse>(){

                                public void a(TransactionResponse transactionResponse) {
                                    CitrusClient.this.createAutoLoadSubscription(callback, transactionResponse);
                                }

                                @Override
                                public void error(CitrusError citrusError) {
                                    CitrusClient.this.sendError(callback, citrusError);
                                }

                                @Override
                                public /* synthetic */ void success(Object object) {
                                    this.a((TransactionResponse)object);
                                }
                            };
                            CitrusClient.this.simpliPay(loadMoney, callback);
                        }

                        @Override
                        public /* synthetic */ void success(Object object) {
                            this.a((f)object);
                        }
                    });
                } else {
                    CitrusError citrusError = new CitrusError("Active subscription already exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    public synchronized void autoLoadMoney(Amount amount, Amount amount2, Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("LoadAmount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("LoadAmount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        if (this.subscriptionRequest == null) {
            this.sendError(callback, new CitrusError("Could not create active subscription.", CitrusResponse.Status.FAILED));
        } else {
            this.subscriptionRequest.setLoadAmount(amount2.getValue());
            this.subscriptionRequest.setThresholdAmount(amount.getValue());
            this.createAutoLoadSubscription(callback, null);
        }
    }

    private void createAutoLoadRequest(PaymentOption paymentOption) {
        if (paymentOption instanceof CreditCardOption && Arrays.asList(e.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            if (this.subscriptionRequest == null) {
                if (paymentOption.isTokenizedPayment()) {
                    this.subscriptionRequest = new SubscriptionRequest(paymentOption.getToken());
                } else {
                    CardOption cardOption = (CardOption)paymentOption;
                    String string2 = null;
                    string2 = this.getCitrusUser() != null ? (!TextUtils.isEmpty((CharSequence)this.getCitrusUser().getFirstName()) ? this.getCitrusUser().getFirstName() : q.e(cardOption.getCardNumber())) : q.e(cardOption.getCardNumber());
                    this.subscriptionRequest = new SubscriptionRequest(cardOption.getCardNumber(), cardOption.getCardExpiry(), string2);
                }
            }
        } else {
            this.subscriptionRequest = null;
            this.mAUTO_load_type = null;
        }
    }

    public void isAutoLoadAvailable(final Callback<Boolean> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            public void a(Boolean bl) {
                if (!bl.booleanValue()) {
                    if (CitrusClient.this.mAUTO_load_type != null && CitrusClient.this.mAUTO_load_type == a.LAZY_AUTO_LOAD) {
                        callback.success(true);
                    } else {
                        callback.success(false);
                    }
                } else {
                    callback.success(false);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    public void updateSubScriptiontoLoweValue(final Amount amount, final Amount amount2, final Callback<SubscriptionResponse> callback) {
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            public void a(Boolean bl) {
                if (bl.booleanValue()) {
                    Callback<SubscriptionResponse> callback2 = new Callback<SubscriptionResponse>(){

                        public void a(SubscriptionResponse subscriptionResponse) {
                            CitrusClient.this.activeSubscription = subscriptionResponse;
                            CitrusClient.this.sendResponse(callback, subscriptionResponse);
                        }

                        @Override
                        public void error(CitrusError citrusError) {
                            if (TextUtils.equals((CharSequence)citrusError.getMessage(), (CharSequence)"authRefId field is required")) {
                                CitrusError citrusError2 = new CitrusError("Load Amount should be less than current Load Amount.", CitrusResponse.Status.FAILED);
                                CitrusClient.this.sendError(callback, citrusError2);
                            } else {
                                CitrusClient.this.sendError(callback, citrusError);
                            }
                        }

                        @Override
                        public /* synthetic */ void success(Object object) {
                            this.a((SubscriptionResponse)object);
                        }
                    };
                    o o2 = null;
                    try {
                        o2 = new o(CitrusClient.this.activeSubscription.getSubscriptionId(), amount2, amount);
                        CitrusClient.this.retrofitAPIWrapper.a(o2, callback2);
                    }
                    catch (CitrusException citrusException) {
                        CitrusClient.this.sendError(callback, new CitrusError(citrusException.getMessage(), CitrusResponse.Status.FAILED));
                    }
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                callback.error(citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    public void updateSubscriptiontoHigherValue(final PaymentType.LoadMoney loadMoney, final Amount amount, final Amount amount2, final Callback<SubscriptionResponse> callback) throws CitrusException {
        if (amount == null) {
            throw new CitrusException("ThresHold should not be null or empty.");
        }
        if (amount2 == null) {
            throw new CitrusException("Auto Load amount should not be null or empty.");
        }
        if (amount2.compareTo(amount) < 0) {
            throw new CitrusException("Auto Load amount should not be less than ThresHold amount.");
        }
        Double d2 = new Double("500");
        if (amount.getValueAsDouble() < d2) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        Double d3 = new Double("500");
        if (amount2.getValueAsDouble() < d3) {
            throw new CitrusException("Threshold amount should not be less than 500");
        }
        PaymentOption paymentOption = loadMoney.getPaymentOption();
        if (paymentOption instanceof DebitCardOption || paymentOption instanceof NetbankingOption) {
            this.sendError(callback, new CitrusError("Auto Load available only for Credit Card Payment", CitrusResponse.Status.FAILED));
            return;
        }
        if (!Arrays.asList(e.a).contains(((CardOption)paymentOption).getCardScheme().toString())) {
            this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
            return;
        }
        this.isActiveSubscriptionPresent(new Callback<Boolean>(){

            public void a(Boolean bl) {
                if (bl.booleanValue()) {
                    Amount amount3 = new Amount(String.valueOf(CitrusClient.this.activeSubscription.getThresholdAmount()));
                    if (amount.compareTo(amount3) < 0) {
                        CitrusClient.this.sendError(callback, new CitrusError("Threshold amount is less than current active threshold amount", CitrusResponse.Status.FAILED));
                        return;
                    }
                    Amount amount22 = new Amount(String.valueOf(CitrusClient.this.activeSubscription.getLoadAmount()));
                    if (amount2.compareTo(amount22) < 0) {
                        CitrusClient.this.sendError(callback, new CitrusError("Auto load amount is less than current active auto load amount", CitrusResponse.Status.FAILED));
                        return;
                    }
                    CitrusClient.this.getBINDetails((CardOption)loadMoney.getPaymentOption(), new Callback<f>(){

                        public void a(f f2) {
                            if (f2.a().contains("Credit")) {
                                try {
                                    CitrusClient.this.updateSubscriptionRequest = new o(CitrusClient.this.activeSubscription.getSubscriptionId(), amount2, amount);
                                    CitrusClient.this.mAUTO_load_type = a.UPDATE_AUTO_LOAD;
                                    Callback<TransactionResponse> callback = new Callback<TransactionResponse>(){

                                        public void a(TransactionResponse transactionResponse) {
                                            CitrusClient.this.updateAutoLoadSubscriptiontoHigherValue(callback, transactionResponse);
                                        }

                                        @Override
                                        public void error(CitrusError citrusError) {
                                            CitrusClient.this.sendError(callback, citrusError);
                                        }

                                        @Override
                                        public /* synthetic */ void success(Object object) {
                                            this.a((TransactionResponse)object);
                                        }
                                    };
                                    CitrusClient.this.simpliPay(loadMoney, callback);
                                }
                                catch (CitrusException citrusException) {
                                    CitrusClient.this.sendError(callback, new CitrusError(citrusException.getMessage(), CitrusResponse.Status.FAILED));
                                }
                            } else {
                                CitrusClient.this.sendError(callback, new CitrusError("Auto load feature is supported only for Master or Visa Credit Card.", CitrusResponse.Status.FAILED));
                            }
                        }

                        @Override
                        public void error(CitrusError citrusError) {
                            try {
                                CitrusClient.this.updateSubscriptionRequest = new o(CitrusClient.this.activeSubscription.getSubscriptionId(), amount2, amount);
                                CitrusClient.this.mAUTO_load_type = a.UPDATE_AUTO_LOAD;
                                Callback<TransactionResponse> callback = new Callback<TransactionResponse>(){

                                    public void a(TransactionResponse transactionResponse) {
                                        CitrusClient.this.updateAutoLoadSubscriptiontoHigherValue(callback, transactionResponse);
                                    }

                                    @Override
                                    public void error(CitrusError citrusError) {
                                        CitrusClient.this.sendError(callback, citrusError);
                                    }

                                    @Override
                                    public /* synthetic */ void success(Object object) {
                                        this.a((TransactionResponse)object);
                                    }
                                };
                                CitrusClient.this.simpliPay(loadMoney, callback);
                            }
                            catch (CitrusException citrusException) {
                                CitrusClient.this.sendError(callback, new CitrusError(citrusException.getMessage(), CitrusResponse.Status.FAILED));
                            }
                        }

                        @Override
                        public /* synthetic */ void success(Object object) {
                            this.a((f)object);
                        }
                    });
                } else {
                    CitrusError citrusError = new CitrusError("No active subscription exists.", CitrusResponse.Status.FAILED);
                    CitrusClient.this.sendError(callback, citrusError);
                }
            }

            @Override
            public void error(CitrusError citrusError) {
                CitrusClient.this.sendError(callback, citrusError);
            }

            @Override
            public /* synthetic */ void success(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    static {
        isCitrusNativeLibraryLoaded = false;
        isFacebookNativeLibraryLoaded = false;
    }

    public static enum a {
        QUICK_AUTO_LOAD,
        UPDATE_AUTO_LOAD,
        LAZY_AUTO_LOAD;

    }
}

