package com.citrus.sdk.network.request;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.citrus.sdk.network.NetworkConstants;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.Map;

public class CustomJsonRequest extends Request<JSONObject> {

    private static final String TAG = CustomJsonRequest.class.getSimpleName() ;

    private Listener<JSONObject> listener;
    private Map<String, String> params;

    private final String mRequestBody;
    private final Map<String, String> headers;
    private final String bodyContentResponseType ;

    public CustomJsonRequest(int method, String url, Map<String, String> params,
                             Listener<JSONObject> reponseListener, ErrorListener errorListener, String mRequestBody, Map<String, String> headers, String bodyContentResponseType) {
        super(method, url, errorListener);

        Log.d(TAG, TAG + ".CustomJsonRequest(): " + url) ;

        this.listener       = reponseListener;
        this.params         = params;
        this.mRequestBody   = mRequestBody;
        this.headers        = headers;
        this.bodyContentResponseType = bodyContentResponseType;
    }

    @Override
    protected Map<String, String> getParams() throws AuthFailureError {
        Log.d( TAG , TAG + ".getParams(): params = "+params  ) ;
        return params != null ? params : super.getParams();
    }

    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            final String jsonString = new String(response.data,
                    HttpHeaderParser.parseCharset(response.headers));

            return Response.success(new JSONObject(jsonString),
                    HttpHeaderParser.parseCacheHeaders(response));
        } catch (UnsupportedEncodingException e) {
            return Response.error(new ParseError(e));
        } catch (JSONException je) {
            return Response.error(new ParseError(je));
        }
    }

    @Override
    protected void deliverResponse(JSONObject response) {
        listener.onResponse(response);
    }

    @Override
    public String getBodyContentType() {
        Log.d( TAG , TAG + ".getBodyContentType(): bodyContentResponseType = "+bodyContentResponseType  ) ;
        return bodyContentResponseType != null ? bodyContentResponseType : super.getBodyContentType();
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Log.d(TAG, TAG + ".getHeaders(): headers = " + headers) ;
        return headers != null ? headers : super.getHeaders();
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        Log.d( TAG , TAG + ".getBody(): mRequestBody = "+mRequestBody+", params = "+params  ) ;

        try {
            if( mRequestBody != null ) {
                return mRequestBody.getBytes(NetworkConstants.PROTOCOL_CHARSET);
            }
            else if( params != null ){
                String body = "" ;
                for(String key: params.keySet()) {
                    body += "&"+key+"="+params.get(key);
                }
                Log.d( TAG , TAG + ".getBody(): param body = "+body  ) ;
                return body.getBytes(NetworkConstants.PROTOCOL_CHARSET);
            }
        } catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf("Unsupported Encoding while trying to get the bytes of %s using %s",
                    mRequestBody, NetworkConstants.PROTOCOL_CHARSET);
        }

        return null;
    }
}