package com.citrus.sdk.network;

import android.content.Context;

import com.citrus.sdk.BlazeWrapper;
import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.BCCancelResponse;
import com.citrus.sdk.classes.BCResponse;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.network.request.RequestBody;
import com.citrus.sdk.network.request.RequestBodyType;

/**
 * Created by mangesh on 2/6/16.
 */
public class BlazeCardClient extends BaseClient {

    private static BlazeCardClient instance;
    private ApiExecutor executor;

    public static BlazeCardClient getInstance(Context context, Environment environment) {
        if (instance == null) {
            synchronized (BlazeCardClient.class) {
                if (instance == null) {
                    instance = new BlazeCardClient(context, environment);
                }
            }
        }
        return instance;
    }

    private BlazeCardClient(Context context, Environment environment) {
        super(context, environment);
        executor = ApiExecutor.getInstance(context);
    }

    @Override
    public String getBaseUrl() {
        return environment.getBlazeCardUrl();
    }

    public void makeBlazeCardPayment(String paymentJSON, Callback<BCResponse> callback) {
        if (validate()) {
            String json = BlazeWrapper.getBlazeCardPaymentObject(paymentJSON).toString();
            final ApiRequest apiRequest = getBlazeCardPaymentAPI(json);
            executor.executeCustomObjectApi(this, apiRequest, callback);
        }
    }

    private ApiRequest getBlazeCardPaymentAPI(final String jsonBody) {
        final RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        final ApiRequest apiRequest = new ApiRequest.Builder(Api.BLAZECARD_PAYMENT).requestBody(requestBody).build();
        return apiRequest;
    }

    public void makeBlazeCardTokenizedPayment(String paymentJSON, Callback<BCResponse> callback) {
        if (validate()) {
            String json = BlazeWrapper.getBlazeCardPaymentObject(paymentJSON).toString();
            final ApiRequest apiRequest = getBlazeCardTokenizedAPI(json);
            executor.executeCustomObjectApi(this, apiRequest, callback);
        }
    }

    private ApiRequest getBlazeCardTokenizedAPI(final String jsonBody) {
        final RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        final ApiRequest apiRequest = new ApiRequest.Builder(Api.BLAZECARD_TOKENIZED_PAYMENT).requestBody(requestBody).build();
        return apiRequest;
    }


    public void cancelTransaction(String cancelPaymentJSON, Callback<BCCancelResponse> callback) {
        if (validate()) {
            String json = BlazeWrapper.getBlazeCardPaymentObject(cancelPaymentJSON).toString();
            final ApiRequest apiRequest = getBlazeCardCancelAPI(json);
            executor.executeCustomObjectApi(this, apiRequest, callback);
        }
    }

    private ApiRequest getBlazeCardCancelAPI(final String jsonBody) {
        final RequestBody requestBody = new RequestBody(RequestBodyType.JSON, jsonBody);
        final ApiRequest apiRequest = new ApiRequest.Builder(Api.BLAZECARD_CANCEL_TRANSACTION).requestBody(requestBody).build();
        return apiRequest;
    }

}



