package com.citrus.sdk.network;

import android.content.Context;

import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;

import org.json.JSONObject;


/**
 * Created by vinay on 10/4/16.
 */
public class BinServiceClient extends BaseClient {

    private static BinServiceClient instance = null;
    final ApiExecutor executor = ApiExecutor.getInstance(mContext);

    public static BinServiceClient getInstance(Context context, Environment environment) {
        if (instance == null) {
            synchronized (BinServiceClient.class) {
                if (instance == null) {
                    instance = new BinServiceClient(context, environment);
                }
            }
        }
        return instance;
    }

    private BinServiceClient(Context context, Environment environment) {
        super(context, environment);
    }

    @Override
    public String getBaseUrl() {
        return environment.getBinServiceURL();
    }

    public synchronized void getCardType(final String first6Digits, final Callback<CardBinDetails> callback) {
        final ApiRequest getCardApi = getCardTypeApiRequest(first6Digits);
        executor.executeCustomObjectApi(this, getCardApi, callback);
    }

    private ApiRequest getCardTypeApiRequest(final String first6Digits) {
        final ApiRequest apiRequest = new ApiRequest.Builder(Api.BIN_GET_CARD_TYPE)
                .pathParams(first6Digits)
                .build();

        return apiRequest;
    }

    public synchronized void getBinInfo(final String first6Digits, final Callback<BinServiceResponse> callback) {
        final ApiRequest getCardApi = getBinInfoApiRequest(first6Digits);
        executor.executeCustomJsonApi(this, getCardApi, new Callback<JSONObject>() {
            @Override
            public void success(JSONObject jsonObject) {
                if (jsonObject != null) {
                    final String jsonString = jsonObject.toString();
                    final BinServiceResponse binServiceResponse = BinServiceResponse.fromJSON(jsonString);
                    sendResponse(callback, binServiceResponse);
                } else {
                    sendError(callback, new CitrusError("Unable to get bin service response", CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                sendError(callback, error);
            }
        });
    }

    private ApiRequest getBinInfoApiRequest(final String first6Digits) {
        final ApiRequest apiRequest = new ApiRequest.Builder(Api.BIN_GET_INFO)
                .pathParams(first6Digits)
                .build();

        return apiRequest;
    }
}
