/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.payment.r;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentBill
implements Parcelable {
    @SerializedName(value="amount")
    private Amount a = null;
    @SerializedName(value="alteredAmount")
    private Amount b = null;
    @SerializedName(value="requestSignature")
    private String c = null;
    @SerializedName(value="merchantTxnId")
    private String d = null;
    @SerializedName(value="merchantAccessKey")
    private String e = null;
    @SerializedName(value="returnUrl")
    private String f = null;
    @SerializedName(value="notifyUrl")
    private String g = null;
    @SerializedName(value="dpSignature")
    private String h = null;
    @SerializedName(value="customParameters")
    private Map<String, String> i = null;
    public static final Parcelable.Creator<PaymentBill> CREATOR = new r();

    public PaymentBill(Amount amount, Amount amount2, String string, String string2, String string3, String string4, String string5, String string6, Map<String, String> map) throws CitrusException {
        this.a = amount;
        this.b = amount2;
        this.c = string;
        this.d = string2;
        this.e = string3;
        this.f = string4;
        this.g = string5;
        this.h = string6;
        this.i = map;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string2.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String string, String string2, String string3, String string4) throws CitrusException {
        this.a = amount;
        this.c = string;
        this.d = string2;
        this.e = string3;
        this.f = string4;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string2.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String string, String string2, String string3, String string4, String string5, Map<String, String> map) throws CitrusException {
        this.a = amount;
        this.c = string;
        this.d = string2;
        this.e = string3;
        this.f = string4;
        this.g = string5;
        this.i = map;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (string2.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    private PaymentBill() {
    }

    public Amount getAmount() {
        return this.a;
    }

    public String getRequestSignature() {
        return this.c;
    }

    public String getMerchantTransactionId() {
        return this.d;
    }

    public String getMerchantAccessKey() {
        return this.e;
    }

    public String getReturnUrl() {
        return this.f;
    }

    public String getNotifyUrl() {
        return this.g;
    }

    public String getDpSignature() {
        return this.h;
    }

    public Map<String, String> getCustomParametersMap() {
        return this.i;
    }

    public static PaymentBill fromJSON(String object) {
        PaymentBill paymentBill = null;
        JSONObject jSONObject = null;
        if (object != null) {
            try {
                jSONObject = new JSONObject((String)object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject != null) {
                HashMap<String, String> hashMap = null;
                object = Amount.fromJSONObject(jSONObject.optJSONObject("amount"));
                Amount amount = Amount.fromJSONObject(jSONObject.optJSONObject("alteredAmount"));
                String string = jSONObject.optString("requestSignature");
                String string2 = jSONObject.optString("merchantTxnId");
                String string3 = jSONObject.optString("merchantAccessKey");
                String string4 = jSONObject.optString("returnUrl");
                String string5 = jSONObject.optString("notifyUrl");
                String string6 = jSONObject.optString("dpSignature");
                if ((jSONObject = jSONObject.optJSONObject("customParameters")) != null) {
                    hashMap = new HashMap<String, String>();
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        String string7 = (String)iterator.next();
                        String string8 = jSONObject.optString(string7);
                        hashMap.put(string7, string8);
                    }
                }
                if (object != null && string != null && string4 != null && string3 != null && string2 != null) {
                    try {
                        paymentBill = new PaymentBill((Amount)object, amount, string, string2, string3, string4, string5, string6, hashMap);
                    }
                    catch (CitrusException citrusException) {
                        citrusException.printStackTrace();
                    }
                }
            }
        }
        return paymentBill;
    }

    public static String toJSON(PaymentBill paymentBill) {
        JSONObject jSONObject = PaymentBill.toJSONObject(paymentBill);
        if (paymentBill != null) {
            return jSONObject.toString();
        }
        return "";
    }

    public static JSONObject toJSONObject(PaymentBill paymentBill) {
        return PaymentBill.toJSONObject(paymentBill, false);
    }

    public static JSONObject toJSONObject(PaymentBill iterator, boolean bl2) {
        JSONObject jSONObject = null;
        if (iterator != null) {
            Amount object2 = ((PaymentBill)((Object)iterator)).getAmount();
            String string = ((PaymentBill)((Object)iterator)).getMerchantAccessKey();
            String string2 = ((PaymentBill)((Object)iterator)).getMerchantTransactionId();
            String string3 = ((PaymentBill)((Object)iterator)).getRequestSignature();
            String string4 = ((PaymentBill)((Object)iterator)).getReturnUrl();
            String string5 = ((PaymentBill)((Object)iterator)).getNotifyUrl();
            iterator = ((PaymentBill)((Object)iterator)).getCustomParametersMap();
            if (object2 != null && string3 != null && string != null && string2 != null && string4 != null) {
                try {
                    jSONObject = new JSONObject();
                    if (bl2) {
                        jSONObject.put("amount", (Object)object2.getValueAsFormattedDouble("#.00"));
                        jSONObject.put("currency", (Object)object2.getCurrency());
                        jSONObject.put("merchantTransactionId", (Object)string2);
                        jSONObject.put("signature", (Object)string3);
                    } else {
                        jSONObject.put("amount", (Object)Amount.toJSONObject(object2));
                        jSONObject.put("merchantTxnId", (Object)string2);
                        jSONObject.put("requestSignature", (Object)string3);
                    }
                    jSONObject.put("merchantAccessKey", (Object)string);
                    jSONObject.put("returnUrl", (Object)string4);
                    if (!TextUtils.isEmpty((CharSequence)string5)) {
                        jSONObject.put("notifyUrl", (Object)string5);
                    }
                    if (!bl2 && iterator != null && iterator.size() > 0) {
                        JSONObject jSONObject2 = new JSONObject();
                        for (Map.Entry entry : iterator.entrySet()) {
                            jSONObject2.put((String)entry.getKey(), entry.getValue());
                        }
                        jSONObject.put("customParameters", (Object)jSONObject2);
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        return jSONObject;
    }

    public String toString() {
        return "PaymentBill{amount=" + this.a + ", requestSignature='" + this.c + '\'' + ", merchantTransactionId='" + this.d + '\'' + ", merchantAccessKey='" + this.e + '\'' + ", returnUrl='" + this.f + '\'' + ", notifyUrl='" + this.g + '\'' + ", dpSignature='" + this.h + '\'' + ", customParametersMap=" + this.i + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.a, 0);
        parcel.writeString(this.c);
        parcel.writeString(this.d);
        parcel.writeString(this.e);
        parcel.writeString(this.f);
        parcel.writeString(this.g);
        parcel.writeString(this.h);
        parcel.writeMap(this.i);
    }

    protected PaymentBill(Parcel parcel) {
        this.a = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.c = parcel.readString();
        this.d = parcel.readString();
        this.e = parcel.readString();
        this.f = parcel.readString();
        this.g = parcel.readString();
        this.h = parcel.readString();
        this.i = parcel.readHashMap(String.class.getClassLoader());
    }
}

