/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.text.TextUtils;
import com.citrus.sdk.classes.l;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerchantPaymentOption {
    private Set<CardOption.CardScheme> a = null;
    private Set<CardOption.CardScheme> b = null;
    private ArrayList<NetbankingOption> c = null;
    private Set<String> d = null;

    private MerchantPaymentOption(Set<CardOption.CardScheme> set, Set<CardOption.CardScheme> set2, ArrayList<NetbankingOption> arrayList, Set<String> set3) {
        this.a = set;
        this.b = set2;
        this.c = arrayList;
        this.d = set3;
    }

    public Set<CardOption.CardScheme> getCreditCardSchemeSet() {
        return this.a;
    }

    public Set<CardOption.CardScheme> getDebitCardSchemeSet() {
        return this.b;
    }

    public ArrayList<NetbankingOption> getNetbankingOptionList() {
        return this.c;
    }

    public Set<String> getBankCIDSet() {
        return this.d;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject jsonObject) {
        return MerchantPaymentOption.getMerchantPaymentOptions(jsonObject, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject object, Map<String, l> map) {
        String string;
        int n2;
        HashSet<CardOption.CardScheme> hashSet = null;
        HashSet<CardOption.CardScheme> hashSet2 = null;
        ArrayList<Object> arrayList = null;
        HashSet<String> hashSet3 = null;
        JsonArray jsonArray = object.getAsJsonArray("netBanking");
        Object object2 = object.getAsJsonArray("creditCard");
        object = object.getAsJsonArray("debitCard");
        int n3 = object2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = object2.get(n2).getAsString();
            if (hashSet2 == null) {
                hashSet2 = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(string) == null) continue;
            hashSet2.add(CardOption.CardScheme.getCardScheme(string));
        }
        n3 = object.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = object.get(n2).getAsString();
            if (hashSet == null) {
                hashSet = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(string) == null) continue;
            hashSet.add(CardOption.CardScheme.getCardScheme(string));
        }
        n3 = jsonArray.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = jsonArray.get(n2);
            if (!object.isJsonObject()) continue;
            string = object.getAsJsonObject();
            object = string.get("bankName").getAsString();
            object2 = string.get("issuerCode").getAsString();
            if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)object2)) continue;
            object = new NetbankingOption((String)object, (String)object2);
            if (map != null) {
                ((NetbankingOption)object).setPgHealth(map.get(object2));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            if (hashSet3 == null) {
                hashSet3 = new HashSet<String>();
            }
            arrayList.add(object);
            hashSet3.add(((NetbankingOption)object).getBankCID());
        }
        return new MerchantPaymentOption(hashSet2, hashSet, arrayList, hashSet3);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject jSONObject) {
        return MerchantPaymentOption.getMerchantPaymentOptions(jSONObject, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject object, Map<String, l> map) {
        MerchantPaymentOption merchantPaymentOption = null;
        try {
            String string;
            int n2;
            HashSet<CardOption.CardScheme> hashSet = null;
            HashSet<CardOption.CardScheme> hashSet2 = null;
            ArrayList<Object> arrayList = null;
            HashSet<String> hashSet3 = null;
            JSONArray jSONArray = object.getJSONArray("netBanking");
            Object object2 = object.getJSONArray("creditCard");
            object = object.getJSONArray("debitCard");
            int n3 = object2.length();
            try {
                for (n2 = 0; n2 < n3; ++n2) {
                    string = object2.getString(n2);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(string) == null) continue;
                    hashSet2.add(CardOption.CardScheme.getCardScheme(string));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            try {
                n3 = object.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = object.getString(n2);
                    if (hashSet == null) {
                        hashSet = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(string) == null) continue;
                    hashSet.add(CardOption.CardScheme.getCardScheme(string));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            try {
                n3 = jSONArray.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = jSONArray.getJSONObject(n2);
                    object = string.getString("bankName");
                    object2 = string.getString("issuerCode");
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)object2)) continue;
                    object = new NetbankingOption((String)object, (String)object2);
                    if (map != null) {
                        ((NetbankingOption)object).setPgHealth(map.get(object2));
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet<String>();
                    }
                    arrayList.add(object);
                    hashSet3.add(((NetbankingOption)object).getBankCID());
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            merchantPaymentOption = new MerchantPaymentOption(hashSet2, hashSet, arrayList, hashSet3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return merchantPaymentOption;
    }

    public String toString() {
        return "MerchantPaymentOption{creditCardSchemeSet=" + this.a + ", debitCardSchemeSet=" + this.b + ", netbankingOptionList=" + this.c + '}';
    }
}

