/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.classes.s;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.a;
import com.citrus.sdk.payment.b;
import com.citrus.sdk.payment.c;
import com.citrus.sdk.payment.d;
import com.citrus.sdk.payment.e;
import com.citrus.sdk.payment.f;
import com.citrus.sdk.payment.g;
import com.citrus.sdk.payment.h;
import com.citrus.sdk.payment.i;
import com.citrus.sdk.payment.j;
import com.citrus.sdk.payment.k;
import com.citrus.sdk.payment.l;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CardOption
extends PaymentOption {
    protected String cardHolderName = null;
    protected String cardNumber = null;
    protected String cardCVV = null;
    protected String cardExpiry = null;
    protected String cardExpiryMonth = null;
    protected String cardExpiryYear = null;
    protected CardScheme cardScheme = null;
    protected String nickName = null;
    public static final Parcelable.Creator<CardOption> CREATOR = new a();

    CardOption(Amount amount, String string, String string2, String string3, Month month, Year year) {
        this(string, string2, string3, month, year);
        this.transactionAmount = amount;
    }

    CardOption(String string, String string2, String string3, Month month, Year year) {
        this.cardHolderName = !TextUtils.isEmpty((CharSequence)string) ? s.a(string) : "Card Holder Name";
        this.cardNumber = CardOption.normalizeCardNumber(string2);
        this.cardCVV = string3;
        this.cardScheme = CardScheme.getCardSchemeUsingNumber(string2);
        if (month != null) {
            this.cardExpiryMonth = month.toString();
        }
        if (year != null) {
            this.cardExpiryYear = year.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && !TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            this.cardExpiry = (Object)((Object)month) + "/" + (Object)((Object)year);
        }
    }

    CardOption(String string, String string2) {
        this.token = string;
        this.cardCVV = string2;
    }

    CardOption(String string, CardScheme cardScheme) {
        this.cardNumber = string;
        this.cardScheme = cardScheme;
    }

    CardOption() {
    }

    public abstract String getCardType();

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public String getNickName() {
        String string = this.getName();
        if ("---".equalsIgnoreCase(string)) {
            string = String.format(this instanceof CreditCardOption ? "Credit Card (%s)" : "Debit Card (%s)", this.getLast4Digits());
        }
        return string;
    }

    public String getCardExpiryYear() {
        return this.cardExpiryYear;
    }

    public String getCardExpiry() {
        return this.cardExpiry;
    }

    public String getCardExpiryMonth() {
        return this.cardExpiryMonth;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String string) {
        this.cardCVV = string;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public void setCardScheme(CardScheme cardScheme) {
        this.cardScheme = cardScheme;
    }

    public void setNickName(String string) {
        this.nickName = s.a(string);
    }

    @Override
    public com.citrus.sdk.classes.l getPgHealth() {
        return com.citrus.sdk.classes.l.GOOD;
    }

    private static String normalizeCardNumber(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().replaceAll("\\s+|-", "");
    }

    public String getLast4Digits() {
        int n2;
        String string = null;
        if (!TextUtils.isEmpty((CharSequence)this.cardNumber) && (n2 = this.cardNumber.length()) - 4 > 0) {
            string = this.cardNumber.substring(n2 - 4, n2);
        }
        return string;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        Drawable drawable2 = null;
        int n2 = 0;
        if (this.cardScheme == CardScheme.VISA) {
            n2 = context.getResources().getIdentifier("visa", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MASTER_CARD) {
            n2 = context.getResources().getIdentifier("mcrd", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MAESTRO) {
            n2 = context.getResources().getIdentifier("mtro", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.DINERS) {
            n2 = context.getResources().getIdentifier("dinerclub", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.JCB) {
            n2 = context.getResources().getIdentifier("jcb", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.AMEX) {
            n2 = context.getResources().getIdentifier("amex", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.RPAY) {
            n2 = context.getResources().getIdentifier("rupay", "drawable", context.getPackageName());
            if (n2 == 0) {
                n2 = context.getResources().getIdentifier("rpay", "drawable", context.getPackageName());
            }
        } else if (this.cardScheme == CardScheme.DISCOVER) {
            n2 = context.getResources().getIdentifier("discover", "drawable", context.getPackageName());
        }
        if (n2 != 0 || (n2 = context.getResources().getIdentifier("default_card", "drawable", context.getPackageName())) != 0) {
            drawable2 = context.getResources().getDrawable(n2);
        }
        return drawable2;
    }

    @Override
    public String toString() {
        return super.toString() + "CardOption{cardHolderName='" + this.cardHolderName + '\'' + ", cardNumber='" + this.cardNumber + '\'' + ", cardCVV='" + this.cardCVV + '\'' + ", cardExpiry='" + this.cardExpiry + '\'' + ", cardExpiryMonth='" + this.cardExpiryMonth + '\'' + ", cardExpiryYear='" + this.cardExpiryYear + '\'' + ", cardScheme='" + (Object)((Object)this.cardScheme) + '\'' + '}';
    }

    public int getCVVLength() {
        int n2 = 3;
        if (this.cardScheme == CardScheme.AMEX) {
            n2 = 4;
        }
        return n2;
    }

    public boolean validateCard() {
        if (!TextUtils.isEmpty((CharSequence)this.token) && this.cardScheme != CardScheme.MAESTRO) {
            return this.validateCVV();
        }
        if (this.cardScheme == CardScheme.MAESTRO) {
            if (TextUtils.isEmpty((CharSequence)this.token)) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    return this.cardCVV.length() == 3 && this.validateCardNumber();
                }
                return this.validateCardNumber();
            }
            if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                return this.cardCVV.length() == 3;
            }
            return true;
        }
        return this.validateCardNumber() && this.validateExpiryDate() && this.validateCVV();
    }

    public boolean validateForSaveCard() {
        if (this.cardScheme == CardScheme.MAESTRO) {
            return this.validateCardNumber();
        }
        return this.validateCardNumber() && this.validateExpiryDate();
    }

    public boolean validateCardNumber() {
        if (TextUtils.isEmpty((CharSequence)this.cardNumber)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.cardNumber) || !TextUtils.isDigitsOnly((CharSequence)this.cardNumber) || !this.isValidLuhnNumber(this.cardNumber)) {
            return false;
        }
        return !(this.cardScheme == CardScheme.AMEX ? this.cardNumber.length() != 15 : (this.cardScheme == CardScheme.VISA ? this.cardNumber.length() != 13 && this.cardNumber.length() != 16 : (this.cardScheme != CardScheme.MAESTRO ? this.cardNumber.length() != 16 : this.cardNumber.length() < 12 || this.cardNumber.length() > 19)));
    }

    public boolean validateExpiryDate() {
        if (this.cardScheme == CardScheme.MAESTRO && TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            return true;
        }
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        int n2 = Integer.valueOf(this.cardExpiryMonth);
        int n3 = Integer.valueOf(this.cardExpiryYear);
        Calendar calendar = Calendar.getInstance();
        return !(s.a(n3) || s.b(n3) == calendar.get(1) && n2 < calendar.get(2) + 1);
    }

    private boolean validateExpMonth() {
        if (this.cardExpiryMonth == null) {
            return false;
        }
        return Integer.valueOf(this.cardExpiryMonth) > 0 && Integer.valueOf(this.cardExpiryMonth) <= 12;
    }

    private boolean validateExpYear() {
        if (this.cardExpiryYear == null) {
            return false;
        }
        return !s.a(Integer.valueOf(this.cardExpiryYear));
    }

    public boolean validateCVV() {
        if (TextUtils.isEmpty((CharSequence)this.cardCVV)) {
            return false;
        }
        if (this.cardScheme == CardScheme.AMEX) {
            return this.cardCVV.length() == 4;
        }
        return this.cardCVV.length() == 3;
    }

    public String getCardValidityFailureReasonsForSaveCard() {
        CharSequence charSequence = null;
        if (!this.validateForSaveCard()) {
            charSequence = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                ((StringBuilder)charSequence).append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                ((StringBuilder)charSequence).append(" Invalid Expiry Date. ");
            }
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public String getCardValidityFailureReasons() {
        CharSequence charSequence = null;
        if (!this.validateCard()) {
            charSequence = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                ((StringBuilder)charSequence).append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                ((StringBuilder)charSequence).append(" Invalid Expiry Date. ");
            }
            if (this.cardScheme == CardScheme.MAESTRO) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV) && !this.validateCVV()) {
                    ((StringBuilder)charSequence).append(" Invalid CVV. ");
                }
            } else if (!this.validateCVV()) {
                ((StringBuilder)charSequence).append(" Invalid CVV. ");
            }
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    @Override
    public String getSavePaymentOptionObject() {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("owner", (Object)this.cardHolderName);
            if (!TextUtils.isEmpty((CharSequence)this.nickName)) {
                jSONObject2.put("name", (Object)this.nickName);
            }
            jSONObject2.put("number", (Object)this.cardNumber);
            jSONObject2.put("scheme", (Object)this.cardScheme.toString());
            if (TextUtils.isEmpty((CharSequence)this.cardExpiry) && this.cardScheme == CardScheme.MAESTRO) {
                jSONObject2.put("expiryDate", (Object)"12/2049");
            } else {
                jSONObject2.put("expiryDate", (Object)this.cardExpiry);
            }
            jSONObject2.put("type", (Object)this.getCardType());
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("paymentOptions", (Object)jSONArray);
            jSONObject.put("type", (Object)"payment");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.isTokenizedPayment()) {
            jSONObject.put("type", (Object)"paymentOptionIdToken");
            jSONObject.put("id", (Object)this.token);
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                jSONObject.put("cvv", (Object)"123");
            } else {
                jSONObject.put("cvv", (Object)this.cardCVV);
            }
        } else {
            jSONObject.put("type", (Object)"paymentOptionToken");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("holder", (Object)this.cardHolderName);
            jSONObject2.put("number", (Object)this.cardNumber);
            jSONObject2.put("scheme", (Object)this.cardScheme.getName().toUpperCase());
            jSONObject2.put("type", (Object)this.getCardType());
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                jSONObject2.put("cvv", (Object)"123");
            } else {
                jSONObject2.put("cvv", (Object)this.cardCVV);
            }
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                jSONObject2.put("expiry", (Object)"11/2049");
            } else {
                jSONObject2.put("expiry", (Object)this.cardExpiry);
            }
            jSONObject.put("paymentMode", (Object)jSONObject2);
        }
        return jSONObject;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jSONObject = null;
        if (this.transactionAmount != null) {
            jSONObject = new JSONObject();
            if (this instanceof CreditCardOption) {
                jSONObject.put("paymentMode", (Object)"CREDIT_CARD");
            } else {
                jSONObject.put("paymentMode", (Object)"DEBIT_CARD");
            }
            if (this.isTokenizedPayment()) {
                jSONObject.put("name", (Object)"");
                jSONObject.put("cardNumber", (Object)"");
                jSONObject.put("cardExpiryDate", (Object)"");
                jSONObject.put("cardScheme", (Object)"");
                jSONObject.put("cvv", (Object)this.cardCVV);
                jSONObject.put("savedCardToken", (Object)this.token);
            } else {
                jSONObject.put("name", (Object)this.cardHolderName);
                jSONObject.put("cardNumber", (Object)this.cardNumber);
                jSONObject.put("cardScheme", (Object)this.cardScheme.getName().toUpperCase());
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                    jSONObject.put("cardExpiryDate", (Object)"11/2049");
                } else {
                    jSONObject.put("cardExpiryDate", (Object)this.cardExpiry);
                }
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    jSONObject.put("cvv", (Object)"123");
                } else {
                    jSONObject.put("cvv", (Object)this.cardCVV);
                }
            }
            jSONObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jSONObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jSONObject;
    }

    private boolean isValidLuhnNumber(String string) {
        boolean bl2 = true;
        int n2 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n3 = string.charAt(i2);
            if (!Character.isDigit((char)n3)) {
                return false;
            }
            n3 = Integer.parseInt(String.valueOf((char)n3));
            if (bl2 = !bl2) {
                n3 *= 2;
            }
            if (n3 > 9) {
                n3 -= 9;
            }
            n2 += n3;
        }
        return n2 % 10 == 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.cardHolderName);
        parcel.writeString(this.cardNumber);
        parcel.writeString(this.cardCVV);
        parcel.writeString(this.cardExpiry);
        parcel.writeString(this.cardExpiryMonth);
        parcel.writeString(this.cardExpiryYear);
        parcel.writeInt(this.cardScheme == null ? -1 : this.cardScheme.ordinal());
        parcel.writeString(this.nickName);
        parcel.writeParcelable((Parcelable)this.transactionAmount, 0);
    }

    protected CardOption(Parcel parcel) {
        super(parcel);
        this.cardHolderName = parcel.readString();
        this.cardNumber = parcel.readString();
        this.cardCVV = parcel.readString();
        this.cardExpiry = parcel.readString();
        this.cardExpiryMonth = parcel.readString();
        this.cardExpiryYear = parcel.readString();
        int n2 = parcel.readInt();
        this.cardScheme = n2 == -1 ? null : CardScheme.values()[n2];
        this.nickName = parcel.readString();
        this.transactionAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
    }

    public static abstract class CardScheme
    extends Enum<CardScheme> {
        public static final /* enum */ CardScheme VISA = new b();
        public static final /* enum */ CardScheme MASTER_CARD = new c();
        public static final /* enum */ CardScheme MAESTRO = new d("504433", "504434", "504435", "504437", "504645", "504681", "504753", "504775", "504809", "504817", "504834", "504848", "504884", "504973", "504993", "508125", "508126", "508159", "508192", "508227", "56", "600206", "603123", "603741", "603845", "622018", "67");
        public static final /* enum */ CardScheme DINERS = new e("36", "38", "39");
        public static final /* enum */ CardScheme JCB = new f();
        public static final /* enum */ CardScheme AMEX = new g("37");
        public static final /* enum */ CardScheme RPAY = new h("5086", "5087", "5088", "6069", "607", "6081", "6521", "6522", "6524");
        public static final /* enum */ CardScheme DISCOVER = new i("62", "64", "65");
        public static final /* enum */ CardScheme UNKNOWN = new j();
        private final String[] pattern;
        private static final /* synthetic */ CardScheme[] $VALUES;

        public static CardScheme[] values() {
            return (CardScheme[])$VALUES.clone();
        }

        public static CardScheme valueOf(String string) {
            return Enum.valueOf(CardScheme.class, string);
        }

        private CardScheme(String ... stringArray) {
            this.pattern = stringArray;
        }

        public abstract String getName();

        public String getIconName() {
            return this.getName().toLowerCase();
        }

        public static CardScheme getCardScheme(String string) {
            if ("visa".equalsIgnoreCase(string)) {
                return VISA;
            }
            if ("mcrd".equalsIgnoreCase(string) || "Master Card".equalsIgnoreCase(string)) {
                return MASTER_CARD;
            }
            if ("mtro".equalsIgnoreCase(string) || "Maestro Card".equalsIgnoreCase(string)) {
                return MAESTRO;
            }
            if ("DINERS".equalsIgnoreCase(string)) {
                return DINERS;
            }
            if ("jcb".equalsIgnoreCase(string)) {
                return JCB;
            }
            if ("amex".equalsIgnoreCase(string)) {
                return AMEX;
            }
            if ("DISCOVER".equalsIgnoreCase(string)) {
                return DISCOVER;
            }
            if ("RPAY".equalsIgnoreCase(string) || "RuPay".equalsIgnoreCase(string)) {
                return RPAY;
            }
            return null;
        }

        public static CardScheme getCardSchemeUsingNumber(String string) {
            CardScheme cardScheme = UNKNOWN;
            for (CardScheme cardScheme2 : CardScheme.values()) {
                boolean bl2;
                String[] stringArray = cardScheme2.pattern;
                String string2 = string;
                if (string2 != null) {
                    string2 = string2.replaceAll("\\s+", "");
                    for (String string3 : stringArray) {
                        if (!string2.startsWith(string3)) continue;
                        bl2 = true;
                        break;
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                cardScheme = cardScheme2;
                break;
            }
            return cardScheme;
        }

        public static int getCVVLength(String string) {
            if (CardScheme.getCardSchemeUsingNumber(string) == AMEX) {
                return 4;
            }
            return 3;
        }

        public static int getFilterLength(CardScheme cardScheme) {
            if (cardScheme == AMEX) {
                return 18;
            }
            if (cardScheme == MAESTRO) {
                return 23;
            }
            return 19;
        }

        /* synthetic */ CardScheme(String string, int n2, String[] stringArray, byte by2) {
            this(stringArray);
        }

        static {
            $VALUES = new CardScheme[]{VISA, MASTER_CARD, MAESTRO, DINERS, JCB, AMEX, RPAY, DISCOVER, UNKNOWN};
        }
    }

    public static abstract class CardType
    extends Enum<CardType> {
        public static final /* enum */ CardType DEBIT = new k();
        public static final /* enum */ CardType CREDIT = new l();
        private static final /* synthetic */ CardType[] $VALUES;

        public static CardType[] values() {
            return (CardType[])$VALUES.clone();
        }

        public static CardType valueOf(String string) {
            return Enum.valueOf(CardType.class, string);
        }

        private CardType() {
        }

        public abstract String getCardType();

        /* synthetic */ CardType(String string, int n2, byte by2) {
            this();
        }

        static {
            $VALUES = new CardType[]{DEBIT, CREDIT};
        }
    }
}

