/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.d;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DynamicPricingResponse
implements Parcelable {
    private int resultCode = -1;
    private Amount originalAmount = null;
    private Amount alteredAmount = null;
    private String offerToken = null;
    private Map<String, String> extraParameters = null;
    private PaymentBill paymentBill = null;
    private PaymentOption paymentOption = null;
    private CitrusUser citrusUser = null;
    public static final Parcelable.Creator<DynamicPricingResponse> CREATOR = new d();

    private DynamicPricingResponse() {
    }

    public DynamicPricingResponse(int n2, Amount amount, Amount amount2, String string, Map<String, String> map) {
        this.resultCode = n2;
        this.originalAmount = amount;
        this.alteredAmount = amount2;
        this.offerToken = string;
        this.extraParameters = map;
    }

    public Status getStatus() {
        return Status.getStatus(this.resultCode);
    }

    public String getMessage() {
        switch (this.getStatus()) {
            case SUCCESS: {
                return "Success";
            }
            case RULE_VALIDATION_FAILED: {
                return "Rule Validation Failed.";
            }
            case NO_ELIGIBLE_RULE_FOUND: {
                return "No Eligible Rule Found.";
            }
            case CALCULATE_PRICING_FAILED: {
                return "Failed To Calculate Price";
            }
            case RULE_DOES_NOT_EXIST: {
                return "Rule Does Not Exist.";
            }
            case OPERATION_NOT_PERMITTED: {
                return "Operation Not Permitted.";
            }
        }
        return "Failed To Apply Dynamic Pricing.";
    }

    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public Amount getAlteredAmount() {
        return this.alteredAmount;
    }

    public String getOfferToken() {
        return this.offerToken;
    }

    public String getConsumerMessage() {
        if (this.extraParameters != null) {
            return this.extraParameters.get("consumerMessage");
        }
        return "";
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public PaymentBill getPaymentBill() {
        return this.paymentBill;
    }

    public void setPaymentBill(PaymentBill paymentBill) {
        this.paymentBill = paymentBill;
    }

    public PaymentOption getPaymentOption() {
        return this.paymentOption;
    }

    public void setPaymentOption(PaymentOption paymentOption) {
        this.paymentOption = paymentOption;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public void setCitrusUser(CitrusUser citrusUser) {
        this.citrusUser = citrusUser;
    }

    public static final DynamicPricingResponse fromJSON(String string) {
        DynamicPricingResponse dynamicPricingResponse = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string = new JSONObject(string);
                dynamicPricingResponse = new DynamicPricingResponse();
                new DynamicPricingResponse().resultCode = string.optInt("resultCode", -1);
                dynamicPricingResponse.originalAmount = Amount.fromJSONObject(string.optJSONObject("originalAmount"));
                dynamicPricingResponse.alteredAmount = Amount.fromJSONObject(string.optJSONObject("alteredAmount"));
                dynamicPricingResponse.offerToken = string.optString("offerToken");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                string = string.optJSONObject("extraParams");
                if (string != null) {
                    Iterator iterator = string.keys();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        hashMap.put(string2, string.optString(string2));
                    }
                    dynamicPricingResponse.extraParameters = hashMap;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return dynamicPricingResponse;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.resultCode);
        parcel.writeParcelable((Parcelable)this.originalAmount, 0);
        parcel.writeParcelable((Parcelable)this.alteredAmount, 0);
        parcel.writeString(this.offerToken);
        parcel.writeMap(this.extraParameters);
        parcel.writeParcelable((Parcelable)this.paymentBill, 0);
        parcel.writeParcelable((Parcelable)this.paymentOption, 0);
        parcel.writeParcelable((Parcelable)this.citrusUser, 0);
    }

    protected DynamicPricingResponse(Parcel parcel) {
        this.resultCode = parcel.readInt();
        this.originalAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.alteredAmount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        this.offerToken = parcel.readString();
        this.extraParameters = parcel.readHashMap(String.class.getClassLoader());
        this.paymentBill = (PaymentBill)parcel.readParcelable(PaymentBill.class.getClassLoader());
        this.paymentOption = (PaymentOption)parcel.readParcelable(PaymentOption.class.getClassLoader());
        this.citrusUser = (CitrusUser)parcel.readParcelable(CitrusUser.class.getClassLoader());
    }

    public static enum Status {
        SUCCESS,
        RULE_VALIDATION_FAILED,
        NO_ELIGIBLE_RULE_FOUND,
        CALCULATE_PRICING_FAILED,
        RULE_DOES_NOT_EXIST,
        OPERATION_NOT_PERMITTED,
        FAILED;


        public static Status getStatus(int n2) {
            switch (n2) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return RULE_VALIDATION_FAILED;
                }
                case 3: {
                    return RULE_DOES_NOT_EXIST;
                }
                case 5: {
                    return CALCULATE_PRICING_FAILED;
                }
                case 6: {
                    return OPERATION_NOT_PERMITTED;
                }
                case 7: {
                    return NO_ELIGIBLE_RULE_FOUND;
                }
            }
            return FAILED;
        }
    }
}

