/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DynamicPricingRequest {
    private DynamicPricingRequestType dynamicPricingRequestType;
    private PaymentBill paymentBill;

    public DynamicPricingRequest(DynamicPricingRequestType dynamicPricingRequestType, PaymentBill paymentBill) {
        this.dynamicPricingRequestType = dynamicPricingRequestType;
        this.paymentBill = paymentBill;
    }

    public DynamicPricingRequestType getDynamicPricingRequestType() {
        return this.dynamicPricingRequestType;
    }

    public PaymentBill getPaymentBill() {
        return this.paymentBill;
    }

    public static String toJSON(DynamicPricingRequest object) {
        Object object2 = null;
        if (object != null) {
            object2 = new JSONObject();
            DynamicPricingRequestType dynamicPricingRequestType = ((DynamicPricingRequest)object).getDynamicPricingRequestType();
            Object object3 = dynamicPricingRequestType.getOriginalAmount();
            CitrusUser object42 = dynamicPricingRequestType.getCitrusUser();
            PaymentOption paymentOption = dynamicPricingRequestType.getPaymentOption();
            object = ((DynamicPricingRequest)object).getPaymentBill();
            Map<String, String> map = dynamicPricingRequestType.getExtraParameters();
            try {
                object2.put("email", (Object)(object42 != null ? object42.getEmailId() : null));
                object2.put("phone", (Object)(object42 != null ? object42.getMobileNo() : null));
                object2.put("merchantTransactionId", (Object)((PaymentBill)object).getMerchantTransactionId());
                object2.put("merchantAccessKey", (Object)((PaymentBill)object).getMerchantAccessKey());
                object2.put("signature", (Object)((PaymentBill)object).getDpSignature());
                object2.put("originalAmount", (Object)Amount.toJSONObject((Amount)object3));
                object2.put("paymentInfo", (Object)DynamicPricingRequest.getPaymentInformation(paymentOption));
                object = new JSONObject();
                if (map != null) {
                    for (String string : map.keySet()) {
                        object.put(string, (Object)map.get(string));
                    }
                }
                object.put("operation", (Object)dynamicPricingRequestType.getDPOperationName());
                object2.put("extraParams", object);
                if (dynamicPricingRequestType instanceof DynamicPricingRequestType.CalculatePrice) {
                    object2.put("ruleName", (Object)((DynamicPricingRequestType.CalculatePrice)dynamicPricingRequestType).getRuleName());
                } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.ValidateRule) {
                    object3 = ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getAlteredAmount();
                    object2.put("ruleName", (Object)((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getRuleName());
                    object2.put("alteredAmount", (Object)Amount.toJSONObject((Amount)object3));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            object2 = object2.toString();
        }
        return object2;
    }

    private static JSONObject getPaymentInformation(PaymentOption paymentOption) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (paymentOption != null) {
                if (paymentOption.getToken() != null) {
                    jSONObject.put("paymentToken", (Object)paymentOption.getToken());
                } else if (paymentOption instanceof NetbankingOption) {
                    jSONObject.put("issuerId", (Object)((NetbankingOption)paymentOption).getBankCID());
                } else if (paymentOption instanceof CardOption) {
                    jSONObject.put("cardNo", (Object)((CardOption)paymentOption).getCardNumber());
                    jSONObject.put("cardType", (Object)((CardOption)paymentOption).getCardScheme().getName().toUpperCase());
                }
                jSONObject.put("paymentMode", (Object)paymentOption.getDynamicPricingPaymentMode());
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }
}

