package com.citrus.sdk.walletpg;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by vinay on 11/4/16.
 */
public class WalletPgTransactionMsg {

    /** "txnMsg": {
         * "respCode": "0",
         * "status": "Success",
         * "description": "Transaction successful",
         * "merchantTransactionId": "145466886075877",
         * "amount": 30,
         * "currency": "INR",
         * "signature": "0f596ef9ef425033952bbbd1c2147b580a9e4eb5",
         * "txnDateTime": 1454674010205,
         *
             * "userDetails": {
             * "firstName": "Salil",
             * "lastName": "Godbole",
             * "email": "salilgodbole@gmail.com",
             * "mobile": "9970950374"
             * },
         *
             * "paymentDetailsLst": [
                 * {
                 * "paymentMode": "PREPAID_CARD",
                 * "status": "Success",
                 * "description": "Transaction successful",
                 * "amount": "30.0",
                 * "currency": "INR"
                 * }
             * ],
     *
         * "paymentMode": "WALLET",
         * "walletType": "Citrus Wallet",
         * "citrusTransactionId": "WTX1602051206505375345"
         * "authIdCode":"844636",
         * "issuerRefNo":"WTX1604110846428094932",
         * "pgTxnId":"WTX1604110846428094932",
     * }
     *
     */


    private String description;
    private String merchantTransactionId;

    private String amount;
    private String currency;

    private long txnDateTime ;

    private String signature;

    private CitrusUser userDetails;

    private List<WalletPgPaymentDetails> paymentDetailsLst;

    private String authIdCode;
    private String issuerRefNo;
    private String pgTxnId;

    public WalletPgTransactionMsg() {
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMerchantTransactionId() { return merchantTransactionId; }

    public void setMerchantTransactionId(String merchantTransactionId) { this.merchantTransactionId = merchantTransactionId; }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Amount getTransactionAmount() {
        return new Amount( getAmount(), getCurrency() );
    }


    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public CitrusUser getUserDetails() {
        return userDetails;
    }

    public void setUserDetails(CitrusUser userDetails) {
        this.userDetails = userDetails;
    }

    public List<WalletPgPaymentDetails> getPaymentDetailsLst() {
        return paymentDetailsLst;
    }

    public void setPaymentDetailsLst(List<WalletPgPaymentDetails> paymentDetailsLst) { this.paymentDetailsLst = paymentDetailsLst; }

    public String getAuthIdCode() {
        return authIdCode;
    }

    public void setAuthIdCode(String authIdCode) {
        this.authIdCode = authIdCode;
    }

    public String getIssuerRefNo() {
        return issuerRefNo;
    }

    public void setIssuerRefNo(String issuerRefNo) {
        this.issuerRefNo = issuerRefNo;
    }

    public String getPgTxnId() {
        return pgTxnId;
    }

    public void setPgTxnId(String pgTxnId) {
        this.pgTxnId = pgTxnId;
    }

    public long getTxnDateTime() {
        return txnDateTime;
    }

    public void setTxnDateTime(long txnDateTime) {
        this.txnDateTime = txnDateTime;
    }

    public List<PaymentOption> getPaymentOptions() {
        final List<WalletPgPaymentDetails> pgPaymentDetailsList = getPaymentDetailsLst() ;
        if( pgPaymentDetailsList != null ){
            final List<PaymentOption> paymentOptions = new ArrayList<>() ;
            for ( WalletPgPaymentDetails detail: paymentDetailsLst ) {
                final PaymentOption paymentOption = detail.getPaymentOption() ;
                paymentOptions.add(paymentOption);
            }
            return  paymentOptions ;
        }
        return null ;
    }
}
