package com.citrus.sdk.network.request;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;

/**
 * Created by vinay on 1/4/16.
 */
public class VolleyNetworkManager {

    private static VolleyNetworkManager mInstance;
    private RequestQueue mRequestQueue;
    private static Context mCtx;

    private VolleyNetworkManager(Context context) {
        mCtx = context;
        mRequestQueue = getRequestQueue();
    }

    public static VolleyNetworkManager getInstance(Context context) {
        if (mInstance == null) {
            synchronized (VolleyNetworkManager.class) {
                if (mInstance == null) {
                    mInstance = new VolleyNetworkManager(context);
                }
            }
        }
        return mInstance;
    }

    public RequestQueue getRequestQueue() {
        if (mRequestQueue == null) {
            synchronized (VolleyNetworkManager.class) {
                if (mRequestQueue == null) {
                    mRequestQueue = Volley.newRequestQueue(mCtx.getApplicationContext());
                }
            }
        }

        return mRequestQueue;
    }

    public synchronized <T> void addToRequestQueue(Request<T> req) {
        getRequestQueue().add(req);
    }

    public synchronized void cancelRequests(final String tag) {
        if (mRequestQueue != null) {
            getRequestQueue().cancelAll(tag);
        }
    }
}
