package com.citrus.sdk.network.request;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.Response;
import com.android.volley.toolbox.StringRequest;

import java.util.Map;

/**
 * Created by vinay on 28/4/16.
 */
public class CustomStringRequest extends StringRequest {

    private static final String TAG = CustomStringRequest.class.getSimpleName();

    private Response.Listener<String> listener;
    private Map<String, String> params;

    private final byte[] body;
    private final Map<String, String> headers;
    private final String bodyContentResponseType;

    public CustomStringRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener,
                               Map<String, String> params, byte[] body, Map<String, String> headers, String bodyContentResponseType) {
        super(method, url, listener, errorListener);

        this.listener = listener;
        this.params = params;
        this.body = body;
        this.headers = headers;
        this.bodyContentResponseType = bodyContentResponseType;
    }

    @Override
    protected Map<String, String> getParams() throws AuthFailureError {
        Log.d(TAG, TAG + ".getParams(): params = " + params);
        return params != null ? params : super.getParams();
    }

    @Override
    public String getBodyContentType() {
        Log.d(TAG, TAG + ".getBodyContentType(): bodyContentResponseType = " + bodyContentResponseType);
        return bodyContentResponseType != null ? bodyContentResponseType : super.getBodyContentType();
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Log.d(TAG, TAG + ".getHeaders(): headers = " + headers);
        return headers != null ? headers : super.getHeaders();
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        Log.d(TAG, TAG + ".getBody(): body = " + body);
        return body != null ? body : super.getBody();
    }
}