package com.citrus.sdk.network;

import android.content.Context;

import com.citrus.sdk.Callback;
import com.citrus.sdk.Environment;
import com.citrus.sdk.ResponseMessages;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.network.request.ApiExecutor;
import com.citrus.sdk.network.request.ApiRequest;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;

import org.json.JSONObject;

/**
 * Created by vinay on 10/4/16.
 */
public class BillingClient extends BaseClient {

    private static BillingClient instance = null;
    final ApiExecutor executor = ApiExecutor.getInstance(mContext);

    public static BillingClient getInstance(Context context, Environment environment) {
        if (instance == null) {
            synchronized (BillingClient.class) {
                if (instance == null) {
                    instance = new BillingClient(context, environment);
                }
            }
        }
        return instance;
    }

    private BillingClient(Context context, Environment environment) {
        super(context, environment);
    }

    @Override
    public String getBaseUrl() {
        return ""; // Empty URL, append only relative URL.
    }

    public void getBill(final String billUrl, final Amount amount, String format, final Callback<PaymentBill> callback) {
        final ApiRequest billApi = getBillApi(billUrl, amount, format);
        executor.executeCustomJsonApi(this, billApi, new Callback<JSONObject>() {
            @Override
            public void success(JSONObject jsonObject) {
                if (jsonObject != null) {
                    final PaymentBill paymentBill = PaymentBill.fromJSON(jsonObject.toString());
                    sendResponse(callback, paymentBill);
                } else {
                    sendError(callback, new CitrusError(ResponseMessages.ERROR_MESSAGE_INVALID_BILL, CitrusResponse.Status.FAILED));
                }
            }

            @Override
            public void error(CitrusError error) {
                sendError(callback, error);
            }
        });
    }

    private ApiRequest getBillApi(final String billUrl, final Amount amount, String format) {
        final ApiRequest getBillApi = new ApiRequest.Builder(Api.GET_BILL).build();

        final String relativeUrl = Utils.getUrlFormatted(billUrl, amount, format);
        getBillApi.setRelativeUrl(relativeUrl);

        return getBillApi;
    }
}
